/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.module.CompatModule;
import com.yungnickyoung.minecraft.travelerstitles.module.SoundModule;
import com.yungnickyoung.minecraft.travelerstitles.module.TagModule;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import com.yungnickyoung.minecraft.travelerstitles.services.Services;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class TitleRenderManager {
    public final TitleRenderer<class_1959> biomeTitleRenderer;
    public final TitleRenderer<class_2874> dimensionTitleRenderer;

    public TitleRenderManager() {
        this.biomeTitleRenderer = new TitleRenderer(TravelersTitlesCommon.CONFIG.biomes.recentBiomeCacheSize, TravelersTitlesCommon.CONFIG.biomes.enabled, TravelersTitlesCommon.CONFIG.biomes.textFadeInTime, TravelersTitlesCommon.CONFIG.biomes.textDisplayTime, TravelersTitlesCommon.CONFIG.biomes.textFadeOutTime, TravelersTitlesCommon.CONFIG.biomes.textColor, TravelersTitlesCommon.CONFIG.biomes.renderShadow, TravelersTitlesCommon.CONFIG.biomes.textSize, TravelersTitlesCommon.CONFIG.biomes.textXOffset, TravelersTitlesCommon.CONFIG.biomes.textYOffset, TravelersTitlesCommon.CONFIG.biomes.centerText);
        this.dimensionTitleRenderer = new TitleRenderer(1, TravelersTitlesCommon.CONFIG.dimensions.enabled, TravelersTitlesCommon.CONFIG.dimensions.textFadeInTime, TravelersTitlesCommon.CONFIG.dimensions.textDisplayTime, TravelersTitlesCommon.CONFIG.dimensions.textFadeOutTime, TravelersTitlesCommon.CONFIG.dimensions.textColor, TravelersTitlesCommon.CONFIG.dimensions.renderShadow, TravelersTitlesCommon.CONFIG.dimensions.textSize, TravelersTitlesCommon.CONFIG.dimensions.textXOffset, TravelersTitlesCommon.CONFIG.dimensions.textYOffset, TravelersTitlesCommon.CONFIG.dimensions.centerText);
    }

    public void clientTick() {
        if (!class_310.method_1551().method_1493()) {
            this.dimensionTitleRenderer.tick();
            Services.WAYSTONES.clientTick();
            this.biomeTitleRenderer.tick();
        }
    }

    public void renderTitles(class_332 guiGraphics, float partialTicks) {
        if (!class_310.method_1551().method_53526().method_53536()) {
            this.dimensionTitleRenderer.renderText(partialTicks, guiGraphics);
            this.biomeTitleRenderer.renderText(partialTicks, guiGraphics);
            Services.WAYSTONES.renderText(partialTicks, guiGraphics);
        }
    }

    public void playerTick(class_1657 player) {
        if (player instanceof class_746 && player.method_37908().method_8477(player.method_24515())) {
            class_2338 playerPos = player.method_24515();
            class_1937 world = player.method_37908();
            boolean isPlayerUnderground = world.method_8597().comp_642() && !world.method_8311(playerPos);
            this.updateDimensionTitle(world, player, isPlayerUnderground);
            boolean isRenderingWaystoneTitle = this.updateWaystoneTitle(player, isPlayerUnderground);
            if (!TravelersTitlesCommon.CONFIG.waystones.waystonesOverrideBiomeTitle || !isRenderingWaystoneTitle) {
                this.updateBiomeTitle(world, playerPos, player, isPlayerUnderground);
            } else {
                this.biomeTitleRenderer.clearTimer();
            }
        }
    }

    public void playerChangedDimension(Object entity) {
        if (entity instanceof class_1657) {
            if (TravelersTitlesCommon.CONFIG.biomes.enabled && TravelersTitlesCommon.CONFIG.biomes.resetBiomeCacheOnDimensionChange) {
                this.biomeTitleRenderer.clearTimer();
                this.biomeTitleRenderer.recentEntries.clear();
                this.biomeTitleRenderer.displayedTitle = null;
            }
            if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled && TravelersTitlesCommon.CONFIG.waystones.resetWaystoneCacheOnDimensionChange) {
                Services.WAYSTONES.reset();
            }
        }
    }

    private void updateDimensionTitle(class_1937 world, class_1657 player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.dimensions.onlyUpdateAtSurface) {
            return;
        }
        class_2874 currDimension = world.method_8597();
        if (this.dimensionTitleRenderer.enabled && !this.dimensionTitleRenderer.matchesAnyRecentEntry(d -> d == currDimension)) {
            class_2960 dimensionBaseKey = world.method_27983().method_29177();
            String dimensionNameKey = class_156.method_646((String)"travelerstitles", (class_2960)dimensionBaseKey);
            if (!TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist.contains(dimensionBaseKey.toString())) {
                class_5250 dimensionTitle = class_2477.method_10517().method_4678(dimensionNameKey) ? class_2561.method_43471((String)dimensionNameKey) : class_2561.method_43470((String)"???");
                String dimensionColorKey = dimensionNameKey + ".color";
                String dimensionColorStr = class_2477.method_10517().method_4678(dimensionColorKey) ? class_2477.method_10517().method_48307(dimensionColorKey) : this.dimensionTitleRenderer.titleDefaultTextColor;
                this.dimensionTitleRenderer.setColor(dimensionColorStr);
                this.dimensionTitleRenderer.displayTitle((class_2561)dimensionTitle, null);
                this.dimensionTitleRenderer.addRecentEntry(currDimension);
                player.method_5783((class_3414)SoundModule.DIMENSION.get(), (float)TravelersTitlesCommon.CONFIG.sound.dimensionVolume, (float)TravelersTitlesCommon.CONFIG.sound.dimensionPitch);
            }
        }
    }

    private void updateBiomeTitle(class_1937 world, class_2338 playerPos, class_1657 player, boolean isPlayerUnderground) {
        boolean isUndergroundBiome;
        class_6880 biomeHolder = world.method_23753(playerPos);
        boolean bl = isUndergroundBiome = biomeHolder.method_40225(class_1972.field_29218) || biomeHolder.method_40225(class_1972.field_28107) || biomeHolder.method_40220(TagModule.IS_UNDERGROUND);
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.biomes.onlyUpdateAtSurface && !isUndergroundBiome) {
            return;
        }
        class_2960 biomeBaseKey = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biomeHolder.comp_349()));
        if (this.biomeTitleRenderer.enabled && this.biomeTitleRenderer.cooldownTimer <= 0 && !this.biomeTitleRenderer.matchesAnyRecentEntry(b -> world.method_30349().method_30530(class_7924.field_41236).method_10221(b) == biomeBaseKey)) {
            String overrideBiomeNameKey = class_156.method_646((String)"travelerstitles.biome", (class_2960)biomeBaseKey);
            String normalBiomeNameKey = class_156.method_646((String)"biome", (class_2960)biomeBaseKey);
            if (biomeBaseKey != null && !TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
                class_5250 biomeTitle;
                if (class_2477.method_10517().method_4678(overrideBiomeNameKey)) {
                    biomeTitle = class_2561.method_43471((String)overrideBiomeNameKey);
                } else if (class_2477.method_10517().method_4678(normalBiomeNameKey)) {
                    biomeTitle = class_2561.method_43471((String)normalBiomeNameKey);
                } else {
                    return;
                }
                String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
                String normalBiomeColorKey = normalBiomeNameKey + ".color";
                String biomeColorStr = class_2477.method_10517().method_4678(overrideBiomeColorKey) ? class_2477.method_10517().method_48307(overrideBiomeColorKey) : (class_2477.method_10517().method_4678(normalBiomeColorKey) ? class_2477.method_10517().method_48307(normalBiomeColorKey) : this.biomeTitleRenderer.titleDefaultTextColor);
                if (this.biomeTitleRenderer.displayedTitle != null && biomeTitle.getString().equals(this.biomeTitleRenderer.displayedTitle.getString())) {
                    return;
                }
                this.biomeTitleRenderer.setColor(biomeColorStr);
                this.biomeTitleRenderer.displayTitle((class_2561)biomeTitle, null);
                this.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
                this.biomeTitleRenderer.addRecentEntry((class_1959)biomeHolder.comp_349());
                if (!(this.dimensionTitleRenderer.titleTimer > 0 || CompatModule.isWaystonesLoaded && Services.WAYSTONES.isRendering())) {
                    player.method_5783((class_3414)SoundModule.BIOME.get(), (float)TravelersTitlesCommon.CONFIG.sound.biomeVolume, (float)TravelersTitlesCommon.CONFIG.sound.biomePitch);
                }
            }
        }
    }

    private boolean updateWaystoneTitle(class_1657 player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.waystones.onlyUpdateAtSurface) {
            return false;
        }
        if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled) {
            return Services.WAYSTONES.updateWaystoneTitle(player);
        }
        return false;
    }
}

