/*
 * Decompiled with CFR 0.152.
 */
package com.forestotzka.yurufu.slabee.block;

import com.forestotzka.yurufu.slabee.SlabeeUtils;
import com.forestotzka.yurufu.slabee.block.AbstractDoubleSlabBlock;
import com.forestotzka.yurufu.slabee.block.ModBlocks;
import com.forestotzka.yurufu.slabee.block.enums.DoubleSlabVariant;
import com.forestotzka.yurufu.slabee.registry.tag.ModBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_7923;

public class DoubleSlabUtils {
    private DoubleSlabUtils() {
    }

    public static boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 playerEntity = context.method_8036();
        class_3726 shapeContext = playerEntity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)playerEntity);
        return context.method_8045().method_8628(state, context.method_8037(), shapeContext);
    }

    public static boolean isPositiveSeeThrough(class_2680 state) {
        if (!SlabeeUtils.isDoubleSlab(state)) {
            return false;
        }
        return DoubleSlabUtils.isSeeThrough((DoubleSlabVariant)((Object)state.method_11654(AbstractDoubleSlabBlock.POSITIVE_SLAB)));
    }

    public static boolean isNegativeSeeThrough(class_2680 state) {
        if (!SlabeeUtils.isDoubleSlab(state)) {
            return false;
        }
        return DoubleSlabUtils.isSeeThrough((DoubleSlabVariant)((Object)state.method_11654(AbstractDoubleSlabBlock.NEGATIVE_SLAB)));
    }

    private static boolean isSeeThrough(DoubleSlabVariant variant) {
        return variant != DoubleSlabVariant.NORMAL;
    }

    public static boolean isPositiveOpaque(class_2680 state) {
        if (!SlabeeUtils.isDoubleSlab(state)) {
            return false;
        }
        return DoubleSlabUtils.isOpaque((DoubleSlabVariant)((Object)state.method_11654(AbstractDoubleSlabBlock.POSITIVE_SLAB)));
    }

    public static boolean isNegativeOpaque(class_2680 state) {
        if (!SlabeeUtils.isDoubleSlab(state)) {
            return false;
        }
        return DoubleSlabUtils.isOpaque((DoubleSlabVariant)((Object)state.method_11654(AbstractDoubleSlabBlock.NEGATIVE_SLAB)));
    }

    private static boolean isOpaque(DoubleSlabVariant variant) {
        return variant == DoubleSlabVariant.NORMAL || variant == DoubleSlabVariant.TINTED_GLASS;
    }

    public static boolean isTrueSlabId(class_2960 id) {
        return id != null && class_7923.field_41175.method_10250(id);
    }

    public static int getLuminance(class_2680 state) {
        if (state.method_27852(ModBlocks.GLOWSTONE_SLAB) || state.method_27852(ModBlocks.GLOWSTONE_VERTICAL_SLAB)) {
            return 15;
        }
        if (state.method_27852(ModBlocks.MAGMA_BLOCK_SLAB) || state.method_27852(ModBlocks.MAGMA_BLOCK_VERTICAL_SLAB)) {
            return 3;
        }
        if (state.method_27852(ModBlocks.CRYING_OBSIDIAN_SLAB) || state.method_27852(ModBlocks.CRYING_OBSIDIAN_VERTICAL_SLAB)) {
            return 1;
        }
        return 0;
    }

    public static float getMiningSpeed(class_2680 positiveSlab, class_2680 negativeSlab, class_1657 player, class_1922 world, class_2338 pos) {
        float hardness = DoubleSlabUtils.getHardness(positiveSlab, negativeSlab, world, pos);
        return hardness == -1.0f ? 0.0f : DoubleSlabUtils.getBlockBreakingSpeed(positiveSlab, negativeSlab, player) / hardness / DoubleSlabUtils.getHarvest(positiveSlab, negativeSlab, player);
    }

    private static float getHardness(class_2680 positiveSlab, class_2680 negativeSlab, class_1922 world, class_2338 pos) {
        float positiveHardness = positiveSlab.method_26214(world, pos);
        float negativeHardness = negativeSlab.method_26214(world, pos);
        if (positiveHardness == -1.0f || negativeHardness == -1.0f) {
            return -1.0f;
        }
        return (positiveHardness + negativeHardness) / 2.0f;
    }

    private static float getBlockBreakingSpeed(class_2680 positiveSlab, class_2680 negativeSlab, class_1657 player) {
        return (player.method_7351(positiveSlab) + player.method_7351(negativeSlab)) / 2.0f;
    }

    private static float getHarvest(class_2680 positiveSlab, class_2680 negativeSlab, class_1657 player) {
        float harvest = 30.0f;
        boolean positiveCanHarvest = DoubleSlabUtils.canHarvest(positiveSlab, player);
        boolean negativeCanHarvest = DoubleSlabUtils.canHarvest(negativeSlab, player);
        if (!positiveCanHarvest && !negativeCanHarvest) {
            harvest = 100.0f;
        } else if (!positiveCanHarvest || !negativeCanHarvest) {
            harvest = 50.0f;
        }
        return harvest;
    }

    private static boolean canHarvest(class_2680 state, class_1657 player) {
        class_1799 mainhandItem = player.method_31548().method_7391();
        if (state.method_26164(class_3481.field_33717)) {
            return mainhandItem.method_31574(class_1802.field_8377) || mainhandItem.method_31574(class_1802.field_22024);
        }
        return player.method_7305(state) || mainhandItem.method_31574(class_1802.field_8868) && state.method_26164(ModBlockTags.MINEABLE_SHEARS);
    }
}

