/*
 * Decompiled with CFR 0.152.
 */
package com.forestotzka.yurufu.slabee.block;

import com.forestotzka.yurufu.slabee.SlabeeUtils;
import com.forestotzka.yurufu.slabee.block.AbstractDoubleSlabBlock;
import com.forestotzka.yurufu.slabee.block.DoubleSlabUtils;
import com.forestotzka.yurufu.slabee.block.VerticalSlabBlock;
import java.util.function.ToIntFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public abstract class AbstractDoubleSlabBlockEntity
extends class_2586 {
    protected final class_2960 defaultPositiveSlabId;
    protected final class_2960 defaultNegativeSlabId;
    protected final class_2680 defaultPositiveSlabState;
    protected final class_2680 defaultNegativeSlabState;
    protected class_2960 positiveSlabId;
    protected class_2960 negativeSlabId;
    protected class_2680 positiveSlabState;
    protected class_2680 negativeSlabState;
    protected final class_2680 defaultBlockState;
    protected class_2680 blockState;
    public static ToIntFunction<class_2680> LUMINANCE = state -> (Integer)state.method_11654((class_2769)AbstractDoubleSlabBlock.LIGHT_LEVEL);
    private boolean init;

    public AbstractDoubleSlabBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_2960 defaultPositiveSlabId, class_2960 defaultNegativeSlabId) {
        super(type, pos, state);
        this.blockState = this.defaultBlockState = this.method_11010();
        this.init = true;
        this.defaultPositiveSlabId = defaultPositiveSlabId;
        this.defaultNegativeSlabId = defaultNegativeSlabId;
        this.defaultPositiveSlabState = ((class_2248)class_7923.field_41175.method_10223(defaultPositiveSlabId)).method_9564();
        this.defaultNegativeSlabState = ((class_2248)class_7923.field_41175.method_10223(defaultNegativeSlabId)).method_9564();
        this.positiveSlabId = this.defaultPositiveSlabId;
        this.negativeSlabId = this.defaultNegativeSlabId;
        this.positiveSlabState = this.defaultPositiveSlabState;
        this.negativeSlabState = this.defaultNegativeSlabState;
    }

    public class_2960 getPositiveSlabId() {
        return this.positiveSlabId;
    }

    public void setPositiveSlabId(class_2960 id) {
        this.positiveSlabId = id;
        this.updatePositiveSlabState();
        this.method_5431();
    }

    public class_2960 getNegativeSlabId() {
        return this.negativeSlabId;
    }

    public void setNegativeSlabId(class_2960 id) {
        this.negativeSlabId = id;
        this.updateNegativeSlabState();
        this.method_5431();
    }

    public class_2680 getPositiveSlabState() {
        return this.positiveSlabState;
    }

    public class_2680 getNegativeSlabState() {
        return this.negativeSlabState;
    }

    public Integer getPositiveRenderLayerType() {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(this.positiveSlabId);
        if (SlabeeUtils.isCutoutSlabs(block)) {
            return 1;
        }
        if (SlabeeUtils.isCutoutMippedSlabs(block)) {
            return 2;
        }
        if (SlabeeUtils.isTranslucentSlabs(block)) {
            return 3;
        }
        return 0;
    }

    public Integer getNegativeRenderLayerType() {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(this.negativeSlabId);
        if (SlabeeUtils.isCutoutSlabs(block)) {
            return 1;
        }
        if (SlabeeUtils.isCutoutMippedSlabs(block)) {
            return 2;
        }
        if (SlabeeUtils.isTranslucentSlabs(block)) {
            return 3;
        }
        return 0;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_58692(registryLookup);
    }

    public void updateBlockProperties() {
        if (this.field_11863 != null) {
            if (!this.field_11863.method_8608()) {
                class_2248 positiveSlab = this.positiveSlabState.method_26204();
                class_2248 negativeSlab = this.negativeSlabState.method_26204();
                this.blockState = SlabeeUtils.getAbstractState(positiveSlab, negativeSlab, this.field_11863.method_8320(this.field_11867));
                this.field_11863.method_8652(this.field_11867, this.blockState, 3);
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.blockState, 3);
            }
        } else {
            this.blockState = this.defaultBlockState;
        }
    }

    public void serverTick() {
        if (this.init) {
            this.updateBlockProperties();
            this.init = false;
        }
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    protected void updateSlabState() {
        this.updatePositiveSlabState();
        this.updateNegativeSlabState();
    }

    protected abstract void updatePositiveSlabState();

    protected abstract void updateNegativeSlabState();

    protected boolean isTrueSlabId(class_2960 i) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(i);
        return DoubleSlabUtils.isTrueSlabId(i) && (block instanceof class_2482 || block instanceof VerticalSlabBlock);
    }
}

