/*
 * Decompiled with CFR 0.152.
 */
package com.forestotzka.yurufu.slabee;

import com.forestotzka.yurufu.slabee.block.AbstractDoubleSlabBlock;
import com.forestotzka.yurufu.slabee.block.DoubleSlabUtils;
import com.forestotzka.yurufu.slabee.block.ModBlocks;
import com.forestotzka.yurufu.slabee.block.VerticalSlabBlock;
import com.forestotzka.yurufu.slabee.block.enums.DoubleSlabVariant;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SlabeeUtils {
    private static final Set<class_2248> StainedGlassSlabs = Set.of(ModBlocks.WHITE_STAINED_GLASS_SLAB, ModBlocks.LIGHT_GRAY_STAINED_GLASS_SLAB, ModBlocks.GRAY_STAINED_GLASS_SLAB, ModBlocks.BLACK_STAINED_GLASS_SLAB, ModBlocks.BROWN_STAINED_GLASS_SLAB, ModBlocks.RED_STAINED_GLASS_SLAB, ModBlocks.ORANGE_STAINED_GLASS_SLAB, ModBlocks.YELLOW_STAINED_GLASS_SLAB, ModBlocks.LIME_STAINED_GLASS_SLAB, ModBlocks.GREEN_STAINED_GLASS_SLAB, ModBlocks.CYAN_STAINED_GLASS_SLAB, ModBlocks.LIGHT_BLUE_STAINED_GLASS_SLAB, ModBlocks.BLUE_STAINED_GLASS_SLAB, ModBlocks.PURPLE_STAINED_GLASS_SLAB, ModBlocks.MAGENTA_STAINED_GLASS_SLAB, ModBlocks.PINK_STAINED_GLASS_SLAB);
    private static final Set<class_2248> StainedGlassVerticalSlabs = Set.of(ModBlocks.WHITE_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.LIGHT_GRAY_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.GRAY_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.BLACK_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.BROWN_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.RED_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.ORANGE_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.YELLOW_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.LIME_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.GREEN_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.CYAN_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.LIGHT_BLUE_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.BLUE_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.PURPLE_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.MAGENTA_STAINED_GLASS_VERTICAL_SLAB, ModBlocks.PINK_STAINED_GLASS_VERTICAL_SLAB);
    private static final Set<class_2248> LeafSlabs = Set.of(ModBlocks.OAK_LEAF_SLAB, ModBlocks.SPRUCE_LEAF_SLAB, ModBlocks.BIRCH_LEAF_SLAB, ModBlocks.JUNGLE_LEAF_SLAB, ModBlocks.ACACIA_LEAF_SLAB, ModBlocks.DARK_OAK_LEAF_SLAB, ModBlocks.MANGROVE_LEAF_SLAB, ModBlocks.CHERRY_LEAF_SLAB, ModBlocks.AZALEA_LEAF_SLAB, ModBlocks.FLOWERING_AZALEA_LEAF_SLAB);
    private static final Set<class_2248> LeafVerticalSlabs = Set.of(ModBlocks.OAK_LEAF_VERTICAL_SLAB, ModBlocks.SPRUCE_LEAF_VERTICAL_SLAB, ModBlocks.BIRCH_LEAF_VERTICAL_SLAB, ModBlocks.JUNGLE_LEAF_VERTICAL_SLAB, ModBlocks.ACACIA_LEAF_VERTICAL_SLAB, ModBlocks.DARK_OAK_LEAF_VERTICAL_SLAB, ModBlocks.MANGROVE_LEAF_VERTICAL_SLAB, ModBlocks.CHERRY_LEAF_VERTICAL_SLAB, ModBlocks.AZALEA_LEAF_VERTICAL_SLAB, ModBlocks.FLOWERING_AZALEA_LEAF_VERTICAL_SLAB);
    private static final Set<class_2248> GlowingSlabs = Set.of(ModBlocks.GLOWSTONE_SLAB, ModBlocks.MAGMA_BLOCK_SLAB, ModBlocks.CRYING_OBSIDIAN_SLAB);
    private static final Set<class_2248> GlowingVerticalSlabs = Set.of(ModBlocks.GLOWSTONE_VERTICAL_SLAB, ModBlocks.MAGMA_BLOCK_VERTICAL_SLAB, ModBlocks.CRYING_OBSIDIAN_VERTICAL_SLAB);
    private static final Set<class_2248> CutoutSlabs = Set.of(ModBlocks.GLASS_SLAB);
    private static final Set<class_2248> CutoutVerticalSlabs = Set.of(ModBlocks.GLASS_VERTICAL_SLAB);
    private static final Set<class_2248> CutoutMippedSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GRASS_SLAB, ModBlocks.MANGROVE_ROOT_SLAB, ModBlocks.DIRT_PATH_SLAB));
    private static final Set<class_2248> CutoutMippedVerticalSlabs;
    private static final Set<class_2248> TranslucentSlabs;
    private static final Set<class_2248> TranslucentVerticalSlabs;
    private static final Set<class_2248> NonOpaqueSlabs;
    private static final Set<class_2248> NonOpaqueVerticalSlabs;
    private static final Set<class_2248> EmissiveLightingSlabs;
    private static final Set<class_2248> EmissiveLightingVerticalSlabs;
    private static final Set<class_2248> SeeThroughSlabs;
    private static final Set<class_2248> SeeThroughVerticalSlabs;

    public static boolean isCutoutSlabs(class_2248 block) {
        if (block instanceof class_2482) {
            return CutoutSlabs.contains(block);
        }
        if (block instanceof VerticalSlabBlock) {
            return CutoutVerticalSlabs.contains(block);
        }
        return false;
    }

    public static boolean isCutoutMippedSlabs(class_2248 block) {
        if (block instanceof class_2482) {
            return CutoutMippedSlabs.contains(block);
        }
        if (block instanceof VerticalSlabBlock) {
            return CutoutMippedVerticalSlabs.contains(block);
        }
        return false;
    }

    public static boolean isTranslucentSlabs(class_2248 block) {
        if (block instanceof class_2482) {
            return TranslucentSlabs.contains(block);
        }
        if (block instanceof VerticalSlabBlock) {
            return TranslucentVerticalSlabs.contains(block);
        }
        return false;
    }

    public static boolean isEmissiveLightingSlabs(class_2248 p, class_2248 n) {
        if (p instanceof class_2482) {
            return EmissiveLightingSlabs.contains(p) || EmissiveLightingSlabs.contains(n);
        }
        if (p instanceof VerticalSlabBlock) {
            return EmissiveLightingVerticalSlabs.contains(p) || EmissiveLightingVerticalSlabs.contains(n);
        }
        return false;
    }

    public static boolean isSeeThrough(class_2248 block) {
        if (block instanceof class_2482) {
            return SeeThroughSlabs.contains(block);
        }
        if (block instanceof VerticalSlabBlock) {
            return SeeThroughVerticalSlabs.contains(block);
        }
        return false;
    }

    public static int getLuminance(class_2248 p, class_2248 n) {
        return Math.max(DoubleSlabUtils.getLuminance(p.method_9564()), DoubleSlabUtils.getLuminance(n.method_9564()));
    }

    public static class_2680 getAbstractState(class_2248 p, class_2248 n) {
        class_2680 state;
        if (p instanceof class_2482) {
            state = ModBlocks.DOUBLE_SLAB_BLOCK.method_9564();
        } else if (p instanceof VerticalSlabBlock) {
            state = ModBlocks.DOUBLE_VERTICAL_SLAB_BLOCK.method_9564();
        } else {
            return ModBlocks.DOUBLE_SLAB_BLOCK.method_9564();
        }
        return SlabeeUtils.getAbstractState(p, n, state);
    }

    public static class_2680 getAbstractState(class_2248 p, class_2248 n, class_2680 state) {
        if (!SlabeeUtils.isDoubleSlab(state)) {
            return ModBlocks.DOUBLE_SLAB_BLOCK.method_9564();
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)AbstractDoubleSlabBlock.IS_EMISSIVE_LIGHTING, (Comparable)Boolean.valueOf(SlabeeUtils.isEmissiveLightingSlabs(p, n)))).method_11657((class_2769)AbstractDoubleSlabBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(SlabeeUtils.getLuminance(p, n)))).method_11657(AbstractDoubleSlabBlock.POSITIVE_SLAB, (Comparable)((Object)DoubleSlabVariant.fromBlock(p)))).method_11657(AbstractDoubleSlabBlock.NEGATIVE_SLAB, (Comparable)((Object)DoubleSlabVariant.fromBlock(n)));
    }

    public static boolean isDoubleSlab(class_2680 state) {
        return SlabeeUtils.isDoubleSlab(state.method_26204());
    }

    public static boolean isDoubleSlab(class_2248 block) {
        return block instanceof AbstractDoubleSlabBlock;
    }

    static {
        CutoutMippedSlabs.addAll(LeafSlabs);
        CutoutMippedVerticalSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GRASS_VERTICAL_SLAB, ModBlocks.MANGROVE_ROOT_VERTICAL_SLAB, ModBlocks.DIRT_PATH_VERTICAL_SLAB));
        CutoutMippedVerticalSlabs.addAll(LeafVerticalSlabs);
        TranslucentSlabs = new HashSet<class_2248>(Set.of(ModBlocks.TINTED_GLASS_SLAB));
        TranslucentSlabs.addAll(StainedGlassSlabs);
        TranslucentVerticalSlabs = new HashSet<class_2248>(Set.of(ModBlocks.TINTED_GLASS_VERTICAL_SLAB));
        TranslucentVerticalSlabs.addAll(StainedGlassVerticalSlabs);
        NonOpaqueSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GLASS_SLAB, ModBlocks.MANGROVE_ROOT_SLAB, ModBlocks.DIRT_PATH_SLAB));
        NonOpaqueSlabs.addAll(StainedGlassSlabs);
        NonOpaqueSlabs.addAll(LeafSlabs);
        NonOpaqueSlabs.addAll(GlowingSlabs);
        NonOpaqueVerticalSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GLASS_VERTICAL_SLAB, ModBlocks.MANGROVE_ROOT_VERTICAL_SLAB, ModBlocks.DIRT_PATH_VERTICAL_SLAB));
        NonOpaqueVerticalSlabs.addAll(StainedGlassVerticalSlabs);
        NonOpaqueVerticalSlabs.addAll(LeafVerticalSlabs);
        NonOpaqueVerticalSlabs.addAll(GlowingVerticalSlabs);
        EmissiveLightingSlabs = Set.of(ModBlocks.MAGMA_BLOCK_SLAB);
        EmissiveLightingVerticalSlabs = Set.of(ModBlocks.MAGMA_BLOCK_VERTICAL_SLAB);
        SeeThroughSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GLASS_SLAB, ModBlocks.TINTED_GLASS_SLAB, ModBlocks.MANGROVE_ROOT_SLAB, ModBlocks.DIRT_PATH_SLAB));
        SeeThroughSlabs.addAll(StainedGlassSlabs);
        SeeThroughSlabs.addAll(LeafSlabs);
        SeeThroughVerticalSlabs = new HashSet<class_2248>(Set.of(ModBlocks.GLASS_VERTICAL_SLAB, ModBlocks.TINTED_GLASS_VERTICAL_SLAB, ModBlocks.MANGROVE_ROOT_VERTICAL_SLAB, ModBlocks.DIRT_PATH_VERTICAL_SLAB));
        SeeThroughVerticalSlabs.addAll(StainedGlassVerticalSlabs);
        SeeThroughVerticalSlabs.addAll(LeafVerticalSlabs);
    }
}

