/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryManager;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.client.registry.display.DisplayCacheImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayKey;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.client.registry.display.RemappingMap;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class DisplaysHolderImpl
implements DisplaysHolder {
    private final DisplayCache cache;
    private final SetMultimap<DisplayKey, Display> displaysByKey = Multimaps.newSetMultimap(new IdentityHashMap(), ReferenceOpenHashSet::new);
    private final Map<CategoryIdentifier<?>, DisplaysList> displays = new ConcurrentHashMap();
    private final Map<CategoryIdentifier<?>, List<Display>> unmodifiableDisplays = new RemappingMap<CategoryIdentifier, DisplaysList>(Collections.unmodifiableMap(this.displays), list -> {
        if (list == null) {
            return null;
        }
        return ((DisplaysList)list).synchronizedList;
    }, key -> CategoryRegistry.getInstance().tryGet(key).isPresent());
    private final WeakHashMap<Display, Object> originsMap = new WeakHashMap();
    private final MutableInt displayCount = new MutableInt(0);

    public DisplaysHolderImpl(boolean init) {
        this.cache = new DisplayCacheImpl(init);
    }

    @Override
    public DisplayCache cache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Display display, @Nullable Object origin) {
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new DisplaysList()).add(display);
        Optional<class_2960> location2 = display.getDisplayLocation();
        if (location2.isPresent()) {
            this.displaysByKey.put((Object)DisplayKey.create(display.getCategoryIdentifier(), location2.get()), (Object)display);
        }
        this.displayCount.increment();
        if (origin != null) {
            WeakHashMap<Display, Object> weakHashMap = this.originsMap;
            synchronized (weakHashMap) {
                this.originsMap.put(display, origin);
            }
        }
        this.cache.add(display);
    }

    @Override
    public boolean remove(Display display) {
        if (this.displays.get(display.getCategoryIdentifier()).remove(display)) {
            this.removeFallout(display);
            if (this.displays.get(display.getCategoryIdentifier()).isEmpty()) {
                this.displays.remove(display.getCategoryIdentifier());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFallout(Display display) {
        Optional<class_2960> location = display.getDisplayLocation();
        if (location.isPresent()) {
            this.displaysByKey.remove((Object)DisplayKey.create(display.getCategoryIdentifier(), location.get()), (Object)display);
        }
        this.displayCount.decrement();
        WeakHashMap<Display, Object> weakHashMap = this.originsMap;
        synchronized (weakHashMap) {
            this.originsMap.remove(display);
        }
        this.cache.remove(display);
    }

    @Override
    public int size() {
        return this.displayCount.intValue();
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> getUnmodifiable() {
        return this.unmodifiableDisplays;
    }

    @Override
    public void endReload() {
        this.cache.endReload();
    }

    @Override
    public Set<Display> getDisplaysByKey(DisplayKey key) {
        return this.displaysByKey.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getDisplayOrigin(Display display) {
        WeakHashMap<Display, Object> weakHashMap = this.originsMap;
        synchronized (weakHashMap) {
            Object origin = this.originsMap.get(display);
            if (origin != null) {
                return origin;
            }
        }
        return DisplayHistoryManager.INSTANCE.getPossibleOrigin(this, display);
    }

    private static class DisplaysList
    extends ArrayList<Display> {
        private final List<Display> synchronizedList;

        public DisplaysList() {
            List<Display> unmodifiableList = Collections.unmodifiableList(this);
            this.synchronizedList = Collections.synchronizedList(unmodifiableList);
        }
    }
}

