/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.plugins;

import java.util.Collection;
import java.util.Collections;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.OverrideOnly
public interface REIPlugin<P extends REIPlugin<?>>
extends Comparable<REIPlugin<P>>,
REIPluginProvider<P> {
    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(REIPlugin o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @ApiStatus.OverrideOnly
    default public void registerEntryTypes(EntryTypeRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    @ApiStatus.Experimental
    default public void registerEntrySettingsAdapters(EntrySettingsAdapterRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void registerItemComparators(ItemComparatorRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void registerFluidComparators(FluidComparatorRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void registerFluidSupport(FluidSupportProvider support) {
    }

    @ApiStatus.OverrideOnly
    default public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    @ApiStatus.Experimental
    default public void registerSlotAccessors(SlotAccessorRegistry registry) {
    }

    @ApiStatus.OverrideOnly
    default public void preStage(PluginManager<P> manager, ReloadStage stage) {
    }

    @ApiStatus.OverrideOnly
    default public void postStage(PluginManager<P> manager, ReloadStage stage) {
    }

    @Override
    default public Collection<P> provide() {
        return Collections.singletonList(this);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    default public boolean shouldBeForcefullyDoneOnMainThread(Reloadable<?> reloadable) {
        return false;
    }
}

