/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.gym;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.api.scheduling.SchedulingTracker;
import com.cobblemon.mod.common.api.scheduling.ServerTaskTracker;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.block.BlockRegistry;
import lol.gito.radgyms.entity.EntityManager;
import lol.gito.radgyms.entity.Trainer;
import lol.gito.radgyms.gym.GymDTO;
import lol.gito.radgyms.gym.GymInstance;
import lol.gito.radgyms.gym.GymLootTable;
import lol.gito.radgyms.gym.GymTemplate;
import lol.gito.radgyms.gym.GymTrainer;
import lol.gito.radgyms.item.dataComponent.DataComponentManager;
import lol.gito.radgyms.nbt.EntityDataSaver;
import lol.gito.radgyms.nbt.GymsNbtData;
import lol.gito.radgyms.world.DimensionManager;
import lol.gito.radgyms.world.PlayerSpawnHelper;
import lol.gito.radgyms.world.StructureManager;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eJ9\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019JE\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010!J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010!J\u0015\u0010$\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010!J\r\u0010%\u001a\u00020\u001f\u00a2\u0006\u0004\b%\u0010\u0003R#\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0&8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R#\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020,0&8\u0006\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+\u00a8\u0006/"}, d2={"Llol/gito/radgyms/gym/GymManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "serverPlayer", "Lnet/minecraft/class_3218;", "serverWorld", "", "level", "", "type", "", "initInstance", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3218;ILjava/lang/String;)Z", "Llol/gito/radgyms/gym/GymTemplate;", "template", "gymDimension", "Lnet/minecraft/class_2338;", "coords", "", "Lkotlin/Pair;", "Ljava/util/UUID;", "Llol/gito/radgyms/gym/GymTrainer;", "buildTrainers", "(Llol/gito/radgyms/gym/GymTemplate;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Ljava/util/List;", "trainerTemplate", "trainerUUID", "requiredUUID", "buildTrainerEntity", "(Llol/gito/radgyms/gym/GymTrainer;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Ljava/util/UUID;Ljava/util/UUID;)Lkotlin/Pair;", "", "handleLeaderBattleWon", "(Lnet/minecraft/class_3222;)V", "handleGymLeave", "destructGym", "handleLootDistribution", "register", "", "Llol/gito/radgyms/gym/GymDTO;", "GYM_TEMPLATES", "Ljava/util/Map;", "getGYM_TEMPLATES", "()Ljava/util/Map;", "Llol/gito/radgyms/gym/GymInstance;", "PLAYER_GYMS", "getPLAYER_GYMS", "Rad Gyms [Cobblemon]"})
@SourceDebugExtension(value={"SMAP\nGymManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/gym/GymManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,346:1\n1#2:347\n1863#3,2:348\n1863#3,2:354\n774#3:356\n865#3,2:357\n1863#3:359\n1863#3,2:360\n1864#3:362\n126#4:350\n153#4,3:351\n*S KotlinDebug\n*F\n+ 1 GymManager.kt\nlol/gito/radgyms/gym/GymManager\n*L\n157#1:348,2\n274#1:354,2\n290#1:356\n290#1:357,2\n293#1:359\n309#1:360,2\n293#1:362\n169#1:350\n169#1:351,3\n*E\n"})
public final class GymManager {
    @NotNull
    public static final GymManager INSTANCE = new GymManager();
    @NotNull
    private static final Map<String, GymDTO> GYM_TEMPLATES = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, GymInstance> PLAYER_GYMS = new LinkedHashMap();

    private GymManager() {
    }

    @NotNull
    public final Map<String, GymDTO> getGYM_TEMPLATES() {
        return GYM_TEMPLATES;
    }

    @NotNull
    public final Map<UUID, GymInstance> getPLAYER_GYMS() {
        return PLAYER_GYMS;
    }

    public final boolean initInstance(@NotNull class_3222 serverPlayer, @NotNull class_3218 serverWorld, int level, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)serverWorld, (String)"serverWorld");
        PLAYER_GYMS.remove(serverPlayer.method_5667());
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        int gymLevel = RangesKt.coerceIn((int)level, (ClosedRange)((ClosedRange)new IntRange(5, 100)));
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        if (minecraftServer == null || (minecraftServer = minecraftServer.method_3847(DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) == null) {
            return false;
        }
        MinecraftServer gymDimension = minecraftServer;
        if (!Intrinsics.areEqual((Object)serverWorld.method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) {
            GymTemplate gym;
            class_243 pos = serverPlayer.method_19538();
            String gymType = CollectionsKt.contains((Iterable)GYM_TEMPLATES.keySet(), (Object)type) ? type : "default";
            RadGyms.INSTANCE.debug("Initializing " + gymType + " template for " + type + " gym");
            RadGyms.INSTANCE.debug("Available templates " + GYM_TEMPLATES.keySet());
            GymDTO gymDTO = GYM_TEMPLATES.get(gymType);
            if (gymDTO != null) {
                GymDTO it = gymDTO;
                boolean bl = false;
                v2 = GymTemplate.INSTANCE.fromGymDto(it, gymLevel, type);
            } else {
                v2 = gym = null;
            }
            if (gym != null) {
                class_2338 coords = PlayerSpawnHelper.INSTANCE.getUniquePlayerCoords(serverPlayer, (class_3218)gymDimension);
                double destX = (double)coords.method_10263() + gym.getRelativePlayerSpawn().field_1352;
                double destY = (double)coords.method_10264() + gym.getRelativePlayerSpawn().field_1351;
                double destZ = (double)coords.method_10260() + gym.getRelativePlayerSpawn().field_1350;
                new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).delay(0.1f).execute(arg_0 -> GymManager.initInstance$lambda$1(gym, coords, (class_3218)gymDimension, arg_0)).build();
                new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).execute(arg_0 -> GymManager.initInstance$lambda$2(serverWorld, serverPlayer, pos, (class_3218)gymDimension, destX, destY, destZ, gym, arg_0)).build();
                new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).delay(1.0f).execute(arg_0 -> GymManager.initInstance$lambda$3(gym, (class_3218)gymDimension, coords, gymType, type, serverPlayer, gymLevel, arg_0)).build();
                RadGyms.INSTANCE.debug("Gym " + gymType + " initialized, took " + Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime)) + "ms");
                return true;
            }
            RadGyms.INSTANCE.getLOGGER().warn("Gym " + gymType + " could not be initialized, no such type in template registry");
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<UUID, GymTrainer>> buildTrainers(GymTemplate template, class_3218 gymDimension, class_2338 coords) {
        void $this$mapTo$iv$iv;
        Object requiredUUID;
        Map trainerIds = new LinkedHashMap();
        Iterable $this$forEach$iv = template.getTrainers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uUID;
            GymTrainer it = (GymTrainer)element$iv;
            boolean bl = false;
            UUID uuid = UUID.randomUUID();
            if (it.getRequires() != null) {
                Pair pair = (Pair)trainerIds.get(it.getRequires());
                uUID = pair != null ? (UUID)pair.getFirst() : null;
            } else {
                uUID = null;
            }
            requiredUUID = uUID;
            Intrinsics.checkNotNull((Object)uuid);
            Pair<UUID, GymTrainer> entity = INSTANCE.buildTrainerEntity(it, gymDimension, coords, uuid, (UUID)requiredUUID);
            boolean bl2 = false;
            trainerIds.put(it.getId(), entity);
        }
        Map $this$map$iv = trainerIds;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            requiredUUID = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Pair)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    private final Pair<UUID, GymTrainer> buildTrainerEntity(GymTrainer trainerTemplate, class_3218 gymDimension, class_2338 coords, UUID trainerUUID, UUID requiredUUID) {
        Trainer trainer;
        Trainer $this$buildTrainerEntity_u24lambda_u247 = trainer = new Trainer(EntityManager.INSTANCE.getGYM_TRAINER(), (class_1937)gymDimension);
        boolean bl = false;
        $this$buildTrainerEntity_u24lambda_u247.method_5971();
        $this$buildTrainerEntity_u24lambda_u247.method_5826(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u247.field_6241 = trainerTemplate.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u247.field_6283 = trainerTemplate.getNpc().getYaw();
        $this$buildTrainerEntity_u24lambda_u247.method_5665(class_2561.method_30163((String)trainerTemplate.getNpc().getName()));
        $this$buildTrainerEntity_u24lambda_u247.method_5880(true);
        $this$buildTrainerEntity_u24lambda_u247.method_33574(new class_243((double)coords.method_10263() + trainerTemplate.getNpc().getRelativePosition().field_1352, (double)coords.method_10264() + trainerTemplate.getNpc().getRelativePosition().field_1351, (double)coords.method_10260() + trainerTemplate.getNpc().getRelativePosition().field_1350));
        $this$buildTrainerEntity_u24lambda_u247.setTrainerId(trainerUUID);
        $this$buildTrainerEntity_u24lambda_u247.setRequires(requiredUUID);
        $this$buildTrainerEntity_u24lambda_u247.setLeader(trainerTemplate.getLeader());
        Trainer it = trainer;
        boolean bl2 = false;
        RadGyms.INSTANCE.debug("Spawning trainer " + it.method_5628() + " at " + it.method_19538().field_1352 + " " + it.method_19538().field_1351 + " " + it.method_19538().field_1350 + " in " + gymDimension.method_27983().method_29177());
        gymDimension.method_8649((class_1297)it);
        Trainer trainerEntity = trainer;
        return new Pair((Object)trainerEntity.method_5667(), (Object)trainerTemplate);
    }

    public final void handleLeaderBattleWon(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        GymInstance gymInstance = PLAYER_GYMS.get(serverPlayer.method_5667());
        if (gymInstance == null) {
            return;
        }
        GymInstance gym = gymInstance;
        class_2338 exitPos = new class_2338((int)((double)gym.getCoords().method_10263() + gym.getTemplate().getRelativeExitBlockSpawn().field_1352), (int)((double)gym.getCoords().method_10264() + gym.getTemplate().getRelativeExitBlockSpawn().field_1351), (int)((double)gym.getCoords().method_10260() + gym.getTemplate().getRelativeExitBlockSpawn().field_1350));
        serverPlayer.method_37908().method_8501(exitPos, BlockRegistry.GYM_EXIT.method_9564());
        serverPlayer.method_37908().method_8524(exitPos);
        serverPlayer.method_43496((class_2561)class_2561.method_43471((String)RadGyms.INSTANCE.modId("message.info.gym_complete").method_42094()));
    }

    public final void handleGymLeave(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        class_2960 returnDim = GymsNbtData.INSTANCE.getReturnDimension((EntityDataSaver)serverPlayer) == null ? class_7134.field_37670 : class_2960.method_60654((String)GymsNbtData.INSTANCE.getReturnDimension((EntityDataSaver)serverPlayer));
        class_3218 class_32182 = serverPlayer.field_13995.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)returnDim));
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 dim = class_32182;
        class_2338 class_23382 = GymsNbtData.INSTANCE.getReturnCoordinates((EntityDataSaver)serverPlayer);
        if (class_23382 == null) {
            class_23382 = dim.method_43126();
        }
        class_2338 returnCoords = class_23382;
        this.destructGym(serverPlayer);
        new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).execute(arg_0 -> GymManager.handleGymLeave$lambda$9(returnCoords, serverPlayer, dim, arg_0)).build();
        new ScheduledTask.Builder().tracker((SchedulingTracker)ServerTaskTracker.INSTANCE).delay(1.0f).execute(arg_0 -> GymManager.handleGymLeave$lambda$12(returnCoords, serverPlayer, dim, arg_0)).build();
    }

    public final void destructGym(@NotNull class_3222 serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        GymInstance gymInstance = PLAYER_GYMS.get(serverPlayer.method_5667());
        if (gymInstance == null) {
            return;
        }
        GymInstance gym = gymInstance;
        class_1937 world = serverPlayer.method_37908();
        Iterable $this$forEach$iv = gym.getNpcList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            RadGyms.INSTANCE.debug("Removing trainer " + it.getSecond() + " from registry and detaching associated entity");
            RadGyms.INSTANCE.getRCT().getTrainerRegistry().unregisterById(((UUID)it.getFirst()).toString());
            Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
            class_1297 class_12972 = ((class_3218)world).method_14190((UUID)it.getFirst());
            if (class_12972 == null) continue;
            class_12972.method_31472();
        }
        PLAYER_GYMS.remove(serverPlayer.method_5667());
    }

    /*
     * WARNING - void declaration
     */
    public final void handleLootDistribution(@NotNull class_3222 serverPlayer) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        GymInstance gymInstance = PLAYER_GYMS.get(serverPlayer.method_5667());
        if (gymInstance == null) {
            return;
        }
        GymInstance gym = gymInstance;
        class_1799 bundle = new class_1799((class_1935)class_1802.field_27023);
        class_9276.class_9277 bundleContents = new class_9276.class_9277(class_9276.field_49289);
        Iterable iterable = gym.getTemplate().getLootTables();
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GymLootTable it = (GymLootTable)element$iv$iv;
            boolean bl3 = false;
            int n = ((Number)it.getLevels().getFirst()).intValue();
            int n2 = ((Number)it.getLevels().getSecond()).intValue();
            int n3 = gym.getLevel();
            boolean bl2 = n <= n3 ? n3 <= n2 : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            class_52 registryLootTable;
            GymLootTable table = (GymLootTable)element$iv;
            boolean bl = false;
            RadGyms.INSTANCE.debug("Settling level " + gym.getLevel() + " rewards for player " + serverPlayer.method_5477().method_54160() + " after beating leader");
            if ((class_52)serverPlayer.field_13995.method_58576().method_58289().method_30530(class_7924.field_50079).method_10223(table.getId()) == null) continue;
            class_1937 class_19372 = serverPlayer.method_37908();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
            class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)class_19372).method_51874(class_181.field_1226, (Object)serverPlayer).method_51874(class_181.field_24424, (Object)serverPlayer.method_19538()).method_51875(class_173.field_16235);
            ObjectArrayList objectArrayList = registryLootTable.method_51878(lootContextParameterSet);
            Intrinsics.checkNotNullExpressionValue((Object)objectArrayList, (String)"generateLoot(...)");
            Iterable bl3 = (Iterable)objectArrayList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                class_1799 itemStack = (class_1799)element$iv2;
                boolean bl4 = false;
                bundleContents.method_57432(itemStack);
            }
        }
        class_5250 styledLevel = class_5250.method_43477((class_7417)class_2561.method_30163((String)String.valueOf(gym.getLevel())).method_10851()).method_27692(class_124.field_1065);
        class_5250 styledType = class_5250.method_43477((class_7417)class_2561.method_30163((String)gym.getType()).method_10851()).method_27692(class_124.field_1056).method_27692(class_124.field_1060);
        objectArray = new Object[]{styledLevel, styledType};
        bundle.method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)RadGyms.INSTANCE.modId("gym_reward").method_42093("item"), (Object[])objectArray));
        bundle.method_57379(class_9334.field_49650, (Object)bundleContents.method_57435());
        bundle.method_57379(DataComponentManager.INSTANCE.getRAD_GYM_BUNDLE_COMPONENT(), (Object)true);
        if (!serverPlayer.method_7270(bundle)) {
            class_1542 it = new class_1542(serverPlayer.method_37908(), serverPlayer.method_19538().field_1352, serverPlayer.method_19538().field_1351, serverPlayer.method_19538().field_1350, bundle);
            boolean bl = false;
            serverPlayer.method_37908().method_8649((class_1297)it);
        }
    }

    public final void register() {
        RadGyms.INSTANCE.debug("GymManager init");
    }

    private static final Unit initInstance$lambda$1(GymTemplate $gym, class_2338 $coords, class_3218 $gymDimension, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadGyms.INSTANCE.debug("Trying to place gym structure with " + $gym.getStructure() + " at " + $coords.method_10263() + " " + $coords.method_10264() + " " + $coords.method_10260() + " ");
        StructureManager.INSTANCE.placeStructure((class_5281)$gymDimension, $coords, $gym.getStructure());
        return Unit.INSTANCE;
    }

    private static final Unit initInstance$lambda$2(class_3218 $serverWorld, class_3222 $serverPlayer, class_243 $pos, class_3218 $gymDimension, double $destX, double $destY, double $destZ, GymTemplate $gym, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadGyms.INSTANCE.debug("return dim " + $serverWorld.method_27983().method_29177());
        Intrinsics.checkNotNull((Object)$serverPlayer, (String)"null cannot be cast to non-null type lol.gito.radgyms.nbt.EntityDataSaver");
        GymsNbtData.INSTANCE.setReturnDimension((EntityDataSaver)$serverPlayer, $serverWorld.method_27983().method_29177().toString());
        EntityDataSaver entityDataSaver = (EntityDataSaver)$serverPlayer;
        Intrinsics.checkNotNull((Object)$pos);
        GymsNbtData.INSTANCE.setReturnCoordinates(entityDataSaver, Vec3ExtensionsKt.toBlockPos((class_243)$pos));
        PlayerSpawnHelper.INSTANCE.teleportPlayer($serverPlayer, $gymDimension, $destX, $destY, $destZ, $gym.getPlayerYaw(), 0.0f);
        return Unit.INSTANCE;
    }

    private static final Unit initInstance$lambda$3(GymTemplate $gym, class_3218 $gymDimension, class_2338 $coords, String $gymType, String $type, class_3222 $serverPlayer, int $gymLevel, ScheduledTask it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<Pair<UUID, GymTrainer>> trainerUUIDs = INSTANCE.buildTrainers($gym, $gymDimension, $coords);
        class_5250 chaosTranslatable = class_2561.method_43471((String)RadGyms.INSTANCE.modId("type").method_48331(".chaos").method_42094());
        String string2 = $gymType;
        String label = Intrinsics.areEqual((Object)string2, (Object)"default") ? (Intrinsics.areEqual((Object)(string = $type), (Object)"default") ? chaosTranslatable.getString() : (string == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + $type)).method_42094()).getString())) : (string2 == null ? chaosTranslatable.getString() : class_2561.method_43471((String)MiscUtilsKt.cobblemonResource((String)("type." + $type)).method_42094()).getString());
        UUID uUID = $serverPlayer.method_5667();
        Intrinsics.checkNotNull((Object)label);
        PLAYER_GYMS.put(uUID, new GymInstance($gym, trainerUUIDs, $coords, $gymLevel, label));
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$9(class_2338 $returnCoords, class_3222 $serverPlayer, class_3218 $dim, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_2338 returnBlockPos = new class_2338($returnCoords.method_10263(), $returnCoords.method_10264(), $returnCoords.method_10260());
        class_2791 preloadPos = ((class_1297)$serverPlayer).method_37908().method_22350(returnBlockPos);
        $dim.method_14178().method_17297(class_3230.field_19280, preloadPos.method_12004(), 1, (Object)returnBlockPos);
        return Unit.INSTANCE;
    }

    private static final Unit handleGymLeave$lambda$12(class_2338 $returnCoords, class_3222 $serverPlayer, class_3218 $dim, ScheduledTask it) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_2338 it2 = $returnCoords;
        boolean bl = false;
        PlayerSpawnHelper.INSTANCE.teleportPlayer($serverPlayer, $dim, it2.method_10263(), it2.method_10264(), it2.method_10260(), ((class_1297)$serverPlayer).method_36454(), ((class_1297)$serverPlayer).method_36455());
        Unit it3 = unit = Unit.INSTANCE;
        boolean bl2 = false;
        RadGyms.INSTANCE.debug("Gym instance removed from memory");
        return Unit.INSTANCE;
    }
}

