/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerEvent;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lol.gito.radgyms.RadGyms;
import lol.gito.radgyms.block.BlockRegistry;
import lol.gito.radgyms.entity.Trainer;
import lol.gito.radgyms.gym.GymInstance;
import lol.gito.radgyms.gym.GymManager;
import lol.gito.radgyms.gym.SpeciesManager;
import lol.gito.radgyms.network.NetworkStackHandler;
import lol.gito.radgyms.world.DimensionManager;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J9\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010!J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020#H\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010\u0003J\u0017\u0010(\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Llol/gito/radgyms/event/EventManager;", "", "<init>", "()V", "", "register", "Lnet/minecraft/class_1657;", "playerEntity", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1268;", "hand", "Lnet/minecraft/class_3965;", "result", "Lnet/minecraft/class_1269;", "onBlockInteract", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1937;Lnet/minecraft/class_1268;Lnet/minecraft/class_3965;)Lnet/minecraft/class_1269;", "player", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2680;", "state", "Lnet/minecraft/class_2586;", "entity", "", "onBeforeBlockBreak", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2586;)Z", "Lcom/cobblemon/mod/common/platform/events/ServerEvent$Starting;", "event", "onServerStart", "(Lcom/cobblemon/mod/common/platform/events/ServerEvent$Starting;)V", "Lcom/cobblemon/mod/common/platform/events/ServerPlayerEvent;", "onPlayerJoin", "(Lcom/cobblemon/mod/common/platform/events/ServerPlayerEvent;)V", "onPlayerDisconnect", "Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;", "onGymBattleWon", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;)V", "onSpeciesUpdate", "Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;", "onGymBattleFled", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;)V", "Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;", "onGymBattleFainted", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;)V", "Rad Gyms [Cobblemon]"})
@SourceDebugExtension(value={"SMAP\nEventManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventManager.kt\nlol/gito/radgyms/event/EventManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1863#2,2:200\n2632#2,3:202\n2632#2,3:205\n230#2,2:208\n1863#2,2:210\n1863#2,2:212\n774#2:214\n865#2,2:215\n1863#2,2:217\n1734#2,3:219\n774#2:222\n865#2,2:223\n1863#2,2:225\n*S KotlinDebug\n*F\n+ 1 EventManager.kt\nlol/gito/radgyms/event/EventManager\n*L\n129#1:200,2\n142#1:202,3\n146#1:205,3\n150#1:208,2\n152#1:210,2\n167#1:212,2\n178#1:214\n178#1:215,2\n179#1:217,2\n189#1:219,3\n193#1:222\n193#1:223,2\n194#1:225,2\n*E\n"})
public final class EventManager {
    @NotNull
    public static final EventManager INSTANCE = new EventManager();

    private EventManager() {
    }

    public final void register() {
        RadGyms.INSTANCE.debug("Registering event handlers");
        UseBlockCallback.EVENT.register(this::onBlockInteract);
        PlayerBlockBreakEvents.BEFORE.register(this::onBeforeBlockBreak);
        PlatformEvents.SERVER_STARTING.subscribe(Priority.LOW, (Function1)new Function1<ServerEvent.Starting, Unit>((Object)this){

            public final void invoke(ServerEvent.Starting p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onServerStart((EventManager)this.receiver, p0);
            }
        });
        PlatformEvents.SERVER_PLAYER_LOGIN.subscribe(Priority.LOW, (Function1)new Function1<ServerPlayerEvent, Unit>((Object)this){

            public final void invoke(ServerPlayerEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onPlayerJoin((EventManager)this.receiver, p0);
            }
        });
        PlatformEvents.SERVER_PLAYER_LOGOUT.subscribe(Priority.HIGHEST, (Function1)new Function1<ServerPlayerEvent, Unit>((Object)this){

            public final void invoke(ServerPlayerEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onPlayerDisconnect((EventManager)this.receiver, p0);
            }
        });
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, (Function1)new Function1<BattleVictoryEvent, Unit>((Object)this){

            public final void invoke(BattleVictoryEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onGymBattleWon((EventManager)this.receiver, p0);
            }
        });
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.LOWEST, (Function1)new Function1<BattleFledEvent, Unit>((Object)this){

            public final void invoke(BattleFledEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onGymBattleFled((EventManager)this.receiver, p0);
            }
        });
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.LOWEST, (Function1)new Function1<BattleFaintedEvent, Unit>((Object)this){

            public final void invoke(BattleFaintedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                EventManager.access$onGymBattleFainted((EventManager)this.receiver, p0);
            }
        });
        PokemonSpecies.INSTANCE.getObservable().subscribe(Priority.LOWEST, EventManager::register$lambda$0);
    }

    private final class_1269 onBlockInteract(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 result) {
        if (Intrinsics.areEqual((Object)world.method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) {
            class_1269 class_12692;
            if (Intrinsics.areEqual((Object)playerEntity.method_6047().method_7909(), (Object)BlockRegistry.GYM_EXIT.method_8389())) {
                class_12692 = class_1269.field_21466;
            } else {
                boolean bl;
                boolean bl2 = bl = !Intrinsics.areEqual((Object)world.method_8320(result.method_17777()).method_26204(), (Object)((Object)BlockRegistry.GYM_EXIT));
                if (bl) {
                    class_12692 = class_1269.field_5814;
                } else if (!bl) {
                    class_12692 = class_1269.field_5811;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return class_12692;
        }
        return class_1269.field_5811;
    }

    private final boolean onBeforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 entity) {
        if (Intrinsics.areEqual((Object)world.method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) {
            return false;
        }
        if (Intrinsics.areEqual((Object)state.method_26204(), (Object)((Object)BlockRegistry.GYM_ENTRANCE))) {
            boolean allowBreak = false;
            if (player.method_5715()) {
                player.method_43496((class_2561)class_2561.method_43471((String)RadGyms.INSTANCE.modId("message.error.gym_entrance.not-sneaking").method_42094()));
                allowBreak = true;
            }
            if (!allowBreak) {
                player.method_43496((class_2561)class_2561.method_43471((String)RadGyms.INSTANCE.modId("message.info.gym_entrance_breaking").method_42094()));
            }
            return allowBreak;
        }
        return true;
    }

    private final void onServerStart(ServerEvent.Starting event) {
        TrainerRegistry trainerRegistry = RadGyms.INSTANCE.getRCT().getTrainerRegistry();
        RadGyms.INSTANCE.debug("initializing RCT trainer mod registry");
        trainerRegistry.init(event.getServer());
    }

    private final void onPlayerJoin(ServerPlayerEvent event) {
        RadGyms.INSTANCE.debug("Adding player " + event.getPlayer().method_5477() + " in RadGyms trainer registry");
        RadGyms.INSTANCE.getRCT().getTrainerRegistry().registerPlayer(event.getPlayer().method_5667().toString(), event.getPlayer());
    }

    private final void onPlayerDisconnect(ServerPlayerEvent event) {
        block2: {
            Object object;
            RadGyms.INSTANCE.debug("Removing player " + event.getPlayer().method_5477() + " from RCT trainer mod registry");
            RadGyms.INSTANCE.getRCT().getTrainerRegistry().unregisterById(event.getPlayer().method_5667().toString());
            if (Intrinsics.areEqual((Object)event.getPlayer().method_37908().method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) {
                RadGyms.INSTANCE.getCHANNEL().serverHandle((class_1657)event.getPlayer()).send((Record)new NetworkStackHandler.GymLeave(null, true, 1, null));
            }
            if ((object = GymManager.INSTANCE.getPLAYER_GYMS().get(event.getPlayer().method_5667())) == null || (object = ((GymInstance)object).getNpcList()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                RadGyms.INSTANCE.debug("Removing trainer " + it.getSecond() + " from registry and discarding associated entity");
                com.gitlab.srcmc.rctapi.api.trainer.Trainer trainer = RadGyms.INSTANCE.getRCT().getTrainerRegistry().getById(((UUID)it.getFirst()).toString());
                trainer.getEntity().method_31472();
                RadGyms.INSTANCE.getRCT().getTrainerRegistry().unregisterById(((UUID)it.getFirst()).toString());
            }
        }
    }

    private final void onGymBattleWon(BattleVictoryEvent event) {
        Object element$iv3;
        block13: {
            boolean bl;
            block12: {
                BattleActor it;
                boolean bl2;
                boolean $i$f$none;
                Iterable $this$none$iv;
                block11: {
                    if (event.getWasWildCapture()) {
                        return;
                    }
                    $this$none$iv = event.getLosers();
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            it = (BattleActor)element$iv2;
                            boolean bl3 = false;
                            if (!(it.getType() == ActorType.NPC)) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return;
                }
                $this$none$iv = event.getWinners();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        it = (BattleActor)element$iv2;
                        boolean bl4 = false;
                        if (!(it.getType() == ActorType.PLAYER)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            Iterable $this$first$iv = event.getWinners();
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                BattleActor it = (BattleActor)element$iv3;
                boolean bl5 = false;
                if (!(it.getType() == ActorType.PLAYER)) continue;
                break block13;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv3;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.battles.actor.PlayerBattleActor");
        PlayerBattleActor winnerBattleActor = (PlayerBattleActor)t;
        class_3222 class_32222 = winnerBattleActor.getEntity();
        Intrinsics.checkNotNull((Object)class_32222, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
        class_3222 player = class_32222;
        Iterable $this$forEach$iv = event.getLosers();
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            BattleActor loser = (BattleActor)element$iv3;
            boolean bl = false;
            if (loser.getType() != ActorType.NPC || !(loser instanceof BattleManager.TrainerEntityBattleActor) || !(((BattleManager.TrainerEntityBattleActor)loser).getEntity() instanceof Trainer)) continue;
            class_1309 class_13092 = ((BattleManager.TrainerEntityBattleActor)loser).getEntity();
            Intrinsics.checkNotNull((Object)class_13092, (String)"null cannot be cast to non-null type lol.gito.radgyms.entity.Trainer");
            Trainer trainer = (Trainer)class_13092;
            boolean bl6 = false;
            trainer.setDefeated(true);
            if (!trainer.getLeader()) continue;
            GymManager.INSTANCE.handleLeaderBattleWon(player);
            GymManager.INSTANCE.handleLootDistribution(player);
        }
    }

    private final void onSpeciesUpdate() {
        SpeciesManager.INSTANCE.getSPECIES_BY_TYPE().clear();
        Iterable $this$forEach$iv = ElementalTypes.INSTANCE.all();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElementalType it = (ElementalType)element$iv;
            boolean bl = false;
            ((Map)SpeciesManager.INSTANCE.getSPECIES_BY_TYPE()).put(it.getName(), SpeciesManager.INSTANCE.speciesOfType(it));
            List<Pair<Species, FormData>> list = SpeciesManager.INSTANCE.getSPECIES_BY_TYPE().get(it.getName());
            RadGyms.INSTANCE.debug("Added " + (list != null ? Integer.valueOf(list.size()) : null) + " " + it.getName() + " entries to species map");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onGymBattleFled(BattleFledEvent event) {
        void $this$filterTo$iv$iv;
        PlayerBattleActor loser = event.getPlayer();
        if (loser.getType() != ActorType.PLAYER) {
            return;
        }
        Iterable $this$filter$iv = event.getBattle().getPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.method_37908().method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            RadGyms.INSTANCE.getCHANNEL().serverHandle((class_1657)player).send((Record)new NetworkStackHandler.GymLeave(null, true, 1, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onGymBattleFainted(BattleFaintedEvent event) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean bl;
        Iterable $this$all$iv;
        class_1309 owner;
        block10: {
            BattlePokemon killed = event.getKilled();
            PokemonEntity pokemonEntity = killed.getEntity();
            if (pokemonEntity == null) {
                return;
            }
            PokemonEntity entity = pokemonEntity;
            class_1309 class_13092 = entity.method_35057();
            if (class_13092 == null) {
                return;
            }
            owner = class_13092;
            if (killed.getActor().getType() != ActorType.PLAYER) {
                return;
            }
            $this$all$iv = killed.getActor().getPokemonList();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BattlePokemon it = (BattlePokemon)element$iv;
                    boolean bl2 = false;
                    if (it.getHealth() == 0) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (!bl) {
            return;
        }
        if (owner.method_29504()) {
            return;
        }
        $this$all$iv = event.getBattle().getPlayers();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.method_37908().method_27983(), DimensionManager.INSTANCE.getRADGYMS_LEVEL_KEY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl4 = false;
            RadGyms.INSTANCE.getCHANNEL().serverHandle((class_1657)player).send((Record)new NetworkStackHandler.GymLeave(null, true, 1, null));
        }
    }

    private static final Unit register$lambda$0(PokemonSpecies pokemonSpecies) {
        Intrinsics.checkNotNullParameter((Object)pokemonSpecies, (String)"<unused var>");
        RadGyms.INSTANCE.debug("Cobblemon species observable triggered, updating elemental gyms species map");
        INSTANCE.onSpeciesUpdate();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onServerStart(EventManager $this, ServerEvent.Starting event) {
        $this.onServerStart(event);
    }

    public static final /* synthetic */ void access$onPlayerJoin(EventManager $this, ServerPlayerEvent event) {
        $this.onPlayerJoin(event);
    }

    public static final /* synthetic */ void access$onPlayerDisconnect(EventManager $this, ServerPlayerEvent event) {
        $this.onPlayerDisconnect(event);
    }

    public static final /* synthetic */ void access$onGymBattleWon(EventManager $this, BattleVictoryEvent event) {
        $this.onGymBattleWon(event);
    }

    public static final /* synthetic */ void access$onGymBattleFled(EventManager $this, BattleFledEvent event) {
        $this.onGymBattleFled(event);
    }

    public static final /* synthetic */ void access$onGymBattleFainted(EventManager $this, BattleFaintedEvent event) {
        $this.onGymBattleFainted(event);
    }
}

