/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.gson.JsonElement;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record StateLookup(Map<String, Bucket> substrates) implements Lookup<class_2680>
{
    public StateLookup() {
        this((Map<String, Bucket>)new Object2ObjectLinkedOpenHashMap());
    }

    @Override
    public SoundsKey getAssociation(class_2680 state, String substrate) {
        return this.substrates.getOrDefault((Object)substrate, (Bucket)Bucket.EMPTY).get((class_2680)state).value;
    }

    @Override
    public void add(String key, JsonElement value) {
        SoundsKey sound = SoundsKey.of(value.getAsString());
        if (!sound.isResult()) {
            return;
        }
        Key k = Key.of(key, sound);
        this.substrates.computeIfAbsent(k.substrate, Bucket.Substrate::new).add(k);
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public boolean contains(class_2680 state) {
        for (Bucket substrate : this.substrates.values()) {
            if (!substrate.contains(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.each(class_7923.field_41175, block -> {
            class_2680 state = block.method_9564();
            class_2498 group = block.method_9564().method_26231();
            if (group != null && group.method_10594() != null) {
                String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
                groups.put(group.method_10594().method_14833().toString() + "@" + substrate, group);
            }
            boolean excludeFromExport = false;
            if (!full) {
                for (String substrate : this.substrates.keySet()) {
                    if (!"wet".equals(substrate) && (excludeFromExport |= this.substrates.get(substrate).contains(state))) break;
                }
            }
            if (!excludeFromExport) {
                writer.object(class_7923.field_41175.method_10221(block).toString(), () -> {
                    writer.field("class", this.getClassData(state));
                    writer.field("tags", this.getTagData(state));
                    writer.field("sound", this.getSoundData(group));
                    writer.object("associations", () -> this.getSubstrates().forEach(substrate -> {
                        try {
                            SoundsKey association = this.getAssociation(state, (String)substrate);
                            if (association.isResult()) {
                                writer.field((String)substrate, association.raw());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }));
                });
            }
        });
    }

    private String getSoundData(@Nullable class_2498 group) {
        if (group == null) {
            return "NULL";
        }
        if (group.method_10594() == null) {
            return "NO_SOUND";
        }
        return group.method_10594().method_14833().method_12832();
    }

    private String getClassData(class_2680 state) {
        @Nullable String canonicalName = state.method_26204().getClass().getCanonicalName();
        if (canonicalName == null) {
            return "<anonymous>";
        }
        try {
            MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
            return resolver.unmapClassName(resolver.getNamespaces().contains("named") ? "named" : "intermediary", canonicalName);
        }
        catch (Throwable throwable) {
            return canonicalName;
        }
    }

    private String getTagData(class_2680 state) {
        return class_7923.field_41175.method_40273().filter(arg_0 -> ((class_2680)state).method_26164(arg_0)).map(class_6862::comp_327).map(class_2960::toString).collect(Collectors.joining(","));
    }

    private static interface Bucket {
        public static final Bucket EMPTY = state -> Key.NULL;

        default public void add(Key key) {
        }

        public Key get(class_2680 var1);

        default public boolean contains(class_2680 state) {
            return false;
        }

        public record Tile(Map<class_2680, Key> cache, KeyList keys) implements Bucket
        {
            Tile(class_2960 id) {
                this((Map<class_2680, Key>)new Object2ObjectLinkedOpenHashMap(), new KeyList());
            }

            @Override
            public void add(Key key) {
                this.keys.add(key);
            }

            @Override
            public Key get(class_2680 state) {
                return this.cache.computeIfAbsent(state, this.keys::findMatch);
            }

            @Override
            public boolean contains(class_2680 state) {
                return this.get(state) != Key.NULL;
            }
        }

        public record Substrate(KeyList wildcards, Map<class_2960, Bucket> blocks, Map<class_2960, Bucket> tags) implements Bucket
        {
            Substrate(String substrate) {
                this(new KeyList(), (Map<class_2960, Bucket>)new Object2ObjectLinkedOpenHashMap(), (Map<class_2960, Bucket>)new Object2ObjectLinkedOpenHashMap());
            }

            @Override
            public void add(Key key) {
                if (key.isWildcard()) {
                    this.wildcards.add(key);
                } else {
                    (key.isTag() ? this.tags : this.blocks).computeIfAbsent(key.identifier(), Tile::new).add(key);
                }
            }

            @Override
            public Key get(class_2680 state) {
                Key association = this.getTile(state).get(state);
                return association == Key.NULL ? this.wildcards.findMatch(state) : association;
            }

            @Override
            public boolean contains(class_2680 state) {
                return this.getTile(state).contains(state) || this.wildcards.findMatch(state) != Key.NULL;
            }

            private Bucket getTile(class_2680 state) {
                return this.blocks.computeIfAbsent(class_7923.field_41175.method_10221((Object)state.method_26204()), id -> {
                    for (class_2960 tag : this.tags.keySet()) {
                        if (!state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tag))) continue;
                        return this.tags.get(tag);
                    }
                    return EMPTY;
                });
            }
        }
    }

    private record Key(class_2960 identifier, String substrate, Set<Attribute> properties, SoundsKey value, boolean empty, boolean isTag, boolean isWildcard) {
        public static final Key NULL = new Key(class_2960.method_60656((String)"air"), "", (Set<Attribute>)ObjectSets.emptySet(), SoundsKey.UNASSIGNED, true, false, false);

        public static Key of(String key, SoundsKey value) {
            String id;
            boolean isTag;
            boolean bl = isTag = key.indexOf(35) == 0;
            if (isTag) {
                key = key.replaceFirst("#", "");
            }
            boolean isWildcard = (id = key.split("[\\.\\[]")[0]).indexOf(42) == 0;
            class_2960 identifier = NULL.identifier();
            if (!isWildcard) {
                if (id.indexOf(94) > -1) {
                    identifier = class_2960.method_60654((String)id.split("\\^")[0]);
                    PresenceFootsteps.logger.warn("Metadata entry for " + key + "=" + value.raw() + " was ignored");
                } else {
                    identifier = class_2960.method_60654((String)id);
                }
                if (!isTag && !class_7923.field_41175.method_10250(identifier)) {
                    PresenceFootsteps.logger.warn("Sound registered for unknown block id " + String.valueOf(identifier));
                }
            }
            key = key.replace(id, "");
            String substrate = key.replaceFirst("\\[[^\\]]+\\]", "");
            String finalSubstrate = "";
            if (substrate.indexOf(46) > -1) {
                finalSubstrate = substrate.split("\\.")[1];
                key = key.replace(substrate, "");
            }
            Set properties = (Set)ObjectArrayList.of((Object[])key.replace("[", "").replace("]", "").split(",")).stream().filter(line -> line.indexOf(61) > -1).map(Attribute::new).collect(ObjectOpenHashSet.toSet());
            boolean empty = properties.isEmpty();
            return new Key(identifier, finalSubstrate, properties, value, empty, isTag, isWildcard);
        }

        boolean matches(class_2680 state) {
            if (this.empty) {
                return true;
            }
            Map entries = state.method_11656();
            Set keys = entries.keySet();
            for (Attribute property : this.properties) {
                for (class_2769 key : keys) {
                    Comparable value;
                    if (!key.method_11899().equals(property.name) || Objects.toString(value = (Comparable)entries.get(key)).equalsIgnoreCase(property.value)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return (this.isTag ? "#" : "") + String.valueOf(this.identifier) + "[" + this.properties.stream().map(Attribute::toString).collect(Collectors.joining()) + "]." + this.substrate + "=" + String.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.empty, this.identifier, this.isTag, this.isWildcard, this.properties, this.substrate);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass() == obj.getClass() && this.equals((Key)obj);
        }

        private boolean equals(Key other) {
            return this.isTag == other.isTag && this.isWildcard == other.isWildcard && this.empty == other.empty && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.substrate, other.substrate) && Objects.equals(this.properties, other.properties);
        }

        private record Attribute(String name, String value) {
            Attribute(String prop) {
                this(prop.split("="));
            }

            Attribute(String[] split) {
                this(split[0], split[1]);
            }

            @Override
            public String toString() {
                return this.name + "=" + this.value;
            }
        }
    }

    private record KeyList(Set<Key> priorityKeys, Set<Key> keys) {
        public KeyList() {
            this((Set<Key>)new ObjectLinkedOpenHashSet(), (Set<Key>)new ObjectLinkedOpenHashSet());
        }

        void add(Key key) {
            Set<Key> keys = this.getSetFor(key);
            keys.remove(key);
            keys.add(key);
        }

        private Set<Key> getSetFor(Key key) {
            return key.empty() ? this.keys : this.priorityKeys;
        }

        public Key findMatch(class_2680 state) {
            for (Key i : this.priorityKeys) {
                if (!i.matches(state)) continue;
                return i;
            }
            for (Key i : this.keys) {
                if (!i.matches(state)) continue;
                return i;
            }
            return Key.NULL;
        }
    }
}

