/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import java.io.IOException;
import net.minecraft.class_1309;

record ChanceAcoustic(Acoustic acoustic, float probability) implements Acoustic
{
    static final Acoustic.Serializer FACTORY = Acoustic.Serializer.ofJsObject((json, context) -> new ChanceAcoustic(Acoustic.read(context, json.get("acoustic")), json.get("probability").getAsFloat()));

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        if (player.getRNG().nextFloat() * 100.0f <= this.probability) {
            this.acoustic.playSound(player, location, event, inputOptions);
        }
    }

    @Override
    public void write(AcousticsFile context, JsonObjectWriter writer) throws IOException {
        writer.object(() -> {
            writer.field("type", "chance");
            writer.field("probability", this.probability);
            writer.field("acoustic", () -> this.acoustic.write(context, writer));
        });
    }
}

