/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.worldgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.lootcrates.LootCrateAtlas;
import de.dafuqs.lootcrates.LootCrates;
import de.dafuqs.lootcrates.blocks.LootCrateBlock;
import de.dafuqs.lootcrates.blocks.LootCrateBlockEntity;
import de.dafuqs.lootcrates.blocks.chest.ChestLootCrateBlock;
import de.dafuqs.lootcrates.components.InventoryDeletionMode;
import de.dafuqs.lootcrates.components.LockMode;
import de.dafuqs.lootcrates.components.LootCrateDataComponentTypes;
import de.dafuqs.lootcrates.components.LootCrateLootComponent;
import de.dafuqs.lootcrates.components.ReplenishTimeScale;
import de.dafuqs.lootcrates.config.LootCrateReplacementEntry;
import de.dafuqs.lootcrates.config.WeightedLootCrateEntryList;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import de.dafuqs.lootcrates.mixin.LootTableAccessor;
import de.dafuqs.lootcrates.worldgen.LootCrateReplacementPosition;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2480;
import net.minecraft.class_2531;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_3708;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class LootCratesWorldgenReplacer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String DEFAULT_CONFIG = "[\n\t{\n\t\t\"loot_table\": \"\",\n\t\t\"entries\": [\n\t\t\t{\n\t\t\t\t\"crate_variant\": \"common\",\n\t\t\t\t\"tracked_per_player\": true,\n\t\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\t\"replenish_time_scale\": \"never\",\n\t\t\t\t\"weight\": 5\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"crate_variant\": \"epic\",\n\t\t\t\t\"tracked_per_player\": true,\n\t\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\t\"replenish_time_scale\": \"never\",\n\t\t\t\t\"weight\": 1\n\t\t\t}\n\t\t]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/bastion_bridge\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"blaze\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/bastion_hoglin_stable\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"blaze\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/bastion_other\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"blaze\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/bastion_treasure\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"blaze\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/buried_treasure\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"rare\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/end_city_treasure\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"epic\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/simple_dungeon\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"uncommon\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/stronghold_corridor\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"uncommon\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/underwater_ruin_big\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"rare\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/underwater_ruin_small\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"rare\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t},\n\t{\n\t\t\"loot_table\": \"minecraft:chests/woodland_mansion\",\n\t\t\"entries\": [{\n\t\t\t\"crate_variant\": \"ghost\",\n\t\t\t\"tracked_per_player\": true,\n\t\t\t\"lock_mode\": \"not_locked\",\n\t\t\t\"inventory_deletion_mode\": \"never\",\n\t\t\t\"replenish_time_scale\": \"never\"\n\t\t}]\n\t}\n]";
    public static final List<LootCrateReplacementPosition> replacements = new ArrayList<LootCrateReplacementPosition>();
    private static WeightedLootCrateEntryList DefaultLootCrateProviderList = new WeightedLootCrateEntryList(1, (List<LootCrateReplacementEntry>)new ArrayList<LootCrateReplacementEntry>(){
        {
            this.add(new LootCrateReplacementEntry(null, null, ReplenishTimeScale.TICKS, 1, LockMode.NOT_LOCKED, InventoryDeletionMode.NEVER, true, 1));
        }
    });
    private static final Map<class_5321<class_52>, WeightedLootCrateEntryList> LootCrateProviders = new HashMap<class_5321<class_52>, WeightedLootCrateEntryList>();

    public static void initialize(class_3218 world) {
        JsonElement jsonElement;
        FileReader configReader;
        File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "LootCratesWorldgenSettings.json5");
        try {
            configReader = new FileReader(configFile);
        }
        catch (Exception e) {
            try {
                configFile.createNewFile();
                FileWriter myWriter = new FileWriter(configFile);
                myWriter.write(DEFAULT_CONFIG);
                myWriter.close();
                configReader = new FileReader(configFile);
            }
            catch (IOException ioException) {
                LootCrates.LOGGER.error("Could not generate config file under {}.\n{}", (Object)configFile.getAbsolutePath(), (Object)ioException.getLocalizedMessage());
                return;
            }
        }
        try {
            jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)configReader, JsonElement.class);
        }
        catch (Exception e) {
            LootCrates.LOGGER.error("Could not parse the LootCratesWorldgenSettings.json5: {}", (Object)e.getLocalizedMessage());
            return;
        }
        JsonArray array = jsonElement.getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject currentEntry = (JsonObject)array.get(i);
            class_2960 lootTableIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)currentEntry, (String)"loot_table"));
            JsonArray weightedEntries = class_3518.method_15261((JsonObject)currentEntry, (String)"entries");
            int totalWeight = 0;
            ArrayList<LootCrateReplacementEntry> lootCrateEntries = new ArrayList<LootCrateReplacementEntry>();
            try {
                for (int j = 0; j < weightedEntries.size(); ++j) {
                    JsonObject targetEntry = (JsonObject)weightedEntries.get(j);
                    LootCrateVariant lootCrateVariant = LootCrateVariant.COMMON;
                    class_2960 lootTable = null;
                    boolean trackedPerPlayer = false;
                    int replenishTimeTicks = -1;
                    LockMode lockMode = LockMode.NOT_LOCKED;
                    ReplenishTimeScale replenishTimeScale = ReplenishTimeScale.NEVER;
                    InventoryDeletionMode inventoryDeletionMode = InventoryDeletionMode.NEVER;
                    int weight = 1;
                    if (class_3518.method_15289((JsonObject)targetEntry, (String)"crate_variant")) {
                        lootCrateVariant = LootCrateVariant.valueOf(class_3518.method_15265((JsonObject)targetEntry, (String)"crate_variant").toUpperCase(Locale.ROOT));
                    }
                    if (class_3518.method_15289((JsonObject)targetEntry, (String)"loot_table")) {
                        lootTable = class_2960.method_12829((String)class_3518.method_15265((JsonObject)targetEntry, (String)"loot_table"));
                    }
                    if (class_3518.method_15254((JsonObject)targetEntry, (String)"tracked_per_player")) {
                        trackedPerPlayer = class_3518.method_15270((JsonObject)targetEntry, (String)"tracked_per_player");
                    }
                    if (class_3518.method_34920((JsonObject)targetEntry, (String)"replenish_time_ticks")) {
                        replenishTimeTicks = class_3518.method_15260((JsonObject)targetEntry, (String)"replenish_time_ticks");
                    }
                    if (class_3518.method_15289((JsonObject)targetEntry, (String)"replenish_time_scale")) {
                        replenishTimeScale = ReplenishTimeScale.valueOf(class_3518.method_15265((JsonObject)targetEntry, (String)"replenish_time_scale").toUpperCase(Locale.ROOT));
                    }
                    if (class_3518.method_15289((JsonObject)targetEntry, (String)"lock_mode")) {
                        lockMode = LockMode.valueOf(class_3518.method_15265((JsonObject)targetEntry, (String)"lock_mode").toUpperCase(Locale.ROOT));
                    }
                    if (class_3518.method_15289((JsonObject)targetEntry, (String)"inventory_deletion_mode")) {
                        inventoryDeletionMode = InventoryDeletionMode.valueOf(class_3518.method_15265((JsonObject)targetEntry, (String)"inventory_deletion_mode").toUpperCase(Locale.ROOT));
                    }
                    if (class_3518.method_34920((JsonObject)targetEntry, (String)"weight")) {
                        weight = class_3518.method_15260((JsonObject)targetEntry, (String)"weight");
                    }
                    totalWeight += weight;
                    lootCrateEntries.add(new LootCrateReplacementEntry(lootCrateVariant, (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTable), replenishTimeScale, replenishTimeTicks, lockMode, inventoryDeletionMode, trackedPerPlayer, weight));
                }
            }
            catch (Exception e) {
                LootCrates.LOGGER.error("Error while reading worldgen replacement config file: {}", (Object)e.getLocalizedMessage());
            }
            WeightedLootCrateEntryList weightedLootCrateEntryList = new WeightedLootCrateEntryList(totalWeight, lootCrateEntries);
            if (lootTableIdentifier == null || lootTableIdentifier.method_12832().isEmpty()) {
                DefaultLootCrateProviderList = weightedLootCrateEntryList;
                continue;
            }
            LootCrateProviders.put((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableIdentifier), weightedLootCrateEntryList);
        }
    }

    public static LootCrateReplacementEntry getEntryForLootTable(class_5321<class_52> lootTable, class_5819 random) {
        if (LootCrateProviders.containsKey(lootTable)) {
            return LootCrateProviders.get(lootTable).getWeightedRandom(random);
        }
        return DefaultLootCrateProviderList.getWeightedRandom(random);
    }

    public static void tick(MinecraftServer server) {
        if (replacements.isEmpty()) {
            return;
        }
        ArrayList<LootCrateReplacementPosition> workingSet = new ArrayList<LootCrateReplacementPosition>();
        workingSet.addAll(replacements);
        replacements.clear();
        for (LootCrateReplacementPosition replacementPosition : workingSet) {
            try {
                LootCratesWorldgenReplacer.replace(replacementPosition);
            }
            catch (Throwable t) {
                LootCrates.LOGGER.error("Error while replacing a container in the world '{}' at '{}': {}", new Object[]{replacementPosition.world().method_27983().method_29177(), replacementPosition.blockPos(), t.getLocalizedMessage()});
            }
        }
    }

    private static void replace(@NotNull LootCrateReplacementPosition replacementPosition) {
        class_3218 serverWorld = replacementPosition.world();
        class_2338 pos = replacementPosition.blockPos();
        class_1923 chunkPos = new class_1923(pos);
        class_2791 chunk = serverWorld.method_14178().method_12121(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        class_2680 sourceState = serverWorld.method_8320(pos);
        class_2586 blockEntity = serverWorld.method_8321(pos);
        if (sourceState.method_31709() && blockEntity == null) {
            return;
        }
        if (blockEntity instanceof class_2621) {
            LootTableAccessor lootTableAccessor = (LootTableAccessor)blockEntity;
            class_5321<class_52> lootTable = lootTableAccessor.getLootTable();
            long lootTableSeed = lootTableAccessor.getLootTableSeed();
            class_2248 sourceBlock = sourceState.method_26204();
            if (!(sourceBlock instanceof LootCrateBlock)) {
                boolean trapped = false;
                LootCrateReplacementEntry replacementTargetData = LootCratesWorldgenReplacer.getEntryForLootTable(lootTable, serverWorld.field_9229);
                if (sourceBlock instanceof class_2281) {
                    if (sourceBlock instanceof class_2531) {
                        trapped = true;
                    }
                    serverWorld.method_8544(pos);
                    serverWorld.method_8501(pos, (class_2680)LootCrateAtlas.getLootCrate(replacementTargetData.lootCrateVariant).method_9564().method_11657((class_2769)ChestLootCrateBlock.FACING, (Comparable)((class_2350)sourceState.method_11654((class_2769)class_2281.field_10768))));
                } else if (sourceBlock instanceof class_3708) {
                    serverWorld.method_8544(pos);
                    serverWorld.method_8501(pos, (class_2680)LootCrateAtlas.getLootBarrel(replacementTargetData.lootCrateVariant).method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)sourceState.method_11654((class_2769)class_2741.field_12525))));
                } else if (sourceBlock instanceof class_2480) {
                    serverWorld.method_8544(pos);
                    serverWorld.method_8501(pos, (class_2680)LootCrateAtlas.getShulkerCrate(replacementTargetData.lootCrateVariant).method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)sourceState.method_11654((class_2769)class_2741.field_12525))));
                } else {
                    return;
                }
                blockEntity = serverWorld.method_8321(pos);
                if (blockEntity instanceof LootCrateBlockEntity) {
                    LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
                    if (replacementTargetData.lootTable == null) {
                        lootCrateBlockEntity.method_54867(lootTable, lootTableSeed);
                    } else {
                        lootCrateBlockEntity.method_54867(replacementTargetData.lootTable, lootTableSeed);
                    }
                    class_9323 components = lootCrateBlockEntity.method_58693();
                    LootCrateLootComponent lootComponent = new LootCrateLootComponent(lootTable, lootTableSeed, replacementTargetData.lockMode, replacementTargetData.replenishTimeScale, replacementTargetData.replenishTimeTicks, replacementTargetData.inventoryDeletionMode, replacementTargetData.trackedPerPlayer, trapped);
                    class_9323.class_9324 builder = class_9323.method_57827().method_57839(components).method_57840(LootCrateDataComponentTypes.LOOT_CRATE_LOOT, (Object)lootComponent);
                    lootCrateBlockEntity.method_58684(builder.method_57838());
                    lootCrateBlockEntity.method_5431();
                }
            }
        }
    }
}

