/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.config;

import de.dafuqs.lootcrates.LootCrates;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1937;

@Config(name="LootCrates")
public class LootCratesConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @Comment(value="Add Item Groups with example Crates and Bundles")
    public boolean AddExampleCratesAndBundlesItemGroups = false;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.PrefixText
    @Comment(value="How long Loot Crates take to break. <1 makes them indestructible.\nObsidian has 50. 150 makes them very much breakable, but taking ages.\nLong enough to absolutely not breakable by accident, but still possible to\nremove them if they are in the way somehow.")
    public float ChestCrateHardness = 150.0f;
    @ConfigEntry.Category(value="general")
    public float LootBarrelHardness = 150.0f;
    @ConfigEntry.Category(value="general")
    public float ShulkerCrateHardness = 3.0f;
    @Comment(value="If crates that are mined by players should drop as items\nOtherwise they will be destroyed and do not drop.")
    @ConfigEntry.Category(value="general")
    public boolean ChestCratesDropAsItems = false;
    @ConfigEntry.Category(value="general")
    public boolean LootBarrelsDropAsItems = false;
    @ConfigEntry.Category(value="general")
    public boolean ShulkerCratesDropAsItems = true;
    @Comment(value="Whether chest and shulker loot crates should keep their inventory when broken.\nOtherwise they will drop their contents just like broken chests")
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Category(value="general")
    public boolean ChestCratesKeepTheirInventory = false;
    @ConfigEntry.Category(value="general")
    public boolean LootBarrelsKeepTheirInventory = false;
    @ConfigEntry.Category(value="general")
    public boolean ShulkerCratesKeepTheirInventory = true;
    @ConfigEntry.Category(value="general")
    public boolean BlazingCratesCauseFire = true;
    @ConfigEntry.Category(value="worldgen")
    @Comment(value="If all chests that generate during worldgen should be replaced by loot crates.\nThis includes vanilla and modded structures. See the granular configuration in LootCratesWorldgenSettings.json5\nThis is especially useful if you want new players to find treasure in structures that were\nraided by players before, or if players should have an incentive to visit those structures again.\nSetting restocking to <= 0 results them functioning like vanilla chests.\nRestocking is only evaluated when players actually open chests, no performance impact besides that.\nSo feel free to leave it at 1 if you want loot to be available instantly for every unique player.")
    public boolean ReplaceVanillaWorldgenChests = true;
    @ConfigEntry.Category(value="worldgen")
    @Comment(value="Dimension identifiers where chests will not be replaced")
    public final List<String> ReplaceVanillaWorldgenChestsDimensionsBlacklist = new ArrayList<String>();

    public boolean isWorldBlacklisted(class_1937 world) {
        return LootCrates.CONFIG.ReplaceVanillaWorldgenChestsDimensionsBlacklist.contains(world.method_27983().method_29177().toString());
    }
}

