/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.components;

import de.dafuqs.lootcrates.components.PlayerCrateData;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum ReplenishTimeScale implements class_3542
{
    NEVER("never", false, false),
    TICKS("ticks", false, true),
    SECONDS("seconds", true, true),
    HOURS("hours", true, false),
    DAYS("days", true, false),
    WEEKS("weeks", true, false),
    MONTHS("months", true, false);

    private final String name;
    public final boolean usesRealTime;
    public final boolean requiresTickData;
    public static final class_3542.class_7292<ReplenishTimeScale> CODEC;

    private ReplenishTimeScale(String name, boolean usesRealTime, boolean requiresTickData) {
        this.name = name;
        this.usesRealTime = usesRealTime;
        this.requiresTickData = requiresTickData;
    }

    public boolean canReplenish(class_1937 world, @NotNull Optional<PlayerCrateData> playerCrateData, long replenishTime) {
        if (playerCrateData.isEmpty()) {
            return true;
        }
        switch (this.ordinal()) {
            case 1: {
                return world.method_8510() > playerCrateData.get().replenishTime() + replenishTime;
            }
            case 3: {
                ZonedDateTime now = ZonedDateTime.now();
                ZonedDateTime then = Instant.ofEpochMilli(playerCrateData.get().replenishTime()).atZone(ZoneId.systemDefault());
                return now.getYear() > then.getYear() || now.getDayOfYear() > then.getDayOfYear() || now.getHour() > then.getHour();
            }
            case 4: {
                ZonedDateTime now = ZonedDateTime.now();
                ZonedDateTime then = Instant.ofEpochMilli(playerCrateData.get().replenishTime()).atZone(ZoneId.systemDefault());
                return now.getYear() > then.getYear() || now.getDayOfYear() > then.getDayOfYear();
            }
            case 5: {
                ZonedDateTime now = ZonedDateTime.now();
                ZonedDateTime then = Instant.ofEpochMilli(playerCrateData.get().replenishTime()).atZone(ZoneId.systemDefault());
                return now.getYear() > then.getYear() || now.get(ChronoField.ALIGNED_WEEK_OF_YEAR) > then.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            }
            case 6: {
                ZonedDateTime now = ZonedDateTime.now();
                ZonedDateTime then = Instant.ofEpochMilli(playerCrateData.get().replenishTime()).atZone(ZoneId.systemDefault());
                return now.getYear() > then.getYear() || now.getMonthValue() > then.getMonthValue();
            }
            case 2: {
                long currentTime = ZonedDateTime.now().toInstant().toEpochMilli() / 1000L;
                return currentTime > (playerCrateData.get().replenishTime() + replenishTime) / 1000L;
            }
        }
        return false;
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(ReplenishTimeScale::values);
    }
}

