/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.lootcrates.components.PlayerCrateData;
import de.dafuqs.lootcrates.components.ReplenishTimeScale;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LootCratePlayerDataComponent(List<PlayerCrateData> playerData) {
    public static final Codec<LootCratePlayerDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlayerCrateData.CODEC.listOf().fieldOf("player_data").forGetter(LootCratePlayerDataComponent::playerData)).apply((Applicative)instance, LootCratePlayerDataComponent::new));
    private static final UUID NO_PLAYER_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static LootCratePlayerDataComponent lockForPlayer(@Nullable LootCratePlayerDataComponent playerDataComponent, class_1657 player, boolean trackedPerPlayer) {
        return LootCratePlayerDataComponent.setUnlockTime(playerDataComponent, player, trackedPerPlayer, -1L);
    }

    public static LootCratePlayerDataComponent unlockForPlayer(@Nullable LootCratePlayerDataComponent playerDataComponent, class_1657 player, boolean trackedPerPlayer, @NotNull ReplenishTimeScale replenishTimeScale) {
        long time = replenishTimeScale.usesRealTime ? ZonedDateTime.now().toInstant().toEpochMilli() : player.method_37908().method_8510();
        return LootCratePlayerDataComponent.setUnlockTime(playerDataComponent, player, trackedPerPlayer, time);
    }

    public static LootCratePlayerDataComponent setReplenishedForPlayer(@Nullable LootCratePlayerDataComponent playerDataComponent, class_1657 player, boolean trackedPerPlayer, @NotNull ReplenishTimeScale replenishTimeScale) {
        long time = replenishTimeScale.usesRealTime ? ZonedDateTime.now().toInstant().toEpochMilli() : player.method_37908().method_8510();
        return LootCratePlayerDataComponent.setReplenishTime(playerDataComponent, player, trackedPerPlayer, time);
    }

    private static LootCratePlayerDataComponent setUnlockTime(@Nullable LootCratePlayerDataComponent playerDataComponent, class_1657 player, boolean trackedPerPlayer, long unlockTime) {
        UUID playerUUID = trackedPerPlayer ? player.method_5667() : NO_PLAYER_UUID;
        ArrayList<PlayerCrateData> newData = new ArrayList<PlayerCrateData>();
        if (playerDataComponent != null) {
            newData.addAll(playerDataComponent.playerData);
        }
        PlayerCrateData foundEntry = null;
        for (PlayerCrateData entry : newData) {
            if (!entry.uuid().equals(playerUUID)) continue;
            foundEntry = entry;
            break;
        }
        if (foundEntry == null) {
            newData.add(new PlayerCrateData(playerUUID, -1L, unlockTime));
        } else {
            newData.remove(foundEntry);
            newData.add(new PlayerCrateData(playerUUID, foundEntry.replenishTime(), unlockTime));
        }
        return new LootCratePlayerDataComponent(newData);
    }

    public static LootCratePlayerDataComponent setReplenishTime(@Nullable LootCratePlayerDataComponent playerDataComponent, class_1657 player, boolean trackedPerPlayer, long replenishTime) {
        UUID playerUUID = trackedPerPlayer ? player.method_5667() : NO_PLAYER_UUID;
        ArrayList<PlayerCrateData> newData = new ArrayList<PlayerCrateData>();
        if (playerDataComponent != null) {
            newData.addAll(playerDataComponent.playerData);
        }
        PlayerCrateData foundEntry = null;
        for (PlayerCrateData entry : newData) {
            if (!entry.uuid().equals(playerUUID)) continue;
            foundEntry = entry;
            break;
        }
        if (foundEntry == null) {
            newData.add(new PlayerCrateData(playerUUID, replenishTime, -1L));
        } else {
            newData.remove(foundEntry);
            newData.add(new PlayerCrateData(playerUUID, replenishTime, foundEntry.unlockTime()));
        }
        return new LootCratePlayerDataComponent(newData);
    }

    public Optional<PlayerCrateData> get(class_1657 player, boolean trackedPerPlayer) {
        UUID playerUUID = trackedPerPlayer ? player.method_5667() : NO_PLAYER_UUID;
        for (PlayerCrateData entry : this.playerData) {
            if (!entry.uuid().equals(playerUUID)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }
}

