/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates;

import de.dafuqs.lootcrates.LootCrateAtlas;
import de.dafuqs.lootcrates.LootCrateDefinition;
import de.dafuqs.lootcrates.LootCratesItemGroups;
import de.dafuqs.lootcrates.blocks.LootCratesBlockEntityType;
import de.dafuqs.lootcrates.components.LootCrateDataComponentTypes;
import de.dafuqs.lootcrates.config.LootCratesConfig;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import de.dafuqs.lootcrates.enums.ScheduledTickEvent;
import de.dafuqs.lootcrates.items.LootBagItem;
import de.dafuqs.lootcrates.worldgen.LootCratesWorldgenReplacer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3620;
import net.minecraft.class_52;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9297;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootCrates
implements ModInitializer {
    public static final String MOD_ID = "lootcrates";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"lootcrates");
    public static LootCratesConfig CONFIG;
    public static final class_2960 CHEST_UNLOCKS_SOUND_ID;
    public static final class_3414 CHEST_UNLOCKS_SOUND_EVENT;
    public static final class_2357 LOOT_BAG_DISPENSER_BEHAVIOR;

    public void onInitialize() {
        LOGGER.info("Loading config...");
        AutoConfig.register(LootCratesConfig.class, JanksonConfigSerializer::new);
        CONFIG = (LootCratesConfig)AutoConfig.getConfigHolder(LootCratesConfig.class).getConfig();
        LootCrateDataComponentTypes.register();
        LOGGER.info("Loading crate definitions...");
        LootCrateDefinition commonLootCrate = new LootCrateDefinition(LootCrateVariant.COMMON, class_1814.field_8906, class_3620.field_16000, 0, false, false);
        LootCrateDefinition uncommonLootCrate = new LootCrateDefinition(LootCrateVariant.UNCOMMON, class_1814.field_8907, class_3620.field_16010, 0, false, false);
        LootCrateDefinition rareLootCrate = new LootCrateDefinition(LootCrateVariant.RARE, class_1814.field_8903, class_3620.field_15984, 0, false, false);
        LootCrateDefinition epicLootCrate = new LootCrateDefinition(LootCrateVariant.EPIC, class_1814.field_8904, class_3620.field_16014, 6, false, false);
        LootCrateDefinition ghostLootCrate = new LootCrateDefinition(LootCrateVariant.GHOST, class_1814.field_8904, class_3620.field_15995, 0, true, false);
        LootCrateDefinition blazeLootCrate = new LootCrateDefinition(LootCrateVariant.BLAZE, class_1814.field_8904, class_3620.field_15987, 15, false, true);
        epicLootCrate.setCustomSounds(class_3417.field_14671, class_3417.field_14550);
        ghostLootCrate.setCustomSounds(class_3417.field_14566, class_3417.field_14566);
        blazeLootCrate.setCustomSounds(class_3417.field_14991, class_3417.field_14970);
        if (LootCrates.CONFIG.BlazingCratesCauseFire) {
            blazeLootCrate.setScheduledTickEvent(ScheduledTickEvent.FIRE);
        }
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.COMMON, commonLootCrate);
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.UNCOMMON, uncommonLootCrate);
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.RARE, rareLootCrate);
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.EPIC, epicLootCrate);
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.GHOST, ghostLootCrate);
        LootCrateAtlas.registerLootCrateDefinition(LootCrateVariant.BLAZE, blazeLootCrate);
        LootCratesBlockEntityType.register();
        LOGGER.info("Registering sounds...");
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CHEST_UNLOCKS_SOUND_ID, (Object)CHEST_UNLOCKS_SOUND_EVENT);
        LOGGER.info("Loading LootCratesWorldgenSettings.json and registering the replacer");
        if (LootCrates.CONFIG.ReplaceVanillaWorldgenChests) {
            ServerTickEvents.END_SERVER_TICK.register(LootCratesWorldgenReplacer::tick);
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> LootCratesWorldgenReplacer.initialize(server.method_30002()));
        LootCratesItemGroups.register(LootCrates.CONFIG.AddExampleCratesAndBundlesItemGroups);
        LOGGER.info("Finished!");
    }

    static {
        CHEST_UNLOCKS_SOUND_ID = class_2960.method_60655((String)MOD_ID, (String)"chest_unlocks");
        CHEST_UNLOCKS_SOUND_EVENT = class_3414.method_47908((class_2960)CHEST_UNLOCKS_SOUND_ID);
        LOOT_BAG_DISPENSER_BEHAVIOR = (pointer, stack) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof LootBagItem) {
                LootBagItem lootBagItem = (LootBagItem)patt0$temp;
                @Nullable class_9297 lootComponent = lootBagItem.getLootComponent(stack);
                if (lootComponent != null) {
                    class_3218 world = pointer.comp_1967();
                    class_52 lootTable = world.method_8503().method_58576().method_58295(lootComponent.comp_2414());
                    class_8567.class_8568 builder = new class_8567.class_8568(pointer.comp_1967()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pointer.comp_1968()));
                    ObjectArrayList lootStacks = lootTable.method_51879(builder.method_51875(class_173.field_1179), lootComponent.comp_2415());
                    class_2374 position = class_2315.method_58682((class_2342)pointer);
                    class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                    for (class_1799 lootStack : lootStacks) {
                        class_1542 itemEntity = new class_1542((class_1937)pointer.comp_1967(), position.method_10216(), position.method_10214(), position.method_10215(), lootStack);
                        itemEntity.method_18800((double)direction.method_10148() * 0.2, (double)direction.method_10164() * 0.2, (double)direction.method_10165() * 0.2);
                        world.method_8649((class_1297)itemEntity);
                    }
                }
                stack.method_7934(1);
                return stack;
            }
            return stack;
        };
    }
}

