/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import de.dafuqs.lootcrates.LootCrateDefinition;
import de.dafuqs.lootcrates.LootCrates;
import de.dafuqs.lootcrates.blocks.LootCrateBlock;
import de.dafuqs.lootcrates.blocks.LootCrateBlockEntity;
import de.dafuqs.lootcrates.blocks.barrel.LootBarrelBlock;
import de.dafuqs.lootcrates.blocks.chest.ChestLootCrateBlock;
import de.dafuqs.lootcrates.blocks.shulker.ShulkerLootCrateBlock;
import de.dafuqs.lootcrates.blocks.shulker.ShulkerLootCrateBlockEntity;
import de.dafuqs.lootcrates.components.LockMode;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import de.dafuqs.lootcrates.enums.ScheduledTickEvent;
import de.dafuqs.lootcrates.items.LootBagItem;
import de.dafuqs.lootcrates.items.LootCrateItem;
import de.dafuqs.lootcrates.items.LootKeyItem;
import de.dafuqs.lootcrates.items.TickingLootBagItem;
import de.dafuqs.lootcrates.items.TickingLootCrateItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2970;
import net.minecraft.class_3414;
import net.minecraft.class_4730;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class LootCrateAtlas {
    private static final HashMap<LootCrateVariant, LootCrateDefinition> lootCrateDefinitions = new HashMap();
    private static final BiMap<LootCrateVariant, LootKeyItem> lootCrateKeys = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, class_1747> chestCrateItems = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, class_1747> shulkerCrateItems = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, class_1747> lootBarrelItems = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, LootBagItem> lootBagItems = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, ChestLootCrateBlock> lootCrateBlocks = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, ShulkerLootCrateBlock> shulkerCrateBlocks = EnumHashBiMap.create(LootCrateVariant.class);
    private static final BiMap<LootCrateVariant, LootBarrelBlock> lootBarrelBlocks = EnumHashBiMap.create(LootCrateVariant.class);

    private static ShulkerLootCrateBlock createShulkerLootCrateBlock(LootCrateVariant variant, class_4970.class_2251 settings) {
        class_4970.class_4973 contextPredicate = (blockState, blockView, blockPos) -> {
            class_2586 blockEntity = blockView.method_8321(blockPos);
            if (!(blockEntity instanceof ShulkerLootCrateBlockEntity)) {
                return true;
            }
            ShulkerLootCrateBlockEntity shulkerBoxBlockEntity = (ShulkerLootCrateBlockEntity)blockEntity;
            return shulkerBoxBlockEntity.suffocates();
        };
        return new ShulkerLootCrateBlock(variant, settings.method_9624().method_22488().method_26243(contextPredicate).method_26245(contextPredicate));
    }

    public static void registerLootCrateDefinition(LootCrateVariant variant, LootCrateDefinition lootCrateDefinition) {
        LootCrateItem lootBarrelBlockItem;
        LootCrateItem shulkerCrateBlockItem;
        LootCrateItem lootCrateBlockItem;
        lootCrateDefinitions.put(variant, lootCrateDefinition);
        class_2960 keyItemIdentifier = class_2960.method_60655((String)"lootcrates", (String)(lootCrateDefinition.identifier + "_crate_key"));
        LootKeyItem keyItem = new LootKeyItem(variant, lootCrateDefinition.getKeyItemSettings());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)keyItemIdentifier, (Object)((Object)keyItem));
        lootCrateKeys.put((Object)variant, (Object)keyItem);
        class_2960 lootCrateIdentifier = class_2960.method_60655((String)"lootcrates", (String)(lootCrateDefinition.identifier + "_chest_loot_crate"));
        class_2960 shulkerCrateIdentifier = class_2960.method_60655((String)"lootcrates", (String)(lootCrateDefinition.identifier + "_shulker_loot_crate"));
        class_2960 lootBarrelIdentifier = class_2960.method_60655((String)"lootcrates", (String)(lootCrateDefinition.identifier + "_loot_barrel"));
        ChestLootCrateBlock lootCrateBlock = new ChestLootCrateBlock(variant, lootCrateDefinition.getChestBlockSettings());
        ShulkerLootCrateBlock shulkerLootCrateBlock = LootCrateAtlas.createShulkerLootCrateBlock(variant, lootCrateDefinition.getShulkerBlockSettings());
        LootBarrelBlock lootBarrelBlock = new LootBarrelBlock(variant, lootCrateDefinition.getLootBarrelBlockSettings());
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)lootCrateIdentifier, (Object)((Object)lootCrateBlock));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)shulkerCrateIdentifier, (Object)((Object)shulkerLootCrateBlock));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)lootBarrelIdentifier, (Object)((Object)lootBarrelBlock));
        lootCrateBlocks.put((Object)variant, (Object)lootCrateBlock);
        shulkerCrateBlocks.put((Object)variant, (Object)shulkerLootCrateBlock);
        lootBarrelBlocks.put((Object)variant, (Object)lootBarrelBlock);
        class_1792.class_1793 blockItemSettings = lootCrateDefinition.getBlockItemSettings();
        if (lootCrateDefinition.scheduledTickEvent == ScheduledTickEvent.NONE) {
            lootCrateBlockItem = new LootCrateItem(variant, (class_2248)lootCrateBlock, blockItemSettings);
            shulkerCrateBlockItem = new LootCrateItem(variant, (class_2248)shulkerLootCrateBlock, blockItemSettings);
            lootBarrelBlockItem = new LootCrateItem(variant, (class_2248)lootBarrelBlock, blockItemSettings);
        } else {
            lootCrateBlockItem = new TickingLootCrateItem(variant, (class_2248)lootCrateBlock, blockItemSettings, lootCrateDefinition.scheduledTickEvent);
            shulkerCrateBlockItem = new TickingLootCrateItem(variant, (class_2248)shulkerLootCrateBlock, blockItemSettings, lootCrateDefinition.scheduledTickEvent);
            lootBarrelBlockItem = new TickingLootCrateItem(variant, (class_2248)lootBarrelBlock, blockItemSettings, lootCrateDefinition.scheduledTickEvent);
        }
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)lootCrateIdentifier, (Object)((Object)lootCrateBlockItem));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)shulkerCrateIdentifier, (Object)((Object)shulkerCrateBlockItem));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)lootBarrelIdentifier, (Object)((Object)lootBarrelBlockItem));
        class_2315.method_10009((class_1935)lootCrateBlockItem, (class_2357)new class_2970());
        class_2315.method_10009((class_1935)shulkerCrateBlockItem, (class_2357)new class_2970());
        class_2315.method_10009((class_1935)lootBarrelBlockItem, (class_2357)new class_2970());
        chestCrateItems.put((Object)variant, (Object)lootCrateBlockItem);
        shulkerCrateItems.put((Object)variant, (Object)shulkerCrateBlockItem);
        lootBarrelItems.put((Object)variant, (Object)lootBarrelBlockItem);
        class_2960 lootBagIdentifier = class_2960.method_60655((String)"lootcrates", (String)(lootCrateDefinition.identifier + "_loot_bag"));
        LootBagItem lootBagItem = lootCrateDefinition.scheduledTickEvent == ScheduledTickEvent.NONE ? new LootBagItem(lootCrateDefinition.getLootBagItemSettings()) : new TickingLootBagItem(lootCrateDefinition.getLootBagItemSettings(), lootCrateDefinition.scheduledTickEvent);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)lootBagIdentifier, (Object)((Object)lootBagItem));
        lootBagItems.put((Object)variant, (Object)lootBagItem);
        class_2315.method_10009((class_1935)lootBagItem, (class_2357)LootCrates.LOOT_BAG_DISPENSER_BEHAVIOR);
    }

    public static class_4730 getChestTexture(LootCrateBlockEntity lootCrateBlockEntity) {
        class_2248 block = lootCrateBlockEntity.method_11010().method_26204();
        LootCrateDefinition lootCrateDefinition = lootCrateDefinitions.get((Object)((LootCrateBlock)block).getVariant());
        return lootCrateDefinition.chestTexture;
    }

    public static class_4730 getShulkerTexture(LootCrateBlockEntity lootCrateBlockEntity) {
        class_2248 block = lootCrateBlockEntity.method_11010().method_26204();
        LootCrateDefinition lootCrateDefinition = lootCrateDefinitions.get((Object)((LootCrateBlock)block).getVariant());
        return lootCrateDefinition.shulkerTexture;
    }

    public static class_2248 getLootCrate(LootCrateVariant lootCrateVariant) {
        return (class_2248)lootCrateBlocks.get((Object)lootCrateVariant);
    }

    public static class_2248 getShulkerCrate(LootCrateVariant lootCrateVariant) {
        return (class_2248)shulkerCrateBlocks.get((Object)lootCrateVariant);
    }

    public static class_2248 getLootBarrel(LootCrateVariant lootCrateVariant) {
        return (class_2248)lootBarrelBlocks.get((Object)lootCrateVariant);
    }

    public static boolean hasTransparency(LootCrateBlockEntity lootCrateBlockEntity) {
        if (lootCrateBlockEntity == null) {
            return false;
        }
        class_2680 blockState = lootCrateBlockEntity.method_11010();
        return ((LootCrateBlock)blockState.method_26204()).getVariant().hasTransparency();
    }

    public static class_2561 getItemLockedTooltip(LootCrateVariant variant, LockMode lockMode) {
        if (lockMode.consumesKey()) {
            return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)variant)).lockedConsumeTooltip;
        }
        return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)variant)).lockedTooltip;
    }

    public static class_2248[] getChestCrates() {
        return lootCrateBlocks.values().toArray(new class_2248[0]);
    }

    public static class_2248[] getShulkerCrates() {
        return shulkerCrateBlocks.values().toArray(new class_2248[0]);
    }

    public static class_2248[] getLootBarrels() {
        return lootBarrelBlocks.values().toArray(new class_2248[0]);
    }

    public static void registerTransparentBlocks() {
        for (Map.Entry<LootCrateVariant, LootCrateDefinition> entry : lootCrateDefinitions.entrySet()) {
            if (!entry.getValue().hasTransparency) continue;
            LootCrateVariant lootCrateVariant = entry.getKey();
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)lootCrateBlocks.get((Object)lootCrateVariant), class_1921.method_23583());
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)shulkerCrateBlocks.get((Object)lootCrateVariant), class_1921.method_23583());
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)lootBarrelBlocks.get((Object)lootCrateVariant), class_1921.method_23583());
        }
    }

    public static List<class_1792> getAllCrateItems() {
        ArrayList<class_1792> arrayList = new ArrayList<class_1792>(chestCrateItems.values());
        arrayList.addAll(shulkerCrateItems.values());
        arrayList.addAll(lootBarrelItems.values());
        return arrayList;
    }

    public static List<class_1792> getAllLootBagItems() {
        return new ArrayList<class_1792>(lootBagItems.values());
    }

    public static class_2561 getKeyNeededTooltip(LootCrateVariant rarity) {
        return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)rarity)).keyNeededTooltip;
    }

    public static LootKeyItem getLootKeyItem(LootCrateVariant lootCrateVariant) {
        return (LootKeyItem)((Object)lootCrateKeys.get((Object)lootCrateVariant));
    }

    public static class_2561 getLootKeyItemToolTip(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return LootCrateAtlas.lootCrateDefinitions.get((Object)LootCrateAtlas.lootCrateKeys.inverse().get((Object)item)).lootKeyTooltip;
    }

    public static class_2561 getLootBagItemToolTip(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return LootCrateAtlas.lootCrateDefinitions.get((Object)LootCrateAtlas.lootBagItems.inverse().get((Object)item)).lootBagTooltip;
    }

    public static ScheduledTickEvent getRandomTickEvent(LootCrateBlock lootCrateBlock) {
        return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)lootCrateBlock.getVariant())).scheduledTickEvent;
    }

    public static class_3414 getCustomOpenSoundEvent(LootCrateBlock lootCrateBlock) {
        return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)lootCrateBlock.getVariant())).customOpenSoundEvent;
    }

    public static class_3414 getCustomCloseSoundEvent(LootCrateBlock lootCrateBlock) {
        return LootCrateAtlas.lootCrateDefinitions.get((Object)((Object)lootCrateBlock.getVariant())).customCloseSoundEvent;
    }

    @Environment(value=EnvType.CLIENT)
    public static void setupTextures() {
        for (LootCrateDefinition lootCrateDefinition : lootCrateDefinitions.values()) {
            lootCrateDefinition.setupTextures();
        }
    }

    public static LootBagItem getLootBagItem(LootCrateVariant rarity) {
        return (LootBagItem)((Object)lootBagItems.get((Object)rarity));
    }
}

