/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.highlighter.config.HighlighterConfig;
import com.anthonyhilyard.iceberg.events.client.ItemTooltipEvent;
import com.anthonyhilyard.iceberg.events.client.NewItemPickupEvent;
import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Highlighter {
    public static final String MODID = "highlighter";
    public static final Logger LOGGER = LogManager.getLogger((String)"highlighter");
    public static final class_2960 NEW_ITEM_MARKS = class_2960.method_60655((String)"highlighter", (String)"textures/gui/newitemmarks.png");
    private static Set<Integer> markedSlots = new HashSet<Integer>(36);

    public static void init() {
        HighlighterConfig.register(HighlighterConfig.class, (String)MODID);
        NewItemPickupEvent.EVENT.register(Highlighter::newItemPickup);
        ItemTooltipEvent.EVENT.register(Highlighter::onItemTooltip);
    }

    public static void newItemPickup(UUID uuid, class_1799 itemStack) {
        class_310 mc = class_310.method_1551();
        class_1657 player = mc.field_1687.method_18470(uuid);
        if (player != null && player.equals((Object)mc.field_1724)) {
            Highlighter.handlePreItemPickup(player, itemStack);
        }
    }

    private static void handlePreItemPickup(class_1657 player, class_1799 item) {
        int slot = player.method_31548().method_7390(item);
        if (slot == -1) {
            slot = player.method_31548().method_7376();
        }
        if (slot != -1) {
            markedSlots.add(slot);
        }
    }

    public static void clearMark(int slotIndex) {
        markedSlots.remove(slotIndex);
    }

    public static void itemClicked(int slotIndex) {
        Highlighter.clearMark(slotIndex);
    }

    public static void inventoryClosed() {
        if (HighlighterConfig.getInstance().clearOnInventoryClose.get().booleanValue()) {
            markedSlots.clear();
        }
    }

    public static void onItemTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 flag, List<class_2561> lines) {
        if (HighlighterConfig.getInstance().clearOnHover.get().booleanValue()) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1755 != null && mc.field_1755 instanceof class_465) {
                class_465 invScreen = (class_465)mc.field_1755;
                class_1735 slot = invScreen.field_2787;
                if (slot != null && slot.method_7677() == stack) {
                    Highlighter.clearMark(slot.method_34266());
                }
            }
        }
    }

    public static void renderNewItemMark(class_4587 poseStack, class_1735 slot) {
        class_310 mc = class_310.method_1551();
        if (!mc.field_1724.method_7337()) {
            if (markedSlots.contains(slot.method_34266()) && slot.method_7681()) {
                Highlighter.render(poseStack, slot.method_7677(), slot.field_7873, slot.field_7872);
            } else {
                Highlighter.clearMark(slot.method_34266());
            }
        }
    }

    public static void renderHotBarItemMark(int slotIndex, class_4587 poseStack, class_1799 item, int x, int y) {
        if (!HighlighterConfig.getInstance().showOnHotbar.get().booleanValue()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (!mc.field_1724.method_7337() && markedSlots.contains(slotIndex)) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, -100.0f);
            Highlighter.render(poseStack, item, x, y);
            poseStack.method_22909();
        }
    }

    private static void render(class_4587 poseStack, class_1799 item, int x, int y) {
        if (item.method_7960()) {
            return;
        }
        float timeOffset = Math.abs((float)(class_156.method_658() % 2000L) / 1000.0f - 1.0f);
        class_5251 color = class_5251.method_27718((class_124)class_124.field_1068);
        if (HighlighterConfig.getInstance().useItemNameColor.get().booleanValue()) {
            color = HighlighterConfig.getColorForItem(item, color);
        }
        RenderSystem.disableDepthTest();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, -Easing.Ease((float)0.0f, (float)1.0f, (float)timeOffset), 410.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)NEW_ITEM_MARKS);
        RenderSystem.setShaderColor((float)((float)(color.method_27716() >> 16 & 0xFF) / 255.0f), (float)((float)(color.method_27716() >> 8 & 0xFF) / 255.0f), (float)((float)(color.method_27716() & 0xFF) / 255.0f), (float)1.0f);
        switch (HighlighterConfig.getInstance().iconPosition.get()) {
            default: {
                break;
            }
            case UpperRight: {
                x += 8;
                break;
            }
            case LowerLeft: {
                y += 8;
                break;
            }
            case LowerRight: {
                x += 8;
                y += 8;
            }
        }
        GuiHelper.blit((class_4587)poseStack, (int)x, (int)y, (int)8, (int)8, (float)(HighlighterConfig.getInstance().useItemNameColor.get() != false ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
    }
}

