/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="gammautils")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Category(value="gammaSettings")
    @ConfigEntry.Gui.TransitiveObject
    public GammaSettings gamma = new GammaSettings();
    @ConfigEntry.Category(value="nightVisionSettings")
    @ConfigEntry.Gui.TransitiveObject
    public NightVisionSettings nightVision = new NightVisionSettings();
    @ConfigEntry.Category(value="otherSettings")
    @ConfigEntry.Gui.TransitiveObject
    public OtherSettings other = new OtherSettings();

    public static class GammaSettings {
        @ConfigEntry.Gui.Tooltip
        private int defaultGamma = 100;
        @ConfigEntry.Gui.Tooltip
        private int toggledGamma = 1500;
        @ConfigEntry.Gui.Tooltip
        private boolean updateToggle = false;
        @ConfigEntry.Gui.Tooltip
        private int gammaStep = 10;
        @ConfigEntry.Gui.Tooltip
        private boolean showStatusEffect = false;
        @ConfigEntry.Gui.Tooltip
        private boolean resetOnClose = false;
        @ConfigEntry.Gui.CollapsibleObject
        private Transition transition = new Transition();
        @ConfigEntry.Gui.CollapsibleObject
        private DynamicGamma dynamic = new DynamicGamma();
        @ConfigEntry.Gui.CollapsibleObject
        private DimensionPreference dimensionPreference = new DimensionPreference();
        @ConfigEntry.Gui.CollapsibleObject
        private Limiter limiter = new Limiter();
        @ConfigEntry.Gui.CollapsibleObject
        private HudMessage hudMessage = new HudMessage();

        public double getDefaultStrength() {
            return (double)this.defaultGamma / 100.0;
        }

        public double getToggledStrength() {
            return (double)this.toggledGamma / 100.0;
        }

        public void setToggledStrength(double newValue) {
            this.toggledGamma = (int)Math.round(newValue * 100.0);
        }

        public boolean isToggleUpdateEnabled() {
            return this.updateToggle;
        }

        public double getStepStrength() {
            return (double)this.gammaStep / 100.0;
        }

        public boolean isSmoothTransitionEnabled() {
            return this.transition.smoothTransition;
        }

        public void setSmoothTransitionStatus(boolean status) {
            this.transition.smoothTransition = status;
        }

        public double getTransitionSpeed(boolean dynamic) {
            return (double)(dynamic ? this.dynamic.transitionSpeed : this.transition.transitionSpeed) / 100.0;
        }

        public boolean isStatusEffectEnabled() {
            return this.showStatusEffect;
        }

        public void setStatusEffectStatus(boolean status) {
            this.showStatusEffect = status;
        }

        public boolean isResetOnCloseEnabled() {
            return this.resetOnClose;
        }

        public boolean isLimiterEnabled() {
            return this.limiter.limitCheck;
        }

        public double getMinimumStrength() {
            return (double)this.limiter.minGamma / 100.0;
        }

        public double getMaximumStrength() {
            return (double)this.limiter.maxGamma / 100.0;
        }

        public boolean isDimensionPreferenceEnabled() {
            return this.dimensionPreference.enableDimensionPreference;
        }

        public double getOverworldPreference() {
            return (double)this.dimensionPreference.overworldPreference / 100.0;
        }

        public double getNetherPreference() {
            return (double)this.dimensionPreference.netherPreference / 100.0;
        }

        public double getEndPreference() {
            return (double)this.dimensionPreference.endPreference / 100.0;
        }

        public boolean isDynamicGammaEnabled() {
            return this.dynamic.enableDynamicGamma;
        }

        public void setDynamicGammaStatus(boolean status) {
            this.dynamic.enableDynamicGamma = status;
        }

        public double getMinDynamicStrength() {
            return (double)this.dynamic.minGamma / 100.0;
        }

        public double getMaxDynamicStrength() {
            return (double)this.dynamic.maxGamma / 100.0;
        }

        public int getDynamicAveragingLightRange() {
            return this.dynamic.averagingLightRange;
        }

        public float getSkyBrightnessOverride() {
            return (float)this.dynamic.skyBrightnessOverride / 100.0f;
        }

        public boolean isHudMessageEnabled() {
            return this.hudMessage.showMessage;
        }

        public int getDefaultHudColor() {
            return this.hudMessage.defaultColor;
        }

        public int getPositiveHudColor() {
            return this.hudMessage.positiveColor;
        }

        public int getNegativeHudColor() {
            return this.hudMessage.negativeColor;
        }

        static class Transition {
            @ConfigEntry.Gui.Tooltip
            private boolean smoothTransition = false;
            @ConfigEntry.Gui.Tooltip
            private int transitionSpeed = 3000;

            Transition() {
            }
        }

        static class DynamicGamma {
            @ConfigEntry.Gui.Tooltip
            private boolean enableDynamicGamma = false;
            @ConfigEntry.Gui.Tooltip
            private int minGamma = 100;
            @ConfigEntry.Gui.Tooltip
            private int maxGamma = 1000;
            @ConfigEntry.Gui.Tooltip
            private int transitionSpeed = 200;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(max=16L)
            private int averagingLightRange = 8;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            private int skyBrightnessOverride = 0;

            DynamicGamma() {
            }
        }

        static class DimensionPreference {
            @ConfigEntry.Gui.Tooltip
            private boolean enableDimensionPreference = false;
            @ConfigEntry.Gui.Tooltip
            private int overworldPreference = 1500;
            @ConfigEntry.Gui.Tooltip
            private int netherPreference = 1500;
            @ConfigEntry.Gui.Tooltip
            private int endPreference = 1500;

            DimensionPreference() {
            }
        }

        static class Limiter {
            @ConfigEntry.Gui.Tooltip
            private boolean limitCheck = true;
            @ConfigEntry.Gui.Tooltip
            private int minGamma = -750;
            @ConfigEntry.Gui.Tooltip
            private int maxGamma = 1500;

            Limiter() {
            }
        }

        static class HudMessage {
            @ConfigEntry.Gui.Tooltip
            private boolean showMessage = true;
            @ConfigEntry.ColorPicker
            private int defaultColor = 43520;
            @ConfigEntry.ColorPicker
            private int positiveColor = 0xFFAA00;
            @ConfigEntry.ColorPicker
            private int negativeColor = 0xAA0000;

            HudMessage() {
            }
        }
    }

    public static class NightVisionSettings {
        @ConfigEntry.Gui.Excluded
        private boolean nightVisionEnabled = false;
        @ConfigEntry.Gui.Excluded
        private double nightVisionStrength = 100.0;
        @ConfigEntry.Gui.Tooltip
        private int toggledNightVision = 100;
        @ConfigEntry.Gui.Tooltip
        private boolean updateToggle = false;
        @ConfigEntry.Gui.Tooltip
        private int nightVisionStep = 2;
        @ConfigEntry.Gui.Tooltip
        private boolean showStatusEffect = false;
        @ConfigEntry.Gui.Tooltip
        private boolean resetOnClose = false;
        @ConfigEntry.Gui.CollapsibleObject
        private Transition transition = new Transition();
        @ConfigEntry.Gui.CollapsibleObject
        private DynamicNightVision dynamic = new DynamicNightVision();
        @ConfigEntry.Gui.CollapsibleObject
        private DimensionPreference dimensionPreference = new DimensionPreference();
        @ConfigEntry.Gui.CollapsibleObject
        private Limiter limiter = new Limiter();
        @ConfigEntry.Gui.CollapsibleObject
        private HudMessage hudMessage = new HudMessage();

        public void setStatus(boolean status) {
            this.nightVisionEnabled = status;
        }

        public boolean isEnabled() {
            return this.nightVisionEnabled;
        }

        public double getStrength() {
            return this.nightVisionStrength;
        }

        public void setStrength(double newValue) {
            this.nightVisionStrength = newValue;
        }

        public int getToggledStrength() {
            return this.toggledNightVision;
        }

        public void setToggledStrength(int newValue) {
            this.toggledNightVision = newValue;
        }

        public boolean isToggleUpdateEnabled() {
            return this.updateToggle;
        }

        public int getStepStrength() {
            return this.nightVisionStep;
        }

        public boolean isSmoothTransitionEnabled() {
            return this.transition.smoothTransition;
        }

        public void setSmoothTransitionStatus(boolean status) {
            this.transition.smoothTransition = status;
        }

        public double getTransitionSpeed(boolean dynamic) {
            return dynamic ? (double)this.dynamic.transitionSpeed : (double)this.transition.transitionSpeed;
        }

        public boolean isLimiterEnabled() {
            return this.limiter.limitCheck;
        }

        public int getMaximumStrength() {
            return this.limiter.maxNightVision;
        }

        public int getMinimumStrength() {
            return this.limiter.minNightVision;
        }

        public boolean isStatusEffectEnabled() {
            return this.showStatusEffect;
        }

        public void setStatusEffectStatus(boolean status) {
            this.showStatusEffect = status;
        }

        public boolean isResetOnCloseEnabled() {
            return this.resetOnClose;
        }

        public boolean isDimensionPreferenceEnabled() {
            return this.dimensionPreference.enableDimensionPreference;
        }

        public int getOverworldPreference() {
            return this.dimensionPreference.overworldPreference;
        }

        public int getNetherPreference() {
            return this.dimensionPreference.netherPreference;
        }

        public int getEndPreference() {
            return this.dimensionPreference.endPreference;
        }

        public boolean isDynamicNightVisionEnabled() {
            return this.dynamic.enableDynamicNightVision;
        }

        public void setDynamicNightVisionStatus(boolean status) {
            this.dynamic.enableDynamicNightVision = status;
        }

        public int getMinDynamicStrength() {
            return this.dynamic.minNightVision;
        }

        public int getMaxDynamicStrength() {
            return this.dynamic.maxNightVision;
        }

        public int getDynamicAveragingLightRange() {
            return this.dynamic.averagingLightRange;
        }

        public float getSkyBrightnessOverride() {
            return (float)this.dynamic.skyBrightnessOverride / 100.0f;
        }

        public boolean isHudMessageEnabled() {
            return this.hudMessage.showMessage;
        }

        public int getDefaultHudColor() {
            return this.hudMessage.defaultColor;
        }

        public int getPositiveHudColor() {
            return this.hudMessage.positiveColor;
        }

        public int getNegativeHudColor() {
            return this.hudMessage.negativeColor;
        }

        public int getEnabledHudColor() {
            return this.hudMessage.enabledColor;
        }

        public int getDisabledHudColor() {
            return this.hudMessage.disabledColor;
        }

        static class Transition {
            @ConfigEntry.Gui.Tooltip
            private boolean smoothTransition = false;
            @ConfigEntry.Gui.Tooltip
            private int transitionSpeed = 200;

            Transition() {
            }
        }

        static class DynamicNightVision {
            @ConfigEntry.Gui.Tooltip
            private boolean enableDynamicNightVision = false;
            @ConfigEntry.Gui.Tooltip
            private int minNightVision = 0;
            @ConfigEntry.Gui.Tooltip
            private int maxNightVision = 100;
            @ConfigEntry.Gui.Tooltip
            private int transitionSpeed = 15;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(max=16L)
            private int averagingLightRange = 8;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            private int skyBrightnessOverride = 0;

            DynamicNightVision() {
            }
        }

        static class DimensionPreference {
            @ConfigEntry.Gui.Tooltip
            private boolean enableDimensionPreference = false;
            @ConfigEntry.Gui.Tooltip
            private int overworldPreference = 100;
            @ConfigEntry.Gui.Tooltip
            private int netherPreference = 100;
            @ConfigEntry.Gui.Tooltip
            private int endPreference = 100;

            DimensionPreference() {
            }
        }

        static class Limiter {
            @ConfigEntry.Gui.Tooltip
            private boolean limitCheck = true;
            @ConfigEntry.Gui.Tooltip
            private int minNightVision = 0;
            @ConfigEntry.Gui.Tooltip
            private int maxNightVision = 100;

            Limiter() {
            }
        }

        static class HudMessage {
            @ConfigEntry.Gui.Tooltip
            private boolean showMessage = true;
            @ConfigEntry.ColorPicker
            private int defaultColor = 43520;
            @ConfigEntry.ColorPicker
            private int positiveColor = 0xFFAA00;
            @ConfigEntry.ColorPicker
            private int negativeColor = 0xAA0000;
            @ConfigEntry.ColorPicker
            private int enabledColor = 43520;
            @ConfigEntry.ColorPicker
            private int disabledColor = 0xAA0000;

            HudMessage() {
            }
        }
    }

    public static class OtherSettings {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        private boolean namespacedCommands = false;

        public boolean namespacedCommandsEnabled() {
            return this.namespacedCommands;
        }
    }
}

