/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.registry;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.ShortWeatheringDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallWeatheringDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDRegistry {
    public static final List<Pair<String, Block>> DOOR_BLOCKS = new ArrayList<Pair<String, Block>>();
    public static final List<Pair<String, Item>> DOOR_ITEMS = new ArrayList<Pair<String, Item>>();
    public static final Item.Properties PROPERTIES = new Item.Properties();

    public static void registerVanilla() {
        DDRegistry.registerDoorBlockAndItem("tall_oak_door", "short_oak_door", Blocks.OAK_DOOR, BlockSetType.OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_spruce_door", "short_spruce_door", Blocks.SPRUCE_DOOR, BlockSetType.SPRUCE, true);
        DDRegistry.registerDoorBlockAndItem("tall_birch_door", "short_birch_door", Blocks.BIRCH_DOOR, BlockSetType.BIRCH, true);
        DDRegistry.registerDoorBlockAndItem("tall_jungle_door", "short_jungle_door", Blocks.JUNGLE_DOOR, BlockSetType.JUNGLE, true);
        DDRegistry.registerDoorBlockAndItem("tall_acacia_door", "short_acacia_door", Blocks.ACACIA_DOOR, BlockSetType.ACACIA, true);
        DDRegistry.registerDoorBlockAndItem("tall_dark_oak_door", "short_dark_oak_door", Blocks.DARK_OAK_DOOR, BlockSetType.DARK_OAK, true);
        DDRegistry.registerDoorBlockAndItem("tall_mangrove_door", "short_mangrove_door", Blocks.MANGROVE_DOOR, BlockSetType.MANGROVE, true);
        DDRegistry.registerDoorBlockAndItem("tall_cherry_door", "short_cherry_door", Blocks.CHERRY_DOOR, BlockSetType.CHERRY, true);
        DDRegistry.registerDoorBlockAndItem("tall_bamboo_door", "short_bamboo_door", Blocks.BAMBOO_DOOR, BlockSetType.BAMBOO, true);
        DDRegistry.registerDoorBlockAndItem("tall_crimson_door", "short_crimson_door", Blocks.CRIMSON_DOOR, BlockSetType.CRIMSON, true);
        DDRegistry.registerDoorBlockAndItem("tall_warped_door", "short_warped_door", Blocks.WARPED_DOOR, BlockSetType.WARPED, true);
        if (Compats.modChecker.isModLoaded("immersive_weathering")) {
            DDRegistry.registerWeatheringDoorBlockAndItem("tall_iron_door", "short_iron_door", Blocks.IRON_DOOR.properties(), BlockSetType.IRON, true, WeatheringCopper.WeatherState.UNAFFECTED);
        } else {
            DDRegistry.registerDoorBlockAndItem("tall_iron_door", "short_iron_door", Blocks.IRON_DOOR, BlockSetType.IRON, true);
        }
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_copper_door", "short_copper_door", Blocks.COPPER_DOOR.properties(), BlockSetType.COPPER, true, WeatheringCopper.WeatherState.UNAFFECTED);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_exposed_copper_door", "short_exposed_copper_door", Blocks.EXPOSED_COPPER_DOOR.properties(), BlockSetType.COPPER, true, WeatheringCopper.WeatherState.EXPOSED);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_weathered_copper_door", "short_weathered_copper_door", Blocks.WEATHERED_COPPER_DOOR.properties(), BlockSetType.COPPER, true, WeatheringCopper.WeatherState.WEATHERED);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_oxidized_copper_door", "short_oxidized_copper_door", Blocks.OXIDIZED_COPPER_DOOR.properties(), BlockSetType.COPPER, true, WeatheringCopper.WeatherState.OXIDIZED);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_copper_door", "short_waxed_copper_door", Blocks.WAXED_COPPER_DOOR.properties(), BlockSetType.COPPER, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_exposed_copper_door", "short_waxed_exposed_copper_door", Blocks.WAXED_EXPOSED_COPPER_DOOR.properties(), BlockSetType.COPPER, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_weathered_copper_door", "short_waxed_weathered_copper_door", Blocks.WAXED_WEATHERED_COPPER_DOOR.properties(), BlockSetType.COPPER, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_oxidized_copper_door", "short_waxed_oxidized_copper_door", Blocks.WAXED_OXIDIZED_COPPER_DOOR.properties(), BlockSetType.COPPER, true);
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock);
            DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(block, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock);
        DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean includeShort) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock);
            DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock);
        DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerWeatheringDoorBlockAndItem(String tallname, @Nullable String shortname, BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean includeShort, WeatheringCopper.WeatherState state) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createCopperDoorBlock(properties, blocksettype, false, state);
            tempItem = DDRegistry.createDoorItem(tempBlock);
            DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createCopperDoorBlock(properties, blocksettype, true, state);
        tempItem = DDRegistry.createDoorItem(tempBlock);
        DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        Item tempItem;
        Block tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock);
            DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock);
        DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, BlockSetType blocksettype, boolean includeShort) {
        Block tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock);
        DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock);
            DOOR_BLOCKS.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static Block createCopperDoorBlock(BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean isTall, WeatheringCopper.WeatherState state) {
        return isTall ? new TallWeatheringDoorBlock(blocksettype, state, properties) : new ShortWeatheringDoorBlock(blocksettype, state, properties);
    }

    protected static Block createSlidingDoorBlock(Block block, BlockSetType blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        return new TallSlidingDoorBlock(blocksettype, block);
    }

    protected static Block createStableDoorBlock(Block block, BlockSetType blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        return new TallStableDoorBlock(blocksettype, block);
    }

    protected static Block createDoorBlock(Block block, BlockSetType blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(blocksettype, block) : new ShortDoorBlock(blocksettype, block);
    }

    protected static Block createDoorBlock(BlockBehaviour.Properties properties, BlockSetType blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(blocksettype, properties) : new ShortDoorBlock(blocksettype, properties);
    }

    protected static Item createDoorItem(Block block) {
        return new BlockItem(block, PROPERTIES);
    }

    public static Block getBlockByKey(ResourceLocation loc) {
        return DDRegistry.getBlockByKey(loc, Blocks.OAK_DOOR);
    }

    public static Block getBlockByKey(ResourceLocation loc, Block fallback) {
        if (BuiltInRegistries.BLOCK.containsKey(loc)) {
            return (Block)BuiltInRegistries.BLOCK.get(loc);
        }
        return fallback;
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource) {
        return DDRegistry.getBlockFromResourceLocation(resource, Blocks.OAK_DOOR);
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource, Block fallback) {
        return BuiltInRegistries.BLOCK.getOptional(resource).orElse(fallback);
    }
}

