/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class ShortLeadDoorBlock
extends ShortDoorBlock {
    public static final IntegerProperty OPENING_PROGRESS = DDBlockStateProperties.OPENING_PROGRESS;

    public ShortLeadDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public boolean canBeOpened(BlockState state) {
        return (Integer)state.getValue((Property)OPENING_PROGRESS) == 2;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE, POWERED, WATERLOGGED, OPENING_PROGRESS});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.canBeOpened(state)) {
            ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
            state = (BlockState)((BlockState)state.cycle((Property)OPEN)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0));
            level.setBlock(pos, state, 10);
            level.levelEvent(player, (Boolean)state.getValue((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        } else {
            int p = (Integer)state.getValue((Property)OPENING_PROGRESS) + 1;
            level.setBlock(pos, (BlockState)state.setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
            level.playSound(player, pos, SoundEvents.NETHERITE_BLOCK_STEP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.scheduleTick(pos, (Block)this, 20);
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        level.setBlock(pos, (BlockState)state.setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
    }
}

