/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.addons.create;

import com.fizzware.dramaticdoors.neoforge.blocks.TallCreateSlidingDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.CreateNeoForgeCompat;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TallNeoForgeCreateSlidingDoorBlockEntity
extends SmartBlockEntity {
    public LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;

    public TallNeoForgeCreateSlidingDoorBlockEntity(BlockPos pos, BlockState blockState) {
        super(CreateNeoForgeCompat.TALL_SLIDING_DOOR_BLOCK_ENTITY, pos, blockState);
        this.animation = LerpedFloat.linear().startWithValue(TallNeoForgeCreateSlidingDoorBlockEntity.isOpen(blockState) ? 1.0 : 0.0);
    }

    public void tick() {
        if (this.deferUpdate && !this.level.isClientSide()) {
            this.deferUpdate = false;
            BlockState blockState = this.getBlockState();
            blockState.handleNeighborChanged(this.level, this.worldPosition, Blocks.AIR, this.worldPosition, false);
        }
        super.tick();
        boolean open = TallNeoForgeCreateSlidingDoorBlockEntity.isOpen(this.getBlockState());
        boolean wasSettled = this.animation.settled();
        this.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open && TallNeoForgeCreateSlidingDoorBlockEntity.isVisible(this.getBlockState())) {
                --this.bridgeTicks;
            }
            return;
        }
        if (!open && !wasSettled && this.animation.settled() && !TallNeoForgeCreateSlidingDoorBlockEntity.isVisible(this.getBlockState())) {
            this.showBlockModel();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public static boolean isVisible(BlockState state) {
        return state.getOptionalValue((Property)DDBlockStateProperties.VISIBLE).orElse(true);
    }

    public boolean shouldRenderSpecial(BlockState state) {
        return !TallNeoForgeCreateSlidingDoorBlockEntity.isVisible(state) || this.bridgeTicks != 0;
    }

    protected void showBlockModel() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TallCreateSlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(true)), 3);
        this.level.playSound(null, this.worldPosition, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    public static boolean isOpen(BlockState state) {
        return state.getOptionalValue((Property)TallDoorBlock.OPEN).orElse(false);
    }
}

