/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.addons.create;

import com.fizzware.dramaticdoors.neoforge.addons.create.TallNeoForgeCreateSlidingDoorBlockEntity;
import com.fizzware.dramaticdoors.neoforge.blocks.TallCreateSlidingDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.CreateNeoForgeCompat;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallNeoForgeCreateSlidingDoorBlock
extends TallCreateSlidingDoorBlock
implements IWrenchable,
IBE<TallNeoForgeCreateSlidingDoorBlockEntity>,
IHaveBigOutline {
    public static final BooleanProperty VISIBLE = DDBlockStateProperties.VISIBLE;

    public TallNeoForgeCreateSlidingDoorBlock(BlockSetType blockset, Block from, boolean isFolding) {
        super(blockset, from, isFolding);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue((Property)THIRD) == TripleBlockPart.LOWER) {
            return new TallNeoForgeCreateSlidingDoorBlockEntity(pos, state);
        }
        return null;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!((Boolean)pState.getValue((Property)OPEN)).booleanValue() && (((Boolean)pState.getValue((Property)VISIBLE)).booleanValue() || pLevel instanceof ContraptionWorld)) {
            return super.getShape(pState, pLevel, pPos, pContext);
        }
        Direction direction = (Direction)pState.getValue((Property)FACING);
        boolean hinge = pState.getValue((Property)HINGE) == DoorHingeSide.RIGHT;
        return TallCreateSlidingDoorBlock.getShapeByProperty(direction, hinge, this.isFoldingDoor());
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean lower = state.getValue((Property)THIRD) == TripleBlockPart.LOWER;
        boolean isPowered = TallNeoForgeCreateSlidingDoorBlock.isDoorPowered(level, pos, state);
        if (this.defaultBlockState().is(blockIn)) {
            return;
        }
        if (isPowered == (Boolean)state.getValue((Property)POWERED)) {
            return;
        }
        TallNeoForgeCreateSlidingDoorBlockEntity be = (TallNeoForgeCreateSlidingDoorBlockEntity)this.getBlockEntity((BlockGetter)level, lower ? pos : pos.below());
        if (be != null && be.deferUpdate) {
            return;
        }
        BlockState changedState = (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isPowered));
        if (isPowered) {
            changedState = (BlockState)changedState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (isPowered != (Boolean)state.getValue((Property)OPEN)) {
            this.playSound(null, level, pos, isPowered);
            level.gameEvent(null, (Holder)(isPowered ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            DoorHingeSide hinge = (DoorHingeSide)changedState.getValue((Property)HINGE);
            Direction facing = (Direction)changedState.getValue((Property)FACING);
            BlockPos otherPos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
            BlockState otherDoor = level.getBlockState(otherPos);
            if (TallNeoForgeCreateSlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
                otherDoor = (BlockState)((BlockState)otherDoor.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isPowered));
                if (isPowered) {
                    otherDoor = (BlockState)otherDoor.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
                }
                level.setBlock(otherPos, otherDoor, 2);
            }
        }
        level.setBlock(pos, changedState, 2);
    }

    @Override
    public void deferUpdate(LevelAccessor level, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)level, pos, sdte -> {
            sdte.deferUpdate = true;
        });
    }

    public Class<TallNeoForgeCreateSlidingDoorBlockEntity> getBlockEntityClass() {
        return TallNeoForgeCreateSlidingDoorBlockEntity.class;
    }

    public BlockEntityType<? extends TallNeoForgeCreateSlidingDoorBlockEntity> getBlockEntityType() {
        return CreateNeoForgeCompat.TALL_SLIDING_DOOR_BLOCK_ENTITY;
    }
}

