/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.addons.create;

import com.fizzware.dramaticdoors.neoforge.blocks.TallCreateSlidingDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TallDoorMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        BlockState newState;
        BlockPos otherPos;
        if (!(currentState.getBlock() instanceof TallDoorBlock)) {
            return currentState;
        }
        boolean trainDoor = currentState.getBlock() instanceof TallCreateSlidingDoorBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)TallDoorBlock.OPEN)).booleanValue() ? (trainDoor ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainDoor ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        BlockPos otherPos2 = switch ((TripleBlockPart)((Object)currentState.getValue(TallDoorBlock.THIRD))) {
            case TripleBlockPart.UPPER -> {
                otherPos = pos.below(1);
                yield pos.below(2);
            }
            case TripleBlockPart.MIDDLE -> {
                otherPos = pos.above(1);
                yield pos.below(1);
            }
            default -> {
                otherPos = pos.above(1);
                yield pos.above(2);
            }
        };
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        StructureTemplate.StructureBlockInfo info2 = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos2);
        if (info != null && info.state().hasProperty((Property)DoorBlock.OPEN)) {
            newState = (BlockState)info.state().cycle((Property)DoorBlock.OPEN);
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        }
        if (info2 != null && info2.state().hasProperty((Property)DoorBlock.OPEN)) {
            newState = (BlockState)info2.state().cycle((Property)DoorBlock.OPEN);
            this.setContraptionBlockData(contraption.entity, otherPos2, new StructureTemplate.StructureBlockInfo(info2.pos(), newState, info2.nbt()));
        }
        currentState = (BlockState)currentState.cycle((Property)DoorBlock.OPEN);
        if (player != null) {
            if (trainDoor) {
                DoorHingeSide hinge = (DoorHingeSide)currentState.getValue((Property)TallCreateSlidingDoorBlock.HINGE);
                Direction facing = (Direction)currentState.getValue((Property)TallCreateSlidingDoorBlock.FACING);
                BlockPos doublePos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
                StructureTemplate.StructureBlockInfo doubleInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(doublePos);
                if (doubleInfo != null && TallCreateSlidingDoorBlock.isDoubleDoor(currentState, hinge, facing, doubleInfo.state())) {
                    this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, doublePos, contraption.entity);
                }
            }
            float pitch = player.level().getRandom().nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    protected boolean updateColliders() {
        return true;
    }
}

