/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.addons.create;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallCreateSlidingDoorBlock;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ShortDoorMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        if (!(currentState.getBlock() instanceof ShortDoorBlock)) {
            return currentState;
        }
        boolean trainDoor = currentState.getBlock() instanceof TallCreateSlidingDoorBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)ShortDoorBlock.OPEN)).booleanValue() ? (trainDoor ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainDoor ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        currentState = (BlockState)currentState.cycle((Property)DoorBlock.OPEN);
        if (player != null) {
            if (trainDoor) {
                DoorHingeSide hinge = (DoorHingeSide)currentState.getValue((Property)TallCreateSlidingDoorBlock.HINGE);
                Direction facing = (Direction)currentState.getValue((Property)TallCreateSlidingDoorBlock.FACING);
                BlockPos doublePos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
                StructureTemplate.StructureBlockInfo doubleInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(doublePos);
                if (doubleInfo != null && TallCreateSlidingDoorBlock.isDoubleDoor(currentState, hinge, facing, doubleInfo.state())) {
                    this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, doublePos, contraption.entity);
                }
            }
            float pitch = player.level().getRandom().nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    protected boolean updateColliders() {
        return true;
    }
}

