/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.fizzware.dramaticdoors.neoforge.compat.CompatChecker;
import com.fizzware.dramaticdoors.neoforge.config.DDConfigCommon;
import com.fizzware.dramaticdoors.neoforge.registry.DDCreativeTabs;
import com.fizzware.dramaticdoors.neoforge.registry.DDRegistry;
import java.nio.file.Path;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import oshi.util.tuples.Pair;

public class NeoforgeUtils
implements CompatChecker {
    public static final NeoforgeUtils INSTANCE = new NeoforgeUtils();

    @Override
    public boolean isModLoaded(String modid) {
        if (LoadingModList.get().getModFileById(modid) != null) {
            return true;
        }
        return ModList.get().isLoaded(modid);
    }

    @Override
    public boolean isDev() {
        if (!FMLEnvironment.production) {
            return true;
        }
        return DDConfigCommon.devMode;
    }

    @Override
    public boolean isQuarkModuleEnabled() {
        return INSTANCE.isModLoaded("quark");
    }

    public static boolean getConfigBooleanValue(Path path, String variable) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().build();
        configData.load();
        if (configData.get(variable) != null) {
            return (Boolean)configData.get(variable);
        }
        return false;
    }

    public static int getConfigIntValue(Path path, String variable) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().build();
        configData.load();
        if (configData.get(variable) != null) {
            return (Integer)configData.get(variable);
        }
        return 0;
    }

    @SubscribeEvent
    public static void assignItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.insertBefore(Items.IRON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_iron_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.EXPOSED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_exposed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WEATHERED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_weathered_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.OXIDIZED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_oxidized_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WAXED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WAXED_EXPOSED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_exposed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WAXED_WEATHERED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_weathered_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WAXED_OXIDIZED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_waxed_oxidized_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.SPRUCE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_spruce_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.BIRCH_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_birch_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.JUNGLE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_jungle_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.ACACIA_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_acacia_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.DARK_OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_dark_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.MANGROVE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_mangrove_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.CHERRY_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_cherry_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.BAMBOO_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_bamboo_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.CRIMSON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_crimson_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.WARPED_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_warped_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.IRON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_iron_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.EXPOSED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_exposed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WEATHERED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_weathered_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.OXIDIZED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_oxidized_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WAXED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_waxed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WAXED_EXPOSED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_waxed_exposed_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WAXED_WEATHERED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_waxed_weathered_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WAXED_OXIDIZED_COPPER_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_waxed_oxidized_copper_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.SPRUCE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_spruce_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.BIRCH_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_birch_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.JUNGLE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_jungle_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.ACACIA_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_acacia_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.DARK_OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_dark_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.MANGROVE_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_mangrove_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.CHERRY_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_cherry_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.BAMBOO_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_bamboo_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.CRIMSON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_crimson_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.WARPED_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_warped_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.insertBefore(Items.IRON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_iron_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertBefore(Items.OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.IRON_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_iron_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.insertAfter(Items.OAK_DOOR.getDefaultInstance(), ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"tall_oak_door"))).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        if (event.getTabKey() == DDCreativeTabs.MAIN_TAB) {
            for (Pair<String, Item> pair : DDRegistry.DOOR_ITEMS) {
                if (((String)pair.getA()).contains("chipped") || ((String)pair.getA()).contains("macaw") || ((String)pair.getA()).contains("manyideas")) continue;
                event.accept(((Item)pair.getB()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == DDCreativeTabs.CHIPPED_TAB) {
            for (Pair<String, Item> pair : DDRegistry.DOOR_ITEMS) {
                if (!((String)pair.getA()).contains("chipped")) continue;
                event.accept(((Item)pair.getB()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == DDCreativeTabs.MACAW_TAB) {
            for (Pair<String, Item> pair : DDRegistry.DOOR_ITEMS) {
                if (!((String)pair.getA()).contains("macaw")) continue;
                event.accept(((Item)pair.getB()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == DDCreativeTabs.MANYIDEAS_TAB) {
            for (Pair<String, Item> pair : DDRegistry.DOOR_ITEMS) {
                if (!((String)pair.getA()).contains("manyideas")) continue;
                event.accept(((Item)pair.getB()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

