/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPostEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.block.ModBlocks;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.FormChangeHelper;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.dynamax.Dynamax;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.tera.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.zmove.ZRingItem;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import dev.emi.trinkets.api.TrinketsApi;
import kotlin.Unit;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class RevertEventsHandler {
    public static Unit battleStarted(BattleStartedPreEvent battleEvent) {
        for (BattleActor pokemon : battleEvent.getBattle().getActors()) {
            for (BattlePokemon pk : pokemon.getPokemonList()) {
                if (!pk.getEffectedPokemon().getAspects().contains("core-percent")) continue;
                battleEvent.cancel();
                return Unit.INSTANCE;
            }
        }
        for (class_3222 player : battleEvent.getBattle().getPlayers()) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean hasTerapagos = false;
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon.getSpecies().getName().equals("Terapagos")) {
                    hasTerapagos = true;
                }
                EventUtils.revertFormesEnd(pokemon);
            }
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasDMaxItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_31573(ModTags.Items.DYNAMAX_BAND))).orElse(false);
            if (RevertEventsHandler.isBlockNearby(player, ModBlocks.POWER_SPOT, MegaShowdownConfig.powerSpotRange.get()) || MegaShowdownConfig.dynamaxAnywhere.get().booleanValue()) {
                if ((player.method_6079().method_7909() instanceof Dynamax || player.method_6079().method_31573(ModTags.Items.DYNAMAX_BAND) || hasDMaxItemTrinkets) && MegaShowdownConfig.dynamax.get().booleanValue()) {
                    data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
                } else {
                    data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
                }
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
            }
            boolean hasTeraItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof TeraItem)).orElse(false);
            class_1799 teraOrb = TrinketsApi.getTrinketComponent((class_1309)player).flatMap(component -> component.getAllEquipped().stream().map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof TeraItem).findFirst()).orElse(null);
            if (teraOrb != null && hasTerapagos) {
                teraOrb.method_7974(0);
            }
            if (teraOrb == null || teraOrb.method_7919() >= 100) {
                hasTeraItemTrinkets = false;
            }
            if (hasTeraItemTrinkets && MegaShowdownConfig.teralization.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            }
            if (MegaShowdownConfig.revertMegas.get().booleanValue() && MegaShowdownConfig.mega.get().booleanValue() && MegaLogic.Possible(player, true) && !FormChangeHelper.hasMega(player)) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            }
            boolean hasZItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof ZRingItem || item.method_31573(ModTags.Items.Z_RINGS))).orElse(false);
            if ((player.method_6079().method_7909() instanceof ZRingItem || player.method_6079().method_31573(ModTags.Items.Z_RINGS) || hasZItemTrinkets) && MegaShowdownConfig.zMoves.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
                continue;
            }
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        }
        return Unit.INSTANCE;
    }

    public static boolean isBlockNearby(class_3222 player, class_2248 targetBlock, int radius) {
        class_2338 playerPos = player.method_24515();
        class_3218 world = player.method_51469();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 checkPos = playerPos.method_10069(dx, dy, dz);
                    if (!world.method_8320(checkPos).method_27852(targetBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        class_3222 serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null || serverPlayer.method_37908().field_9236) {
            return Unit.INSTANCE;
        }
        boolean isMega = pokemon.getAspects().stream().anyMatch(aspect -> aspect.startsWith("mega"));
        if (isMega) {
            MegaLogic.Devolve(pokemon, true);
        }
        return Unit.INSTANCE;
    }

    public static Unit hookBattleEnded(BattleStartedPostEvent event) {
        event.getBattle().getOnEndHandlers().add(battle -> {
            battle.getPlayers().forEach(serverPlayer -> {
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
                for (Pokemon pokemon : playerPartyStore) {
                    EventUtils.revertFormesEnd(pokemon);
                    if (pokemon.getEntity() == null) continue;
                    pokemon.getEntity().method_6016(class_1294.field_5912);
                }
            });
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }
}

