/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.FormChangeHelper;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.UltraLogic;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.formchange.ArceusType;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.formchange.Drives;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.formchange.Memory;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.zmove.ElementalZCrystal;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.SnowStormHandler;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5251;

public class HeldItemChangeHandler {
    public static void genesectChange(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Genesect")) {
            if (event.getReceiving().method_31574(FormeChangeItems.DOUSE_DRIVE)) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                new StringSpeciesFeature("techno_drive", "water").apply(pokemon);
            } else if (event.getReceiving().method_31574(FormeChangeItems.BURN_DRIVE)) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                new StringSpeciesFeature("techno_drive", "fire").apply(pokemon);
            } else if (event.getReceiving().method_31574(FormeChangeItems.CHILL_DRIVE)) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                new StringSpeciesFeature("techno_drive", "ice").apply(pokemon);
            } else if (event.getReceiving().method_31574(FormeChangeItems.SHOCK_DRIVE)) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                new StringSpeciesFeature("techno_drive", "electric").apply(pokemon);
            } else if (!(event.getReceiving().method_7909() instanceof Drives) && event.getReturning().method_7909() instanceof Drives) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                new StringSpeciesFeature("techno_drive", "none").apply(pokemon);
            }
        }
    }

    public static void silvallyChange(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Silvally")) {
            class_1792 class_17922 = event.getReceiving().method_7909();
            if (class_17922 instanceof Memory) {
                Memory memory = (Memory)class_17922;
                HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", memory.getType()).apply(pokemon);
            } else if (event.getReturning().method_7909() instanceof Memory) {
                HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "normal").apply(pokemon);
            }
        }
    }

    public static void arcuesChange(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        class_2338 entityPos = pokemonEntity.method_24515();
        if (pokemon.getSpecies().getName().equals("Arceus")) {
            class_1792 class_17922 = event.getReceiving().method_7909();
            if (class_17922 instanceof ArceusType) {
                ArceusType plate = (ArceusType)class_17922;
                pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ARCEUS_MULTITYPE, class_3419.field_15248, 0.2f, 1.3f);
                SnowStormHandler.Companion.snowStormPartileSpawner(pokemon.getEntity(), class_2960.method_12829((String)("cobblemon:arceus_" + plate.getType())), List.of("target"));
                pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                pokemon.getEntity().after(3.0f, () -> {
                    new StringSpeciesFeature("multitype", plate.getType()).apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                    pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                    return Unit.INSTANCE;
                });
            } else {
                class_17922 = event.getReceiving().method_7909();
                if (class_17922 instanceof ElementalZCrystal) {
                    ElementalZCrystal crystal = (ElementalZCrystal)class_17922;
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ARCEUS_MULTITYPE, class_3419.field_15248, 0.2f, 1.3f);
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemon.getEntity(), class_2960.method_12829((String)("cobblemon:arceus_" + crystal.getType())), List.of("target"));
                    pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                    pokemon.getEntity().after(3.0f, () -> {
                        new StringSpeciesFeature("multitype", crystal.getType()).apply(pokemon);
                        SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                        pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                        return Unit.INSTANCE;
                    });
                } else if (event.getReturning().method_7909() instanceof ArceusType || event.getReturning().method_7909() instanceof ElementalZCrystal) {
                    HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("multitype", "normal").apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
                }
            }
        }
    }

    public static void originChange(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (event.getReceiving().method_31574(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), true);
            } else if (event.getReturning().method_31574(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Palkia")) {
            if (event.getReceiving().method_31574(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), true);
            } else if (event.getReturning().method_31574(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Dialga")) {
            if (event.getReceiving().method_31574(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), true);
            } else if (event.getReturning().method_31574(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeHandler.originAnimation(pokemon.getEntity(), false);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Pre event) {
        if (!MegaShowdownConfig.etermaxForme.get().booleanValue()) {
            return;
        }
        Pokemon pokemon = event.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Eternatus")) {
            return;
        }
        if (event.getReceiving().method_31574(FormeChangeItems.STAR_CORE)) {
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
            pokemon.setTradeable(false);
        } else if (event.getReturning().method_31574(FormeChangeItems.STAR_CORE) && event.getReturning().method_31574(FormeChangeItems.STAR_CORE)) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
            pokemon.setTradeable(true);
        }
    }

    public static void ogerponChange(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (event.getReceiving().method_31574(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getFIRE());
        } else if (event.getReceiving().method_31574(FormeChangeItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getROCK());
        } else if (event.getReceiving().method_31574(FormeChangeItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getWATER());
        } else if (event.getReturning().method_31574(FormeChangeItems.WELLSPRING_MASK) || event.getReturning().method_31574(FormeChangeItems.CORNERSTONE_MASK) || event.getReturning().method_31574(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getGRASS());
        }
    }

    public static void primalEvent(HeldItemEvent.Pre event) {
        class_3222 player = event.getPokemon().getOwnerPlayer();
        Species species = event.getPokemon().getSpecies();
        if (!species.getName().equals("Kyogre") && !species.getName().equals("Groudon")) {
            return;
        }
        boolean primalData = FormChangeHelper.hasPrimal(player);
        if (species.getName().equals("Kyogre") && event.getReceiving().method_31574(MegaStones.BLUE_ORB) && !event.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals.get().booleanValue()) {
                new StringSpeciesFeature("reversion_state", "primal").apply(event.getPokemon());
                HeldItemChangeHandler.primalRevertAnimation(event.getPokemon().getEntity(), class_2398.field_11247, true);
                event.getPokemon().setTradeable(false);
            } else {
                event.cancel();
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.primal_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
        } else if (species.getName().equals("Groudon") && event.getReceiving().method_31574(MegaStones.RED_ORB) && !event.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals.get().booleanValue()) {
                new StringSpeciesFeature("reversion_state", "primal").apply(event.getPokemon());
                HeldItemChangeHandler.primalRevertAnimation(event.getPokemon().getEntity(), class_2398.field_17430, true);
                event.getPokemon().setTradeable(false);
            } else {
                event.cancel();
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.primal_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
        } else if (species.getName().equals("Kyogre") && !event.getReceiving().method_31574(MegaStones.BLUE_ORB) && event.getReturning().method_31574(MegaStones.BLUE_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(event.getPokemon());
            HeldItemChangeHandler.primalRevertAnimation(event.getPokemon().getEntity(), class_2398.field_11207, false);
            event.getPokemon().setTradeable(true);
        } else if (species.getName().equals("Groudon") && !event.getReceiving().method_31574(MegaStones.RED_ORB) && event.getReturning().method_31574(MegaStones.RED_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(event.getPokemon());
            HeldItemChangeHandler.primalRevertAnimation(event.getPokemon().getEntity(), class_2398.field_11207, false);
            event.getPokemon().setTradeable(true);
        }
    }

    public static void megaEvent(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getAspects().contains("mega_x") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega")) {
            MegaLogic.Devolve(pokemon, true);
        }
    }

    public static void crownedEvent(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceiving().method_31574(FormeChangeItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                HeldItemChangeHandler.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                pokemon.setTradeable(false);
            } else if (event.getReceiving().method_31574(FormeChangeItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                HeldItemChangeHandler.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                pokemon.setTradeable(false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturning().method_31574(FormeChangeItems.RUSTED_SWORD)) {
                HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                pokemon.setTradeable(true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturning().method_31574(FormeChangeItems.RUSTED_SHIELD)) {
                HeldItemChangeHandler.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                pokemon.setTradeable(true);
            }
        }
    }

    public static void ultraEvent(HeldItemEvent.Pre event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.getAspects().contains("ultra-fusion") && event.getReturning().method_31574(ZCrystals.ULTRANECROZIUM_Z)) {
            if (!pokemon.getEntity().isBattling()) {
                SnowStormHandler.Companion.playAnimation((class_1297)pokemon.getEntity(), Set.of("cry"), List.of());
            }
            UltraLogic.ultraAnimation((class_1309)pokemon.getEntity());
            new StringSpeciesFeature("prism_fusion", pokemon.getPersistentData().method_10558("fusion_form")).apply(pokemon);
        }
    }

    private static void playHeldItemFormeChange(class_1309 context) {
        SnowStormHandler.Companion.playAnimation((class_1297)context, Set.of("cry"), List.of());
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_26980, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void originAnimation(PokemonEntity context, boolean enabled) {
        class_2338 entityPos = context.method_24515();
        if (context.getPokemon().getSpecies().getName().equals("Giratina")) {
            context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.GIRATINIA_FORM, class_3419.field_15248, 0.2f, 1.1f);
            SnowStormHandler.Companion.snowStormPartileSpawner(context, class_2960.method_12829((String)"cobblemon:origin_g_effect"), List.of("target"));
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(3.8f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                SnowStormHandler.Companion.playAnimation((class_1297)context, Set.of("cry"), List.of());
                return Unit.INSTANCE;
            });
        } else {
            context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ORIGIN_FORM, class_3419.field_15248, 0.2f, 1.1f);
            SnowStormHandler.Companion.snowStormPartileSpawner(context, class_2960.method_12829((String)"cobblemon:origin_effect"), List.of("target"));
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(4.0f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                SnowStormHandler.Companion.playAnimation((class_1297)context, Set.of("cry"), List.of());
                return Unit.INSTANCE;
            });
        }
    }

    private static void crownAnimation(class_3218 level, class_2338 pos, class_1309 context) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)level);
        if (lightning != null) {
            lightning.method_33574(class_243.method_24955((class_2382)pos));
            lightning.method_29498(true);
            level.method_8649((class_1297)lightning);
            HeldItemChangeHandler.playHeldItemFormeChange(context);
        }
    }

    private static void primalRevertAnimation(PokemonEntity context, class_2400 particleType, Boolean revert) {
        class_1937 class_19372;
        if (revert.booleanValue()) {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(2.5f, () -> {
                SnowStormHandler.Companion.playAnimation((class_1297)context, Set.of("cry"), List.of());
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        }
        if ((class_19372 = context.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_14703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverWorld.method_14199((class_2394)particleType, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

