/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.datapack.handler;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.particles.EffectsData;
import com.cobblemon.yajatkaul.mega_showdown.utility.SnowStormHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class HandlerUtils {
    public static class_3966 getEntityLookingAt(class_1657 player, double distance) {
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5828(1.0f);
        class_243 targetPos = eyePos.method_1019(lookVec.method_1021(distance));
        return class_1675.method_18075((class_1297)player, (class_243)eyePos, (class_243)targetPos, (class_238)player.method_5829().method_18804(lookVec.method_1021(distance)).method_1009(1.0, 1.0, 1.0), entity -> !entity.method_7325() && entity.method_5863() && entity instanceof class_1309, (double)(distance * distance));
    }

    public static void applyEffects(EffectsData effects, PokemonEntity pokemon, List<String> aspects, boolean apply) {
        if (apply) {
            if (effects.snowStorm() != null && effects.minecraft() != null) {
                HandlerUtils.particleEffect(pokemon, effects, true);
                HandlerUtils.snowStromParticleEffect(pokemon, effects, true, aspects);
            } else if (effects.minecraft() != null) {
                HandlerUtils.particleEffect(pokemon, effects, true);
                HandlerUtils.applyAspects(aspects, pokemon.getPokemon());
            } else if (effects.snowStorm() != null) {
                HandlerUtils.snowStromParticleEffect(pokemon, effects, true, aspects);
            }
        } else if (effects.snowStorm() != null && effects.minecraft() != null) {
            HandlerUtils.particleEffect(pokemon, effects, false);
            HandlerUtils.snowStromParticleEffect(pokemon, effects, false, aspects);
        } else if (effects.minecraft() != null) {
            HandlerUtils.particleEffect(pokemon, effects, false);
            HandlerUtils.applyAspects(aspects, pokemon.getPokemon());
        } else if (effects.snowStorm() != null) {
            HandlerUtils.snowStromParticleEffect(pokemon, effects, false, aspects);
        }
    }

    private static void particleEffect(PokemonEntity context, EffectsData effects, boolean apply) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            String[] partsSound;
            String[] partsParticle;
            class_3218 serverWorld = (class_3218)class_19372;
            int amplifier = apply ? effects.minecraft().particle_apply_amplifier() : effects.minecraft().particle_revert_amplifier();
            if (apply) {
                partsParticle = effects.minecraft().particle_apply().split(":");
                partsSound = effects.minecraft().sound_apply().split(":");
                if (effects.minecraft().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.minecraft().animations().animations_apply()), effects.minecraft().animations().expressions_apply());
                }
            } else {
                partsParticle = effects.minecraft().particle_revert().split(":");
                partsSound = effects.minecraft().sound_revert().split(":");
                if (effects.minecraft().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.minecraft().animations().animations_revert()), effects.minecraft().animations().expressions_revert());
                }
            }
            class_2960 custom_particle_id = class_2960.method_60655((String)partsParticle[0], (String)partsParticle[1]);
            class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(custom_particle_id);
            class_2960 custom_sound_id = class_2960.method_60655((String)partsSound[0], (String)partsSound[1]);
            class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(custom_sound_id);
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double scaleFactor = (apply ? effects.minecraft().particle_apply_amplifier() : effects.minecraft().particle_revert_amplifier()).intValue();
            double ampFactor = Math.max(1, amplifier);
            double adjustedWidth = entityWidth * scaleFactor * ampFactor;
            double adjustedHeight = entityHeight * scaleFactor * ampFactor;
            double adjustedDepth = entityWidth * scaleFactor * ampFactor;
            if (soundEvent == null) {
                if (apply && !effects.minecraft().sound_apply().isEmpty()) {
                    MegaShowdown.LOGGER.error("A: Invalid Sound used for pokemon: {}, sound id: {}", (Object)context.getPokemon().getSpecies().getName(), (Object)effects.minecraft().sound_apply());
                } else if (!apply && !effects.minecraft().sound_revert().isEmpty()) {
                    MegaShowdown.LOGGER.error("R: Invalid Sound used for pokemon: {}, sound id: {}", (Object)context.getPokemon().getSpecies().getName(), (Object)effects.minecraft().sound_revert());
                }
            } else {
                serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, soundEvent, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            }
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            if (particleType instanceof class_2394) {
                class_2394 particle = (class_2394)particleType;
                for (int i = 0; i < particleCount; ++i) {
                    double xOffset = (Math.random() - 0.5) * adjustedWidth;
                    double yOffset = Math.random() * adjustedHeight;
                    double zOffset = (Math.random() - 0.5) * adjustedDepth;
                    serverWorld.method_14199(particle, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                }
            } else if (apply && !effects.minecraft().particle_apply().isEmpty()) {
                MegaShowdown.LOGGER.error("A: Invalid Particle used for pokemon: {}, sound id: {}", (Object)context.getPokemon().getSpecies().getName(), (Object)effects.minecraft().particle_apply());
            } else if (!apply && !effects.minecraft().particle_revert().isEmpty()) {
                MegaShowdown.LOGGER.error("R: Invalid Particle used for pokemon: {}, sound id: {}", (Object)context.getPokemon().getSpecies().getName(), (Object)effects.minecraft().particle_revert());
            }
        }
    }

    private static void snowStromParticleEffect(PokemonEntity context, EffectsData effects, boolean apply, List<String> aspects) {
        if (apply) {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.getPokemon().getPersistentData().method_10566("revert_aspect", (class_2520)HandlerUtils.makeNbt(aspects));
            class_2960 particleId = class_2960.method_12829((String)effects.snowStorm().particle_apply());
            if (particleId == null) {
                MegaShowdown.LOGGER.error("Invalid snowstorm apply particle");
                return;
            }
            SnowStormHandler.Companion.snowStormPartileSpawner(context, particleId, effects.snowStorm().source_apply());
            context.after(effects.snowStorm().apply_after().floatValue(), () -> {
                HandlerUtils.applyAspects(aspects, context.getPokemon());
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                context.getPokemon().getPersistentData().method_10551("revert_aspect");
                if (effects.snowStorm().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.snowStorm().animations().animations_apply()), effects.snowStorm().animations().expressions_apply());
                }
                return Unit.INSTANCE;
            });
        } else {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.getPokemon().getPersistentData().method_10566("revert_aspect", (class_2520)HandlerUtils.makeNbt(aspects));
            class_2960 particleId = class_2960.method_12829((String)effects.snowStorm().particle_revert());
            if (particleId == null) {
                MegaShowdown.LOGGER.error("Invalid snowstorm revert particle");
                return;
            }
            SnowStormHandler.Companion.snowStormPartileSpawner(context, particleId, effects.snowStorm().source_revert());
            context.after(effects.snowStorm().revert_after().floatValue(), () -> {
                HandlerUtils.applyAspects(aspects, context.getPokemon());
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                context.getPokemon().getPersistentData().method_10551("revert_aspect");
                if (effects.snowStorm().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.snowStorm().animations().animations_revert()), effects.snowStorm().animations().expressions_revert());
                }
                return Unit.INSTANCE;
            });
        }
    }

    private static class_2499 makeNbt(List<String> aspects) {
        class_2499 nbtList = new class_2499();
        for (String aspect : aspects) {
            nbtList.add((Object)class_2519.method_23256((String)aspect));
        }
        return nbtList;
    }

    public static List<String> decodeNbt(class_2499 nbtList) {
        ArrayList<String> aspects = new ArrayList<String>();
        for (class_2520 element : nbtList) {
            aspects.add(element.method_10714());
        }
        return aspects;
    }

    public static boolean itemValidator(class_1792 item, Integer custom_model_data, class_1799 itemStack, String item_id) {
        class_9280 nbt = (class_9280)itemStack.method_57824(class_9334.field_49637);
        String[] parts = item_id.split(":");
        boolean hasEnchantment = parts.length >= 4;
        boolean enchantmentCorrect = false;
        if (hasEnchantment) {
            String nameSpace = parts[2] + parts[3];
            class_9304 enchantments = class_1890.method_57532((class_1799)itemStack);
            for (class_6880 entry : enchantments.method_57534()) {
                if (!nameSpace.equals(entry.method_55840())) continue;
                enchantmentCorrect = true;
                break;
            }
        }
        return itemStack.method_31574(item) && (nbt != null && custom_model_data.intValue() == nbt.comp_2382() || custom_model_data == 0) && (!hasEnchantment || enchantmentCorrect);
    }

    public static void applyAspects(List<String> aspects, Pokemon pokemon) {
        for (String aspect : aspects) {
            String[] div = aspect.split("=");
            if (div[1].equals("true") || div[1].equals("false")) {
                new FlagSpeciesFeature(div[0], Boolean.parseBoolean(div[1])).apply(pokemon);
                continue;
            }
            new StringSpeciesFeature(div[0], div[1]).apply(pokemon);
        }
    }

    public static void applyEffects(EffectsData effects, PokemonEntity pokemon, List<String> aspects, boolean apply, PokemonEntity other) {
        if (apply) {
            if (effects.snowStorm() != null && effects.minecraft() != null) {
                HandlerUtils.particleEffect(pokemon, effects, true);
                HandlerUtils.snowStromParticleEffect(pokemon, effects, true, aspects, other);
            } else if (effects.minecraft() != null) {
                HandlerUtils.particleEffect(pokemon, effects, true);
                HandlerUtils.applyAspects(aspects, pokemon.getPokemon());
            } else if (effects.snowStorm() != null) {
                HandlerUtils.snowStromParticleEffect(pokemon, effects, true, aspects, other);
            }
        } else if (effects.snowStorm() != null && effects.minecraft() != null) {
            HandlerUtils.particleEffect(pokemon, effects, false);
            HandlerUtils.snowStromParticleEffect(pokemon, effects, false, aspects, other);
        } else if (effects.minecraft() != null) {
            HandlerUtils.particleEffect(pokemon, effects, false);
            HandlerUtils.applyAspects(aspects, pokemon.getPokemon());
        } else if (effects.snowStorm() != null) {
            HandlerUtils.snowStromParticleEffect(pokemon, effects, false, aspects, other);
        }
    }

    private static void snowStromParticleEffect(PokemonEntity context, EffectsData effects, boolean apply, List<String> aspects, PokemonEntity other) {
        if (apply) {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            class_2960 particleId = class_2960.method_12829((String)effects.snowStorm().particle_apply());
            if (particleId == null) {
                MegaShowdown.LOGGER.error("Invalid snowstorm apply particle");
                return;
            }
            SnowStormHandler.Companion.snowStormPartileSpawner(context, particleId, effects.snowStorm().source_apply(), other, effects.snowStorm().target_apply());
            context.after(effects.snowStorm().apply_after().floatValue(), () -> {
                HandlerUtils.applyAspects(aspects, context.getPokemon());
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                if (effects.snowStorm().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.snowStorm().animations().animations_apply()), effects.snowStorm().animations().expressions_apply());
                }
                return Unit.INSTANCE;
            });
        } else {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            class_2960 particleId = class_2960.method_12829((String)effects.snowStorm().particle_revert());
            if (particleId == null) {
                MegaShowdown.LOGGER.error("Invalid snowstorm revert particle");
                return;
            }
            SnowStormHandler.Companion.snowStormPartileSpawner(context, particleId, effects.snowStorm().source_revert(), other, effects.snowStorm().target_apply());
            context.after(effects.snowStorm().revert_after().floatValue(), () -> {
                HandlerUtils.applyAspects(aspects, context.getPokemon());
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                if (effects.snowStorm().animations() != null) {
                    SnowStormHandler.Companion.playAnimation((class_1297)context, new HashSet<String>(effects.snowStorm().animations().animations_revert()), effects.snowStorm().animations().expressions_revert());
                }
                return Unit.INSTANCE;
            });
        }
    }

    public static boolean listCheck(List<List<String>> aspects, Set<String> pokemonAspects, boolean blacklist) {
        if (aspects.isEmpty()) {
            return !blacklist;
        }
        for (List<String> aspectList : aspects) {
            if (!pokemonAspects.containsAll(aspectList)) continue;
            return true;
        }
        return false;
    }
}

