/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaMember;

class JavaMethod
extends JavaMember {
    static final Map methods = Collections.synchronizedMap(new HashMap());
    final Method method;

    static JavaMethod forMethod(Method m4) {
        JavaMethod j = (JavaMethod)methods.get(m4);
        if (j == null) {
            j = new JavaMethod(m4);
            methods.put(m4, j);
        }
        return j;
    }

    static LuaFunction forMethods(JavaMethod[] m4) {
        return new Overload(m4);
    }

    private JavaMethod(Method m4) {
        super(m4.getParameterTypes(), m4.getModifiers());
        this.method = m4;
        try {
            if (!m4.isAccessible()) {
                m4.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public LuaValue call() {
        return JavaMethod.error("method cannot be called without instance");
    }

    @Override
    public LuaValue call(LuaValue arg) {
        return this.invokeMethod(arg.checkuserdata(), LuaValue.NONE);
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        return this.invokeMethod(arg1.checkuserdata(), arg2);
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        return this.invokeMethod(arg1.checkuserdata(), LuaValue.varargsOf(arg2, (Varargs)arg3));
    }

    @Override
    public Varargs invoke(Varargs args) {
        return this.invokeMethod(args.checkuserdata(1), args.subargs(2));
    }

    LuaValue invokeMethod(Object instance, Varargs args) {
        Object[] a = this.convertArgs(args);
        try {
            return CoerceJavaToLua.coerce(this.method.invoke(instance, a));
        }
        catch (InvocationTargetException e) {
            throw new LuaError(e.getTargetException());
        }
        catch (Exception e) {
            return LuaValue.error("coercion error " + e);
        }
    }

    static class Overload
    extends LuaFunction {
        final JavaMethod[] methods;

        Overload(JavaMethod[] methods) {
            this.methods = methods;
        }

        @Override
        public LuaValue call() {
            return Overload.error("method cannot be called without instance");
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return this.invokeBestMethod(arg.checkuserdata(), LuaValue.NONE);
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return this.invokeBestMethod(arg1.checkuserdata(), arg2);
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            return this.invokeBestMethod(arg1.checkuserdata(), LuaValue.varargsOf(arg2, (Varargs)arg3));
        }

        @Override
        public Varargs invoke(Varargs args) {
            return this.invokeBestMethod(args.checkuserdata(1), args.subargs(2));
        }

        private LuaValue invokeBestMethod(Object instance, Varargs args) {
            JavaMethod best = null;
            int score = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (JavaMethod method : this.methods) {
                int s2 = method.score(args);
                if (s2 >= score) continue;
                score = s2;
                best = method;
                if (score == 0) break;
            }
            if (best == null) {
                LuaValue.error("no coercible public method");
            }
            return best.invokeMethod(instance, args);
        }
    }
}

