/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.util.Random;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class MathLib
extends TwoArgFunction {
    public static MathLib MATHLIB = null;

    public MathLib() {
        MATHLIB = this;
    }

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable math = new LuaTable(0, 30);
        math.set("abs", (LuaValue)new abs());
        math.set("ceil", (LuaValue)new ceil());
        math.set("cos", (LuaValue)new cos());
        math.set("deg", (LuaValue)new deg());
        math.set("exp", (LuaValue)new exp(this));
        math.set("floor", (LuaValue)new floor());
        math.set("fmod", (LuaValue)new fmod());
        math.set("frexp", (LuaValue)new frexp());
        math.set("huge", (LuaValue)LuaDouble.POSINF);
        math.set("ldexp", (LuaValue)new ldexp());
        math.set("max", (LuaValue)new max());
        math.set("min", (LuaValue)new min());
        math.set("modf", (LuaValue)new modf());
        math.set("pi", Math.PI);
        math.set("pow", (LuaValue)new pow());
        random r = new random();
        math.set("random", (LuaValue)r);
        math.set("randomseed", (LuaValue)new randomseed(r));
        math.set("rad", (LuaValue)new rad());
        math.set("sin", (LuaValue)new sin());
        math.set("sqrt", (LuaValue)new sqrt());
        math.set("tan", (LuaValue)new tan());
        env.set("math", (LuaValue)math);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("math", (LuaValue)math);
        }
        return math;
    }

    public static LuaValue dpow(double a, double b) {
        return LuaDouble.valueOf(MATHLIB != null ? MATHLIB.dpow_lib(a, b) : MathLib.dpow_default(a, b));
    }

    public static double dpow_d(double a, double b) {
        return MATHLIB != null ? MATHLIB.dpow_lib(a, b) : MathLib.dpow_default(a, b);
    }

    public double dpow_lib(double a, double b) {
        return MathLib.dpow_default(a, b);
    }

    protected static double dpow_default(double a, double b) {
        double d;
        if (b < 0.0) {
            return 1.0 / MathLib.dpow_default(a, -b);
        }
        double p = 1.0;
        int whole = (int)b;
        double v = a;
        while (whole > 0) {
            if ((whole & 1) != 0) {
                p *= v;
            }
            whole >>= 1;
            v *= v;
        }
        b -= (double)whole;
        if (d > 0.0) {
            int frac = (int)(65536.0 * b);
            while ((frac & 0xFFFF) != 0) {
                a = Math.sqrt(a);
                if ((frac & 0x8000) != 0) {
                    p *= a;
                }
                frac <<= 1;
            }
        }
        return p;
    }

    static final class abs
    extends UnaryOp {
        abs() {
        }

        @Override
        protected double call(double d) {
            return Math.abs(d);
        }
    }

    static final class ceil
    extends UnaryOp {
        ceil() {
        }

        @Override
        protected double call(double d) {
            return Math.ceil(d);
        }
    }

    static final class cos
    extends UnaryOp {
        cos() {
        }

        @Override
        protected double call(double d) {
            return Math.cos(d);
        }
    }

    static final class deg
    extends UnaryOp {
        deg() {
        }

        @Override
        protected double call(double d) {
            return Math.toDegrees(d);
        }
    }

    static final class exp
    extends UnaryOp {
        final MathLib mathlib;

        exp(MathLib mathlib) {
            this.mathlib = mathlib;
        }

        @Override
        protected double call(double d) {
            return this.mathlib.dpow_lib(Math.E, d);
        }
    }

    static final class floor
    extends UnaryOp {
        floor() {
        }

        @Override
        protected double call(double d) {
            return Math.floor(d);
        }
    }

    static final class fmod
    extends TwoArgFunction {
        fmod() {
        }

        @Override
        public LuaValue call(LuaValue xv, LuaValue yv) {
            if (yv.checkdouble() == 0.0) {
                return LuaDouble.NAN;
            }
            if (xv.islong() && yv.islong()) {
                return fmod.valueOf(xv.tolong() % yv.tolong());
            }
            return fmod.valueOf(xv.checkdouble() % yv.checkdouble());
        }
    }

    static class frexp
    extends VarArgFunction {
        frexp() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            double x = args.checkdouble(1);
            if (x == 0.0) {
                return frexp.varargsOf(ZERO, (Varargs)ZERO);
            }
            long bits = Double.doubleToLongBits(x);
            double m4 = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
            double e = ((int)(bits >> 52) & 0x7FF) - 1022;
            return frexp.varargsOf(frexp.valueOf(m4), (Varargs)frexp.valueOf(e));
        }
    }

    static final class ldexp
    extends BinaryOp {
        ldexp() {
        }

        @Override
        protected double call(double x, double y) {
            return x * Double.longBitsToDouble((long)y + 1023L << 52);
        }
    }

    static class max
    extends VarArgFunction {
        max() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaNumber m4 = args.checknumber(1);
            int n = args.narg();
            for (int i = 2; i <= n; ++i) {
                LuaNumber v = args.checknumber(i);
                if (!m4.lt_b(v)) continue;
                m4 = v;
            }
            return m4;
        }
    }

    static class min
    extends VarArgFunction {
        min() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaNumber m4 = args.checknumber(1);
            int n = args.narg();
            for (int i = 2; i <= n; ++i) {
                LuaNumber v = args.checknumber(i);
                if (!v.lt_b(m4)) continue;
                m4 = v;
            }
            return m4;
        }
    }

    static class modf
    extends VarArgFunction {
        modf() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaValue n = args.arg1();
            if (n.islong()) {
                return modf.varargsOf(n.tonumber(), (Varargs)modf.valueOf(0.0));
            }
            double x = n.checkdouble();
            double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
            double fracPart = x == intPart ? 0.0 : x - intPart;
            return modf.varargsOf(modf.valueOf(intPart), (Varargs)modf.valueOf(fracPart));
        }
    }

    static final class pow
    extends BinaryOp {
        pow() {
        }

        @Override
        protected double call(double x, double y) {
            return MathLib.dpow_default(x, y);
        }
    }

    static class random
    extends LibFunction {
        Random random = new Random();

        random() {
        }

        @Override
        public LuaValue call() {
            return org.luaj.vm2.lib.MathLib$random.valueOf(this.random.nextDouble());
        }

        @Override
        public LuaValue call(LuaValue a) {
            int m4 = a.checkint();
            if (m4 < 1) {
                org.luaj.vm2.lib.MathLib$random.argerror(1, "interval is empty");
            }
            return org.luaj.vm2.lib.MathLib$random.valueOf(1 + this.random.nextInt(m4));
        }

        @Override
        public LuaValue call(LuaValue a, LuaValue b) {
            int m4 = a.checkint();
            int n = b.checkint();
            if (n < m4) {
                org.luaj.vm2.lib.MathLib$random.argerror(2, "interval is empty");
            }
            return org.luaj.vm2.lib.MathLib$random.valueOf(m4 + this.random.nextInt(n + 1 - m4));
        }
    }

    static class randomseed
    extends OneArgFunction {
        final random random;

        randomseed(random random2) {
            this.random = random2;
        }

        @Override
        public LuaValue call(LuaValue arg) {
            long seed = arg.checklong();
            this.random.random = new Random(seed);
            return NONE;
        }
    }

    static final class rad
    extends UnaryOp {
        rad() {
        }

        @Override
        protected double call(double d) {
            return Math.toRadians(d);
        }
    }

    static final class sin
    extends UnaryOp {
        sin() {
        }

        @Override
        protected double call(double d) {
            return Math.sin(d);
        }
    }

    static final class sqrt
    extends UnaryOp {
        sqrt() {
        }

        @Override
        protected double call(double d) {
            return Math.sqrt(d);
        }
    }

    static final class tan
    extends UnaryOp {
        tan() {
        }

        @Override
        protected double call(double d) {
            return Math.tan(d);
        }
    }

    protected static abstract class BinaryOp
    extends TwoArgFunction {
        protected BinaryOp() {
        }

        @Override
        public LuaValue call(LuaValue x, LuaValue y) {
            return BinaryOp.valueOf(this.call(x.checkdouble(), y.checkdouble()));
        }

        protected abstract double call(double var1, double var3);
    }

    protected static abstract class UnaryOp
    extends OneArgFunction {
        protected UnaryOp() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return UnaryOp.valueOf(this.call(arg.checkdouble()));
        }

        protected abstract double call(double var1);
    }
}

