/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Metatable;

public class WeakTable
implements Metatable {
    private final boolean weakkeys;
    private final boolean weakvalues;
    private final LuaValue backing;

    public static LuaTable make(boolean weakkeys, boolean weakvalues) {
        LuaString mode;
        if (weakkeys && weakvalues) {
            mode = LuaString.valueOf("kv");
        } else if (weakkeys) {
            mode = LuaString.valueOf("k");
        } else if (weakvalues) {
            mode = LuaString.valueOf("v");
        } else {
            return LuaValue.tableOf();
        }
        LuaTable table = LuaValue.tableOf();
        LuaTable mt = LuaValue.tableOf(new LuaValue[]{LuaValue.MODE, mode});
        table.setmetatable(mt);
        return table;
    }

    public WeakTable(boolean weakkeys, boolean weakvalues, LuaValue backing) {
        this.weakkeys = weakkeys;
        this.weakvalues = weakvalues;
        this.backing = backing;
    }

    @Override
    public boolean useWeakKeys() {
        return this.weakkeys;
    }

    @Override
    public boolean useWeakValues() {
        return this.weakvalues;
    }

    @Override
    public LuaValue toLuaValue() {
        return this.backing;
    }

    @Override
    public LuaTable.Slot entry(LuaValue key, LuaValue value) {
        if ((value = value.strongvalue()) == null) {
            return null;
        }
        if (this.weakkeys && !key.isnumber() && !key.isstring() && !key.isboolean()) {
            if (this.weakvalues && !value.isnumber() && !value.isstring() && !value.isboolean()) {
                return new WeakKeyAndValueSlot(key, value, null);
            }
            return new WeakKeySlot(key, value, null);
        }
        if (this.weakvalues && !value.isnumber() && !value.isstring() && !value.isboolean()) {
            return new WeakValueSlot(key, value, null);
        }
        return LuaTable.defaultEntry(key, value);
    }

    protected static LuaValue weaken(LuaValue value) {
        switch (value.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakValue(value);
            }
            case 7: {
                return new WeakUserdata(value);
            }
        }
        return value;
    }

    protected static LuaValue strengthen(Object ref) {
        if (ref instanceof WeakReference) {
            ref = ((WeakReference)ref).get();
        }
        if (ref instanceof WeakValue) {
            return ((WeakValue)ref).strongvalue();
        }
        return (LuaValue)ref;
    }

    @Override
    public LuaValue wrap(LuaValue value) {
        return this.weakvalues ? WeakTable.weaken(value) : value;
    }

    @Override
    public LuaValue arrayget(LuaValue[] array, int index) {
        LuaValue value = array[index];
        if (value != null && (value = WeakTable.strengthen(value)) == null) {
            array[index] = null;
        }
        return value;
    }

    static class WeakKeyAndValueSlot
    extends WeakSlot {
        private final int keyhash;

        protected WeakKeyAndValueSlot(LuaValue key, LuaValue value, LuaTable.Slot next2) {
            super(WeakTable.weaken(key), WeakTable.weaken(value), next2);
            this.keyhash = key.hashCode();
        }

        protected WeakKeyAndValueSlot(WeakKeyAndValueSlot copyFrom, LuaTable.Slot next2) {
            super(copyFrom.key, copyFrom.value, next2);
            this.keyhash = copyFrom.keyhash;
        }

        @Override
        public int keyindex(int hashMask) {
            return LuaTable.hashmod(this.keyhash, hashMask);
        }

        @Override
        public LuaTable.Slot set(LuaValue value) {
            this.value = WeakTable.weaken(value);
            return this;
        }

        @Override
        public LuaValue strongkey() {
            return WeakTable.strengthen(this.key);
        }

        @Override
        public LuaValue strongvalue() {
            return WeakTable.strengthen(this.value);
        }

        @Override
        protected WeakSlot copy(LuaTable.Slot next2) {
            return new WeakKeyAndValueSlot(this, next2);
        }
    }

    static class WeakKeySlot
    extends WeakSlot {
        private final int keyhash;

        protected WeakKeySlot(LuaValue key, LuaValue value, LuaTable.Slot next2) {
            super(WeakTable.weaken(key), value, next2);
            this.keyhash = key.hashCode();
        }

        protected WeakKeySlot(WeakKeySlot copyFrom, LuaTable.Slot next2) {
            super(copyFrom.key, copyFrom.value, next2);
            this.keyhash = copyFrom.keyhash;
        }

        @Override
        public int keyindex(int mask) {
            return LuaTable.hashmod(this.keyhash, mask);
        }

        @Override
        public LuaTable.Slot set(LuaValue value) {
            this.value = value;
            return this;
        }

        @Override
        public LuaValue strongkey() {
            return WeakTable.strengthen(this.key);
        }

        @Override
        protected WeakSlot copy(LuaTable.Slot rest) {
            return new WeakKeySlot(this, rest);
        }
    }

    static class WeakValueSlot
    extends WeakSlot {
        protected WeakValueSlot(LuaValue key, LuaValue value, LuaTable.Slot next2) {
            super(key, WeakTable.weaken(value), next2);
        }

        protected WeakValueSlot(WeakValueSlot copyFrom, LuaTable.Slot next2) {
            super(copyFrom.key, copyFrom.value, next2);
        }

        @Override
        public int keyindex(int mask) {
            return LuaTable.hashSlot(this.strongkey(), mask);
        }

        @Override
        public LuaTable.Slot set(LuaValue value) {
            this.value = WeakTable.weaken(value);
            return this;
        }

        @Override
        public LuaValue strongvalue() {
            return WeakTable.strengthen(this.value);
        }

        @Override
        protected WeakSlot copy(LuaTable.Slot next2) {
            return new WeakValueSlot(this, next2);
        }
    }

    static class WeakValue
    extends LuaValue {
        WeakReference ref;

        protected WeakValue(LuaValue value) {
            this.ref = new WeakReference<LuaValue>(value);
        }

        @Override
        public int type() {
            this.illegal("type", "weak value");
            return 0;
        }

        @Override
        public String typename() {
            this.illegal("typename", "weak value");
            return null;
        }

        @Override
        public String toString() {
            return "weak<" + this.ref.get() + ">";
        }

        @Override
        public LuaValue strongvalue() {
            Object o = this.ref.get();
            return (LuaValue)o;
        }

        @Override
        public boolean raweq(LuaValue rhs) {
            Object o = this.ref.get();
            return o != null && rhs.raweq((LuaValue)o);
        }
    }

    static final class WeakUserdata
    extends WeakValue {
        private final WeakReference ob;
        private final LuaValue mt;

        private WeakUserdata(LuaValue value) {
            super(value);
            this.ob = new WeakReference<Object>(value.touserdata());
            this.mt = value.getmetatable();
        }

        @Override
        public LuaValue strongvalue() {
            Object u = this.ref.get();
            if (u != null) {
                return (LuaValue)u;
            }
            Object o = this.ob.get();
            if (o != null) {
                LuaUserdata ud = LuaValue.userdataOf(o, this.mt);
                this.ref = new WeakReference<LuaUserdata>(ud);
                return ud;
            }
            return null;
        }
    }

    public static abstract class WeakSlot
    implements LuaTable.Slot {
        protected Object key;
        protected Object value;
        protected LuaTable.Slot next;

        protected WeakSlot(Object key, Object value, LuaTable.Slot next2) {
            this.key = key;
            this.value = value;
            this.next = next2;
        }

        @Override
        public abstract int keyindex(int var1);

        public abstract LuaTable.Slot set(LuaValue var1);

        @Override
        public LuaTable.StrongSlot first() {
            LuaValue key = this.strongkey();
            LuaValue value = this.strongvalue();
            if (key != null && value != null) {
                return new LuaTable.NormalEntry(key, value);
            }
            this.key = null;
            this.value = null;
            return null;
        }

        @Override
        public LuaTable.StrongSlot find(LuaValue key) {
            LuaTable.StrongSlot first = this.first();
            return first != null ? first.find(key) : null;
        }

        @Override
        public boolean keyeq(LuaValue key) {
            LuaTable.StrongSlot first = this.first();
            return first != null && first.keyeq(key);
        }

        @Override
        public LuaTable.Slot rest() {
            return this.next;
        }

        @Override
        public int arraykey(int max2) {
            return 0;
        }

        @Override
        public LuaTable.Slot set(LuaTable.StrongSlot target, LuaValue value) {
            LuaValue key = this.strongkey();
            if (key != null && target.find(key) != null) {
                return this.set(value);
            }
            if (key != null) {
                this.next = this.next.set(target, value);
                return this;
            }
            return this.next.set(target, value);
        }

        @Override
        public LuaTable.Slot add(LuaTable.Slot entry) {
            LuaTable.Slot slot = this.next = this.next != null ? this.next.add(entry) : entry;
            if (this.strongkey() != null && this.strongvalue() != null) {
                return this;
            }
            return this.next;
        }

        @Override
        public LuaTable.Slot remove(LuaTable.StrongSlot target) {
            LuaValue key = this.strongkey();
            if (key == null) {
                return this.next.remove(target);
            }
            if (target.keyeq(key)) {
                this.value = null;
                return this;
            }
            this.next = this.next.remove(target);
            return this;
        }

        @Override
        public LuaTable.Slot relink(LuaTable.Slot rest) {
            if (this.strongkey() != null && this.strongvalue() != null) {
                if (rest == null && this.next == null) {
                    return this;
                }
                return this.copy(rest);
            }
            return rest;
        }

        public LuaValue strongkey() {
            return (LuaValue)this.key;
        }

        public LuaValue strongvalue() {
            return (LuaValue)this.value;
        }

        protected abstract WeakSlot copy(LuaTable.Slot var1);
    }
}

