/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.regex.Pattern;
import net.minecraft.class_2960;

public class StringUtils {
    private static final CharSet ILLEGAL_CHARACTERS;
    private static final Pattern WINDOWS_RESERVED_REGEX;

    public static String convertResourceToPretty(class_2960 resource) {
        StringBuilder builder = new StringBuilder();
        if (!resource.method_12836().equals("minecraft")) {
            builder.append('(');
            builder.append(StringUtils.convertSnakeToWords(resource.method_12836()));
            builder.append(") ");
        }
        builder.append(StringUtils.convertSnakeToWords(resource.method_12832()));
        return builder.toString().strip();
    }

    public static String convertSnakeToWords(String snake) {
        StringBuilder builder = new StringBuilder();
        boolean capitalize = true;
        int length = snake.length();
        for (int i = 0; i < length; ++i) {
            char c = snake.charAt(i);
            if (c == '_') {
                builder.append(' ');
                capitalize = true;
                continue;
            }
            if (capitalize) {
                builder.append(Character.toUpperCase(c));
                capitalize = false;
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        if (capitalize) {
            builder.append('_');
        }
        return builder.toString().strip();
    }

    public static String convertSnakeToCamel(String snake) {
        StringBuilder builder = new StringBuilder();
        boolean capitalize = false;
        int length = snake.length();
        for (int i = 0; i < length; ++i) {
            char c = snake.charAt(i);
            if (c == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                builder.append(Character.toUpperCase(c));
                capitalize = false;
                continue;
            }
            builder.append(Character.toLowerCase(c));
        }
        if (capitalize) {
            builder.append('_');
        }
        return builder.toString();
    }

    public static String sanitizePath(String string) {
        StringBuilder builder = new StringBuilder();
        for (char c : ((String)string).toCharArray()) {
            if (ILLEGAL_CHARACTERS.contains(c)) continue;
            builder.append(c);
        }
        string = builder.toString();
        if (WINDOWS_RESERVED_REGEX.matcher((CharSequence)string).matches()) {
            string = "_" + (String)string + "_";
        }
        string = ((String)string).strip();
        while (((String)string).startsWith(".")) {
            string = ((String)string).substring(1);
        }
        if (((String)string).isEmpty()) {
            return "__EMPTY__";
        }
        return string;
    }

    static {
        char c;
        ILLEGAL_CHARACTERS = new CharOpenHashSet();
        ILLEGAL_CHARACTERS.add('/');
        ILLEGAL_CHARACTERS.add('?');
        ILLEGAL_CHARACTERS.add('<');
        ILLEGAL_CHARACTERS.add('>');
        ILLEGAL_CHARACTERS.add('\\');
        ILLEGAL_CHARACTERS.add(':');
        ILLEGAL_CHARACTERS.add('*');
        ILLEGAL_CHARACTERS.add('|');
        ILLEGAL_CHARACTERS.add('\"');
        for (c = '\u0000'; c <= '\u001f'; c = (char)(c + '\u0001')) {
            ILLEGAL_CHARACTERS.add(c);
        }
        for (c = '\u0080'; c <= '\u009f'; c = (char)(c + '\u0001')) {
            ILLEGAL_CHARACTERS.add(c);
        }
        WINDOWS_RESERVED_REGEX = Pattern.compile("(?:con|prn|aux|nul|com[0-9]|lpt[0-9])(?:\\..*)?$", 2);
    }
}

