/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.shatter;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.VoronoiEdgesNoise;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImString;
import java.text.NumberFormat;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class ShatterTool
implements Tool {
    protected final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    protected final ChunkedBooleanRegion removeRegion = new ChunkedBooleanRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final int[] scale = new int[]{8};
    private final int[] width = new int[]{1};
    private boolean useActiveBlock = false;
    private final int[] axis = new int[]{0};
    private final ImString noiseSeed = new ImString();
    private final int defaultRandomValue = ThreadLocalRandom.current().nextInt();
    private final PresetWidget presetWidget = new PresetWidget(this, "shatter");

    public ShatterTool() {
        this.noiseSeed.set(String.valueOf(this.defaultRandomValue), false);
    }

    @Override
    public void reset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.INSTANCE.release("shatter");
        }
        this.removeRegion.clear();
        this.chunkedBlockRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.INSTANCE.acquire("shatter");
                }
                this.pathProvider = new AsyncToolPathProvider(this.createToolPather(this.brushWidget.getBrushShape()));
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: 
            case DELETE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 2);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            class_2680 block = this.useActiveBlock ? Tool.getActiveBlock() : class_2246.field_10124.method_9564();
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            if (block.method_26215()) {
                String countString = NumberFormat.getInstance().format(this.removeRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.shatter", countString);
                RegionHelper.pushBooleanRegionChange(this.removeRegion, class_2246.field_10124.method_9564(), historyDescription, sourceInfo);
            } else {
                String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.shatter", countString);
                RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo);
            }
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            this.removeRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        int seed;
        String seedStr = ImGuiHelper.getString(this.noiseSeed).trim();
        if (seedStr.isEmpty()) {
            seed = this.defaultRandomValue;
        } else {
            try {
                seed = Integer.parseInt(seedStr);
            }
            catch (NumberFormatException numberFormatException) {
                seed = 0;
                for (char c : seedStr.toCharArray()) {
                    seed = 31 * seed + c;
                }
            }
        }
        VoronoiEdgesNoise crackNoise = new VoronoiEdgesNoise(seed, 1.0f);
        class_2680 setBlock = this.useActiveBlock ? Tool.getActiveBlock() : class_2246.field_10124.method_9564();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int scale = this.scale[0];
        int width = this.width[0];
        int axis = this.axis[0];
        class_638 level = class_310.method_1551().field_1687;
        MaskElement maskElement = MaskManager.getSourceMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        if (setBlock.method_26215()) {
            return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                class_2680 block = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (!block.method_26215() && maskElement.test(maskContext.reset(), x, y, z)) {
                    float noise;
                    switch (axis) {
                        default: {
                            float f = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)y + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                            break;
                        }
                        case 1: {
                            float f = crackNoise.evaluate(((double)y + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                            break;
                        }
                        case 2: {
                            float f = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                            break;
                        }
                        case 3: {
                            float f = noise = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)y + 0.5) / (double)scale);
                        }
                    }
                    if (noise < (float)width / ((float)scale * 2.0f)) {
                        ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, class_2246.field_10124.method_9564());
                        this.removeRegion.add(x, y, z);
                    }
                }
            });
        }
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            class_2680 block = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (!block.method_26215() && maskElement.test(maskContext.reset(), x, y, z)) {
                float noise;
                switch (axis) {
                    default: {
                        float f = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)y + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                        break;
                    }
                    case 1: {
                        float f = crackNoise.evaluate(((double)y + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                        break;
                    }
                    case 2: {
                        float f = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)z + 0.5) / (double)scale);
                        break;
                    }
                    case 3: {
                        float f = noise = crackNoise.evaluate(((double)x + 0.5) / (double)scale, ((double)y + 0.5) / (double)scale);
                    }
                }
                if (noise < (float)width / ((float)scale * 2.0f)) {
                    this.chunkedBlockRegion.addBlock(x, y, z, setBlock);
                }
            }
        });
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shatter"));
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shatter.scale"), this.scale, 0, 50);
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shatter.width"), this.width, 1, 8);
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shatter.use_active_block"), this.useActiveBlock)) {
            this.useActiveBlock = !this.useActiveBlock;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shatter.axis"), this.axis, new String[]{AxiomI18n.get("axiom.tool.shatter.axis_3d"), AxiomI18n.get("axiom.tool.shatter.axis_x"), AxiomI18n.get("axiom.tool.shatter.axis_y"), AxiomI18n.get("axiom.tool.shatter.axis_z")});
        changed |= ImGui.inputText(AxiomI18n.get("axiom.tool.generic.noise_seed"), this.noiseSeed);
        if (ImGui.button(AxiomI18n.get("axiom.tool.generic.noise_seed_do_randomize"))) {
            this.noiseSeed.set(String.valueOf(ThreadLocalRandom.current().nextInt()), false);
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.shatter");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Shatter Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10569("ShatterScale", this.scale[0]);
        tag.method_10569("ShatterWidth", this.width[0]);
        tag.method_10556("UseActiveBlock", this.useActiveBlock);
        tag.method_10567("Axis", (byte)this.axis[0]);
        tag.method_10582("NoiseSeed", ImGuiHelper.getString(this.noiseSeed));
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.scale[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "ShatterScale", 8);
        this.width[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "ShatterWidth", 1);
        this.useActiveBlock = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "UseActiveBlock", false);
        this.axis[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Axis", 0);
        this.noiseSeed.set(VersionUtilsNbt.helperCompoundTagGetStringOr(tag, "NoiseSeed", String.valueOf(this.defaultRandomValue)), false);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue911';
    }

    @Override
    public String keybindId() {
        return "shatter";
    }
}

