/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.ruler;

import com.moulberry.axiom.collections.Position2dSet;
import com.moulberry.axiom.funcinterfaces.BiIntConsumer;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.Shapes;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public record RulerCircle(Gizmo center, class_2382 offset, class_2350.class_2351 axis) {
    private static final Int2IntMap blockCountCache = new Int2IntOpenHashMap();

    public RulerCircle(class_2338 center, class_2338 edge, class_2350.class_2351 axis) {
        this(new Gizmo(center), (class_2382)edge.method_10059((class_2382)center), axis);
    }

    public int radius() {
        int dx = this.offset.method_10263();
        int dy = this.offset.method_10264();
        int dz = this.offset.method_10260();
        return (int)(Math.sqrt(dx * dx + dy * dy + dz * dz) + (double)0.35f);
    }

    public int blockCount() {
        int r = this.radius();
        if (blockCountCache.containsKey(r)) {
            return blockCountCache.get(r);
        }
        Position2dSet set = new Position2dSet();
        RulerCircle.forEachBlock(r, set::add);
        int count = set.count();
        blockCountCache.put(r, count);
        return count;
    }

    public void drawLineFromCenterToEdge(class_287 bufferBuilder, class_4587.class_4665 pose) {
        class_243 from = this.center().getTargetVec();
        class_243 to = from.method_1031((double)this.offset().method_10263(), (double)this.offset().method_10264(), (double)this.offset().method_10260());
        Shapes.line(bufferBuilder, pose, 1.0f, 1.0f, 1.0f, from, to);
    }

    public void drawCircle(class_4184 camera, class_4587 matrices, class_638 level, class_287 bufferBuilder, int colour) {
        class_2338 centerPos = this.center().getTargetPosition();
        RulerCircle.drawBlockOutline(camera, matrices, level, bufferBuilder, centerPos, colour);
        class_2338.class_2339 point = new class_2338.class_2339();
        RulerCircle.forEachBlock(this.radius(), (x, y) -> {
            switch (this.axis()) {
                case field_11048: {
                    point.method_10103(centerPos.method_10263(), centerPos.method_10264() + x, centerPos.method_10260() + y);
                    break;
                }
                case field_11052: {
                    point.method_10103(centerPos.method_10263() + x, centerPos.method_10264(), centerPos.method_10260() + y);
                    break;
                }
                case field_11051: {
                    point.method_10103(centerPos.method_10263() + x, centerPos.method_10264() + y, centerPos.method_10260());
                }
            }
            RulerCircle.drawBlockOutline(camera, matrices, level, bufferBuilder, (class_2338)point, colour);
        });
    }

    private static void drawBlockOutline(class_4184 camera, class_4587 matrices, class_638 level, class_287 bufferBuilder, class_2338 point, int colour) {
        class_2680 blockState = level.method_8320(point);
        class_265 voxelShape = blockState.method_26172((class_1922)level, point, class_3726.method_16195((class_1297)camera.method_19331()));
        matrices.method_22903();
        matrices.method_46416((float)point.method_10263(), (float)point.method_10264(), (float)point.method_10260());
        Shapes.blockOutline(bufferBuilder, matrices.method_23760(), voxelShape, colour);
        matrices.method_22909();
    }

    private static void forEachBlock(int r, BiIntConsumer consumer) {
        int t1 = r / 16;
        int x = r;
        int y = 0;
        while (x >= y) {
            int t2;
            consumer.accept(x, y);
            consumer.accept(-x, y);
            consumer.accept(x, -y);
            consumer.accept(-x, -y);
            consumer.accept(y, x);
            consumer.accept(-y, x);
            consumer.accept(y, -x);
            consumer.accept(-y, -x);
            if ((t2 = (t1 += ++y) - x) < 0) continue;
            t1 = t2;
            --x;
        }
    }
}

