/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.generator;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.generator.SpaceColonization;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5;
import net.minecraft.class_9;

public class TreeGeneration {
    public static ChunkedBlockRegion generateCyprus(class_1937 level, class_2338 pos) {
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        int height = 10 + ((Random)random2).nextInt(9);
        ChunkedBlockRegion region = new ChunkedBlockRegion();
        for (int y = 0; y < height; ++y) {
            region.addBlockWithoutDirty(pos.method_10263(), pos.method_10264() + y, pos.method_10260(), class_2246.field_10558.method_9564());
        }
        int leafHeight = 23 + random2.nextInt(-1, 2);
        for (int y = height; y < leafHeight; ++y) {
            region.addBlockWithoutDirty(pos.method_10263(), pos.method_10264() + y, pos.method_10260(), class_2246.field_28673.method_9564());
        }
        TreeGeneration.generateCyprusLeaves(pos.method_10069(0, 4, 0), height, region, class_2246.field_28673.method_9564());
        region.addBlockWithoutDirty(pos.method_10263() + 1, pos.method_10264() + 3, pos.method_10260(), class_2246.field_28673.method_9564());
        region.addBlockWithoutDirty(pos.method_10263() - 1, pos.method_10264() + 3, pos.method_10260(), class_2246.field_28673.method_9564());
        region.addBlockWithoutDirty(pos.method_10263(), pos.method_10264() + 3, pos.method_10260() + 1, class_2246.field_28673.method_9564());
        region.addBlockWithoutDirty(pos.method_10263(), pos.method_10264() + 3, pos.method_10260() - 1, class_2246.field_28673.method_9564());
        return region;
    }

    private static void generateCyprusLeaves(class_2338 pos, int height, ChunkedBlockRegion region, class_2680 blockState) {
        class_5 heap = new class_5();
        class_9 heapNode = new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260());
        heap.method_2(heapNode);
        PositionSet visited = new PositionSet();
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
        PositionSet reached = new PositionSet();
        int[] offsets = new int[]{0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, -1, 0, 0, 1, 0, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0, -1};
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        for (int i = 0; i < 14 * height && !heap.method_8(); ++i) {
            heapNode = heap.method_6();
            reached.add(heapNode.field_40, heapNode.field_39, heapNode.field_38);
            for (int i1 = 0; i1 < offsets.length; i1 += 3) {
                int newX = heapNode.field_40 + offsets[i1];
                int newY = heapNode.field_39 + offsets[i1 + 1];
                int newZ = heapNode.field_38 + offsets[i1 + 2];
                if (visited.contains(newX, newY, newZ)) continue;
                visited.add(newX, newY, newZ);
                class_9 newNode = new class_9(newX, newY, newZ);
                float dx = pos.method_10263() - newX;
                float dy = newY > pos.method_10264() + 15 ? (float)(4 + (newY - (pos.method_10264() + 15))) : (float)(pos.method_10264() - newY) / 15.0f * 4.0f;
                float dz = pos.method_10260() - newZ;
                if (offsets[i1 + 1] < 0) {
                    newNode.field_47 += 4.0f;
                }
                newNode.field_47 = (float)((double)newNode.field_47 + Math.sqrt(dx * dx * 4.0f + dy * dy + dz * dz * 4.0f));
                heap.method_2(newNode);
            }
        }
        reached.forEach((x, y, z) -> {
            if (x == pos.method_10263() && z == pos.method_10260() || y < pos.method_10264()) {
                region.addBlockIfNotPresent(x, y, z, blockState);
                return;
            }
            if (y < pos.method_10264() + height && Math.abs(x - pos.method_10263()) + Math.abs(z - pos.method_10260()) <= 1) {
                region.addBlockIfNotPresent(x, y, z, blockState);
                if ((double)random2.nextFloat() < 0.5) {
                    region.addBlockIfNotPresent(x, y + 1, z, blockState);
                }
                return;
            }
            int neighbors = 0;
            if (reached.contains(x + 1, y, z)) {
                ++neighbors;
            }
            if (reached.contains(x - 1, y, z)) {
                ++neighbors;
            }
            if (reached.contains(x, y + 1, z)) {
                ++neighbors;
            }
            if (reached.contains(x, y - 1, z)) {
                ++neighbors;
            }
            if (reached.contains(x, y, z + 1)) {
                ++neighbors;
            }
            if (reached.contains(x, y, z - 1)) {
                ++neighbors;
            }
            if ((double)random2.nextFloat() <= 0.5 + 0.5 * (double)neighbors * (double)neighbors / 30.0) {
                region.addBlockIfNotPresent(x, y, z, blockState);
                if ((double)random2.nextFloat() < 0.5) {
                    region.addBlockIfNotPresent(x, y + 1, z, blockState);
                }
            }
        });
    }

    public static ChunkedBlockRegion generateAsh(class_1937 level, class_2338 pos) {
        ChunkedBlockRegion region = new ChunkedBlockRegion();
        ArrayList<class_243> attractionPoints = new ArrayList<class_243>();
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        int height = 10 + ((Random)random2).nextInt(17);
        for (int i = 0; i < 1000; ++i) {
            float angle = ((Random)random2).nextFloat() * 2.0f * (float)Math.PI;
            float angleX = (float)Math.sin(angle);
            float angleZ = (float)Math.cos(angle);
            double y2 = ((Random)random2).nextFloat() * (float)(height - 5) + 5.0f;
            double spread = ((double)height - y2) / (double)((float)height / 5.0f) + 3.0;
            double randomSpread = (double)((Random)random2).nextFloat() * spread;
            attractionPoints.add(new class_243((double)pos.method_10263() + 0.5 + (double)angleX * randomSpread, (double)pos.method_10264() + 0.5 + y2, (double)pos.method_10260() + 0.5 + (double)angleZ * randomSpread));
        }
        SpaceColonization.TreeNode root = new SpaceColonization.TreeNode(class_243.method_24953((class_2382)pos));
        AtomicReference<SpaceColonization.TreeNode> last = new AtomicReference<SpaceColonization.TreeNode>(root);
        class_2338 end = pos.method_10069(random2.nextInt(-1, 2), height, random2.nextInt(-1, 2));
        Rasterization3D.dda(pos, end, (x, y, z) -> {
            SpaceColonization.TreeNode newNode = new SpaceColonization.TreeNode(new class_243((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
            ((SpaceColonization.TreeNode)last.get()).children.add(newNode);
            last.set(newNode);
        });
        SpaceColonization.colonize(root, attractionPoints, 3.0f, 6.0f);
        root.generate(region, class_2246.field_10178.method_9564());
        TreeGeneration.generateAshLeavesAtBranches(root, pos, height, region);
        TreeGeneration.generateAshLeaves(last.get(), pos, height, region);
        TreeGeneration.generateAshStump(level, pos, region, class_2246.field_10178.method_9564());
        return region;
    }

    private static boolean removeBranchesBelowLength(SpaceColonization.TreeNode node, int currentLength, int threshold) {
        if (node.children.isEmpty()) {
            return currentLength < threshold;
        }
        if (node.children.size() == 1) {
            return TreeGeneration.removeBranchesBelowLength(node.children.get(0), currentLength + 1, threshold);
        }
        node.children.removeIf(child -> TreeGeneration.removeBranchesBelowLength(child, 0, threshold));
        return false;
    }

    private static void generateAshLeavesAtBranches(SpaceColonization.TreeNode node, class_2338 rootPosition, int height, ChunkedBlockRegion region) {
        if (node.children.isEmpty()) {
            TreeGeneration.generateAshLeaves(node, rootPosition, height, region);
        } else {
            for (SpaceColonization.TreeNode child : node.children) {
                TreeGeneration.generateAshLeavesAtBranches(child, rootPosition, height, region);
            }
        }
    }

    private static void generateAshStump(class_1937 level, class_2338 pos, ChunkedBlockRegion region, class_2680 blockState) {
        class_5 heap = new class_5();
        class_9 heapNode = new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260());
        heap.method_2(heapNode);
        PositionSet visited = new PositionSet();
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
        int[] offsets = new int[]{0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, -1, 0, 0, 1, 0, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0, -1};
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        for (int i = 0; i < 8 && !heap.method_8(); ++i) {
            heapNode = heap.method_6();
            region.addBlockIfNotPresent(heapNode.field_40, heapNode.field_39, heapNode.field_38, blockState);
            for (int i1 = 0; i1 < offsets.length; i1 += 3) {
                int newX = heapNode.field_40 + offsets[i1];
                int newY = heapNode.field_39 + offsets[i1 + 1];
                int newZ = heapNode.field_38 + offsets[i1 + 2];
                if (offsets[i1 + 1] == 0 && !level.method_8320(new class_2338(newX, newY - 1, newZ)).method_51366() || visited.contains(newX, newY, newZ)) continue;
                visited.add(newX, newY, newZ);
                class_9 newNode = new class_9(newX, newY, newZ);
                float dx = pos.method_10263() - newX;
                float dy = pos.method_10264() - newY;
                float dz = pos.method_10260() - newZ;
                newNode.field_47 = (float)((double)newNode.field_47 + Math.sqrt(dx * dx * 4.0f + dy * dy + dz * dz * 4.0f));
                newNode.field_47 = (float)((double)newNode.field_47 + random2.nextGaussian());
                heap.method_2(newNode);
            }
        }
    }

    private static void generateAshLeaves(SpaceColonization.TreeNode node, class_2338 rootPosition, int height, ChunkedBlockRegion region) {
        class_5 heap = new class_5();
        class_2338 pos = class_2338.method_49638((class_2374)node.position);
        class_9 leafNode = new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260());
        heap.method_2(leafNode);
        PositionSet visited = new PositionSet();
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
        class_2350[] directions = class_2350.values();
        ThreadLocalRandom random2 = ThreadLocalRandom.current();
        int leaves = 32 + ((Random)random2).nextInt(32);
        leaves += 32 * (height - (pos.method_10264() - rootPosition.method_10264())) / height;
        for (int i = 0; i < leaves && !heap.method_8(); ++i) {
            leafNode = heap.method_6();
            region.addBlockIfNotPresent(leafNode.field_40, leafNode.field_39, leafNode.field_38, class_2246.field_10503.method_9564());
            for (class_2350 direction : directions) {
                int newZ;
                int newY;
                int newX = leafNode.field_40 + direction.method_10148();
                if (visited.contains(newX, newY = leafNode.field_39 + direction.method_10164(), newZ = leafNode.field_38 + direction.method_10165())) continue;
                visited.add(newX, newY, newZ);
                class_9 newNode = new class_9(newX, newY, newZ);
                float dx = pos.method_10263() - newX;
                float dy = pos.method_10264() - newY;
                float dz = pos.method_10260() - newZ;
                newNode.field_47 = (float)((double)newNode.field_47 + Math.sqrt(dx * dx + dy * dy * 3.0f + dz * dz));
                newNode.field_47 = (float)((double)newNode.field_47 + random2.nextGaussian() * 0.75);
                int y = leafNode.field_39 - rootPosition.method_10264();
                double spread = (float)(height - y) / ((float)height / 5.0f) + 3.0f;
                double distanceToCenterX = leafNode.field_40 - rootPosition.method_10263();
                double distanceToCenterZ = leafNode.field_38 - rootPosition.method_10260();
                double distanceToCenter = Math.sqrt(distanceToCenterX * distanceToCenterX + distanceToCenterZ * distanceToCenterZ);
                newNode.field_47 = (float)((double)newNode.field_47 + Math.abs(distanceToCenter - spread) * ((double)((Random)random2).nextFloat() + 0.5));
                heap.method_2(newNode);
            }
        }
    }
}

