/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.freehand;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import java.text.NumberFormat;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class FreehandDraw
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final ChunkedBooleanRegion airRegion = new ChunkedBooleanRegion();
    private boolean paintingAir = false;
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();

    @Override
    public void reset() {
        this.usingTool = false;
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
        this.chunkedBlockRegion.clear();
        this.airRegion.clear();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                BrushShape brushShape = this.brushWidget.getBrushShape();
                MaskElement maskElement = MaskManager.getDestMask();
                MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
                class_2680 blockState = Tool.getActiveBlock();
                this.reset();
                this.usingTool = true;
                if (blockState.method_26215()) {
                    this.paintingAir = true;
                    this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                        maskContext.reset();
                        class_2680 existing = maskContext.getBlockState(x, y, z);
                        if (!existing.method_26215() && maskElement.test(maskContext, x, y, z)) {
                            this.chunkedBlockRegion.addBlock(x, y, z, blockState);
                            this.airRegion.add(x, y, z);
                        }
                    }));
                } else {
                    this.paintingAir = false;
                    this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                        if (maskElement.test(maskContext.reset(), x, y, z)) {
                            this.chunkedBlockRegion.addBlock(x, y, z, blockState);
                        }
                    }));
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 1);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.drew", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            if (this.paintingAir) {
                this.airRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
            } else {
                float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            }
        }
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.brushWidget.displayImgui();
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.freehand_draw");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Freehand Draw Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue912';
    }

    @Override
    public String keybindId() {
        return "freehand_draw";
    }

    @Override
    public int defaultKeybind() {
        return 71;
    }
}

