/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.annotations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.annotations.AnnotationHistoryElement;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.core_rendering.AxiomBlending;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.windows.TextAnnotationListWindow;
import com.moulberry.axiom.packets.AxiomServerboundAnnotationUpdate;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.render.annotations.OutlineAnnotation;
import com.moulberry.axiom.render.annotations.TextAnnotation;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.annotation.AnnotationTool;
import com.moulberry.axiom.utils.FramebufferUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1041;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL31C;

public class Annotations {
    private static final Map<UUID, Annotation> annotationsByUUID = new LinkedHashMap<UUID, Annotation>();
    private static final Map<UUID, Annotation> visibleAnnotationsByUUID = new LinkedHashMap<UUID, Annotation>();
    private static class_4076 lastSectionPos = null;
    private static Vector4f pendingErase = null;
    private static final List<AnnotationHistoryElement> history = new ArrayList<AnnotationHistoryElement>();
    private static int historyPosition = 0;
    public static boolean hasVisibleOutlineAnnotation = false;
    private static class_276 renderTarget = null;

    public static Collection<Map.Entry<UUID, Annotation>> allAnnotations() {
        return annotationsByUUID.entrySet();
    }

    public static Set<Map.Entry<UUID, Annotation>> visibleAnnotations() {
        return visibleAnnotationsByUUID.entrySet();
    }

    public static int totalCount() {
        return annotationsByUUID.size();
    }

    public static void push(AnnotationHistoryElement annotationHistoryElement) {
        AnnotationUpdateAction annotationUpdateAction;
        while (history.size() > historyPosition) {
            history.remove(history.size() - 1);
        }
        new AxiomServerboundAnnotationUpdate(annotationHistoryElement.redo()).send();
        if (!history.isEmpty() && (annotationUpdateAction = annotationHistoryElement.singleUndo()) instanceof AnnotationUpdateAction.MoveAnnotation) {
            AnnotationUpdateAction.MoveAnnotation undoMove = (AnnotationUpdateAction.MoveAnnotation)annotationUpdateAction;
            AnnotationHistoryElement last = history.get(history.size() - 1);
            AnnotationUpdateAction annotationUpdateAction2 = last.singleRedo();
            if (annotationUpdateAction2 instanceof AnnotationUpdateAction.MoveAnnotation) {
                AnnotationUpdateAction.MoveAnnotation redoMove = (AnnotationUpdateAction.MoveAnnotation)annotationUpdateAction2;
                if (undoMove.uuid().equals(redoMove.uuid()) && undoMove.to().equals((Object)redoMove.to())) {
                    history.remove(history.size() - 1);
                    history.add(new AnnotationHistoryElement(last.undo(), annotationHistoryElement.redo()));
                    historyPosition = history.size();
                    return;
                }
            }
        }
        history.add(annotationHistoryElement);
        historyPosition = history.size();
    }

    public static UUID pushCreateAnnotation(AnnotationData annotation) {
        UUID uuid = UUID.randomUUID();
        Annotations.push(new AnnotationHistoryElement(List.of(new AnnotationUpdateAction.DeleteAnnotation(uuid)), List.of(new AnnotationUpdateAction.CreateAnnotation(uuid, annotation))));
        return uuid;
    }

    public static void pushUpdateAnnotation(UUID uuid, AnnotationData oldData, AnnotationData newData) {
        Annotations.push(new AnnotationHistoryElement(List.of(new AnnotationUpdateAction.CreateAnnotation(uuid, oldData)), List.of(new AnnotationUpdateAction.CreateAnnotation(uuid, newData))));
    }

    public static void undo() {
        if (historyPosition == 0) {
            return;
        }
        AnnotationHistoryElement element = history.get(--historyPosition);
        new AxiomServerboundAnnotationUpdate(element.undo()).send();
    }

    public static void redo() {
        if (historyPosition == history.size()) {
            return;
        }
        AnnotationHistoryElement element = history.get(historyPosition);
        new AxiomServerboundAnnotationUpdate(element.redo()).send();
        ++historyPosition;
    }

    public static void add(UUID uuid, AnnotationData annotationData) {
        Annotation oldAnnotation;
        Tool tool;
        Annotation annotation = Annotation.fromData(annotationData);
        if (annotation == null) {
            return;
        }
        if (ToolManager.isToolActive() && (tool = ToolManager.getCurrentTool()) instanceof AnnotationTool) {
            AnnotationTool annotationTool = (AnnotationTool)tool;
            if (uuid.equals(annotationTool.justPlacedAnnotation)) {
                annotationTool.selectedGizmo = annotation.getGizmo();
                annotationTool.selectedAnnotation = uuid;
                annotationTool.lastSelectedAnnotation = null;
                annotationTool.justPlacedAnnotation = null;
            }
        }
        if ((oldAnnotation = annotationsByUUID.put(uuid, annotation)) != null) {
            oldAnnotation.close();
        }
        if (annotation instanceof TextAnnotation) {
            TextAnnotationListWindow.invalidateTextAnnotations();
        }
        lastSectionPos = null;
    }

    @Nullable
    public static AnnotationData getData(UUID uuid) {
        Annotation annotation = annotationsByUUID.get(uuid);
        if (annotation != null) {
            return annotation.getData();
        }
        return null;
    }

    public static void remove(UUID uuid) {
        Annotation removed = annotationsByUUID.remove(uuid);
        if (removed != null) {
            removed.close();
            if (removed instanceof TextAnnotation) {
                TextAnnotationListWindow.invalidateTextAnnotations();
            }
        }
        if ((removed = visibleAnnotationsByUUID.remove(uuid)) != null) {
            removed.close();
        }
    }

    public static void move(UUID uuid, Vector3f location) {
        Annotation annotation = annotationsByUUID.get(uuid);
        if (annotation != null) {
            annotation.getData().setPosition(location);
        }
    }

    public static void rotate(UUID uuid, Quaternionf rotation) {
        Annotation annotation = annotationsByUUID.get(uuid);
        if (annotation != null) {
            annotation.getData().setRotation(rotation);
        }
    }

    public static void clear() {
        for (Annotation value : annotationsByUUID.values()) {
            value.close();
        }
        for (Annotation value : visibleAnnotationsByUUID.values()) {
            value.close();
        }
        annotationsByUUID.clear();
        visibleAnnotationsByUUID.clear();
        history.clear();
        historyPosition = 0;
    }

    public static void erase(class_241 pos1, class_241 pos2) {
        pendingErase = new Vector4f(pos1.field_1343, pos1.field_1342, pos2.field_1343, pos2.field_1342);
    }

    public static boolean showAnnotations() {
        return Configuration.rendering.showAnnotations || ToolManager.isToolActive() && ToolManager.getCurrentTool() instanceof AnnotationTool;
    }

    public static void renderPre(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!Annotations.showAnnotations() || annotationsByUUID.isEmpty()) {
            pendingErase = null;
            return;
        }
        RenderSystem.assertOnRenderThread();
        class_4076 sectionPos = class_4076.method_18682((class_2338)camera.method_19328());
        if (!Objects.equals(lastSectionPos, sectionPos)) {
            lastSectionPos = sectionPos;
            Annotations.calculateVisibleAnnotations();
        }
        if (visibleAnnotationsByUUID.isEmpty()) {
            pendingErase = null;
            return;
        }
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        bufferSource.method_22993();
        for (Map.Entry<UUID, Annotation> entry : visibleAnnotationsByUUID.entrySet()) {
            if (entry.getValue().renderPost()) continue;
            entry.getValue().render(entry.getKey(), camera, tickDelta, time, matrices, projection, class_310.method_1551().method_1522());
        }
        bufferSource.method_22993();
        if (pendingErase != null) {
            Annotations.eraseVisibleAnnotations(camera, tickDelta, time, matrices, projection);
            pendingErase = null;
        }
    }

    public static void renderPost(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!Annotations.showAnnotations() || visibleAnnotationsByUUID.isEmpty()) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        bufferSource.method_22993();
        boolean renderedAnything = false;
        int mainWidth = class_310.method_1551().method_1522().field_1482;
        int mainHeight = class_310.method_1551().method_1522().field_1481;
        for (Map.Entry<UUID, Annotation> entry : visibleAnnotationsByUUID.entrySet()) {
            if (!entry.getValue().renderPost()) continue;
            if (!renderedAnything) {
                renderedAnything = true;
                renderTarget = FramebufferUtils.resizeOrCreateFramebuffer(renderTarget, mainWidth, mainHeight);
                FramebufferUtils.clear(renderTarget, 0);
                FramebufferUtils.copyDepth(class_310.method_1551().method_1522(), renderTarget);
            }
            entry.getValue().render(entry.getKey(), camera, tickDelta, time, matrices, projection, renderTarget);
        }
        bufferSource.method_22993();
        if (renderedAnything) {
            class_310.method_1551().method_1522().method_1235(true);
            FramebufferUtils.blitToMainBlend(renderTarget, mainWidth, mainHeight, AxiomBlending.ONE_ONE_MINUS_SRC_ALPHA);
        }
    }

    private static void calculateVisibleAnnotations() {
        for (Annotation value : visibleAnnotationsByUUID.values()) {
            value.sectionChanged();
        }
        visibleAnnotationsByUUID.clear();
        hasVisibleOutlineAnnotation = false;
        int renderDistance = class_310.method_1551().field_1690.method_38521();
        for (Map.Entry<UUID, Annotation> entry : annotationsByUUID.entrySet()) {
            class_4076 minSectionPos = entry.getValue().getMinSectionY();
            class_4076 maxSectionPos = entry.getValue().getMaxSection();
            int deltaSectionX = Math.abs(Math.max(minSectionPos.method_18674(), Math.min(maxSectionPos.method_18674(), lastSectionPos.method_18674())) - lastSectionPos.method_18674());
            int deltaSectionY = Math.abs(Math.max(minSectionPos.method_18683(), Math.min(maxSectionPos.method_18683(), lastSectionPos.method_18683())) - lastSectionPos.method_18683());
            int deltaSectionZ = Math.abs(Math.max(minSectionPos.method_18687(), Math.min(maxSectionPos.method_18687(), lastSectionPos.method_18687())) - lastSectionPos.method_18687());
            if (deltaSectionX * deltaSectionX + deltaSectionZ * deltaSectionZ > renderDistance * renderDistance || deltaSectionY > renderDistance) continue;
            visibleAnnotationsByUUID.put(entry.getKey(), entry.getValue());
            if (!(entry.getValue() instanceof OutlineAnnotation)) continue;
            hasVisibleOutlineAnnotation = true;
        }
    }

    private static void eraseVisibleAnnotations(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        class_1041 window = class_310.method_1551().method_22683();
        float minX = (Math.min(Annotations.pendingErase.x, Annotations.pendingErase.z) - (float)EditorUI.frameX) / (float)EditorUI.frameWidth;
        float maxX = (Math.max(Annotations.pendingErase.x, Annotations.pendingErase.z) - (float)EditorUI.frameX) / (float)EditorUI.frameWidth;
        float minY = (Math.min(Annotations.pendingErase.y, Annotations.pendingErase.w) - (float)EditorUI.frameY) / (float)EditorUI.frameHeight;
        float maxY = (Math.max(Annotations.pendingErase.y, Annotations.pendingErase.w) - (float)EditorUI.frameY) / (float)EditorUI.frameHeight;
        minX = Math.max(0.0f, Math.min(1.0f, minX));
        maxX = Math.max(0.0f, Math.min(1.0f, maxX));
        minY = Math.max(0.0f, Math.min(1.0f, minY));
        maxY = Math.max(0.0f, Math.min(1.0f, maxY));
        float left = (float)window.method_4489() * minX;
        float bottom = (float)window.method_4506() - (float)window.method_4506() * maxY;
        float width = (float)window.method_4489() * (maxX - minX);
        float height = (float)window.method_4506() * (maxY - minY);
        AxiomRenderer.enableScissor((int)left, (int)bottom, (int)width, (int)height);
        ArrayList<AnnotationUpdateAction> undo = new ArrayList<AnnotationUpdateAction>();
        ArrayList<AnnotationUpdateAction> redo = new ArrayList<AnnotationUpdateAction>();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        bufferSource.method_22993();
        for (Map.Entry<UUID, Annotation> entry : visibleAnnotationsByUUID.entrySet()) {
            Annotation annotation = entry.getValue();
            int query = GL31C.glGenQueries();
            GL31C.glBeginQuery((int)35092, (int)query);
            annotation.render(entry.getKey(), camera, tickDelta, time, matrices, projection, class_310.method_1551().method_1522());
            bufferSource.method_22993();
            GL31C.glEndQuery((int)35092);
            if (GL31C.glGetQueryObjecti((int)query, (int)34918) > 0) {
                undo.add(new AnnotationUpdateAction.CreateAnnotation(entry.getKey(), annotation.getData()));
                redo.add(new AnnotationUpdateAction.DeleteAnnotation(entry.getKey()));
            }
            GL31C.glDeleteQueries((int)query);
        }
        Annotations.push(new AnnotationHistoryElement(undo, redo));
        AxiomRenderer.disableScissor();
    }
}

