/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TorusRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void torus(ChunkedBlockRegion region, class_2680 block, class_2338 center, int diameterX, int diameterZ, boolean hollow, int ringHorizontal, int ringVertical, @Nullable Quaternionf quaternionf) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        if (diameterX < ringHorizontal) {
            diameterX = ringHorizontal;
        }
        if (diameterZ < ringHorizontal) {
            diameterZ = ringHorizontal;
        }
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        float ringRadiusV = (float)(ringVertical - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRingRadiusV = (int)Math.ceil(ringRadiusV);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRingRadiusV * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float majorRadius = Math.min(radiusX, radiusZ) + 0.5f - (float)ringHorizontal / 2.0f;
        float invRingVerticalSq = RasterizationHelper.calcInvRadiusSq(ringRadiusV);
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(ringRadiusV % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        float subX = radiusX - radiusZ;
        float subZ = radiusZ - radiusX;
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    if (Math.abs(rx) < subX) {
                        rx = 0.0f;
                    } else if (subX > 0.0f) {
                        rx -= Math.copySign(subX, rx);
                    }
                    if (Math.abs(rz) < subZ) {
                        rz = 0.0f;
                    } else if (subZ > 0.0f) {
                        rz -= Math.copySign(subZ, rz);
                    }
                    float majorDistance = (float)Math.sqrt(rx * rx + rz * rz) - majorRadius;
                    float majorDistanceSq = majorDistance * majorDistance;
                    if (majorDistanceSq / ((float)(ringHorizontal * ringHorizontal) / 4.0f) + ry * ry * invRingVerticalSq > 1.0f) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        if (Math.abs(rx) < subX) {
                            rx = 0.0f;
                        } else if (subX > 0.0f) {
                            rx -= Math.copySign(subX, rx);
                        }
                        if (Math.abs(rz) < subZ) {
                            rz = 0.0f;
                        } else if (subZ > 0.0f) {
                            rz -= Math.copySign(subZ, rz);
                        }
                        majorDistance = (float)Math.sqrt(rx * rx + rz * rz) - majorRadius;
                        majorDistanceSq = majorDistance * majorDistance;
                        if (!(majorDistanceSq / ((float)(ringHorizontal * ringHorizontal) / 4.0f) + ry * ry * invRingVerticalSq > 1.0f)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block5;
                    }
                }
            }
        }
    }

    public static void torusMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, int diameterX, int diameterZ, boolean hollow, int ringHorizontal, int ringVertical, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            TorusRasterization.torus(region, block, center, diameterX, diameterZ, hollow, ringHorizontal, ringVertical, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        Quaternionf quaternionFinal = quaternionf;
        if (diameterX < ringHorizontal) {
            diameterX = ringHorizontal;
        }
        if (diameterZ < ringHorizontal) {
            diameterZ = ringHorizontal;
        }
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        float ringRadiusV = (float)(ringVertical - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRingRadiusV = (int)Math.ceil(ringRadiusV + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x2 = -1; x2 <= 1; x2 += 2) {
            for (int y2 = -1; y2 <= 1; y2 += 2) {
                for (int z2 = -1; z2 <= 1; z2 += 2) {
                    vector3f.set((float)(ceilRadiusX * x2), (float)(ceilRingRadiusV * y2), (float)(ceilRadiusZ * z2));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float majorRadius = Math.min(radiusX, radiusZ) + 0.5f - (float)ringHorizontal / 2.0f;
        float invRingVerticalSq = RasterizationHelper.calcInvRadiusSq(ringRadiusV);
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(ringRadiusV % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        float subX = radiusX - radiusZ;
        float subZ = radiusZ - radiusX;
        RasterizationHelper.metaball((class_1937)level, region, metaballRange, block, center, maxRadiusX, maxRadiusY, maxRadiusZ, (x, y, z) -> {
            vector3f.set((float)x, (float)y, (float)z);
            quaternionFinal.transform(vector3f);
            float rx = vector3f.x + offsetX;
            float ry = vector3f.y + offsetY;
            float rz = vector3f.z + offsetZ;
            if (Math.abs(rx) < subX) {
                rx = 0.0f;
            } else if (subX > 0.0f) {
                rx -= Math.copySign(subX, rx);
            }
            if (Math.abs(rz) < subZ) {
                rz = 0.0f;
            } else if (subZ > 0.0f) {
                rz -= Math.copySign(subZ, rz);
            }
            float majorDistance = (float)Math.sqrt(rx * rx + rz * rz) - majorRadius;
            float majorDistanceSq = majorDistance * majorDistance;
            if (majorDistanceSq / ((float)(ringHorizontal * ringHorizontal) / 4.0f) + ry * ry * invRingVerticalSq > 1.0f) {
                return false;
            }
            if (!hollow) {
                return true;
            }
            for (int i = 0; i < 18; i += 3) {
                int nx = x + CARDINAL_OFFSETS[i];
                int ny = y + CARDINAL_OFFSETS[i + 1];
                int nz = z + CARDINAL_OFFSETS[i + 2];
                vector3f.set((float)nx, (float)ny, (float)nz);
                quaternionFinal.transform(vector3f);
                rx = vector3f.x + offsetX;
                ry = vector3f.y + offsetY;
                rz = vector3f.z + offsetZ;
                if (Math.abs(rx) < subX) {
                    rx = 0.0f;
                } else if (subX > 0.0f) {
                    rx -= Math.copySign(subX, rx);
                }
                if (Math.abs(rz) < subZ) {
                    rz = 0.0f;
                } else if (subZ > 0.0f) {
                    rz -= Math.copySign(subZ, rz);
                }
                majorDistance = (float)Math.sqrt(rx * rx + rz * rz) - majorRadius;
                majorDistanceSq = majorDistance * majorDistance;
                if (!(majorDistanceSq / ((float)(ringHorizontal * ringHorizontal) / 4.0f) + ry * ry * invRingVerticalSq > 1.0f)) continue;
                return true;
            }
            return false;
        });
    }
}

