/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PyramidRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void pyramid(ChunkedBlockRegion region, class_2680 block, class_2338 center, int diameterX, int height, int diameterZ, boolean hollow, @Nullable Quaternionf quaternionf) {
        if (diameterX <= 0 || height <= 0 || diameterZ <= 0) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusY = (float)(height - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(radiusY % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    float h2 = radiusY - ry + 1.0f;
                    float r = Math.max(Math.abs(rx) * radiusZ, Math.abs(rz) * radiusX) * (float)height;
                    if (!(r <= h2 * radiusX * radiusZ) || !(Math.abs(ry) <= radiusY + 0.5f)) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        h2 = radiusY - ry + 1.0f;
                        r = Math.max(Math.abs(rx) * radiusZ, Math.abs(rz) * radiusX) * (float)height;
                        if (!(r > h2 * radiusX * radiusZ) && !(Math.abs(ry) > radiusY + 0.5f)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block5;
                    }
                }
            }
        }
    }

    public static void pyramidMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, int diameterX, int height, int diameterZ, boolean hollow, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            PyramidRasterization.pyramid(region, block, center, diameterX, height, diameterZ, hollow, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (diameterX <= 0 || height <= 0 || diameterZ <= 0) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        Quaternionf quaternionFinal = quaternionf;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusY = (float)(height - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRadiusY = (int)Math.ceil(radiusY + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x2 = -1; x2 <= 1; x2 += 2) {
            for (int y2 = -1; y2 <= 1; y2 += 2) {
                for (int z2 = -1; z2 <= 1; z2 += 2) {
                    vector3f.set((float)(ceilRadiusX * x2), (float)(ceilRadiusY * y2), (float)(ceilRadiusZ * z2));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float offsetX = -(radiusX % 1.0f);
        float offsetY = -(radiusY % 1.0f);
        float offsetZ = -(radiusZ % 1.0f);
        RasterizationHelper.metaball((class_1937)level, region, metaballRange, block, center, maxRadiusX, maxRadiusY, maxRadiusZ, (x, y, z) -> {
            vector3f.set((float)x, (float)y, (float)z);
            quaternionFinal.transform(vector3f);
            float rx = vector3f.x + offsetX;
            float ry = vector3f.y + offsetY;
            float rz = vector3f.z + offsetZ;
            float h2 = radiusY - ry + 1.0f;
            float r = Math.max(Math.abs(rx) * radiusZ, Math.abs(rz) * radiusX) * (float)height;
            if (r <= h2 * radiusX * radiusZ && Math.abs(ry) <= radiusY + 0.5f) {
                if (!hollow) {
                    return true;
                }
                for (int i = 0; i < 18; i += 3) {
                    int nx = x + CARDINAL_OFFSETS[i];
                    int ny = y + CARDINAL_OFFSETS[i + 1];
                    int nz = z + CARDINAL_OFFSETS[i + 2];
                    vector3f.set((float)nx, (float)ny, (float)nz);
                    quaternionFinal.transform(vector3f);
                    rx = vector3f.x + offsetX;
                    ry = vector3f.y + offsetY;
                    rz = vector3f.z + offsetZ;
                    h2 = radiusY - ry + 1.0f;
                    r = Math.max(Math.abs(rx) * radiusZ, Math.abs(rz) * radiusX) * (float)height;
                    if (!(r > h2 * radiusX * radiusZ) && !(Math.abs(ry) > radiusY + 0.5f)) continue;
                    return true;
                }
            }
            return false;
        });
    }
}

