/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class FillOperation {
    public static int FILL_INSIDE = 1;
    public static int FILL_WALLS = 2;
    public static int FILL_CEILING = 4;
    public static int FILL_FLOOR = 8;
    public static int FILL_EXTERIOR = FILL_WALLS | FILL_CEILING | FILL_FLOOR;
    public static int FILL_ALL = FILL_INSIDE | FILL_EXTERIOR;

    public static void fill(class_2680 blockState) {
        FillOperation.fill(blockState, FILL_ALL);
    }

    public static void fill(class_2680 blockState, int fillFlags) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            FillOperation.fillAABB(aabb, blockState, fillFlags);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            FillOperation.fillSet(set, blockState, fillFlags);
        }
    }

    private static void fillAABB(SelectionBuffer.AABB aabb, class_2680 blockState, int fillFlags) {
        if ((fillFlags & FILL_ALL) == 0) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if ((fillFlags & FILL_INSIDE) != 0) {
            if ((fillFlags & FILL_WALLS) == 0) {
                ++minX;
                ++minZ;
                --maxX;
                --maxZ;
            }
            if ((fillFlags & FILL_CEILING) == 0) {
                --maxY;
            }
            if ((fillFlags & FILL_FLOOR) == 0) {
                ++minY;
            }
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (block.method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount;
                    }
                }
            }
        } else {
            boolean floor2;
            if ((fillFlags & FILL_WALLS) != 0) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2680 block;
                    for (int x = minX; x <= maxX; ++x) {
                        block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, minZ));
                        if (block.method_26204() == class_2246.field_10243) continue;
                        if (block != blockState) {
                            setOperation.set(x, y, minZ, blockState);
                            previousBlocksForUndo.set(x, y, minZ, block);
                            ++changeCount;
                        }
                        if ((block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, maxZ))).method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(x, y, maxZ, blockState);
                        previousBlocksForUndo.set(x, y, maxZ, block);
                        ++changeCount;
                    }
                    for (int z = minZ + 1; z <= maxZ - 1; ++z) {
                        block = world.method_8320((class_2338)mutableBlockPos.method_10103(minX, y, z));
                        if (block.method_26204() == class_2246.field_10243) continue;
                        if (block != blockState) {
                            setOperation.set(minX, y, z, blockState);
                            previousBlocksForUndo.set(minX, y, z, block);
                            ++changeCount;
                        }
                        if ((block = world.method_8320((class_2338)mutableBlockPos.method_10103(maxX, y, z))).method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(maxX, y, z, blockState);
                        previousBlocksForUndo.set(maxX, y, z, block);
                        ++changeCount;
                    }
                }
                ++minX;
                ++minZ;
                --maxX;
                --maxZ;
            }
            boolean ceiling = (fillFlags & FILL_CEILING) != 0;
            boolean bl = floor2 = (fillFlags & FILL_FLOOR) != 0;
            if (floor2 && ceiling) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, minY, z));
                        if (block.method_26204() == class_2246.field_10243) continue;
                        if (block != blockState) {
                            setOperation.set(x, minY, z, blockState);
                            previousBlocksForUndo.set(x, minY, z, block);
                            ++changeCount;
                        }
                        if ((block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, maxY, z))).method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(x, maxY, z, blockState);
                        previousBlocksForUndo.set(x, maxY, z, block);
                        ++changeCount;
                    }
                }
            } else if (floor2) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, minY, z));
                        if (block.method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(x, minY, z, blockState);
                        previousBlocksForUndo.set(x, minY, z, block);
                        ++changeCount;
                    }
                }
            } else if (ceiling) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, maxY, z));
                        if (block.method_26204() == class_2246.field_10243 || block == blockState) continue;
                        setOperation.set(x, maxY, z, blockState);
                        previousBlocksForUndo.set(x, maxY, z, block);
                        ++changeCount;
                    }
                }
            }
        }
        if (changeCount == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String blockName = AxiomI18n.get(blockState.method_26204().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Fill Operation"));
    }

    private static void fillSet(SelectionBuffer.Set set, class_2680 blockState, int fillFlags) {
        if ((fillFlags & FILL_ALL) == 0) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if ((fillFlags & FILL_ALL) == FILL_ALL) {
            set.selectionRegion.forEach((x, y, z) -> {
                class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (block.method_26204() == class_2246.field_10243) {
                    return;
                }
                if (block != blockState) {
                    setOperation.set(x, y, z, blockState);
                    previousBlocksForUndo.set(x, y, z, block);
                    ++changeCount.value;
                }
            });
        } else if ((fillFlags & FILL_INSIDE) != 0) {
            ceiling = (fillFlags & FILL_CEILING) != 0;
            floor = (fillFlags & FILL_FLOOR) != 0;
            boolean bl = walls = (fillFlags & FILL_WALLS) != 0;
            if (!(ceiling || floor || walls)) {
                set.selectionRegion.forEach((x, y, z) -> {
                    if (!set.selectionRegion.contains(x, y + 1, z)) {
                        return;
                    }
                    if (!set.selectionRegion.contains(x, y - 1, z)) {
                        return;
                    }
                    if (!set.selectionRegion.contains(x + 1, y, z)) {
                        return;
                    }
                    if (!set.selectionRegion.contains(x - 1, y, z)) {
                        return;
                    }
                    if (!set.selectionRegion.contains(x, y, z + 1)) {
                        return;
                    }
                    if (!set.selectionRegion.contains(x, y, z - 1)) {
                        return;
                    }
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26204() == class_2246.field_10243) {
                        return;
                    }
                    if (block != blockState) {
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount.value;
                    }
                });
            } else {
                set.selectionRegion.forEach((x, y, z) -> {
                    class_2680 block;
                    if (!ceiling && !set.selectionRegion.contains(x, y + 1, z)) {
                        return;
                    }
                    if (!floor && !set.selectionRegion.contains(x, y - 1, z)) {
                        return;
                    }
                    if (!walls) {
                        if (!set.selectionRegion.contains(x + 1, y, z)) {
                            return;
                        }
                        if (!set.selectionRegion.contains(x - 1, y, z)) {
                            return;
                        }
                        if (!set.selectionRegion.contains(x, y, z + 1)) {
                            return;
                        }
                        if (!set.selectionRegion.contains(x, y, z - 1)) {
                            return;
                        }
                    }
                    if ((block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z))).method_26204() == class_2246.field_10243) {
                        return;
                    }
                    if (block != blockState) {
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount.value;
                    }
                });
            }
        } else {
            ceiling = (fillFlags & FILL_CEILING) != 0;
            floor = (fillFlags & FILL_FLOOR) != 0;
            boolean bl = walls = (fillFlags & FILL_WALLS) != 0;
            if (ceiling && !floor && !walls) {
                set.selectionRegion.forEach((x, y, z) -> {
                    if (set.selectionRegion.contains(x, y + 1, z)) {
                        return;
                    }
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26204() == class_2246.field_10243) {
                        return;
                    }
                    if (block != blockState) {
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount.value;
                    }
                });
            } else if (!ceiling && floor && !walls) {
                set.selectionRegion.forEach((x, y, z) -> {
                    if (set.selectionRegion.contains(x, y - 1, z)) {
                        return;
                    }
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26204() == class_2246.field_10243) {
                        return;
                    }
                    if (block != blockState) {
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount.value;
                    }
                });
            } else if (!ceiling && !floor && walls) {
                set.selectionRegion.forEach((x, y, z) -> {
                    if (set.selectionRegion.contains(x + 1, y, z) && set.selectionRegion.contains(x - 1, y, z) && set.selectionRegion.contains(x, y, z + 1) && set.selectionRegion.contains(x, y, z - 1)) {
                        return;
                    }
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26204() == class_2246.field_10243) {
                        return;
                    }
                    if (block != blockState) {
                        setOperation.set(x, y, z, blockState);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount.value;
                    }
                });
            } else {
                set.selectionRegion.forEach((x, y, z) -> {
                    if (ceiling && !set.selectionRegion.contains(x, y + 1, z) || floor && !set.selectionRegion.contains(x, y - 1, z) || walls && (!set.selectionRegion.contains(x + 1, y, z) || !set.selectionRegion.contains(x - 1, y, z) || !set.selectionRegion.contains(x, y, z + 1) || !set.selectionRegion.contains(x, y, z - 1))) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (block.method_26204() == class_2246.field_10243) {
                            return;
                        }
                        if (block != blockState) {
                            setOperation.set(x, y, z, blockState);
                            previousBlocksForUndo.set(x, y, z, block);
                            ++changeCount.value;
                        }
                    }
                });
            }
        }
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String blockName = AxiomI18n.get(blockState.method_26204().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0), Dispatcher.simpleSourceInfo("Fill Operation"));
    }
}

