/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.hooks;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.capabilities.AngelPlacement;
import com.moulberry.axiom.capabilities.ArcballCamera;
import com.moulberry.axiom.capabilities.BuildSymmetry;
import com.moulberry.axiom.capabilities.ReplaceMode;
import com.moulberry.axiom.clipboard.ModifySelection;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.windows.operations.AutoshadeWindow;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.render.BiomeOverlayRenderer;
import com.moulberry.axiom.render.CollisionMeshOverlayRenderer;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.render.annotations.Annotations;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.fluidball.FluidBall;
import com.moulberry.axiom.tools.lasso_select.LassoSelect;
import com.moulberry.axiom.tools.lasso_select.PendingLassoSelect;
import com.moulberry.axiom.tools.ruler.RulerTool;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_746;
import net.minecraft.class_846;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class WorldRenderHook {
    public static float distance = 0.0f;
    public static boolean hasDistance = false;
    public static final class_846.class_849 VERY_VISIBLE_CHUNK = new class_846.class_849(){

        public boolean method_3650(class_2350 direction, class_2350 direction2) {
            return true;
        }
    };

    private static boolean renderHookOnPost() {
        return class_310.method_29611() || ToolManager.isToolActive() && ToolManager.getCurrentTool() instanceof FluidBall;
    }

    public static void renderPre(class_4587 poseStack, float tickDelta, long limitTime, class_4184 camera, Matrix4f projection) {
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        AxiomRenderer.forgetRememberedVertexBuffers();
        Matrix4f pose = poseStack.method_23760().method_23761();
        class_4599 renderBuffers = class_310.method_1551().method_22940();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_243 vec3 = camera.method_19326();
            double camX = vec3.method_10216();
            double camY = vec3.method_10214();
            double camZ = vec3.method_10215();
            for (class_1268 hand : class_1268.values()) {
                class_1799 heldItem = class_310.method_1551().field_1724.method_5998(hand);
                if (!(heldItem.method_7909() instanceof class_1747)) continue;
                AngelPlacement.render(poseStack, renderBuffers.method_23000(), camX, camY, camZ, tickDelta, hand, heldItem);
                renderBuffers.method_23000().method_37104();
                break;
            }
        }
        if (!WorldRenderHook.renderHookOnPost()) {
            WorldRenderHook.renderHook(poseStack, tickDelta, limitTime, camera, projection);
        }
        renderBuffers.method_23000().method_22993();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderPost(class_4587 poseStack, float tickDelta, long limitTime, class_4184 camera, Matrix4f projection) {
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        if (WorldRenderHook.renderHookOnPost()) {
            WorldRenderHook.renderHook(poseStack, tickDelta, limitTime, camera, projection);
        }
        class_310.method_1551().method_22940().method_23000().method_22993();
        BiomeOverlayRenderer.INSTANCE.render(poseStack, projection, camera);
        CollisionMeshOverlayRenderer.INSTANCE.render(poseStack, projection, camera);
        Annotations.renderPost(camera, tickDelta, limitTime, poseStack, projection);
        ShaderManager.blitSelectionOutlineTarget();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderHook(class_4587 poseStack, float tickDelta, long limitTime, class_4184 camera, Matrix4f projection) {
        long oldImGuiContext = EditorUI.pushImGuiContext();
        try {
            class_310.method_1551().method_22940().method_23000().method_22993();
            ++MaskContext.frame;
            Annotations.renderPre(camera, tickDelta, limitTime, poseStack, projection);
            if (Annotations.showAnnotations() && Annotations.hasVisibleOutlineAnnotation) {
                ShaderManager.preCopySelectionOutlineTarget();
            }
            ReplaceMode.renderTick();
            EditorUI.lastProjectionMatrix = projection;
            EditorUI.lastViewQuaternion = camera.method_23767();
            if (Placement.INSTANCE.isPlacing()) {
                Placement.INSTANCE.render(camera, tickDelta, limitTime, poseStack, projection);
            }
            if (EditorUI.isActive()) {
                if (ModifySelection.isModifyingSelection()) {
                    ModifySelection.render(camera, tickDelta, limitTime, poseStack, projection);
                } else if (ToolManager.isToolActive()) {
                    Tool currentTool = ToolManager.getCurrentTool();
                    currentTool.render(camera, tickDelta, limitTime, poseStack, projection);
                } else {
                    Selection.render(camera, limitTime, poseStack, projection, 7);
                }
                AutoshadeWindow.renderWorld(camera, limitTime, poseStack, projection);
            } else {
                if (BuilderToolManager.isToolSlotActive()) {
                    BuilderToolManager.renderWorld(camera, limitTime, poseStack, projection);
                }
                BuildSymmetry.renderWorld(camera, limitTime, poseStack, projection);
                DisplayEntityManipulator.render(camera, limitTime, poseStack, projection);
            }
            MarkerEntityManipulator.render(camera, limitTime, poseStack, projection);
            WorldRenderHook.handleDepthFeatures(projection, tickDelta);
            if (Configuration.rendering.showRuler || ToolManager.isToolActive() && ToolManager.getCurrentTool() instanceof RulerTool) {
                RulerTool.renderPoints(camera, tickDelta, limitTime, poseStack, projection);
            }
            Dispatcher.renderTracers(poseStack, camera, tickDelta);
        }
        finally {
            EditorUI.popImGuiContext(oldImGuiContext);
        }
    }

    private static void handleDepthFeatures(Matrix4f projection, float tickDelta) {
        class_276 renderTarget;
        if (!LassoSelect.pendingDepthBuffer.isEmpty()) {
            float[] pixels = null;
            class_276 renderTarget2 = class_310.method_1551().method_1522();
            for (PendingLassoSelect pending : LassoSelect.pendingDepthBuffer) {
                if (pending.width() != renderTarget2.field_1482 || pending.height() != renderTarget2.field_1481) continue;
                if (pixels == null) {
                    FramebufferUtils.bindDepth(renderTarget2);
                    pixels = new float[renderTarget2.field_1482 * renderTarget2.field_1481];
                    GL11.glReadPixels((int)0, (int)0, (int)renderTarget2.field_1482, (int)renderTarget2.field_1481, (int)6402, (int)5126, (float[])pixels);
                    renderTarget2.method_1235(true);
                }
                pending.handle(pixels, new Matrix4f((Matrix4fc)projection));
            }
            LassoSelect.pendingDepthBuffer.clear();
        }
        if (EditorUI.pendingDepthActions.isEmpty()) {
            hasDistance = false;
        } else {
            renderTarget = class_310.method_1551().method_1522();
            class_241 fraction = EditorUI.getMouseViewportFraction();
            WorldRenderHook.updateDepthDistance(renderTarget, projection, fraction);
        }
        if (ClientEvents.waitingForOrbitCameraDepth) {
            ClientEvents.waitingForOrbitCameraDepth = false;
            renderTarget = class_310.method_1551().method_1522();
            WorldRenderHook.updateDepthDistance(renderTarget, projection, new class_241(0.5f, 0.5f));
            class_746 player = class_310.method_1551().field_1724;
            if (hasDistance && player != null) {
                class_243 look = player.method_5720();
                class_243 point = player.method_5836(tickDelta).method_1019(look.method_1021((double)distance));
                int minBuildHeight = player.method_37908().method_31607();
                if (point.field_1351 < (double)minBuildHeight) {
                    double yDelta = (double)minBuildHeight - point.field_1351;
                    if (Math.abs(look.field_1351) > 1.0E-4) {
                        double scale = yDelta / look.field_1351;
                        point = point.method_1019(look.method_1021(scale));
                    }
                }
                class_243 raycastStart = point.method_1019(look.method_1021(-1.0));
                class_243 raycastEnd = point.method_1019(look.method_1021(1.0));
                class_3965 result = player.method_37908().method_17742(new class_3959(raycastStart, raycastEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
                if (!result.method_17781() && result.method_17783() == class_239.class_240.field_1332) {
                    point = result.method_17784();
                }
                float distance = (float)point.method_1022(player.method_33571());
                ArcballCamera.lock(point, distance);
            }
        }
    }

    private static void updateDepthDistance(class_276 renderTarget, Matrix4f projection, class_241 fraction) {
        RayCaster.RaycastResult result;
        class_1297 cameraEntity;
        if (fraction != null && fraction.field_1343 >= 0.0f && fraction.field_1343 <= 1.0f && fraction.field_1342 >= 0.0f && fraction.field_1342 <= 1.0f) {
            float fractionX = fraction.field_1343;
            float fractionY = 1.0f - fraction.field_1342;
            float[] pixel = new float[1];
            int x = Math.round((float)(renderTarget.field_1482 - 1) * fractionX);
            int y = Math.round((float)(renderTarget.field_1481 - 1) * fractionY);
            FramebufferUtils.bindDepth(renderTarget);
            GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6402, (int)5126, (float[])pixel);
            renderTarget.method_1235(true);
            Matrix4f matrix = new Matrix4f((Matrix4fc)projection);
            matrix.invert();
            Vector4f forwards = new Vector4f(fraction.field_1343 * 2.0f - 1.0f, fraction.field_1342 * 2.0f - 1.0f, pixel[0] * 2.0f - 1.0f, 1.0f);
            forwards.mul((Matrix4fc)matrix);
            float a = forwards.x / forwards.w;
            float b = forwards.y / forwards.w;
            float c = forwards.z / forwards.w;
            distance = (float)Math.sqrt(a * a + b * b + c * c);
            hasDistance = true;
            float depthFar = class_310.method_1551().field_1773.method_32796();
            if (distance > depthFar / 2.0f) {
                distance = Math.min(distance, class_310.method_1551().field_1773.method_3193());
            }
        }
        if ((cameraEntity = class_310.method_1551().method_1560()) != null && (result = Tool.raycastBlock()) != null) {
            double raycastDistance = result.getLocation().method_1022(cameraEntity.method_33571());
            if (hasDistance) {
                distance = Math.min((float)raycastDistance, distance);
            } else {
                hasDistance = true;
                distance = (float)raycastDistance;
            }
        }
    }
}

