/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.TagListWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_2487;
import net.minecraft.class_310;

public class BlueprintCreateWindow {
    private static BlueprintPreview blueprintPreview = null;
    private static final ImString blueprintName = new ImString();
    private static final ImString authorName = new ImString();
    private static boolean showingWindow = false;
    private static final TagListWidget tagListWidget = new TagListWidget();
    private static ChunkedBlockRegion blockRegion = null;
    private static Long2ObjectMap<CompressedBlockEntity> blockEntities = null;
    private static List<class_2487> entities = null;
    private static boolean containsAir = false;
    private static boolean isRotating = false;
    private static float lastMouseX = 0.0f;
    private static float lastMouseY = 0.0f;
    private static boolean focusFirst = false;
    private static boolean focusLast = false;
    private static CompletableFuture<String> saveFileCompletableFuture = null;
    private static CompletableFuture<class_1011> blueprintPreviewFuture = null;

    public static void render() {
        String createBlueprint = AxiomI18n.get("axiom.editorui.window.create_blueprint");
        if (!showingWindow) {
            if (ImGui.isPopupOpen(createBlueprint + "###CreateBlueprint")) {
                BlueprintCreateWindow.close();
            }
            return;
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
        if (!ImGui.isPopupOpen(createBlueprint + "###CreateBlueprint")) {
            ImGui.openPopup("###CreateBlueprint");
        }
        if (ImGuiHelper.beginPopupModalCloseable(createBlueprint + "###CreateBlueprint", 68)) {
            if (EditorUI.consumeNavClose()) {
                BlueprintCreateWindow.close();
                ImGui.closeCurrentPopup();
                ImGui.endPopup();
                return;
            }
            if (saveFileCompletableFuture != null && saveFileCompletableFuture.isDone()) {
                class_1011 nativeImage = BlueprintCreateWindow.tryGetImage();
                if (nativeImage != null) {
                    String filePath = saveFileCompletableFuture.join();
                    saveFileCompletableFuture = null;
                    if (filePath != null) {
                        BlueprintCreateWindow.save(filePath, nativeImage);
                        BlueprintCreateWindow.close();
                        ImGui.closeCurrentPopup();
                        ImGui.endPopup();
                        return;
                    }
                }
                ImGui.endPopup();
                return;
            }
            if (blueprintPreview == null) {
                blueprintPreview = new BlueprintPreview();
            }
            if (blockRegion.count() < 0x1000000) {
                ImGui.image(blueprintPreview.render(512, true, true), 256.0f, 256.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                if (isRotating) {
                    if (!ImGui.isMouseDown(0)) {
                        isRotating = false;
                        blueprintPreview.mouseReleased();
                    } else {
                        float mouseX = ImGui.getMousePosX();
                        float mouseY = ImGui.getMousePosY();
                        blueprintPreview.mouseMoved(mouseX - lastMouseX, mouseY - lastMouseY, EditorUI.isCtrlOrCmdDown());
                        lastMouseX = mouseX;
                        lastMouseY = mouseY;
                    }
                } else if (ImGui.isItemClicked(0)) {
                    isRotating = true;
                    lastMouseX = ImGui.getMousePosX();
                    lastMouseY = ImGui.getMousePosY();
                }
            }
            boolean handledFocusNext = false;
            if (focusFirst) {
                focusFirst = false;
                handledFocusNext = true;
                ImGui.setKeyboardFocusHere();
            }
            String username = class_310.method_1551().field_1724.method_5820();
            ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.name"), blueprintName);
            if (!handledFocusNext && ImGui.isItemActive() && ImGui.isKeyPressed(258, false)) {
                handledFocusNext = true;
                ImGui.setKeyboardFocusHere();
            }
            ImGui.inputTextWithHint(AxiomI18n.get("axiom.editorui.window.create_blueprint.author"), username, authorName);
            if (!handledFocusNext && ImGui.isItemActive() && ImGui.isKeyPressed(258, false)) {
                handledFocusNext = true;
                ImGui.setKeyboardFocusHere(1);
            }
            tagListWidget.render(256);
            float[] angleArray = new float[]{blueprintPreview.getYaw(), blueprintPreview.getPitch()};
            if (focusLast) {
                focusLast = false;
                handledFocusNext = true;
                ImGui.setKeyboardFocusHere(1);
            }
            if (ImGui.inputFloat2(AxiomI18n.get("axiom.editorui.window.create_blueprint.angle"), angleArray, "%.2f")) {
                blueprintPreview.setYaw(angleArray[0], false);
                blueprintPreview.setPitch(angleArray[1], false);
            }
            if (!handledFocusNext && ImGui.isItemActive() && ImGui.isKeyPressed(258, false)) {
                handledFocusNext = true;
                focusLast = true;
            }
            if (!handledFocusNext && ImGui.isKeyPressed(258, false)) {
                focusFirst = true;
            }
            boolean save = ImGui.button(AxiomI18n.get("axiom.editorui.window.create_blueprint.save"));
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
                BlueprintCreateWindow.close();
                ImGui.closeCurrentPopup();
                ImGui.endPopup();
                return;
            }
            if (save || ImGui.isKeyPressed(257, false)) {
                Path blueprintDir = Axiom.getInstance().getBlueprintDirectory();
                String separator = blueprintDir.getFileSystem().getSeparator();
                String blueprintNameString = ImGuiHelper.getString(blueprintName).trim();
                Object snakeName = blueprintNameString.isEmpty() ? "unnamed.bp" : blueprintNameString.toLowerCase(Locale.ROOT).replace(' ', '_').replace(separator, "_") + ".bp";
                snakeName = StringUtils.sanitizePath((String)snakeName);
                try {
                    saveFileCompletableFuture = AsyncFileDialogs.saveFileDialog(blueprintDir.toString(), (String)snakeName, "Blueprint Files", "bp");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ImGuiHelper.endPopupModalCloseable();
        }
        if (!ImGui.isPopupOpen(createBlueprint + "###CreateBlueprint")) {
            BlueprintCreateWindow.close();
        }
    }

    private static class_1011 tryGetImage() {
        if (blueprintPreview == null) {
            blueprintPreview = new BlueprintPreview();
        }
        if (blueprintPreviewFuture != null) {
            if (blueprintPreviewFuture.isDone()) {
                class_1011 nativeImage = blueprintPreviewFuture.join();
                blueprintPreviewFuture = null;
                return nativeImage;
            }
            return null;
        }
        if (blockRegion.count() >= 0x1000000) {
            return new class_1011(96, 96, true);
        }
        blueprintPreview.render(960, false, false);
        blueprintPreviewFuture = blueprintPreview.toNativeImage(96, true);
        return null;
    }

    private static void save(String filePathName, class_1011 nativeImage) {
        if (blueprintPreview == null) {
            blueprintPreview = new BlueprintPreview();
        }
        filePathName = filePathName.replace(".bp.bp", ".bp");
        Path path = Path.of(filePathName, new String[0]);
        String authorNameStr = ImGuiHelper.getString(authorName).trim();
        if (authorNameStr.isEmpty()) {
            authorNameStr = class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_5820();
        }
        BlueprintHeader header = new BlueprintHeader(ImGuiHelper.getString(blueprintName).trim(), authorNameStr, tagListWidget.tags(), blueprintPreview.getYaw(), blueprintPreview.getPitch(), false, blockRegion.count(), containsAir);
        BlueprintBrowserWindow.updatedBlueprintPaths.add(path);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BlueprintIo.write(outputStream, header, nativeImage, blockRegion, blockEntities, entities);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        nativeImage.close();
    }

    public static void open(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, List<class_2487> entities, boolean containsAir) {
        EditorWindowType.KEYBINDS.setOpen(false);
        if (blueprintPreview == null) {
            blueprintPreview = new BlueprintPreview();
        }
        showingWindow = true;
        blueprintPreview.setBlockRegion(blockRegion);
        BlueprintCreateWindow.blockRegion = blockRegion;
        BlueprintCreateWindow.blockEntities = blockEntities;
        BlueprintCreateWindow.entities = entities;
        BlueprintCreateWindow.containsAir = containsAir;
        saveFileCompletableFuture = null;
    }

    private static void close() {
        saveFileCompletableFuture = null;
        if (blueprintPreviewFuture != null) {
            blueprintPreviewFuture.thenAccept(class_1011::close);
            blueprintPreviewFuture = null;
        }
        showingWindow = false;
        blockRegion = null;
        blockEntities = null;
        entities = null;
        if (blueprintPreview != null) {
            blueprintPreview.clear();
        }
        blueprintName.clear();
    }
}

