/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.schematic;

import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.block_maps.LegacyBlocks;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2843;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SchematicLoader {
    public static Path getDefaultSchematicDir() {
        Path worldeditSchematicsDir = FabricLoader.getInstance().getConfigDir().resolve("worldedit").resolve("schematics");
        if (Files.exists(worldeditSchematicsDir, new LinkOption[0])) {
            return worldeditSchematicsDir;
        }
        return FabricLoader.getInstance().getGameDir();
    }

    public static ClipboardObject loadSponge(class_2487 compoundTag) throws SchematicLoadException {
        int currentDataVersion = DFUHelper.DATA_VERSION;
        SpongeSchematic schem = SpongeSchematic.parse(compoundTag);
        class_2487 palette = schem.palette;
        Int2ObjectOpenHashMap paletteMap = new Int2ObjectOpenHashMap();
        for (String key : palette.method_10541()) {
            try {
                class_2680 blockState;
                if (currentDataVersion <= schem.dataVersion) {
                    class_2259.class_7211 result = class_2259.method_41957(VersionUtils.createLookup(class_7923.field_41175), (String)key, (boolean)false);
                    blockState = result.comp_622();
                } else {
                    class_2487 blockTag = DFUHelper.createBlockTag(key);
                    blockState = DFUHelper.updateBlockState(blockTag, schem.dataVersion).result().orElse(class_2246.field_10124.method_9564());
                }
                paletteMap.put(VersionUtilsNbt.helperCompoundTagGetIntOr(palette, key, -1), (Object)blockState);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SchematicLoadException("Unable to parse BlockState: " + key);
            }
        }
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])schem.blockData));
        for (int y = 0; y < schem.height; ++y) {
            for (int z = 0; z < schem.length; ++z) {
                for (int x = 0; x < schem.width; ++x) {
                    int blockId = buf.method_10816();
                    class_2680 blockState = (class_2680)paletteMap.get(blockId);
                    if (blockState == null) {
                        blockState = class_2246.field_10124.method_9564();
                    }
                    blockRegion.addBlockWithoutDirty(x - schem.width / 2, y - schem.height / 2, z - schem.length / 2, blockState);
                }
            }
        }
        blockRegion.dirtyAll();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        if (schem.blockEntities != null && !schem.blockEntities.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (class_2520 blockEntityTag : schem.blockEntities) {
                String key;
                Optional<String> idOptional;
                class_2487 blockEntity = (class_2487)blockEntityTag;
                Optional<int[]> posOptional = VersionUtilsNbt.helperCompoundTagGetIntArray(blockEntity, "Pos");
                if (posOptional.isEmpty() || (idOptional = VersionUtilsNbt.helperCompoundTagGetString(blockEntity, "Id")).isEmpty()) continue;
                int[] pos = posOptional.get();
                String id = idOptional.get();
                int x = pos[0] - schem.width / 2;
                int y = pos[1] - schem.height / 2;
                int z = pos[2] - schem.length / 2;
                class_2591 type2 = class_7923.field_41181.method_17966(class_2960.method_60654((String)id)).orElse(null);
                if (type2 == null || !type2.method_20526(blockRegion.getBlockStateOrAir(x, y, z))) continue;
                blockEntity.method_10551("Pos");
                blockEntity.method_10551("Id");
                if (blockEntity.method_10541().size() == 1 && (key = (String)blockEntity.method_10541().iterator().next()).equals("Data")) {
                    blockEntity = blockEntity.method_10562("Data");
                }
                CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(blockEntity, baos);
                blockEntityMap.put(class_2338.method_10064((int)x, (int)y, (int)z), (Object)compressedBlockEntity);
            }
        }
        return new ClipboardObject.Anonymous(blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, List.of(), schem.name, 45.0f, true, compoundTag);
    }

    public static ClipboardObject loadLitematic(class_2487 compoundTag) throws SchematicLoadException {
        int litematicDataVersion = VersionUtilsNbt.helperCompoundTagGetIntOr(compoundTag, "MinecraftDataVersion", 0);
        String name = "";
        Optional<class_2487> metadataOptional = VersionUtilsNbt.helperCompoundTagGetCompound(compoundTag, "Metadata");
        if (metadataOptional.isPresent()) {
            class_2487 metadata = metadataOptional.get();
            name = VersionUtilsNbt.helperCompoundTagGetString(metadata, "Name").orElse("");
        }
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        class_2487 regions = compoundTag.method_10562("Regions");
        for (String regionName : regions.method_10541()) {
            class_2487 region = regions.method_10562(regionName);
            SchematicLoader.loadLitematicRegion(region, blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, litematicDataVersion);
        }
        blockRegion.dirtyAll();
        return new ClipboardObject.Anonymous(blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, List.of(), name, 45.0f, true, null);
    }

    private static void loadLitematicRegion(class_2487 region, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntityMap, int schemDataVersion) {
        int currentDataVersion = DFUHelper.DATA_VERSION;
        Int2ObjectOpenHashMap paletteMap = new Int2ObjectOpenHashMap();
        class_2499 palette = NbtHelper.getList(region, "BlockStatePalette", 10);
        for (int i = 0; i < palette.size(); ++i) {
            class_2487 entryTag = palette.method_10602(i);
            class_2680 blockState = currentDataVersion <= schemDataVersion ? class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)entryTag).result().orElse(class_2246.field_10124.method_9564()) : DFUHelper.updateBlockState(entryTag, schemDataVersion).result().orElse(class_2246.field_10124.method_9564());
            paletteMap.put(i, (Object)blockState);
        }
        class_2487 size = region.method_10562("Size");
        int width = VersionUtilsNbt.helperCompoundTagGetIntOr(size, "x", 0);
        int height = VersionUtilsNbt.helperCompoundTagGetIntOr(size, "y", 0);
        int length = VersionUtilsNbt.helperCompoundTagGetIntOr(size, "z", 0);
        class_2487 position = region.method_10562("Position");
        int offsetX = VersionUtilsNbt.helperCompoundTagGetIntOr(position, "x", 0);
        int offsetY = VersionUtilsNbt.helperCompoundTagGetIntOr(position, "y", 0);
        int offsetZ = VersionUtilsNbt.helperCompoundTagGetIntOr(position, "z", 0);
        if (width < 0) {
            offsetX += width + 1;
            width = -width;
        }
        if (height < 0) {
            offsetY += height + 1;
            height = -height;
        }
        if (length < 0) {
            offsetZ += length + 1;
            length = -length;
        }
        int bitsPerEntry = Math.max(2, 32 - Integer.numberOfLeadingZeros(palette.size() - 1));
        int entryMask = (1 << bitsPerEntry) - 1;
        long[] blockStateData = VersionUtilsNbt.helperCompoundTagGetLongArray(region, "BlockStates").orElse(new long[0]);
        int currentLongIndex = 0;
        int currentLongBitPosition = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    long value = blockStateData[currentLongIndex] >>> currentLongBitPosition & (long)entryMask;
                    int overflowBits = currentLongBitPosition + bitsPerEntry - 64;
                    if (overflowBits > 0) {
                        value |= (blockStateData[currentLongIndex + 1] & (1L << overflowBits) - 1L) << bitsPerEntry - overflowBits;
                    }
                    if ((currentLongBitPosition += bitsPerEntry) >= 64) {
                        ++currentLongIndex;
                        currentLongBitPosition -= 64;
                    }
                    class_2680 blockState = (class_2680)paletteMap.get((int)value);
                    blockRegion.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, blockState);
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        block4: for (class_2520 blockEntityTag : NbtHelper.getList(region, "TileEntities", 10)) {
            class_2487 blockEntity = (class_2487)blockEntityTag;
            int x = VersionUtilsNbt.helperCompoundTagGetIntOr(blockEntity, "x", 0);
            int y = VersionUtilsNbt.helperCompoundTagGetIntOr(blockEntity, "y", 0);
            int z = VersionUtilsNbt.helperCompoundTagGetIntOr(blockEntity, "z", 0);
            blockEntity.method_10551("x");
            blockEntity.method_10551("y");
            blockEntity.method_10551("z");
            if (blockEntity.method_33133()) continue;
            class_2680 blockState = blockRegion.getBlockStateOrAir(x + offsetX, y + offsetY, z + offsetZ);
            for (class_2591 blockEntityType : class_7923.field_41181) {
                if (!blockEntityType.method_20526(blockState)) continue;
                CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(blockEntity, baos);
                blockEntityMap.put(class_2338.method_10064((int)(x + offsetX), (int)(y + offsetY), (int)(z + offsetZ)), (Object)compressedBlockEntity);
                continue block4;
            }
        }
    }

    public static ClipboardObject loadLegacy(class_2487 compoundTag) throws SchematicLoadException {
        Optional<byte[]> blocksOptional = VersionUtilsNbt.helperCompoundTagGetByteArray(compoundTag, "Blocks");
        if (blocksOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Blocks' byte array tag");
        }
        Optional<byte[]> dataOptional = VersionUtilsNbt.helperCompoundTagGetByteArray(compoundTag, "Data");
        if (dataOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Data' byte array tag");
        }
        Optional<Short> widthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Width");
        if (widthOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Width' short tag");
        }
        Optional<Short> heightOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Height");
        if (heightOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Height' short tag");
        }
        Optional<Short> lengthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Length");
        if (lengthOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Length' short tag");
        }
        short width = widthOptional.get();
        short height = heightOptional.get();
        short length = lengthOptional.get();
        int maxIndex = width * height * length;
        int minX = -Math.floorDiv(width, 2);
        int minY = -Math.floorDiv(height, 2);
        int minZ = -Math.floorDiv(length, 2);
        byte[] legacyBlockIds = blocksOptional.get();
        byte[] legacyBlockData = dataOptional.get();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        class_2680[] legacyBlocks = LegacyBlocks.getLegacyBlocks();
        for (int index = 0; index < maxIndex; ++index) {
            int blockId = legacyBlockIds[index] & 0xFF;
            int blockData = legacyBlockData[index] & 0xFF;
            class_2680 blockState = legacyBlocks[blockId * 16 + blockData];
            if (blockState == null && (blockState = legacyBlocks[blockId * 16]) == null) continue;
            int x2 = index % width + minX;
            int z2 = index % (width * length) / width + minZ;
            int y2 = index / (width * length) + minY;
            chunkedBlockRegion.addBlockWithoutDirty(x2, y2, z2, blockState);
        }
        class_2350[] directions = class_2350.values();
        class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        ChunkedBlockRegion updatedRegion = new ChunkedBlockRegion();
        chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
            if (block.method_26204() instanceof class_2320) {
                class_2680 below;
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609 && (below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z)).method_26204() instanceof class_2320) {
                    block = (class_2680)below.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                }
            } else if (block.method_26204() instanceof class_2323) {
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609) {
                    class_2680 below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z);
                    if (below.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)below.method_11654((class_2769)class_2741.field_12481)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12537, (Comparable)((Boolean)below.method_11654((class_2769)class_2741.field_12537)));
                    }
                } else {
                    class_2680 above = chunkedBlockRegion.getBlockStateOrAir(x, y + 1, z);
                    if (above.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12520, (Comparable)((class_2750)above.method_11654((class_2769)class_2741.field_12520)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12484, (Comparable)((Boolean)above.method_11654((class_2769)class_2741.field_12484)));
                    }
                }
            }
            updatedRegion.addBlock(x, y, z, (class_2680)block);
        });
        updatedRegion.forEachEntry((x, y, z, block) -> {
            try {
                for (class_2350 direction : directions) {
                    mutableBlockPos1.method_10103(x, y, z);
                    mutableBlockPos2.method_25505((class_2382)mutableBlockPos1, direction);
                    block = class_2843.method_12351((class_2680)block, (class_2350)direction, (class_1936)updatedRegion, (class_2338)mutableBlockPos1, (class_2338)mutableBlockPos2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            chunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
        });
        chunkedBlockRegion.dirtyAll();
        return new ClipboardObject.Anonymous(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), List.of(), "", 45.0f, true, compoundTag);
    }

    record SpongeSchematic(int dataVersion, int width, int height, int length, String name, class_2487 palette, byte[] blockData, class_2499 blockEntities, class_2487 remainingTag) {
        public static SpongeSchematic parse(class_2487 compoundTag) {
            Optional<Integer> versionOptional = VersionUtilsNbt.helperCompoundTagGetInt(compoundTag, "Version");
            if (versionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Version' int tag");
            }
            int version = versionOptional.get();
            if (version == 2) {
                return SpongeSchematic.parseV2(compoundTag);
            }
            if (version == 3) {
                return SpongeSchematic.parseV3(compoundTag);
            }
            throw new SchematicLoadException("Unsupported version, expected 2 or 3, but got " + version);
        }

        public static SpongeSchematic parseV2(class_2487 compoundTag) {
            Optional<Integer> dataVersionOptional = VersionUtilsNbt.helperCompoundTagGetInt(compoundTag, "DataVersion");
            if (dataVersionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'DataVersion' int tag");
            }
            Optional<Short> widthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Width");
            if (widthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Width' short tag");
            }
            Optional<Short> heightOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Height");
            if (heightOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Height' short tag");
            }
            Optional<Short> lengthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Length");
            if (lengthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Length' short tag");
            }
            Optional<class_2487> paletteOptional = VersionUtilsNbt.helperCompoundTagGetCompound(compoundTag, "Palette");
            if (paletteOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Palette' compound tag");
            }
            Optional<byte[]> blockDataOptional = VersionUtilsNbt.helperCompoundTagGetByteArray(compoundTag, "BlockData");
            if (blockDataOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'BlockData' byte array tag");
            }
            int schematicDataVersion = dataVersionOptional.get();
            class_2487 palette = paletteOptional.get();
            byte[] blockData = blockDataOptional.get();
            String name = "";
            Optional<class_2487> metadataOptional = VersionUtilsNbt.helperCompoundTagGetCompound(compoundTag, "Metadata");
            if (metadataOptional.isPresent()) {
                class_2487 metadata = metadataOptional.get();
                name = VersionUtilsNbt.helperCompoundTagGetString(metadata, "Name").orElse("");
            }
            int width = widthOptional.get() & 0xFFFF;
            int height = heightOptional.get() & 0xFFFF;
            int length = lengthOptional.get() & 0xFFFF;
            class_2499 blockEntities = NbtHelper.getList(compoundTag, "BlockEntities", 10);
            class_2487 remaining = compoundTag.method_10553();
            compoundTag.method_10551("Version");
            compoundTag.method_10551("DataVersion");
            compoundTag.method_10551("Palette");
            compoundTag.method_10551("PaletteMax");
            compoundTag.method_10551("BlockData");
            compoundTag.method_10551("Width");
            compoundTag.method_10551("Height");
            compoundTag.method_10551("Length");
            compoundTag.method_10551("BlockEntities");
            return new SpongeSchematic(schematicDataVersion, width, height, length, name, palette, blockData, blockEntities, remaining);
        }

        public static SpongeSchematic parseV3(class_2487 compoundTag) {
            Optional<Integer> dataVersionOptional = VersionUtilsNbt.helperCompoundTagGetInt(compoundTag, "DataVersion");
            if (dataVersionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'DataVersion' int tag");
            }
            Optional<Short> widthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Width");
            if (widthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Width' short tag");
            }
            Optional<Short> heightOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Height");
            if (heightOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Height' short tag");
            }
            Optional<Short> lengthOptional = VersionUtilsNbt.helperCompoundTagGetShort(compoundTag, "Length");
            if (lengthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Length' short tag");
            }
            Optional<class_2487> blocksOptional = VersionUtilsNbt.helperCompoundTagGetCompound(compoundTag, "Blocks");
            if (blocksOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Blocks' compound tag");
            }
            class_2487 blocks = blocksOptional.get();
            Optional<class_2487> paletteOptional = VersionUtilsNbt.helperCompoundTagGetCompound(blocks, "Palette");
            if (paletteOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Palette' compound tag inside 'Blocks'");
            }
            Optional<byte[]> dataOptional = VersionUtilsNbt.helperCompoundTagGetByteArray(blocks, "Data");
            if (dataOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Data' byte array tag inside 'Blocks'");
            }
            int schematicDataVersion = dataVersionOptional.get();
            class_2487 palette = paletteOptional.get();
            byte[] blockData = dataOptional.get();
            String name = "";
            Optional<class_2487> metadataOptional = VersionUtilsNbt.helperCompoundTagGetCompound(compoundTag, "Metadata");
            if (metadataOptional.isPresent()) {
                class_2487 metadata = metadataOptional.get();
                name = VersionUtilsNbt.helperCompoundTagGetString(metadata, "Name").orElse("");
            }
            int width = widthOptional.get() & 0xFFFF;
            int height = heightOptional.get() & 0xFFFF;
            int length = lengthOptional.get() & 0xFFFF;
            class_2499 blockEntities = NbtHelper.getList(compoundTag, "BlockEntities", 10);
            class_2487 remaining = compoundTag.method_10553();
            compoundTag.method_10551("Version");
            compoundTag.method_10551("DataVersion");
            compoundTag.method_10551("BlockData");
            compoundTag.method_10551("Width");
            compoundTag.method_10551("Height");
            compoundTag.method_10551("Length");
            compoundTag.method_10551("Blocks");
            return new SpongeSchematic(schematicDataVersion, width, height, length, name, palette, blockData, blockEntities, remaining);
        }
    }

    public static class SchematicLoadException
    extends RuntimeException {
        public SchematicLoadException(String message) {
            super(message);
        }
    }
}

