/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.AsyncChunkProvider;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2841;

public class LevelPredicateSet {
    private final Long2ObjectMap<short[]> map = new Long2ObjectOpenHashMap();
    private final AsyncChunkProvider asyncChunkProvider;
    private final Predicate<class_2680> predicate;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private short[] lastChunk = null;

    public LevelPredicateSet(AsyncChunkProvider asyncChunkProvider, Predicate<class_2680> predicate) {
        this.asyncChunkProvider = asyncChunkProvider;
        this.predicate = predicate;
    }

    private short[] computeForSection(long k) {
        int sectionZ;
        int sectionY;
        short[] array = new short[256];
        int sectionX = class_2338.method_10061((long)k);
        class_2841<class_2680> blocks = this.asyncChunkProvider.getSection(sectionX, sectionY = class_2338.method_10071((long)k), sectionZ = class_2338.method_10083((long)k));
        if (blocks == null) {
            return array;
        }
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short v = 0;
                for (int x = 0; x < 16; ++x) {
                    if (!this.predicate.test((class_2680)blocks.method_12321(x, y, z))) continue;
                    v = (short)(v | 1 << x);
                }
                array[index++] = v;
            }
        }
        return array;
    }

    public void reset() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public boolean contains(int x, int y, int z) {
        int bit;
        int offset;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getOrCreateChunk(xC, yC, zC);
        return (array[offset = (y & 0xF) + (z & 0xF) * 16] & (bit = 1 << (x & 0xF))) != 0;
    }

    public short[] getOrCreateChunk(int cx, int cy, int cz) {
        long pos = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            short[] chunk = (short[])this.map.computeIfAbsent(pos, this::computeForSection);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }
}

