/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.jetbrains.annotations.Nullable;

public class AsyncChunkProvider {
    private static final class_2680 DEFAULT_STATE = class_2246.field_10243.method_9564();
    private final Long2ObjectMap<class_2841<class_2680>> containerMap = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<class_7522<class_6880<class_1959>>> biomeContainerMap = new Long2ObjectOpenHashMap();
    private final class_1937 level;
    private final int minSectionY;
    private final int maxSectionY;
    private final int maxWorldY;

    public AsyncChunkProvider(class_1937 level) {
        this.level = level;
        this.minSectionY = level.method_32891();
        this.maxSectionY = level.method_31597() - 1;
        this.maxWorldY = level.method_31600() - 1;
    }

    public int getMaxY() {
        return this.maxWorldY;
    }

    public class_2680 getBlockState(class_2338 blockPos) {
        return this.get(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Nullable
    public class_2841<class_2680> getSection(int sectionX, int sectionY, int sectionZ) {
        if (sectionY < this.minSectionY || sectionY > this.maxSectionY) {
            return null;
        }
        long pos = class_2338.method_10064((int)sectionX, (int)sectionY, (int)sectionZ);
        return (class_2841)this.containerMap.computeIfAbsent(pos, k -> {
            class_2818 chunk = (class_2818)this.level.method_8402(sectionX, sectionZ, class_2806.field_12803, false);
            if (chunk == null) {
                return null;
            }
            class_2826 levelChunkSection = chunk.method_38259(chunk.method_31603(sectionY));
            class_2841 container = levelChunkSection.method_12265();
            container.method_12334();
            class_2841 copied = container.method_39957();
            container.method_12335();
            return copied;
        });
    }

    public class_2680 get(int x, int y, int z) {
        int sectionY = y >> 4;
        if (sectionY < this.minSectionY || sectionY > this.maxSectionY) {
            return DEFAULT_STATE;
        }
        class_2841<class_2680> section = this.getSection(x >> 4, sectionY, z >> 4);
        if (section == null) {
            return DEFAULT_STATE;
        }
        return (class_2680)section.method_12321(x & 0xF, y & 0xF, z & 0xF);
    }

    @Nullable
    public class_7522<class_6880<class_1959>> getBiomeSection(int sectionX, int sectionY, int sectionZ) {
        if (sectionY < this.minSectionY || sectionY > this.maxSectionY) {
            return null;
        }
        long pos = class_2338.method_10064((int)sectionX, (int)sectionY, (int)sectionZ);
        return (class_7522)this.biomeContainerMap.computeIfAbsent(pos, k -> {
            class_2818 chunk = (class_2818)this.level.method_8402(sectionX, sectionZ, class_2806.field_12803, false);
            if (chunk == null) {
                return null;
            }
            class_2826 levelChunkSection = chunk.method_38259(chunk.method_31603(sectionY));
            return levelChunkSection.method_38294();
        });
    }

    @Nullable
    public class_6880<class_1959> getBiome(int quartX, int quartY, int quartZ) {
        int sectionY = quartY >> 2;
        if (sectionY < this.minSectionY || sectionY > this.maxSectionY) {
            return null;
        }
        class_7522<class_6880<class_1959>> section = this.getBiomeSection(quartX >> 2, quartY >> 2, quartZ >> 2);
        if (section == null) {
            return null;
        }
        return (class_6880)section.method_12321(quartX & 3, quartY & 3, quartZ & 3);
    }
}

