/*
 * Decompiled with CFR 0.152.
 */
package com.harium.storage.kdtree;

import java.util.PriorityQueue;

class NearestNeighborList<T> {
    PriorityQueue<NeighborEntry<T>> m_Queue;
    int m_Capacity = 0;

    public NearestNeighborList(int capacity) {
        this.m_Capacity = capacity;
        this.m_Queue = new PriorityQueue(this.m_Capacity);
    }

    public double getMaxPriority() {
        NeighborEntry<T> p = this.m_Queue.peek();
        return p == null ? Double.POSITIVE_INFINITY : p.value;
    }

    public boolean insert(T object, double priority) {
        if (this.isCapacityReached()) {
            if (priority > this.getMaxPriority()) {
                return false;
            }
            this.m_Queue.add(new NeighborEntry<T>(object, priority));
            this.m_Queue.poll();
        } else {
            this.m_Queue.add(new NeighborEntry<T>(object, priority));
        }
        return true;
    }

    public boolean isCapacityReached() {
        return this.m_Queue.size() >= this.m_Capacity;
    }

    public T getHighest() {
        NeighborEntry<T> p = this.m_Queue.peek();
        return p == null ? null : (T)p.data;
    }

    public boolean isEmpty() {
        return this.m_Queue.size() == 0;
    }

    public int getSize() {
        return this.m_Queue.size();
    }

    public T removeHighest() {
        NeighborEntry<T> p = this.m_Queue.poll();
        return p == null ? null : (T)p.data;
    }

    static class NeighborEntry<T>
    implements Comparable<NeighborEntry<T>> {
        final T data;
        final double value;

        public NeighborEntry(T data, double value) {
            this.data = data;
            this.value = value;
        }

        @Override
        public int compareTo(NeighborEntry<T> t2) {
            return Double.compare(t2.value, this.value);
        }
    }
}

