r"""
Defines the interface between the kernel and the UI.

It contains:
* the UI dispatcher notification codes (ui_notification_t)
* convenience functions for UI services
* structures which hold information about the lines (disassembly, structures,
enums) generated by the kernel
* functions to interact with the user (dialog boxes)
* some string and conversion functions."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ida_kernwin
else:
    import _ida_kernwin

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

SWIG_PYTHON_LEGACY_BOOL = _ida_kernwin.SWIG_PYTHON_LEGACY_BOOL

import ida_idaapi


def _kludge_force_declare_dirspec_t(arg1: "dirspec_t const *") -> "void":
    r"""
    _kludge_force_declare_dirspec_t(arg1)

    Parameters
    ----------
    arg1: dirspec_t const *

    """
    return _ida_kernwin._kludge_force_declare_dirspec_t(arg1)

def _kludge_force_declare_dirtree_t(arg1: "dirtree_t const *") -> "void":
    r"""
    _kludge_force_declare_dirtree_t(arg1)

    Parameters
    ----------
    arg1: dirtree_t const *

    """
    return _ida_kernwin._kludge_force_declare_dirtree_t(arg1)
class chooser_row_info_vec_t(object):
    r"""
    Proxy of C++ qvector< chooser_row_info_t > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> chooser_row_info_vec_t
        __init__(self, x) -> chooser_row_info_vec_t

        @param x: qvector< chooser_row_info_t > const &
        """
        _ida_kernwin.chooser_row_info_vec_t_swiginit(self, _ida_kernwin.new_chooser_row_info_vec_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_chooser_row_info_vec_t

    def push_back(self, *args) -> "chooser_row_info_t &":
        r"""
        push_back(self, x)

        @param x: chooser_row_info_t const &

        push_back(self) -> chooser_row_info_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.chooser_row_info_vec_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.chooser_row_info_vec_t_empty(self)

    def at(self, _idx: "size_t") -> "chooser_row_info_t const &":
        r"""
        at(self, _idx) -> chooser_row_info_t

        @param _idx: size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.chooser_row_info_vec_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.chooser_row_info_vec_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: chooser_row_info_t const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_resize(self, *args)

    def grow(self, *args) -> "void":
        r"""
        grow(self, x=chooser_row_info_t())

        @param x: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_vec_t_grow(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.chooser_row_info_vec_t_truncate(self)

    def swap(self, r: "chooser_row_info_vec_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< chooser_row_info_t > &
        """
        return _ida_kernwin.chooser_row_info_vec_t_swap(self, r)

    def extract(self) -> "chooser_row_info_t *":
        r"""
        extract(self) -> chooser_row_info_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_extract(self)

    def inject(self, s: "chooser_row_info_t", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: chooser_row_info_t *
        @param len: size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_inject(self, s, len)

    def __eq__(self, r: "chooser_row_info_vec_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: qvector< chooser_row_info_t > const &
        """
        return _ida_kernwin.chooser_row_info_vec_t___eq__(self, r)

    def __ne__(self, r: "chooser_row_info_vec_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: qvector< chooser_row_info_t > const &
        """
        return _ida_kernwin.chooser_row_info_vec_t___ne__(self, r)

    def begin(self, *args) -> "qvector< chooser_row_info_t >::const_iterator":
        r"""
        begin(self) -> chooser_row_info_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_begin(self, *args)

    def end(self, *args) -> "qvector< chooser_row_info_t >::const_iterator":
        r"""
        end(self) -> chooser_row_info_t
        """
        return _ida_kernwin.chooser_row_info_vec_t_end(self, *args)

    def insert(self, it: "chooser_row_info_t", x: "chooser_row_info_t") -> "qvector< chooser_row_info_t >::iterator":
        r"""
        insert(self, it, x) -> chooser_row_info_t

        @param it: qvector< chooser_row_info_t >::iterator
        @param x: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_vec_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< chooser_row_info_t >::iterator":
        r"""
        erase(self, it) -> chooser_row_info_t

        @param it: qvector< chooser_row_info_t >::iterator

        erase(self, first, last) -> chooser_row_info_t

        @param first: qvector< chooser_row_info_t >::iterator
        @param last: qvector< chooser_row_info_t >::iterator
        """
        return _ida_kernwin.chooser_row_info_vec_t_erase(self, *args)

    def find(self, *args) -> "qvector< chooser_row_info_t >::const_iterator":
        r"""
        find(self, x) -> chooser_row_info_t

        @param x: chooser_row_info_t const &

        """
        return _ida_kernwin.chooser_row_info_vec_t_find(self, *args)

    def has(self, x: "chooser_row_info_t") -> "bool":
        r"""
        has(self, x) -> bool

        @param x: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_vec_t_has(self, x)

    def add_unique(self, x: "chooser_row_info_t") -> "bool":
        r"""
        add_unique(self, x) -> bool

        @param x: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_vec_t_add_unique(self, x)

    def _del(self, x: "chooser_row_info_t") -> "bool":
        r"""
        _del(self, x) -> bool

        Parameters
        ----------
        x: chooser_row_info_t const &

        """
        return _ida_kernwin.chooser_row_info_vec_t__del(self, x)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t___len__(self)

    def __getitem__(self, i: "size_t") -> "chooser_row_info_t const &":
        r"""
        __getitem__(self, i) -> chooser_row_info_t

        @param i: size_t
        """
        return _ida_kernwin.chooser_row_info_vec_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "chooser_row_info_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_vec_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register chooser_row_info_vec_t in _ida_kernwin:
_ida_kernwin.chooser_row_info_vec_t_swigregister(chooser_row_info_vec_t)

def refresh_choosers() -> "void":
    r"""
    refresh_choosers()
    """
    return _ida_kernwin.refresh_choosers()

def textctrl_info_t_create() -> "PyObject *":
    r"""
    textctrl_info_t_create() -> PyObject *
    """
    return _ida_kernwin.textctrl_info_t_create()

def textctrl_info_t_destroy(py_obj: "PyObject *") -> "bool":
    r"""
    textctrl_info_t_destroy(py_obj) -> bool

    @param py_obj: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_destroy(py_obj)

def textctrl_info_t_get_clink(_self: "PyObject *") -> "textctrl_info_t *":
    r"""
    textctrl_info_t_get_clink(_self) -> textctrl_info_t *

    @param self: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_get_clink(_self)

def textctrl_info_t_get_clink_ptr(_self: "PyObject *") -> "PyObject *":
    r"""
    textctrl_info_t_get_clink_ptr(_self) -> PyObject *

    @param self: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_get_clink_ptr(_self)

def register_timer(interval: "int", py_callback: "PyObject *") -> "PyObject *":
    r"""
    register_timer(interval, py_callback) -> PyCapsule
    Register a timer

    @param interval: Interval in milliseconds
    @param py_callback: A Python callable that takes no parameters and returns an integer.
                     The callback may return:
                     -1   : to unregister the timer
                     >= 0 : the new or same timer interval
    @return: None or a timer object
    """
    return _ida_kernwin.register_timer(interval, py_callback)

def unregister_timer(py_timerctx: "PyObject *") -> "bool":
    r"""
    unregister_timer(py_timerctx) -> bool
    Unregister a timer

    @param timer_obj: a timer object previously returned by a register_timer()
    @return: Boolean
    @note: After the timer has been deleted, the timer_obj will become invalid.
    """
    return _ida_kernwin.unregister_timer(py_timerctx)

def choose_idasgn() -> "PyObject *":
    r"""
    choose_idasgn() -> PyObject *
    Opens the signature chooser

    @return: None or the selected signature name
    """
    return _ida_kernwin.choose_idasgn()

def get_highlight(v: "TWidget *", in_flags: "uint32"=0) -> "PyObject *":
    r"""
    get_highlight(v, in_flags=0) -> PyObject
    Returns the currently highlighted identifier and flags

    @param v: The UI widget to operate on
    @param flags: Optionally specify a slot (see kernwin.hpp), current otherwise
    @return: a tuple (text, flags), or None if nothing
             is highlighted or in case of error.
    """
    return _ida_kernwin.get_highlight(v, in_flags)

def py_load_custom_icon_fn(filename: "char const *") -> "int":
    r"""
    py_load_custom_icon_fn(filename) -> int

    @param filename: char const *
    """
    return _ida_kernwin.py_load_custom_icon_fn(filename)

def py_load_custom_icon_data(data: "PyObject *", format: "char const *") -> "int":
    r"""
    py_load_custom_icon_data(data, format) -> int

    @param data: PyObject *
    @param format: char const *
    """
    return _ida_kernwin.py_load_custom_icon_data(data, format)

def msg(o: "PyObject *") -> "PyObject *":
    r"""
    msg(o) -> int
    Display an UTF-8 string in the message window

    The result of the stringification of the arguments
    will be treated as an UTF-8 string.

    @param message: message to print (formatting is done in Python)

    This function can be used to debug IDAPython scripts
    """
    return _ida_kernwin.msg(o)

def ask_text(max_size: "size_t", defval: "char const *", prompt: "char const *") -> "PyObject *":
    r"""
    ask_text(max_size, defval, prompt) -> str
    Asks for a long text

    @param max_size: Maximum text length, 0 for unlimited
    @param defval: The default value
    @param prompt: The prompt value
    @return: None or the entered string
    """
    return _ida_kernwin.ask_text(max_size, defval, prompt)

def ask_str(defval: "qstring *", hist: "int", prompt: "char const *") -> "PyObject *":
    r"""
    ask_str(defval, hist, prompt) -> str or None
    Asks for a long text

    @param defval: The default value
    @param hist: history id
    @param prompt: The prompt value
    @return: None or the entered string
    """
    return _ida_kernwin.ask_str(defval, hist, prompt)

def process_ui_action(name: "char const *", flags: "int"=0) -> "bool":
    r"""
    process_ui_action(name, flags=0) -> bool
    Invokes an IDA UI action by name

    @param name: action name
    @param flags: int
    @return: Boolean
    """
    return _ida_kernwin.process_ui_action(name, flags)

def del_hotkey(pyctx: "PyObject *") -> "bool":
    r"""
    del_hotkey(pyctx) -> bool
    Deletes a previously registered function hotkey

    @param ctx: Hotkey context previously returned by add_hotkey()

    @return: Boolean.
    """
    return _ida_kernwin.del_hotkey(pyctx)

def add_hotkey(hotkey: "char const *", pyfunc: "PyObject *") -> "PyObject *":
    r"""
    add_hotkey(hotkey, pyfunc) -> PyCapsule
    Associates a function call with a hotkey.
    Callable pyfunc will be called each time the hotkey is pressed

    @param hotkey: The hotkey
    @param pyfunc: Callable

    @return: Context object on success or None on failure.
    """
    return _ida_kernwin.add_hotkey(hotkey, pyfunc)

def take_database_snapshot(ss: "snapshot_t *") -> "PyObject *":
    r"""
    take_database_snapshot(ss) -> (bool, NoneType)
    Take a database snapshot (ui_take_database_snapshot).

    @param ss: (C++: snapshot_t *) in/out parameter.
    * in: description, flags
    * out: filename, id
    @return: success
    """
    return _ida_kernwin.take_database_snapshot(ss)

def restore_database_snapshot(ss: "snapshot_t const *", pyfunc_or_none: "PyObject *", pytuple_or_none: "PyObject *") -> "PyObject *":
    r"""
    restore_database_snapshot(ss, pyfunc_or_none, pytuple_or_none) -> bool
    Restore a database snapshot. Note: This call is asynchronous. When it is
    completed, the callback will be triggered.

    @param ss: (C++: const snapshot_t *) snapshot instance (see build_snapshot_tree())
    @param pyfunc_or_none: PyObject *
    @param pytuple_or_none: PyObject *
    @return: false if restoration could not be started (snapshot file was not
             found).
    If the returned value is True then check if the operation succeeded from the
    callback.
    """
    return _ida_kernwin.restore_database_snapshot(ss, pyfunc_or_none, pytuple_or_none)

def execute_sync(py_callable: "PyObject *", reqf: "int") -> "ssize_t":
    r"""
    execute_sync(py_callable, reqf) -> ssize_t
    Executes a function in the context of the main thread.
    If the current thread not the main thread, then the call is queued and
    executed afterwards.

    @param py_callable: A python callable object, must return an integer value
    @param reqf: one of MFF_ flags
    @return: -1 or the return value of the callable
    """
    return _ida_kernwin.execute_sync(py_callable, reqf)

def execute_ui_requests(py_list: "PyObject *") -> "bool":
    r"""
    execute_ui_requests(py_list) -> bool
    Inserts a list of callables into the UI message processing queue.
    When the UI is ready it will call one callable.
    A callable can request to be called more than once if it returns True.

    @param callable_list: A list of python callable objects.
    @note: A callable should return True if it wants to be called more than once.
    @return: Boolean. False if the list contains a non callable item
    """
    return _ida_kernwin.execute_ui_requests(py_list)
class jobj_wrapper_t(object):
    r"""
    Proxy of C++ jobj_wrapper_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def get_dict(self) -> "PyObject *":
        r"""
        get_dict(self) -> dict
        """
        return _ida_kernwin.jobj_wrapper_t_get_dict(self)

# Register jobj_wrapper_t in _ida_kernwin:
_ida_kernwin.jobj_wrapper_t_swigregister(jobj_wrapper_t)
class UI_Hooks(object):
    r"""
    Proxy of C++ UI_Hooks class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, _flags: "uint32"=0, _hkcb_flags: "uint32"=0x0001):
        r"""
        __init__(self, _flags=0, _hkcb_flags=0x0001) -> UI_Hooks

        @param _flags: uint32
        @param _hkcb_flags: uint32
        """
        if self.__class__ == UI_Hooks:
            _self = None
        else:
            _self = self
        _ida_kernwin.UI_Hooks_swiginit(self, _ida_kernwin.new_UI_Hooks(_self, _flags, _hkcb_flags))

    def hook(self) -> "bool":
        r"""
        hook(self) -> bool
        """
        return _ida_kernwin.UI_Hooks_hook(self)

    def unhook(self) -> "bool":
        r"""
        unhook(self) -> bool
        """
        return _ida_kernwin.UI_Hooks_unhook(self)

    def range(self) -> "void":
        r"""
        range(self)
        The disassembly range has been changed ( idainfo::min_ea ...
        idainfo::max_ea). UI should redraw the scrollbars. See also:
        ui_lock_range_refresh
        """
        return _ida_kernwin.UI_Hooks_range(self)

    def idcstart(self) -> "void":
        r"""
        idcstart(self)
        Start of IDC engine work.
        """
        return _ida_kernwin.UI_Hooks_idcstart(self)

    def idcstop(self) -> "void":
        r"""
        idcstop(self)
        Stop of IDC engine work.
        """
        return _ida_kernwin.UI_Hooks_idcstop(self)

    def suspend(self) -> "void":
        r"""
        suspend(self)
        Suspend graphical interface. Only the text version. Interface should respond
        to it.
        """
        return _ida_kernwin.UI_Hooks_suspend(self)

    def resume(self) -> "void":
        r"""
        resume(self)
        Resume the suspended graphical interface. Only the text version. Interface
        should respond to it
        """
        return _ida_kernwin.UI_Hooks_resume(self)

    def saving(self) -> "void":
        r"""
        saving(self)
        The kernel is flushing its buffers to the disk. The user interface should
        save its state. Parameters: none Returns: none
        """
        return _ida_kernwin.UI_Hooks_saving(self)

    def saved(self, path: "char const *") -> "void":
        r"""
        saved(self, path)
        The kernel has saved the database. This callback just informs the interface.
        Note that at the time this notification is sent, the internal paths are not
        updated yet, and calling get_path(PATH_TYPE_IDB) will return the previous path.

        @param path: (const char *) the database path
        """
        return _ida_kernwin.UI_Hooks_saved(self, path)

    def database_closed(self) -> "void":
        r"""
        database_closed(self)
        The database has been closed. See also processor_t::closebase, it occurs
        earlier. See also ui_initing_database. This is not the same as IDA exiting. If
        you need to perform cleanup at the exiting time, use qatexit().
        """
        return _ida_kernwin.UI_Hooks_database_closed(self)

    def debugger_menu_change(self, enable: "bool") -> "void":
        r"""
        debugger_menu_change(self, enable)
        debugger menu modification detected

        @param enable: (bool) true: debugger menu has been added, or a different
                       debugger has been selected false: debugger menu will be removed
                       (user switched to "No debugger")
        """
        return _ida_kernwin.UI_Hooks_debugger_menu_change(self, enable)

    def widget_visible(self, widget: "TWidget *") -> "void":
        r"""
        widget_visible(self, widget)
        TWidget is displayed on the screen. Use this event to populate the window with
        controls

        @param widget: (TWidget *)
        """
        return _ida_kernwin.UI_Hooks_widget_visible(self, widget)

    def widget_closing(self, widget: "TWidget *") -> "void":
        r"""
        widget_closing(self, widget)
        TWidget is about to close. This event precedes ui_widget_invisible. Use this to
        perform some possible actions relevant to the lifecycle of this widget

        @param widget: (TWidget *)
        """
        return _ida_kernwin.UI_Hooks_widget_closing(self, widget)

    def widget_invisible(self, widget: "TWidget *") -> "void":
        r"""
        widget_invisible(self, widget)
        TWidget is being closed. Use this event to destroy the window controls

        @param widget: (TWidget *)
        """
        return _ida_kernwin.UI_Hooks_widget_invisible(self, widget)

    def get_ea_hint(self, ea: "ea_t") -> "PyObject *":
        r"""
        get_ea_hint(self, ea) -> PyObject *
        ui wants to display a simple hint for an address. Use this event to generate
        a custom hint See also more generic ui_get_item_hint

        @param ea: (::ea_t)
        @return: true if generated a hint
        """
        return _ida_kernwin.UI_Hooks_get_ea_hint(self, ea)

    def get_item_hint(self, ea: "ea_t", max_lines: "int") -> "PyObject *":
        r"""
        get_item_hint(self, ea, max_lines) -> PyObject *
        ui wants to display multiline hint for an item. See also more generic
        ui_get_custom_viewer_hint

        @param ea: (ea_t) or item id like a structure or enum member
        @param max_lines: (int) maximal number of lines
        @return: true if generated a hint
        """
        return _ida_kernwin.UI_Hooks_get_item_hint(self, ea, max_lines)

    def get_custom_viewer_hint(self, viewer: "TWidget *", place: "place_t") -> "PyObject *":
        r"""
        get_custom_viewer_hint(self, viewer, place) -> PyObject *
        ui wants to display a hint for a viewer (idaview or custom). Every
        subscriber is supposed to append the hint lines to HINT and increment
        IMPORTANT_LINES accordingly. Completely overwriting the existing lines in HINT
        is possible but not recommended. If the REG_HINTS_MARKER sequence is found in
        the returned hints string, it will be replaced with the contents of the
        "regular" hints. If the SRCDBG_HINTS_MARKER sequence is found in the returned
        hints string, it will be replaced with the contents of the source-level
        debugger-generated hints. The following keywords might appear at the beginning
        of the returned hints: HIGHLIGHT text
        where text will be highlighted CAPTION caption
        caption for the hint widget

        @param viewer: (TWidget*) viewer
        @param place: (place_t *) current position in the viewer
        @retval 0: continue collecting hints with other subscribers
        @retval 1: stop collecting hints
        """
        return _ida_kernwin.UI_Hooks_get_custom_viewer_hint(self, viewer, place)

    def database_inited(self, is_new_database: "int", idc_script: "char const *") -> "void":
        r"""
        database_inited(self, is_new_database, idc_script)
        database initialization has completed. the kernel is about to run idc
        scripts

        @param is_new_database: (int)
        @param idc_script: (const char *) - may be nullptr
        @return: void See also ui_initing_database. This event is called for both new
                 and old databases.
        """
        return _ida_kernwin.UI_Hooks_database_inited(self, is_new_database, idc_script)

    def ready_to_run(self) -> "void":
        r"""
        ready_to_run(self)
        all UI elements have been initialized. Automatic plugins may hook to this
        event to perform their tasks.
        """
        return _ida_kernwin.UI_Hooks_ready_to_run(self)

    def preprocess_action(self, name: "char const *") -> "int":
        r"""
        preprocess_action(self, name) -> int
        ida ui is about to handle a user action.

        @param name: (const char *) ui action name. these names can be looked up in
                     ida[tg]ui.cfg
        @retval 0: ok
        @retval nonzero: a plugin has handled the command
        """
        return _ida_kernwin.UI_Hooks_preprocess_action(self, name)

    def postprocess_action(self) -> "void":
        r"""
        postprocess_action(self)
        an ida ui action has been handled
        """
        return _ida_kernwin.UI_Hooks_postprocess_action(self)

    def get_chooser_item_attrs(self, chooser: "chooser_base_t", n: "size_t", attrs: "chooser_item_attrs_t") -> "void":
        r"""
        get_chooser_item_attrs(self, chooser, n, attrs)
        get item-specific attributes for a chooser. This callback is generated only
        after enable_chooser_attrs()

        @param chooser: (const chooser_base_t *)
        @param n: (::size_t)
        @param attrs: (chooser_item_attrs_t *)
        """
        return _ida_kernwin.UI_Hooks_get_chooser_item_attrs(self, chooser, n, attrs)

    def updating_actions(self, ctx: "action_ctx_base_t") -> "void":
        r"""
        updating_actions(self, ctx)
        IDA is about to update all actions. If your plugin needs to perform
        expensive operations more than once (e.g., once per action it registers), you
        should do them only once, right away.

        @param ctx: (action_update_ctx_t *)
        """
        return _ida_kernwin.UI_Hooks_updating_actions(self, ctx)

    def updated_actions(self) -> "void":
        r"""
        updated_actions(self)
        IDA is done updating actions.
        """
        return _ida_kernwin.UI_Hooks_updated_actions(self)

    def populating_widget_popup(self, widget: "TWidget *", popup_handle: "TPopupMenu *", ctx: "action_ctx_base_t"=None) -> "void":
        r"""
        populating_widget_popup(self, widget, popup_handle, ctx=None)
        IDA is populating the context menu for a widget. This is your chance to
        attach_action_to_popup().

        Have a look at ui_finish_populating_widget_popup, if you want to augment the
        context menu with your own actions after the menu has had a chance to be
        properly populated by the owning component or plugin (which typically does it on
        ui_populating_widget_popup.)

        @param widget: (TWidget *)
        @param popup_handle: (TPopupMenu *)
        @param ctx: (const action_activation_ctx_t *)
        """
        return _ida_kernwin.UI_Hooks_populating_widget_popup(self, widget, popup_handle, ctx)

    def finish_populating_widget_popup(self, widget: "TWidget *", popup_handle: "TPopupMenu *", ctx: "action_ctx_base_t"=None) -> "void":
        r"""
        finish_populating_widget_popup(self, widget, popup_handle, ctx=None)
        IDA is about to be done populating the context menu for a widget. This is
        your chance to attach_action_to_popup().

        @param widget: (TWidget *)
        @param popup_handle: (TPopupMenu *)
        @param ctx: (const action_activation_ctx_t *)
        """
        return _ida_kernwin.UI_Hooks_finish_populating_widget_popup(self, widget, popup_handle, ctx)

    def plugin_loaded(self, plugin_info: "plugin_info_t const *") -> "void":
        r"""
        plugin_loaded(self, plugin_info)
        The plugin was loaded in memory.

        @param plugin_info: (const plugin_info_t *)
        """
        return _ida_kernwin.UI_Hooks_plugin_loaded(self, plugin_info)

    def plugin_unloading(self, plugin_info: "plugin_info_t const *") -> "void":
        r"""
        plugin_unloading(self, plugin_info)
        The plugin is about to be unloaded

        @param plugin_info: (const plugin_info_t *)
        """
        return _ida_kernwin.UI_Hooks_plugin_unloading(self, plugin_info)

    def current_widget_changed(self, widget: "TWidget *", prev_widget: "TWidget *") -> "void":
        r"""
        current_widget_changed(self, widget, prev_widget)
        The currently-active TWidget changed.

        @param widget: (TWidget *)
        @param prev_widget: (TWidget *)
        """
        return _ida_kernwin.UI_Hooks_current_widget_changed(self, widget, prev_widget)

    def screen_ea_changed(self, ea: "ea_t", prev_ea: "ea_t") -> "void":
        r"""
        screen_ea_changed(self, ea, prev_ea)
        The "current address" changed

        @param ea: (ea_t)
        @param prev_ea: (ea_t)
        """
        return _ida_kernwin.UI_Hooks_screen_ea_changed(self, ea, prev_ea)

    def create_desktop_widget(self, title: "char const *", cfg: "jobj_wrapper_t") -> "PyObject *":
        r"""
        create_desktop_widget(self, title, cfg) -> PyObject *
        create a widget, to be placed in the widget tree (at desktop-creation time.)

        @param title: (const char *)
        @param cfg: (const jobj_t *)
        @return: TWidget * the created widget, or null
        """
        return _ida_kernwin.UI_Hooks_create_desktop_widget(self, title, cfg)

    def get_lines_rendering_info(self, out: "lines_rendering_output_t", widget: "TWidget const *", info: "lines_rendering_input_t") -> "void":
        r"""
        get_lines_rendering_info(self, out, widget, info)
        get lines rendering information

        @param out: (lines_rendering_output_t *)
        @param widget: (const TWidget *)
        @param info: (const lines_rendering_input_t *)
        """
        return _ida_kernwin.UI_Hooks_get_lines_rendering_info(self, out, widget, info)

    def get_widget_config(self, widget: "TWidget const *", cfg: "jobj_t *") -> "PyObject *":
        r"""
        get_widget_config(self, widget, cfg) -> PyObject *
        retrieve the widget configuration (it will be passed back at
        ui_create_desktop_widget-, and ui_set_widget_config-time)

        @param widget: (const TWidget *)
        @param cfg: (jobj_t *)
        """
        return _ida_kernwin.UI_Hooks_get_widget_config(self, widget, cfg)

    def set_widget_config(self, widget: "TWidget const *", cfg: "jobj_wrapper_t") -> "void":
        r"""
        set_widget_config(self, widget, cfg)
        set the widget configuration

        @param widget: (const TWidget *)
        @param cfg: (const jobj_t *)
        """
        return _ida_kernwin.UI_Hooks_set_widget_config(self, widget, cfg)

    def initing_database(self) -> "void":
        r"""
        initing_database(self)
        database initialization has started.

        @return: void See also ui_database_inited. This event is called for both new and
                 old databases.
        """
        return _ida_kernwin.UI_Hooks_initing_database(self)

    def destroying_procmod(self, procmod: "procmod_t") -> "void":
        r"""
        destroying_procmod(self, procmod)
        The processor module is about to be destroyed

        @param procmod: (const procmod_t *)
        """
        return _ida_kernwin.UI_Hooks_destroying_procmod(self, procmod)

    def destroying_plugmod(self, plugmod: "plugmod_t", entry: "plugin_t const *") -> "void":
        r"""
        destroying_plugmod(self, plugmod, entry)
        The plugin object is about to be destroyed

        @param plugmod: (const plugmod_t *)
        @param entry: (const plugin_t *)
        """
        return _ida_kernwin.UI_Hooks_destroying_plugmod(self, plugmod, entry)

    def desktop_applied(self, name: "char const *", from_idb: "bool", type: "int") -> "void":
        r"""
        desktop_applied(self, name, from_idb, type)
        a desktop has been applied

        @param name: (const char *) the desktop name
        @param from_idb: (bool) the desktop was stored in the IDB (false if it comes
                         from the registry)
        @param type: (int) the desktop type (1-disassembly, 2-debugger, 3-merge)
        """
        return _ida_kernwin.UI_Hooks_desktop_applied(self, name, from_idb, type)
    __swig_destroy__ = _ida_kernwin.delete_UI_Hooks
    def __disown__(self):
        self.this.disown()
        _ida_kernwin.disown_UI_Hooks(self)
        return weakref.proxy(self)

# Register UI_Hooks in _ida_kernwin:
_ida_kernwin.UI_Hooks_swigregister(UI_Hooks)

def register_action(desc: "action_desc_t") -> "bool":
    r"""
    register_action(desc) -> bool
    Create a new action (ui_register_action). After an action has been created, it
    is possible to attach it to menu items (attach_action_to_menu()), or to popup
    menus (attach_action_to_popup()).

    Because the actions will need to call the handler's activate() and update()
    methods at any time, you shouldn't build your action handler on the stack.

    Please see the SDK's "ht_view" plugin for an example how to register actions.

    @param desc: (C++: const action_desc_t &) action to register
    @return: success
    """
    return _ida_kernwin.register_action(desc)

def get_registered_actions() -> "PyObject *":
    r"""
    get_registered_actions() -> [str, ...]
    Get a list of all currently-registered actions
    """
    return _ida_kernwin.get_registered_actions()

def attach_dynamic_action_to_popup(unused: "TWidget *", popup_handle: "TPopupMenu *", desc: "action_desc_t", popuppath: "char const *"=None, flags: "int"=0) -> "bool":
    r"""
    attach_dynamic_action_to_popup(unused, popup_handle, desc, popuppath=None, flags=0) -> bool
    Create & insert an action into the widget's popup menu
    (::ui_attach_dynamic_action_to_popup).
    Note: The action description in the 'desc' parameter is modified by
          this call so you should prepare a new description for each call.
    For example:
        desc = idaapi.action_desc_t(None, 'Dynamic popup action', Handler())
        idaapi.attach_dynamic_action_to_popup(form, popup, desc)

    @param unused: deprecated; should be None
    @param popup_handle: target popup
    @param desc: action description of type action_desc_t
    @param popuppath: can be None
    @param flags: a combination of SETMENU_ constants
    @return: success
    """
    return _ida_kernwin.attach_dynamic_action_to_popup(unused, popup_handle, desc, popuppath, flags)
class disasm_line_t(object):
    r"""
    Proxy of C++ disasm_line_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ida_kernwin.delete_disasm_line_t

    def __init__(self, *args):
        r"""
        __init__(self) -> disasm_line_t
        __init__(self, other) -> disasm_line_t

        @param other: disasm_line_t const &
        """
        _ida_kernwin.disasm_line_t_swiginit(self, _ida_kernwin.new_disasm_line_t(*args))
    at: "place_t *" = property(_ida_kernwin.disasm_line_t_at_get, _ida_kernwin.disasm_line_t_at_set, doc=r"""at""")
    line: "qstring" = property(_ida_kernwin.disasm_line_t_line_get, _ida_kernwin.disasm_line_t_line_set, doc=r"""line""")
    prefix_color: "color_t" = property(_ida_kernwin.disasm_line_t_prefix_color_get, _ida_kernwin.disasm_line_t_prefix_color_set, doc=r"""prefix_color""")
    bg_color: "bgcolor_t" = property(_ida_kernwin.disasm_line_t_bg_color_get, _ida_kernwin.disasm_line_t_bg_color_set, doc=r"""bg_color""")
    is_default: "bool" = property(_ida_kernwin.disasm_line_t_is_default_get, _ida_kernwin.disasm_line_t_is_default_set, doc=r"""is_default""")

# Register disasm_line_t in _ida_kernwin:
_ida_kernwin.disasm_line_t_swigregister(disasm_line_t)

def py_chooser_base_t_get_row(chobj: "chooser_base_t", n: "size_t") -> "PyObject *":
    r"""
    py_chooser_base_t_get_row(chobj, n) -> PyObject *

    @param chobj: chooser_base_t const *
    @param n: size_t
    """
    return _ida_kernwin.py_chooser_base_t_get_row(chobj, n)

def gen_disasm_text(text: "disasm_text_t", ea1: "ea_t", ea2: "ea_t", truncate_lines: "bool") -> "void":
    r"""
    gen_disasm_text(text, ea1, ea2, truncate_lines)
    Generate disassembly text for a range.

    @param text: (C++: text_t &) result
    @param ea1: (C++: ea_t) start address
    @param ea2: (C++: ea_t) end address
    @param truncate_lines: (C++: bool) (on idainfo::margin)
    """
    return _ida_kernwin.gen_disasm_text(text, ea1, ea2, truncate_lines)

def set_nav_colorizer(new_py_colorizer: "PyObject *") -> "PyObject *":
    r"""
    set_nav_colorizer(new_py_colorizer) -> dict or None
    Set a new colorizer for the navigation band.

    The 'callback' is a function of 2 arguments:
       - ea (the EA to colorize for)
       - nbytes (the number of bytes at that EA)
    and must return a 'long' value.

    The previous colorizer is returned, allowing
    the new 'callback' to use 'call_nav_colorizer'
    with it.

    Note that the previous colorizer is returned
    only the first time set_nav_colorizer() is called:
    due to the way the colorizers API is defined in C,
    it is impossible to chain more than 2 colorizers
    in IDAPython: the original, IDA-provided colorizer,
    and a user-provided one.

    Example: colorizer inverting the color provided by the IDA colorizer:
        def my_colorizer(ea, nbytes):
            global ida_colorizer
            orig = idaapi.call_nav_colorizer(ida_colorizer, ea, nbytes)
            return long(~orig)

        ida_colorizer = idaapi.set_nav_colorizer(my_colorizer)

    @param new_py_colorizer: PyObject *
    """
    return _ida_kernwin.set_nav_colorizer(new_py_colorizer)

def call_nav_colorizer(dict: "PyObject *", ea: "ea_t", nbytes: "asize_t") -> "uint32":
    r"""
    call_nav_colorizer(dict, ea, nbytes) -> uint32
    To be used with the IDA-provided colorizer, that is
    returned as result of the first call to set_nav_colorizer().

    @param dict: PyObject *
    @param ea: ea_t
    @param nbytes: asize_t
    """
    return _ida_kernwin.call_nav_colorizer(dict, ea, nbytes)

def msg_get_lines(count: "int"=-1) -> "PyObject *":
    r"""
    msg_get_lines(count=-1) -> PyObject
    Retrieve the last 'count' lines from the output window, in reverse order (from
    most recent, to least recent)

    @param count: (C++: int) The number of lines to retrieve. -1 means: all
    """
    return _ida_kernwin.msg_get_lines(count)

def TWidget__from_ptrval__(ptrval: "size_t") -> "TWidget *":
    r"""
    TWidget__from_ptrval__(ptrval) -> TWidget *

    @param ptrval: size_t
    """
    return _ida_kernwin.TWidget__from_ptrval__(ptrval)
MAX_SPACES_ADDED = _ida_kernwin.MAX_SPACES_ADDED


def add_spaces(s: "char const *", len: "size_t") -> "PyObject *":
    r"""
    add_spaces(s, len) -> str
    Add space characters to the colored string so that its length will be at least
    'len' characters. Don't trim the string if it is longer than 'len'.

    @param str: (C++: char *) pointer to colored string to modify (may not be nullptr)
    @param len: (C++: ssize_t) the desired length of the string
    @return: pointer to the end of input string
    """
    return _ida_kernwin.add_spaces(s, len)

def show_wait_box(message: "char const *") -> "void":
    r"""
    show_wait_box(message)
    Display a dialog box with "Please wait...". The behavior of the dialog box can
    be configured with well-known
    tokens, that should be placed at the start of the format string:
    "NODELAY\n": the dialog will show immediately, instead of
    appearing after usual grace threshold
    "HIDECANCEL\n": the cancel button won't be added to the dialog box
    and user_cancelled() will always return false (but
    can be called to refresh UI)
    Using "HIDECANCEL" implies "NODELAY"
    Plugins must call hide_wait_box() to close the dialog box, otherwise
    the user interface will remain disabled.
    Note that, if the wait dialog is already visible, show_wait_box() will
    1) push the currently-displayed text on a stack
    2) display the new text
    Then, when hide_wait_box() is called, if that stack isn't empty its top
    label will be popped and restored in the wait dialog.
    This implies that a plugin should call hide_wait_box() exactly as many
    times as it called show_wait_box(), or the wait dialog might remain
    visible and block the UI.
    Also, in case the plugin knows the wait dialog is currently displayed,
    alternatively it can call replace_wait_box(), to replace the text of the
    dialog without pushing the currently-displayed text on the stack.

    @param message: char const *
    """
    return _ida_kernwin.show_wait_box(message)

def hide_wait_box() -> "void":
    r"""
    hide_wait_box()
    Hide the "Please wait dialog box".
    """
    return _ida_kernwin.hide_wait_box()
class line_rendering_output_entries_refs_t(object):
    r"""
    Proxy of C++ qvector< line_rendering_output_entry_t * > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> line_rendering_output_entries_refs_t
        __init__(self, x) -> line_rendering_output_entries_refs_t

        @param x: qvector< line_rendering_output_entry_t * > const &
        """
        _ida_kernwin.line_rendering_output_entries_refs_t_swiginit(self, _ida_kernwin.new_line_rendering_output_entries_refs_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_line_rendering_output_entries_refs_t

    def push_back(self, *args) -> "line_rendering_output_entry_t *&":
        r"""
        push_back(self, x)

        @param x: line_rendering_output_entry_t *const &

        push_back(self) -> line_rendering_output_entry_t *&
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_empty(self)

    def at(self, _idx: "size_t") -> "line_rendering_output_entry_t *const &":
        r"""
        at(self, _idx) -> line_rendering_output_entry_t

        @param _idx: size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: line_rendering_output_entry_t *const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_resize(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_truncate(self)

    def swap(self, r: "line_rendering_output_entries_refs_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< line_rendering_output_entry_t * > &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_swap(self, r)

    def extract(self) -> "line_rendering_output_entry_t **":
        r"""
        extract(self) -> line_rendering_output_entry_t **
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_extract(self)

    def inject(self, s: "line_rendering_output_entry_t **", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: line_rendering_output_entry_t **
        @param len: size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_inject(self, s, len)

    def __eq__(self, r: "line_rendering_output_entries_refs_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: qvector< line_rendering_output_entry_t * > const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t___eq__(self, r)

    def __ne__(self, r: "line_rendering_output_entries_refs_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: qvector< line_rendering_output_entry_t * > const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t___ne__(self, r)

    def begin(self, *args) -> "qvector< line_rendering_output_entry_t * >::const_iterator":
        r"""
        begin(self) -> qvector< line_rendering_output_entry_t * >::iterator
        begin(self) -> qvector< line_rendering_output_entry_t * >::const_iterator
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_begin(self, *args)

    def end(self, *args) -> "qvector< line_rendering_output_entry_t * >::const_iterator":
        r"""
        end(self) -> qvector< line_rendering_output_entry_t * >::iterator
        end(self) -> qvector< line_rendering_output_entry_t * >::const_iterator
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_end(self, *args)

    def insert(self, it: "qvector< line_rendering_output_entry_t * >::iterator", x: "line_rendering_output_entry_t") -> "qvector< line_rendering_output_entry_t * >::iterator":
        r"""
        insert(self, it, x) -> qvector< line_rendering_output_entry_t * >::iterator

        @param it: qvector< line_rendering_output_entry_t * >::iterator
        @param x: line_rendering_output_entry_t *const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< line_rendering_output_entry_t * >::iterator":
        r"""
        erase(self, it) -> qvector< line_rendering_output_entry_t * >::iterator

        @param it: qvector< line_rendering_output_entry_t * >::iterator

        erase(self, first, last) -> qvector< line_rendering_output_entry_t * >::iterator

        @param first: qvector< line_rendering_output_entry_t * >::iterator
        @param last: qvector< line_rendering_output_entry_t * >::iterator
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_erase(self, *args)

    def find(self, *args) -> "qvector< line_rendering_output_entry_t * >::const_iterator":
        r"""
        find(self, x) -> qvector< line_rendering_output_entry_t * >::iterator

        @param x: line_rendering_output_entry_t *const &

        find(self, x) -> qvector< line_rendering_output_entry_t * >::const_iterator

        @param x: line_rendering_output_entry_t *const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_find(self, *args)

    def has(self, x: "line_rendering_output_entry_t") -> "bool":
        r"""
        has(self, x) -> bool

        @param x: line_rendering_output_entry_t *const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_has(self, x)

    def add_unique(self, x: "line_rendering_output_entry_t") -> "bool":
        r"""
        add_unique(self, x) -> bool

        @param x: line_rendering_output_entry_t *const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t_add_unique(self, x)

    def _del(self, x: "line_rendering_output_entry_t") -> "bool":
        r"""
        _del(self, x) -> bool

        Parameters
        ----------
        x: line_rendering_output_entry_t *const &

        """
        return _ida_kernwin.line_rendering_output_entries_refs_t__del(self, x)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t___len__(self)

    def __getitem__(self, i: "size_t") -> "line_rendering_output_entry_t *const &":
        r"""
        __getitem__(self, i) -> line_rendering_output_entry_t

        @param i: size_t
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "line_rendering_output_entry_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: line_rendering_output_entry_t *const &
        """
        return _ida_kernwin.line_rendering_output_entries_refs_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


    def _internal_push_back(self, e: "line_rendering_output_entry_t") -> "void":
        r"""
        _internal_push_back(self, e)

        Parameters
        ----------
        e: line_rendering_output_entry_t *

        """
        return _ida_kernwin.line_rendering_output_entries_refs_t__internal_push_back(self, e)

    def push_back(self, e):
        if e and e.thisown:
            self._internal_push_back(e)
            e.thisown = False


# Register line_rendering_output_entries_refs_t in _ida_kernwin:
_ida_kernwin.line_rendering_output_entries_refs_t_swigregister(line_rendering_output_entries_refs_t)
class section_lines_refs_t(object):
    r"""
    Proxy of C++ qvector< twinline_t const * > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> section_lines_refs_t
        __init__(self, x) -> section_lines_refs_t

        @param x: qvector< twinline_t const * > const &
        """
        _ida_kernwin.section_lines_refs_t_swiginit(self, _ida_kernwin.new_section_lines_refs_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_section_lines_refs_t

    def push_back(self, *args) -> "twinline_t const *&":
        r"""
        push_back(self, x)

        @param x: twinline_t const *const &

        push_back(self) -> twinline_t const *&
        """
        return _ida_kernwin.section_lines_refs_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.section_lines_refs_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.section_lines_refs_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.section_lines_refs_t_empty(self)

    def at(self, _idx: "size_t") -> "twinline_t const *const &":
        r"""
        at(self, _idx) -> twinline_t

        @param _idx: size_t
        """
        return _ida_kernwin.section_lines_refs_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.section_lines_refs_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.section_lines_refs_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: twinline_t const *const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.section_lines_refs_t_resize(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.section_lines_refs_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.section_lines_refs_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.section_lines_refs_t_truncate(self)

    def swap(self, r: "section_lines_refs_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< twinline_t const * > &
        """
        return _ida_kernwin.section_lines_refs_t_swap(self, r)

    def extract(self) -> "twinline_t const **":
        r"""
        extract(self) -> twinline_t const **
        """
        return _ida_kernwin.section_lines_refs_t_extract(self)

    def inject(self, s: "twinline_t const **", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: twinline_t const **
        @param len: size_t
        """
        return _ida_kernwin.section_lines_refs_t_inject(self, s, len)

    def __eq__(self, r: "section_lines_refs_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: qvector< twinline_t const * > const &
        """
        return _ida_kernwin.section_lines_refs_t___eq__(self, r)

    def __ne__(self, r: "section_lines_refs_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: qvector< twinline_t const * > const &
        """
        return _ida_kernwin.section_lines_refs_t___ne__(self, r)

    def begin(self, *args) -> "qvector< twinline_t const * >::const_iterator":
        r"""
        begin(self) -> qvector< twinline_t const * >::iterator
        begin(self) -> qvector< twinline_t const * >::const_iterator
        """
        return _ida_kernwin.section_lines_refs_t_begin(self, *args)

    def end(self, *args) -> "qvector< twinline_t const * >::const_iterator":
        r"""
        end(self) -> qvector< twinline_t const * >::iterator
        end(self) -> qvector< twinline_t const * >::const_iterator
        """
        return _ida_kernwin.section_lines_refs_t_end(self, *args)

    def insert(self, it: "qvector< twinline_t const * >::iterator", x: "twinline_t") -> "qvector< twinline_t const * >::iterator":
        r"""
        insert(self, it, x) -> qvector< twinline_t const * >::iterator

        @param it: qvector< twinline_t const * >::iterator
        @param x: twinline_t const *const &
        """
        return _ida_kernwin.section_lines_refs_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< twinline_t const * >::iterator":
        r"""
        erase(self, it) -> qvector< twinline_t const * >::iterator

        @param it: qvector< twinline_t const * >::iterator

        erase(self, first, last) -> qvector< twinline_t const * >::iterator

        @param first: qvector< twinline_t const * >::iterator
        @param last: qvector< twinline_t const * >::iterator
        """
        return _ida_kernwin.section_lines_refs_t_erase(self, *args)

    def find(self, *args) -> "qvector< twinline_t const * >::const_iterator":
        r"""
        find(self, x) -> qvector< twinline_t const * >::iterator

        @param x: twinline_t const *const &

        find(self, x) -> qvector< twinline_t const * >::const_iterator

        @param x: twinline_t const *const &
        """
        return _ida_kernwin.section_lines_refs_t_find(self, *args)

    def has(self, x: "twinline_t") -> "bool":
        r"""
        has(self, x) -> bool

        @param x: twinline_t const *const &
        """
        return _ida_kernwin.section_lines_refs_t_has(self, x)

    def add_unique(self, x: "twinline_t") -> "bool":
        r"""
        add_unique(self, x) -> bool

        @param x: twinline_t const *const &
        """
        return _ida_kernwin.section_lines_refs_t_add_unique(self, x)

    def _del(self, x: "twinline_t") -> "bool":
        r"""
        _del(self, x) -> bool

        Parameters
        ----------
        x: twinline_t const *const &

        """
        return _ida_kernwin.section_lines_refs_t__del(self, x)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.section_lines_refs_t___len__(self)

    def __getitem__(self, i: "size_t") -> "twinline_t const *const &":
        r"""
        __getitem__(self, i) -> twinline_t

        @param i: size_t
        """
        return _ida_kernwin.section_lines_refs_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "twinline_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: twinline_t const *const &
        """
        return _ida_kernwin.section_lines_refs_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register section_lines_refs_t in _ida_kernwin:
_ida_kernwin.section_lines_refs_t_swigregister(section_lines_refs_t)
class sections_lines_refs_t(object):
    r"""
    Proxy of C++ qvector< section_lines_refs_t > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> sections_lines_refs_t
        __init__(self, x) -> sections_lines_refs_t

        @param x: qvector< section_lines_refs_t > const &
        """
        _ida_kernwin.sections_lines_refs_t_swiginit(self, _ida_kernwin.new_sections_lines_refs_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_sections_lines_refs_t

    def push_back(self, *args) -> "section_lines_refs_t &":
        r"""
        push_back(self, x)

        @param x: section_lines_refs_t const &

        push_back(self) -> section_lines_refs_t
        """
        return _ida_kernwin.sections_lines_refs_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.sections_lines_refs_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.sections_lines_refs_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.sections_lines_refs_t_empty(self)

    def at(self, _idx: "size_t") -> "section_lines_refs_t const &":
        r"""
        at(self, _idx) -> section_lines_refs_t

        @param _idx: size_t
        """
        return _ida_kernwin.sections_lines_refs_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.sections_lines_refs_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.sections_lines_refs_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: section_lines_refs_t const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.sections_lines_refs_t_resize(self, *args)

    def grow(self, *args) -> "void":
        r"""
        grow(self, x=section_lines_refs_t())

        @param x: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t_grow(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.sections_lines_refs_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.sections_lines_refs_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.sections_lines_refs_t_truncate(self)

    def swap(self, r: "sections_lines_refs_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< section_lines_refs_t > &
        """
        return _ida_kernwin.sections_lines_refs_t_swap(self, r)

    def extract(self) -> "section_lines_refs_t *":
        r"""
        extract(self) -> section_lines_refs_t
        """
        return _ida_kernwin.sections_lines_refs_t_extract(self)

    def inject(self, s: "section_lines_refs_t", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: section_lines_refs_t *
        @param len: size_t
        """
        return _ida_kernwin.sections_lines_refs_t_inject(self, s, len)

    def __eq__(self, r: "sections_lines_refs_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: qvector< section_lines_refs_t > const &
        """
        return _ida_kernwin.sections_lines_refs_t___eq__(self, r)

    def __ne__(self, r: "sections_lines_refs_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: qvector< section_lines_refs_t > const &
        """
        return _ida_kernwin.sections_lines_refs_t___ne__(self, r)

    def begin(self, *args) -> "qvector< section_lines_refs_t >::const_iterator":
        r"""
        begin(self) -> qvector< section_lines_refs_t >::iterator
        begin(self) -> qvector< section_lines_refs_t >::const_iterator
        """
        return _ida_kernwin.sections_lines_refs_t_begin(self, *args)

    def end(self, *args) -> "qvector< section_lines_refs_t >::const_iterator":
        r"""
        end(self) -> qvector< section_lines_refs_t >::iterator
        end(self) -> qvector< section_lines_refs_t >::const_iterator
        """
        return _ida_kernwin.sections_lines_refs_t_end(self, *args)

    def insert(self, it: "qvector< section_lines_refs_t >::iterator", x: "section_lines_refs_t") -> "qvector< section_lines_refs_t >::iterator":
        r"""
        insert(self, it, x) -> qvector< section_lines_refs_t >::iterator

        @param it: qvector< section_lines_refs_t >::iterator
        @param x: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< section_lines_refs_t >::iterator":
        r"""
        erase(self, it) -> qvector< section_lines_refs_t >::iterator

        @param it: qvector< section_lines_refs_t >::iterator

        erase(self, first, last) -> qvector< section_lines_refs_t >::iterator

        @param first: qvector< section_lines_refs_t >::iterator
        @param last: qvector< section_lines_refs_t >::iterator
        """
        return _ida_kernwin.sections_lines_refs_t_erase(self, *args)

    def find(self, *args) -> "qvector< section_lines_refs_t >::const_iterator":
        r"""
        find(self, x) -> qvector< section_lines_refs_t >::iterator

        @param x: section_lines_refs_t const &

        find(self, x) -> qvector< section_lines_refs_t >::const_iterator

        @param x: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t_find(self, *args)

    def has(self, x: "section_lines_refs_t") -> "bool":
        r"""
        has(self, x) -> bool

        @param x: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t_has(self, x)

    def add_unique(self, x: "section_lines_refs_t") -> "bool":
        r"""
        add_unique(self, x) -> bool

        @param x: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t_add_unique(self, x)

    def _del(self, x: "section_lines_refs_t") -> "bool":
        r"""
        _del(self, x) -> bool

        Parameters
        ----------
        x: section_lines_refs_t const &

        """
        return _ida_kernwin.sections_lines_refs_t__del(self, x)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.sections_lines_refs_t___len__(self)

    def __getitem__(self, i: "size_t") -> "section_lines_refs_t const &":
        r"""
        __getitem__(self, i) -> section_lines_refs_t

        @param i: size_t
        """
        return _ida_kernwin.sections_lines_refs_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "section_lines_refs_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: section_lines_refs_t const &
        """
        return _ida_kernwin.sections_lines_refs_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register sections_lines_refs_t in _ida_kernwin:
_ida_kernwin.sections_lines_refs_t_swigregister(sections_lines_refs_t)
class text_t(object):
    r"""
    Proxy of C++ qvector< twinline_t > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> text_t
        __init__(self, x) -> text_t

        @param x: qvector< twinline_t > const &
        """
        _ida_kernwin.text_t_swiginit(self, _ida_kernwin.new_text_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_text_t

    def push_back(self, *args) -> "twinline_t &":
        r"""
        push_back(self, x)

        @param x: twinline_t const &

        push_back(self) -> twinline_t
        """
        return _ida_kernwin.text_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.text_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.text_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.text_t_empty(self)

    def at(self, _idx: "size_t") -> "twinline_t const &":
        r"""
        at(self, _idx) -> twinline_t

        @param _idx: size_t
        """
        return _ida_kernwin.text_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.text_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.text_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: twinline_t const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.text_t_resize(self, *args)

    def grow(self, *args) -> "void":
        r"""
        grow(self, x=twinline_t())

        @param x: twinline_t const &
        """
        return _ida_kernwin.text_t_grow(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.text_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.text_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.text_t_truncate(self)

    def swap(self, r: "text_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< twinline_t > &
        """
        return _ida_kernwin.text_t_swap(self, r)

    def extract(self) -> "twinline_t *":
        r"""
        extract(self) -> twinline_t
        """
        return _ida_kernwin.text_t_extract(self)

    def inject(self, s: "twinline_t", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: twinline_t *
        @param len: size_t
        """
        return _ida_kernwin.text_t_inject(self, s, len)

    def begin(self, *args) -> "qvector< twinline_t >::const_iterator":
        r"""
        begin(self) -> twinline_t
        """
        return _ida_kernwin.text_t_begin(self, *args)

    def end(self, *args) -> "qvector< twinline_t >::const_iterator":
        r"""
        end(self) -> twinline_t
        """
        return _ida_kernwin.text_t_end(self, *args)

    def insert(self, it: "twinline_t", x: "twinline_t") -> "qvector< twinline_t >::iterator":
        r"""
        insert(self, it, x) -> twinline_t

        @param it: qvector< twinline_t >::iterator
        @param x: twinline_t const &
        """
        return _ida_kernwin.text_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< twinline_t >::iterator":
        r"""
        erase(self, it) -> twinline_t

        @param it: qvector< twinline_t >::iterator

        erase(self, first, last) -> twinline_t

        @param first: qvector< twinline_t >::iterator
        @param last: qvector< twinline_t >::iterator
        """
        return _ida_kernwin.text_t_erase(self, *args)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.text_t___len__(self)

    def __getitem__(self, i: "size_t") -> "twinline_t const &":
        r"""
        __getitem__(self, i) -> twinline_t

        @param i: size_t
        """
        return _ida_kernwin.text_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "twinline_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: twinline_t const &
        """
        return _ida_kernwin.text_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register text_t in _ida_kernwin:
_ida_kernwin.text_t_swigregister(text_t)
class sync_source_vec_t(object):
    r"""
    Proxy of C++ qvector< sync_source_t > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> sync_source_vec_t
        __init__(self, x) -> sync_source_vec_t

        @param x: qvector< sync_source_t > const &
        """
        _ida_kernwin.sync_source_vec_t_swiginit(self, _ida_kernwin.new_sync_source_vec_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_sync_source_vec_t

    def push_back(self, x: "sync_source_t") -> "void":
        r"""
        push_back(self, x)

        @param x: sync_source_t const &
        """
        return _ida_kernwin.sync_source_vec_t_push_back(self, x)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.sync_source_vec_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.sync_source_vec_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.sync_source_vec_t_empty(self)

    def at(self, _idx: "size_t") -> "sync_source_t const &":
        r"""
        at(self, _idx) -> sync_source_t

        @param _idx: size_t
        """
        return _ida_kernwin.sync_source_vec_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.sync_source_vec_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.sync_source_vec_t_clear(self)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.sync_source_vec_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.sync_source_vec_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.sync_source_vec_t_truncate(self)

    def swap(self, r: "sync_source_vec_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< sync_source_t > &
        """
        return _ida_kernwin.sync_source_vec_t_swap(self, r)

    def extract(self) -> "sync_source_t *":
        r"""
        extract(self) -> sync_source_t
        """
        return _ida_kernwin.sync_source_vec_t_extract(self)

    def inject(self, s: "sync_source_t", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: sync_source_t *
        @param len: size_t
        """
        return _ida_kernwin.sync_source_vec_t_inject(self, s, len)

    def __eq__(self, r: "sync_source_vec_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: qvector< sync_source_t > const &
        """
        return _ida_kernwin.sync_source_vec_t___eq__(self, r)

    def __ne__(self, r: "sync_source_vec_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: qvector< sync_source_t > const &
        """
        return _ida_kernwin.sync_source_vec_t___ne__(self, r)

    def begin(self, *args) -> "qvector< sync_source_t >::const_iterator":
        r"""
        begin(self) -> sync_source_t
        """
        return _ida_kernwin.sync_source_vec_t_begin(self, *args)

    def end(self, *args) -> "qvector< sync_source_t >::const_iterator":
        r"""
        end(self) -> sync_source_t
        """
        return _ida_kernwin.sync_source_vec_t_end(self, *args)

    def insert(self, it: "sync_source_t", x: "sync_source_t") -> "qvector< sync_source_t >::iterator":
        r"""
        insert(self, it, x) -> sync_source_t

        @param it: qvector< sync_source_t >::iterator
        @param x: sync_source_t const &
        """
        return _ida_kernwin.sync_source_vec_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< sync_source_t >::iterator":
        r"""
        erase(self, it) -> sync_source_t

        @param it: qvector< sync_source_t >::iterator

        erase(self, first, last) -> sync_source_t

        @param first: qvector< sync_source_t >::iterator
        @param last: qvector< sync_source_t >::iterator
        """
        return _ida_kernwin.sync_source_vec_t_erase(self, *args)

    def find(self, *args) -> "qvector< sync_source_t >::const_iterator":
        r"""
        find(self, x) -> sync_source_t

        @param x: sync_source_t const &

        """
        return _ida_kernwin.sync_source_vec_t_find(self, *args)

    def has(self, x: "sync_source_t") -> "bool":
        r"""
        has(self, x) -> bool

        @param x: sync_source_t const &
        """
        return _ida_kernwin.sync_source_vec_t_has(self, x)

    def add_unique(self, x: "sync_source_t") -> "bool":
        r"""
        add_unique(self, x) -> bool

        @param x: sync_source_t const &
        """
        return _ida_kernwin.sync_source_vec_t_add_unique(self, x)

    def _del(self, x: "sync_source_t") -> "bool":
        r"""
        _del(self, x) -> bool

        Parameters
        ----------
        x: sync_source_t const &

        """
        return _ida_kernwin.sync_source_vec_t__del(self, x)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.sync_source_vec_t___len__(self)

    def __getitem__(self, i: "size_t") -> "sync_source_t const &":
        r"""
        __getitem__(self, i) -> sync_source_t

        @param i: size_t
        """
        return _ida_kernwin.sync_source_vec_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "sync_source_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: sync_source_t const &
        """
        return _ida_kernwin.sync_source_vec_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register sync_source_vec_t in _ida_kernwin:
_ida_kernwin.sync_source_vec_t_swigregister(sync_source_vec_t)
mbox_internal = _ida_kernwin.mbox_internal
r"""
internal error
"""

mbox_info = _ida_kernwin.mbox_info

mbox_warning = _ida_kernwin.mbox_warning

mbox_error = _ida_kernwin.mbox_error

mbox_nomem = _ida_kernwin.mbox_nomem

mbox_feedback = _ida_kernwin.mbox_feedback

mbox_readerror = _ida_kernwin.mbox_readerror

mbox_writeerror = _ida_kernwin.mbox_writeerror

mbox_filestruct = _ida_kernwin.mbox_filestruct

mbox_wait = _ida_kernwin.mbox_wait

mbox_hide = _ida_kernwin.mbox_hide

mbox_replace = _ida_kernwin.mbox_replace

chtype_generic = _ida_kernwin.chtype_generic
r"""
the generic choose() function
"""

chtype_idasgn = _ida_kernwin.chtype_idasgn
r"""
see choose_idasgn()
"""

chtype_entry = _ida_kernwin.chtype_entry
r"""
see choose_entry()
"""

chtype_name = _ida_kernwin.chtype_name
r"""
see choose_name()
"""

chtype_stkvar_xref = _ida_kernwin.chtype_stkvar_xref
r"""
see choose_stkvar_xref()
"""

chtype_xref = _ida_kernwin.chtype_xref
r"""
see choose_xref()
"""

chtype_func = _ida_kernwin.chtype_func
r"""
see choose_func()
"""

chtype_segm = _ida_kernwin.chtype_segm
r"""
see choose_segm()
"""

chtype_strpath = _ida_kernwin.chtype_strpath
r"""
see choose_struc_path()
"""

chtype_idatil = _ida_kernwin.chtype_idatil
r"""
see choose_til()
"""

chtype_srcp = _ida_kernwin.chtype_srcp
r"""
see choose_srcp()
"""

chtype_struct = _ida_kernwin.chtype_struct
r"""
see choose_struct()
"""

chtype_enum = _ida_kernwin.chtype_enum
r"""
see choose_enum()
"""

chtype_enum_by_value_and_size = _ida_kernwin.chtype_enum_by_value_and_size
r"""
see choose_enum_by_value()
"""

beep_default = _ida_kernwin.beep_default

TCCRT_INVALID = _ida_kernwin.TCCRT_INVALID
r"""
invalid
"""

TCCRT_FLAT = _ida_kernwin.TCCRT_FLAT
r"""
flat view
"""

TCCRT_GRAPH = _ida_kernwin.TCCRT_GRAPH
r"""
graph view
"""

TCCRT_PROXIMITY = _ida_kernwin.TCCRT_PROXIMITY
r"""
proximity view
"""

TCCPT_INVALID = _ida_kernwin.TCCPT_INVALID
r"""
invalid
"""

TCCPT_PLACE = _ida_kernwin.TCCPT_PLACE
r"""
place_t
"""

TCCPT_SIMPLELINE_PLACE = _ida_kernwin.TCCPT_SIMPLELINE_PLACE
r"""
simpleline_place_t
"""

TCCPT_IDAPLACE = _ida_kernwin.TCCPT_IDAPLACE
r"""
idaplace_t
"""

TCCPT_TIPLACE = _ida_kernwin.TCCPT_TIPLACE
r"""
tiplace_t
"""

VME_UNKNOWN = _ida_kernwin.VME_UNKNOWN
r"""
unknown mouse button
"""

VME_LEFT_BUTTON = _ida_kernwin.VME_LEFT_BUTTON
r"""
left mouse button
"""

VME_RIGHT_BUTTON = _ida_kernwin.VME_RIGHT_BUTTON
r"""
right mouse button
"""

VME_MID_BUTTON = _ida_kernwin.VME_MID_BUTTON
r"""
middle mouse button
"""

SETMENU_POSMASK = _ida_kernwin.SETMENU_POSMASK

SETMENU_INS = _ida_kernwin.SETMENU_INS
r"""
add menu item before the specified path (default)
"""

SETMENU_APP = _ida_kernwin.SETMENU_APP
r"""
add menu item after the specified path
"""

SETMENU_FIRST = _ida_kernwin.SETMENU_FIRST
r"""
add item to the beginning of menu
"""

SETMENU_ENSURE_SEP = _ida_kernwin.SETMENU_ENSURE_SEP
r"""
make sure there is a separator before the action
"""

CREATETB_ADV = _ida_kernwin.CREATETB_ADV
r"""
toolbar is for 'advanced mode' only
"""

HIF_IDENTIFIER = _ida_kernwin.HIF_IDENTIFIER
r"""
text is an identifier (i.e., when searching for the current highlight,
SEARCH_IDENT will be used)
"""

HIF_REGISTER = _ida_kernwin.HIF_REGISTER
r"""
text represents a register (aliases/subregisters will be highlit as well)
"""

HIF_LOCKED = _ida_kernwin.HIF_LOCKED
r"""
locked; clicking/moving the cursor around doesn't change the highlight
"""

HIF_NOCASE = _ida_kernwin.HIF_NOCASE
r"""
case insensitive
"""

HIF_USE_SLOT = _ida_kernwin.HIF_USE_SLOT
r"""
use the given number, or just use the "floating" highlight
"""

HIF_SLOT_SHIFT = _ida_kernwin.HIF_SLOT_SHIFT
r"""
position of the 3 top bits specifying which highlight to use
"""

HIF_SLOT_0 = _ida_kernwin.HIF_SLOT_0
r"""
operate on slot 0
"""

HIF_SLOT_1 = _ida_kernwin.HIF_SLOT_1
r"""
operate on slot 1
"""

HIF_SLOT_2 = _ida_kernwin.HIF_SLOT_2
r"""
operate on slot 2
"""

HIF_SLOT_3 = _ida_kernwin.HIF_SLOT_3
r"""
operate on slot 3
"""

HIF_SLOT_4 = _ida_kernwin.HIF_SLOT_4
r"""
operate on slot 4
"""

HIF_SLOT_5 = _ida_kernwin.HIF_SLOT_5
r"""
operate on slot 5
"""

HIF_SLOT_6 = _ida_kernwin.HIF_SLOT_6
r"""
operate on slot 6
"""

HIF_SLOT_7 = _ida_kernwin.HIF_SLOT_7
r"""
operate on slot 7
"""

REG_HINTS_MARKER = _ida_kernwin.REG_HINTS_MARKER

REG_HINTS_MARKER_LEN = _ida_kernwin.REG_HINTS_MARKER_LEN

SRCDBG_HINTS_MARKER = _ida_kernwin.SRCDBG_HINTS_MARKER

SRCDBG_HINTS_MARKER_LEN = _ida_kernwin.SRCDBG_HINTS_MARKER_LEN

CDVF_NOLINES = _ida_kernwin.CDVF_NOLINES
r"""
don't show line numbers
"""

CDVF_LINEICONS = _ida_kernwin.CDVF_LINEICONS
r"""
icons can be drawn over the line control
"""

CDVF_STATUSBAR = _ida_kernwin.CDVF_STATUSBAR
r"""
keep the status bar in the custom viewer
"""

IDCHK_OK = _ida_kernwin.IDCHK_OK
r"""
ok
"""

IDCHK_ARG = _ida_kernwin.IDCHK_ARG
r"""
bad argument(s)
"""

IDCHK_KEY = _ida_kernwin.IDCHK_KEY
r"""
bad hotkey name
"""

IDCHK_MAX = _ida_kernwin.IDCHK_MAX
r"""
too many IDC hotkeys
"""

WCLS_SAVE = _ida_kernwin.WCLS_SAVE
r"""
save state in desktop config
"""

WCLS_NO_CONTEXT = _ida_kernwin.WCLS_NO_CONTEXT
r"""
don't change the current context (useful for toolbars)
"""

WCLS_DONT_SAVE_SIZE = _ida_kernwin.WCLS_DONT_SAVE_SIZE
r"""
don't save size of the window
"""

WCLS_DELETE_LATER = _ida_kernwin.WCLS_DELETE_LATER
r"""
assign the deletion of the widget to the UI loop ///<
"""

WCLS_CLOSE_LATER = _ida_kernwin.WCLS_CLOSE_LATER

DP_LEFT = _ida_kernwin.DP_LEFT
r"""
Dock src_form to the left of dest_form.
"""

DP_TOP = _ida_kernwin.DP_TOP
r"""
Dock src_form above dest_form.
"""

DP_RIGHT = _ida_kernwin.DP_RIGHT
r"""
Dock src_form to the right of dest_form.
"""

DP_BOTTOM = _ida_kernwin.DP_BOTTOM
r"""
Dock src_form below dest_form.
"""

DP_INSIDE = _ida_kernwin.DP_INSIDE
r"""
Create a new tab bar with both src_form and dest_form.
"""

DP_TAB = _ida_kernwin.DP_TAB
r"""
Place src_form into a tab next to dest_form, if dest_form is in a tab bar
(otherwise the same as DP_INSIDE)
"""

DP_BEFORE = _ida_kernwin.DP_BEFORE
r"""
Place src_form before dst_form in the tab bar instead of after; used with
DP_INSIDE or DP_TAB.
"""

DP_FLOATING = _ida_kernwin.DP_FLOATING
r"""
Make src_form floating.
"""

DP_SZHINT = _ida_kernwin.DP_SZHINT
r"""
When floating or in a splitter (i.e., not tabbed), use the widget's size hint to
determine the best geometry (Qt only)
"""

SVF_COPY_LINES = _ida_kernwin.SVF_COPY_LINES
r"""
keep a local copy of '*lines'
"""

SVF_LINES_BYPTR = _ida_kernwin.SVF_LINES_BYPTR
r"""
remember the 'lines' ptr. do not make a copy of '*lines'
"""

CVNF_LAZY = _ida_kernwin.CVNF_LAZY
r"""
try and move the cursor to a line displaying the place_t if possible. This might
disregard the Y position in case of success
"""

CVNF_JUMP = _ida_kernwin.CVNF_JUMP
r"""
push the current position in this viewer's lochist_t before going to the new
location
"""

CVNF_ACT = _ida_kernwin.CVNF_ACT
r"""
activate (i.e., switch to) the viewer. Activation is performed before the new
lochist_entry_t instance is actually copied to the viewer's lochist_t
(otherwise, if the viewer was invisible its on_location_changed() handler
wouldn't be called.)
"""

WOPN_RESTORE = _ida_kernwin.WOPN_RESTORE
r"""
if the widget was the only widget in a floating area the last time it was
closed, it will be restored as floating, with the same position+size as before
"""

WOPN_PERSIST = _ida_kernwin.WOPN_PERSIST
r"""
widget will remain available when starting or stopping debugger sessions
"""

WOPN_CLOSED_BY_ESC = _ida_kernwin.WOPN_CLOSED_BY_ESC
r"""
override idagui.cfg:CLOSED_BY_ESC: esc will close
"""

WOPN_NOT_CLOSED_BY_ESC = _ida_kernwin.WOPN_NOT_CLOSED_BY_ESC
r"""
override idagui.cfg:CLOSED_BY_ESC: esc will not close
"""

WOPN_DP_MASK = _ida_kernwin.WOPN_DP_MASK

WOPN_DP_SHIFT = _ida_kernwin.WOPN_DP_SHIFT

WOPN_DP_LEFT = _ida_kernwin.WOPN_DP_LEFT
r"""
Dock widget to the left of dest_ctrl.
"""

WOPN_DP_TOP = _ida_kernwin.WOPN_DP_TOP
r"""
Dock widget above dest_ctrl.
"""

WOPN_DP_RIGHT = _ida_kernwin.WOPN_DP_RIGHT
r"""
Dock widget to the right of dest_ctrl.
"""

WOPN_DP_BOTTOM = _ida_kernwin.WOPN_DP_BOTTOM
r"""
Dock widget below dest_ctrl.
"""

WOPN_DP_INSIDE = _ida_kernwin.WOPN_DP_INSIDE
r"""
Create a new tab bar with both widget and dest_ctrl.
"""

WOPN_DP_TAB = _ida_kernwin.WOPN_DP_TAB
r"""
Place widget into a tab next to dest_ctrl, if dest_ctrl is in a tab bar
(otherwise the same as WOPN_DP_INSIDE)
"""

WOPN_DP_BEFORE = _ida_kernwin.WOPN_DP_BEFORE
r"""
Place widget before dst_form in the tab bar instead of after; used with
WOPN_DP_INSIDE and WOPN_DP_TAB
"""

WOPN_DP_FLOATING = _ida_kernwin.WOPN_DP_FLOATING
r"""
Make widget floating.
"""

WOPN_DP_SZHINT = _ida_kernwin.WOPN_DP_SZHINT
r"""
when floating or in a splitter (i.e., not tabbed), use the widget's size hint to
determine the best geometry (Qt only)
"""

WOPN_DP_INSIDE_BEFORE = _ida_kernwin.WOPN_DP_INSIDE_BEFORE

WOPN_DP_TAB_BEFORE = _ida_kernwin.WOPN_DP_TAB_BEFORE

RENADDR_IDA = _ida_kernwin.RENADDR_IDA
r"""
dialog for "IDA View"
"""

RENADDR_HR = _ida_kernwin.RENADDR_HR
r"""
dialog for "Pseudocode"; additional flags:
* 0x01 Library function
* 0x02 Mark as decompiled
"""

CVLF_USE_MOUSE = _ida_kernwin.CVLF_USE_MOUSE
r"""
Fetch the location from the mouse, instead of caret in the listing.
"""


def get_kernel_version() -> "size_t":
    r"""
    get_kernel_version() -> str
    Get IDA kernel version (in a string like "5.1").
    """
    return _ida_kernwin.get_kernel_version()

def is_ida_library(path: "char *", pathsize: "size_t", handle: "void **") -> "bool":
    r"""
    is_ida_library(path, pathsize, handle) -> bool

    @param path: char *
    @param pathsize: size_t
    @param handle: void **
    """
    return _ida_kernwin.is_ida_library(path, pathsize, handle)
class place_t(object):
    r"""
    Proxy of C++ place_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    lnnum: "int" = property(_ida_kernwin.place_t_lnnum_get, _ida_kernwin.place_t_lnnum_set, doc=r"""lnnum""")
    r"""
    Number of line within the current object.
    """

    def _print(self, ud: "void *") -> "void":
        r"""
        _print(self, ud)

        Parameters
        ----------
        ud: void *

        """
        return _ida_kernwin.place_t__print(self, ud)

    def touval(self, ud: "void *") -> "uval_t":
        r"""
        touval(self, ud) -> uval_t
        Map the location to a number. This mapping is used to draw the vertical
        scrollbar.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        """
        return _ida_kernwin.place_t_touval(self, ud)

    def clone(self) -> "place_t *":
        r"""
        clone(self) -> place_t
        Clone the location.

        @return: a pointer to a copy of the current location in dynamic memory
        """
        return _ida_kernwin.place_t_clone(self)

    def copyfrom(self, _from: "place_t") -> "void":
        r"""
        copyfrom(self, _from)
        Copy the specified location object to the current object.

        @param from: (C++: const place_t *) place_t const *
        """
        return _ida_kernwin.place_t_copyfrom(self, _from)

    def makeplace(self, ud: "void *", x: "uval_t", lnnum: "int") -> "place_t *":
        r"""
        makeplace(self, ud, x, lnnum) -> place_t
        Map a number to a location. When the user clicks on the scrollbar and drags it,
        we need to determine the location corresponding to the new scrollbar position.
        This function is used to determine it. It builds a location object for the
        specified 'x' and returns a pointer to it.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @param x: (C++: uval_t) number to map
        @param lnnum: (C++: int) line number to initialize 'lnnum'
        @return: a freshly allocated object. See also PCF_MAKEPLACE_ALLOCATES
        """
        return _ida_kernwin.place_t_makeplace(self, ud, x, lnnum)

    def compare(self, t2: "place_t") -> "int":
        r"""
        compare(self, t2) -> int
        Deprecated. Please consider compare2(const place_t *, void *) instead.

        @param t2: (C++: const place_t *) place_t const *
        """
        return _ida_kernwin.place_t_compare(self, t2)

    def adjust(self, ud: "void *") -> "void":
        r"""
        adjust(self, ud)
        Adjust the current location to point to a displayable object. This function
        validates the location and makes sure that it points to an existing object. For
        example, if the location points to the middle of an instruction, it will be
        adjusted to point to the beginning of the instruction.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        """
        return _ida_kernwin.place_t_adjust(self, ud)

    def prev(self, ud: "void *") -> "bool":
        r"""
        prev(self, ud) -> bool
        Move to the previous displayable location.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: success
        """
        return _ida_kernwin.place_t_prev(self, ud)

    def next(self, ud: "void *") -> "bool":
        r"""
        next(self, ud) -> bool
        Move to the next displayable location.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: success
        """
        return _ida_kernwin.place_t_next(self, ud)

    def beginning(self, ud: "void *") -> "bool":
        r"""
        beginning(self, ud) -> bool
        Are we at the first displayable object?.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: true if the current location points to the first displayable object
        """
        return _ida_kernwin.place_t_beginning(self, ud)

    def ending(self, ud: "void *") -> "bool":
        r"""
        ending(self, ud) -> bool
        Are we at the last displayable object?.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: true if the current location points to the last displayable object
        """
        return _ida_kernwin.place_t_ending(self, ud)

    def serialize(self) -> "void":
        r"""
        serialize(self)
        Serialize this instance. It is fundamental that all instances of a particular
        subclass of of place_t occupy the same number of bytes when serialized.
        """
        return _ida_kernwin.place_t_serialize(self)

    def id(self) -> "int":
        r"""
        id(self) -> int
        Get the place's ID (i.e., the value returned by register_place_class())

        @return: the id
        """
        return _ida_kernwin.place_t_id(self)

    def name(self) -> "char const *":
        r"""
        name(self) -> char const *
        Get this place type name. All instances of a given class must return the same
        string.

        @return: the place type name. Please try and pick something that is not too
                 generic, as it might clash w/ other plugins. A good practice is to
                 prefix the class name with the name of your plugin. E.g.,
                 "myplugin:srcplace_t".
        """
        return _ida_kernwin.place_t_name(self)

    def toea(self) -> "ea_t":
        r"""
        toea(self) -> ea_t
        Map the location to an ea_t.

        @return: the corresponding ea_t, or BADADDR;
        """
        return _ida_kernwin.place_t_toea(self)

    def rebase(self, arg2: "segm_move_infos_t const &") -> "bool":
        r"""
        rebase(self, arg2) -> bool
        Rebase the place instance

        @param arg2: segm_move_infos_t const &
        @return: true if place was rebased, false otherwise
        """
        return _ida_kernwin.place_t_rebase(self, arg2)

    def enter(self, arg2: "uint32 *") -> "place_t *":
        r"""
        enter(self, arg2) -> place_t
        Visit this place, possibly 'unhiding' a section of text. If entering that place
        required some expanding, a place_t should be returned that represents that
        section, plus some flags for later use by 'leave()'.

        @param out_flags: flags to be used together with the place_t that is returned,
                          in order to restore the section to its original state when
                          leave() is called.
        @return: a place_t corresponding to the beginning of the section of text that
                 had to be expanded. That place_t's leave() will be called with the
                 flags contained in 'out_flags' when the user navigates away from it.
        """
        return _ida_kernwin.place_t_enter(self, arg2)

    def leave(self, arg2: "uint32") -> "void":
        r"""
        leave(self, arg2)
        Leave this place, possibly 'hiding' a section of text that was previously
        expanded (at enter()-time.)

        @param arg2: uint32
        """
        return _ida_kernwin.place_t_leave(self, arg2)

    def compare2(self, t2: "place_t", arg3: "void *") -> "int":
        r"""
        compare2(self, t2, arg3) -> int
        Compare two locations except line numbers (lnnum). This function is used to
        organize loops. For example, if the user has selected an range, its boundaries
        are remembered as location objects. Any operation within the selection will have
        the following look: for ( loc=starting_location; loc < ending_location;
        loc.next() ) In this loop, the comparison function is used.

        @param t2: (C++: const place_t *) the place to compare this one to.
        @param arg3: void *
        """
        return _ida_kernwin.place_t_compare2(self, t2, arg3)

    def deserialize(self, _in: "bytevec_t const &") -> "bool":
        r"""
        deserialize(self, _in) -> bool
        De-serialize into this instance. 'pptr' should be incremented by as many bytes
        as de-serialization consumed.

        @param pptr: (C++: const uchar **) pointer to a serialized representation of a place_t of this type.
        @return: whether de-serialization was successful
        """
        return _ida_kernwin.place_t_deserialize(self, _in)

    @staticmethod
    def as_idaplace_t(p: "place_t") -> "idaplace_t *":
        r"""
        as_idaplace_t(p) -> idaplace_t

        @param p: place_t *
        """
        return _ida_kernwin.place_t_as_idaplace_t(p)

    @staticmethod
    def as_simpleline_place_t(p: "place_t") -> "simpleline_place_t *":
        r"""
        as_simpleline_place_t(p) -> simpleline_place_t

        @param p: place_t *
        """
        return _ida_kernwin.place_t_as_simpleline_place_t(p)

    @staticmethod
    def as_tiplace_t(p: "place_t") -> "tiplace_t *":
        r"""
        as_tiplace_t(p) -> tiplace_t

        @param p: place_t *
        """
        return _ida_kernwin.place_t_as_tiplace_t(p)

    def generate(self, ud: "void *", maxsize: "int") -> "PyObject *":
        r"""
        generate(self, ud, maxsize) -> ([str, ...], int, int, int)
        Generate text lines for the current location.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @param maxsize: (C++: int) the maximum number of lines to generate
        @return: number of generated lines
        """
        return _ida_kernwin.place_t_generate(self, ud, maxsize)

# Register place_t in _ida_kernwin:
_ida_kernwin.place_t_swigregister(place_t)
cvar = _ida_kernwin.cvar
IDALIB_API_MAGIC = cvar.IDALIB_API_MAGIC

DEFAULT_PLACE_LNNUM = _ida_kernwin.DEFAULT_PLACE_LNNUM


def l_compare2(t1: "place_t", t2: "place_t", ud: "void *") -> "int":
    r"""
    l_compare2(t1, t2, ud) -> int

    @param t1: place_t const *
    @param t2: place_t const *
    @param ud: void *
    """
    return _ida_kernwin.l_compare2(t1, t2, ud)
class simpleline_t(object):
    r"""
    Proxy of C++ simpleline_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    line: "qstring" = property(_ida_kernwin.simpleline_t_line_get, _ida_kernwin.simpleline_t_line_set, doc=r"""line""")
    r"""
    line text
    """
    color: "color_t" = property(_ida_kernwin.simpleline_t_color_get, _ida_kernwin.simpleline_t_color_set, doc=r"""color""")
    r"""
    line prefix color
    """
    bgcolor: "bgcolor_t" = property(_ida_kernwin.simpleline_t_bgcolor_get, _ida_kernwin.simpleline_t_bgcolor_set, doc=r"""bgcolor""")
    r"""
    line background color
    """

    def __init__(self, *args):
        r"""
        __init__(self) -> simpleline_t
        __init__(self, c, str) -> simpleline_t

        @param c: color_t
        @param str: char const *

        __init__(self, str) -> simpleline_t

        @param str: char const *
        """
        _ida_kernwin.simpleline_t_swiginit(self, _ida_kernwin.new_simpleline_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_simpleline_t

# Register simpleline_t in _ida_kernwin:
_ida_kernwin.simpleline_t_swigregister(simpleline_t)
class simpleline_place_t(place_t):
    r"""
    Proxy of C++ simpleline_place_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    n: "uint32" = property(_ida_kernwin.simpleline_place_t_n_get, _ida_kernwin.simpleline_place_t_n_set, doc=r"""n""")
    r"""
    line number
    """

# Register simpleline_place_t in _ida_kernwin:
_ida_kernwin.simpleline_place_t_swigregister(simpleline_place_t)
class idaplace_t(place_t):
    r"""
    Proxy of C++ idaplace_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    ea: "ea_t" = property(_ida_kernwin.idaplace_t_ea_get, _ida_kernwin.idaplace_t_ea_set, doc=r"""ea""")
    r"""
    address
    """

# Register idaplace_t in _ida_kernwin:
_ida_kernwin.idaplace_t_swigregister(idaplace_t)

def is_tif_cursor_header(c: "tif_cursor_t") -> "bool":
    r"""
    is_tif_cursor_header(c) -> bool

    @param c: tif_cursor_t
    """
    return _ida_kernwin.is_tif_cursor_header(c)

def is_tif_cursor_footer(c: "tif_cursor_t") -> "bool":
    r"""
    is_tif_cursor_footer(c) -> bool

    @param c: tif_cursor_t
    """
    return _ida_kernwin.is_tif_cursor_footer(c)

def is_tif_cursor_index(c: "tif_cursor_t") -> "bool":
    r"""
    is_tif_cursor_index(c) -> bool

    @param c: tif_cursor_t
    """
    return _ida_kernwin.is_tif_cursor_index(c)
class tiplace_t(place_t):
    r"""
    Proxy of C++ tiplace_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    ordinal: "uint32" = property(_ida_kernwin.tiplace_t_ordinal_get, _ida_kernwin.tiplace_t_ordinal_set, doc=r"""ordinal""")
    cursor: "tif_cursor_t" = property(_ida_kernwin.tiplace_t_cursor_get, _ida_kernwin.tiplace_t_cursor_set, doc=r"""cursor""")

    def valid_ord(self) -> "bool":
        r"""
        valid_ord(self) -> bool
        """
        return _ida_kernwin.tiplace_t_valid_ord(self)

    def reset(self) -> "void":
        r"""
        reset(self)
        """
        return _ida_kernwin.tiplace_t_reset(self)

    def is_header(self) -> "bool":
        r"""
        is_header(self) -> bool
        """
        return _ida_kernwin.tiplace_t_is_header(self)

    def is_footer(self) -> "bool":
        r"""
        is_footer(self) -> bool
        """
        return _ida_kernwin.tiplace_t_is_footer(self)

    def is_index(self) -> "bool":
        r"""
        is_index(self) -> bool
        """
        return _ida_kernwin.tiplace_t_is_index(self)

    def set_header(self) -> "void":
        r"""
        set_header(self)
        """
        return _ida_kernwin.tiplace_t_set_header(self)

    def set_footer(self) -> "void":
        r"""
        set_footer(self)
        """
        return _ida_kernwin.tiplace_t_set_footer(self)

    def calc_udm_offset(self, ud: "void const *", p_udmidx: "ssize_t *"=None, p_bitoff: "int *"=None) -> "uint64":
        r"""
        calc_udm_offset(self, ud, p_udmidx=None, p_bitoff=None) -> uint64
        for structs: calculate the offset that corresponds to the tiplace.

        @param ud: (C++: const void *) pointer to user-defined context data. Is supplied by linearray_t
        @param p_udmidx: (C++: ssize_t *) place to return the index of the current udt member, if any. if
                         there is no member at the current offset, return -1
        @param p_bitoff: (C++: int *) place to return the bit offset of the item from the beginning
                         of the bit bucket if there no bitfields, return -1
        @return: the current offset or uint64(-1)
        """
        return _ida_kernwin.tiplace_t_calc_udm_offset(self, ud, p_udmidx, p_bitoff)

    def set_index_by_offset(self, ud: "void *", offset: "uint64") -> "void":
        r"""
        set_index_by_offset(self, ud, offset)
        for structs: calculate the index that corresponds to the offset and set it.

        @param ud: (C++: void *) pointer to user-defined context data. Is supplied by linearray_t
        @param offset: (C++: uint64) offset of udt member
        """
        return _ida_kernwin.tiplace_t_set_index_by_offset(self, ud, offset)

    def get_kind(self, ud: "void const *") -> "type_t":
        r"""
        get_kind(self, ud) -> type_t
        get the kind of type this place represents

        @param ud: (C++: const void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: one of BTF_TYPEDEF, BTF_STRUCT, BTF_UNION, BTF_ENUM or BT_UNK
        """
        return _ida_kernwin.tiplace_t_get_kind(self, ud)

    def fill_type_ref(self, out: "til_type_ref_t *", ud: "void const *") -> "bool":
        r"""
        fill_type_ref(self, out, ud) -> bool
        fill the type information for use in actions

        @param out: (C++: til_type_ref_t *) pointer to storage
        @param ud: (C++: const void *) pointer to user-defined context data. Is supplied by linearray_t
        @return: success
        """
        return _ida_kernwin.tiplace_t_fill_type_ref(self, out, ud)

# Register tiplace_t in _ida_kernwin:
_ida_kernwin.tiplace_t_swigregister(tiplace_t)
PCF_EA_CAPABLE = _ida_kernwin.PCF_EA_CAPABLE
r"""
toea() implementation returns meaningful data
"""

PCF_MAKEPLACE_ALLOCATES = _ida_kernwin.PCF_MAKEPLACE_ALLOCATES
r"""
makeplace() returns a freshly allocated (i.e., non-static) instance. All new
code should pass that flag to register_place_class(), and the corresponding
makeplace() class implementation should return new instances.
"""


def internal_register_place_class(tmplate: "place_t", flags: "int", owner: "plugin_t const *", sdk_version: "int") -> "int":
    r"""
    internal_register_place_class(tmplate, flags, owner, sdk_version) -> int

    @param tmplate: place_t const *
    @param flags: int
    @param owner: plugin_t const *
    @param sdk_version: int
    """
    return _ida_kernwin.internal_register_place_class(tmplate, flags, owner, sdk_version)

def get_place_class(out_flags: "int *", out_sdk_version: "int *", id: "int") -> "place_t const *":
    r"""
    get_place_class(out_flags, out_sdk_version, id) -> place_t
    Get information about a previously-registered place_t class. See also
    register_place_class().

    @param out_flags: (C++: int *) output flags (can be nullptr)
    @param out_sdk_version: (C++: int *) sdk version the place was created with (can be nullptr)
    @param id: (C++: int) place class ID
    @return: the place_t template, or nullptr if not found
    """
    return _ida_kernwin.get_place_class(out_flags, out_sdk_version, id)

def get_place_class_template(id: "int") -> "place_t const *":
    r"""
    get_place_class_template(id) -> place_t
    See get_place_class()

    @param id: (C++: int)
    """
    return _ida_kernwin.get_place_class_template(id)

def is_place_class_ea_capable(id: "int") -> "bool":
    r"""
    is_place_class_ea_capable(id) -> bool
    See get_place_class()

    @param id: (C++: int)
    """
    return _ida_kernwin.is_place_class_ea_capable(id)

def get_place_class_id(name: "char const *") -> "int":
    r"""
    get_place_class_id(name) -> int
    Get the place class ID for the place that has been registered as 'name'.

    @param name: (C++: const char *) the class name
    @return: the place class ID, or -1 if not found
    """
    return _ida_kernwin.get_place_class_id(name)
class sync_source_t(object):
    r"""
    Proxy of C++ sync_source_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self, _view) -> sync_source_t

        @param _view: TWidget const *

        __init__(self, _regname) -> sync_source_t

        @param _regname: char const *
        """
        _ida_kernwin.sync_source_t_swiginit(self, _ida_kernwin.new_sync_source_t(*args))

    def __eq__(self, _o: "sync_source_t") -> "bool":
        r"""
        __eq__(self, _o) -> bool

        @param _o: sync_source_t const &
        """
        return _ida_kernwin.sync_source_t___eq__(self, _o)

    def __ne__(self, _o: "sync_source_t") -> "bool":
        r"""
        __ne__(self, _o) -> bool

        @param _o: sync_source_t const &
        """
        return _ida_kernwin.sync_source_t___ne__(self, _o)

    def is_register(self) -> "bool":
        r"""
        is_register(self) -> bool
        """
        return _ida_kernwin.sync_source_t_is_register(self)

    def is_widget(self) -> "bool":
        r"""
        is_widget(self) -> bool
        """
        return _ida_kernwin.sync_source_t_is_widget(self)

    def get_widget(self) -> "TWidget const *":
        r"""
        get_widget(self) -> TWidget const *
        """
        return _ida_kernwin.sync_source_t_get_widget(self)

    def get_register(self) -> "char const *":
        r"""
        get_register(self) -> char const *
        """
        return _ida_kernwin.sync_source_t_get_register(self)
    __swig_destroy__ = _ida_kernwin.delete_sync_source_t

# Register sync_source_t in _ida_kernwin:
_ida_kernwin.sync_source_t_swigregister(sync_source_t)
class synced_group_t(sync_source_vec_t):
    r"""
    Proxy of C++ synced_group_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def has_widget(self, v: "TWidget const *") -> "bool":
        r"""
        has_widget(self, v) -> bool

        @param v: TWidget const *
        """
        return _ida_kernwin.synced_group_t_has_widget(self, v)

    def has_register(self, r: "char const *") -> "bool":
        r"""
        has_register(self, r) -> bool

        @param r: char const *
        """
        return _ida_kernwin.synced_group_t_has_register(self, r)

    def has(self, ss: "sync_source_t") -> "bool":
        r"""
        has(self, ss) -> bool

        @param ss: sync_source_t const &
        """
        return _ida_kernwin.synced_group_t_has(self, ss)

    def __init__(self):
        r"""
        __init__(self) -> synced_group_t
        """
        _ida_kernwin.synced_group_t_swiginit(self, _ida_kernwin.new_synced_group_t())
    __swig_destroy__ = _ida_kernwin.delete_synced_group_t

# Register synced_group_t in _ida_kernwin:
_ida_kernwin.synced_group_t_swigregister(synced_group_t)
LECVT_CANCELED = _ida_kernwin.LECVT_CANCELED

LECVT_ERROR = _ida_kernwin.LECVT_ERROR

LECVT_OK = _ida_kernwin.LECVT_OK

LECVT_WITHIN_LISTING = _ida_kernwin.LECVT_WITHIN_LISTING

class twinpos_t(object):
    r"""
    Proxy of C++ twinpos_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    at: "place_t *" = property(_ida_kernwin.twinpos_t_at_get, _ida_kernwin.twinpos_t_at_set, doc=r"""at""")
    r"""
    location in view
    """
    x: "int" = property(_ida_kernwin.twinpos_t_x_get, _ida_kernwin.twinpos_t_x_set, doc=r"""x""")
    r"""
    cursor x
    """

    def __init__(self, *args):
        r"""
        __init__(self) -> twinpos_t
        __init__(self, t) -> twinpos_t

        @param t: place_t *

        __init__(self, t, x0) -> twinpos_t

        @param t: place_t *
        @param x0: int
        """
        _ida_kernwin.twinpos_t_swiginit(self, _ida_kernwin.new_twinpos_t(*args))

    def place_as_idaplace_t(self):
        return place_t.as_idaplace_t(self.at)
    def place_as_simpleline_place_t(self):
        return place_t.as_simpleline_place_t(self.at)
    def place_as_tiplace_t(self):
        return place_t.as_tiplace_t(self.at)

    def place(self, view):
        ptype = get_viewer_place_type(view)
        if ptype == TCCPT_IDAPLACE:
            return self.place_as_idaplace_t()
        elif ptype == TCCPT_SIMPLELINE_PLACE:
            return self.place_as_simpleline_place_t()
        elif ptype == TCCPT_TIPLACE:
            return self.place_as_simpleline_place_t()
        else:
            return self.at

    __swig_destroy__ = _ida_kernwin.delete_twinpos_t

# Register twinpos_t in _ida_kernwin:
_ida_kernwin.twinpos_t_swigregister(twinpos_t)
class twinline_t(object):
    r"""
    Proxy of C++ twinline_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    at: "place_t *" = property(_ida_kernwin.twinline_t_at_get, _ida_kernwin.twinline_t_at_set, doc=r"""at""")
    r"""
    location in view
    """
    line: "qstring" = property(_ida_kernwin.twinline_t_line_get, _ida_kernwin.twinline_t_line_set, doc=r"""line""")
    r"""
    line contents
    """
    prefix_color: "color_t" = property(_ida_kernwin.twinline_t_prefix_color_get, _ida_kernwin.twinline_t_prefix_color_set, doc=r"""prefix_color""")
    r"""
    line prefix color
    """
    bg_color: "bgcolor_t" = property(_ida_kernwin.twinline_t_bg_color_get, _ida_kernwin.twinline_t_bg_color_set, doc=r"""bg_color""")
    r"""
    line background color
    """
    is_default: "bool" = property(_ida_kernwin.twinline_t_is_default_get, _ida_kernwin.twinline_t_is_default_set, doc=r"""is_default""")
    r"""
    is this the default line of the current location?
    """

    def __init__(self, *args):
        r"""
        __init__(self) -> twinline_t
        __init__(self, t, pc, bc) -> twinline_t

        @param t: place_t *
        @param pc: color_t
        @param bc: bgcolor_t
        """
        _ida_kernwin.twinline_t_swiginit(self, _ida_kernwin.new_twinline_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_twinline_t

# Register twinline_t in _ida_kernwin:
_ida_kernwin.twinline_t_swigregister(twinline_t)
class linearray_t(object):
    r"""
    Proxy of C++ linearray_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, _ud: "void *"):
        r"""
        __init__(self, _ud) -> linearray_t

        @param _ud: void *
        """
        _ida_kernwin.linearray_t_swiginit(self, _ida_kernwin.new_linearray_t(_ud))
    __swig_destroy__ = _ida_kernwin.delete_linearray_t

    def set_place(self, new_at: "place_t") -> "int":
        r"""
        set_place(self, new_at) -> int
        Position the array. This function must be called before calling any other member
        functions.

        linearray_t doesn't own place_t structures. The caller must take care of place_t
        objects.

        @param new_at: (C++: const place_t *) new position of the array
        @return: the delta of lines that the linearray_t had to adjust the place by.
        For example, if the place_t has a lnnum of 5, but it turns out, upon generating
        lines,
        that the number of lines for that particular place is only 2, then 3 will be
        returned.
        """
        return _ida_kernwin.linearray_t_set_place(self, new_at)

    def get_place(self) -> "place_t *":
        r"""
        get_place(self) -> place_t
        Get the current place. If called before down(), then returns place of line which
        will be returned by down(). If called after up(), then returns place if line
        returned by up().
        """
        return _ida_kernwin.linearray_t_get_place(self)

    def get_bg_color(self) -> "bgcolor_t":
        r"""
        get_bg_color(self) -> bgcolor_t
        Get current background color. (the same behavior as with get_place(): good
        before down() and after up())
        """
        return _ida_kernwin.linearray_t_get_bg_color(self)

    def get_pfx_color(self) -> "bgcolor_t":
        r"""
        get_pfx_color(self) -> bgcolor_t
        Get current prefix color. (the same behavior as with get_place(): good before
        down() and after up())
        """
        return _ida_kernwin.linearray_t_get_pfx_color(self)

    def get_dlnnum(self) -> "int":
        r"""
        get_dlnnum(self) -> int
        Get default line number. (the same behavior as with get_place(): good before
        down() and after up())
        """
        return _ida_kernwin.linearray_t_get_dlnnum(self)

    def get_linecnt(self) -> "int":
        r"""
        get_linecnt(self) -> int
        Get number of lines for the current place. (the same behavior as with
        get_place(): good before down() and after up())
        """
        return _ida_kernwin.linearray_t_get_linecnt(self)

    def userdata(self) -> "void *":
        r"""
        userdata(self) -> void *
        Get pointer to user data.
        """
        return _ida_kernwin.linearray_t_userdata(self)

    def set_userdata(self, userd: "void *") -> "void":
        r"""
        set_userdata(self, userd)
        Change the user data.

        @param userd: (C++: void *)
        """
        return _ida_kernwin.linearray_t_set_userdata(self, userd)

    def beginning(self) -> "bool":
        r"""
        beginning(self) -> bool
        Are we at the beginning?
        """
        return _ida_kernwin.linearray_t_beginning(self)

    def ending(self) -> "bool":
        r"""
        ending(self) -> bool
        """
        return _ida_kernwin.linearray_t_ending(self)

    def down(self) -> "qstring const *":
        r"""
        down(self) -> qstring const *
        Get a line from down direction. place is ok BEFORE
        """
        return _ida_kernwin.linearray_t_down(self)

    def up(self) -> "qstring const *":
        r"""
        up(self) -> qstring const *
        Get a line from up direction. place is ok AFTER
        """
        return _ida_kernwin.linearray_t_up(self)

# Register linearray_t in _ida_kernwin:
_ida_kernwin.linearray_t_swigregister(linearray_t)
class lines_rendering_input_t(object):
    r"""
    Proxy of C++ lines_rendering_input_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cb: "int" = property(_ida_kernwin.lines_rendering_input_t_cb_get, _ida_kernwin.lines_rendering_input_t_cb_set, doc=r"""cb""")
    sections_lines: "sections_lines_refs_t" = property(_ida_kernwin.lines_rendering_input_t_sections_lines_get, _ida_kernwin.lines_rendering_input_t_sections_lines_set, doc=r"""sections_lines""")
    r"""
    references to the lines that are used for rendering
    """
    sync_group: "synced_group_t const *" = property(_ida_kernwin.lines_rendering_input_t_sync_group_get, _ida_kernwin.lines_rendering_input_t_sync_group_set, doc=r"""sync_group""")
    r"""
    the 'synced' group 'widget' (see ui_get_lines_rendering_info) belongs to, or
    nullptr
    """

    def __init__(self):
        r"""
        __init__(self) -> lines_rendering_input_t
        """
        _ida_kernwin.lines_rendering_input_t_swiginit(self, _ida_kernwin.new_lines_rendering_input_t())
    __swig_destroy__ = _ida_kernwin.delete_lines_rendering_input_t

# Register lines_rendering_input_t in _ida_kernwin:
_ida_kernwin.lines_rendering_input_t_swigregister(lines_rendering_input_t)
CK_TRACE = _ida_kernwin.CK_TRACE
r"""
traced address
"""

CK_TRACE_OVL = _ida_kernwin.CK_TRACE_OVL
r"""
overlay trace address
"""

CK_EXTRA1 = _ida_kernwin.CK_EXTRA1
r"""
extra background overlay #1
"""

CK_EXTRA2 = _ida_kernwin.CK_EXTRA2
r"""
extra background overlay #2
"""

CK_EXTRA3 = _ida_kernwin.CK_EXTRA3
r"""
extra background overlay #3
"""

CK_EXTRA4 = _ida_kernwin.CK_EXTRA4
r"""
extra background overlay #4
"""

CK_EXTRA5 = _ida_kernwin.CK_EXTRA5
r"""
extra background overlay #5
"""

CK_EXTRA6 = _ida_kernwin.CK_EXTRA6
r"""
extra background overlay #6
"""

CK_EXTRA7 = _ida_kernwin.CK_EXTRA7
r"""
extra background overlay #7
"""

CK_EXTRA8 = _ida_kernwin.CK_EXTRA8
r"""
extra background overlay #8
"""

CK_EXTRA9 = _ida_kernwin.CK_EXTRA9
r"""
extra background overlay #9
"""

CK_EXTRA10 = _ida_kernwin.CK_EXTRA10
r"""
extra background overlay #10
"""

CK_EXTRA11 = _ida_kernwin.CK_EXTRA11
r"""
extra background overlay #11
"""

CK_EXTRA12 = _ida_kernwin.CK_EXTRA12
r"""
extra background overlay #12
"""

CK_EXTRA13 = _ida_kernwin.CK_EXTRA13
r"""
extra background overlay #13
"""

CK_EXTRA14 = _ida_kernwin.CK_EXTRA14
r"""
extra background overlay #14
"""

CK_EXTRA15 = _ida_kernwin.CK_EXTRA15
r"""
extra background overlay #15
"""

CK_EXTRA16 = _ida_kernwin.CK_EXTRA16
r"""
extra background overlay #16
"""

LROEF_MASK = _ida_kernwin.LROEF_MASK

LROEF_FULL_LINE = _ida_kernwin.LROEF_FULL_LINE
r"""
full line background
"""

LROEF_CPS_RANGE = _ida_kernwin.LROEF_CPS_RANGE
r"""
background for range of chars
"""

class line_rendering_output_entry_t(object):
    r"""
    Proxy of C++ line_rendering_output_entry_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    line: "twinline_t const *" = property(_ida_kernwin.line_rendering_output_entry_t_line_get, _ida_kernwin.line_rendering_output_entry_t_line_set, doc=r"""line""")
    flags: "uint32" = property(_ida_kernwin.line_rendering_output_entry_t_flags_get, _ida_kernwin.line_rendering_output_entry_t_flags_set, doc=r"""flags""")
    r"""
    line_rendering_output_entry_t flags
    """
    bg_color: "bgcolor_t" = property(_ida_kernwin.line_rendering_output_entry_t_bg_color_get, _ida_kernwin.line_rendering_output_entry_t_bg_color_set, doc=r"""bg_color""")
    cpx: "int" = property(_ida_kernwin.line_rendering_output_entry_t_cpx_get, _ida_kernwin.line_rendering_output_entry_t_cpx_set, doc=r"""cpx""")
    r"""
    number of char to start from, valid if LROEF_CPS_RANGE
    """
    nchars: "int" = property(_ida_kernwin.line_rendering_output_entry_t_nchars_get, _ida_kernwin.line_rendering_output_entry_t_nchars_set, doc=r"""nchars""")
    r"""
    chars count, valid if LROEF_CPS_RANGE
    """

    def __init__(self, *args):
        r"""
        __init__(self, _line, _flags=0, _bg_color=0) -> line_rendering_output_entry_t

        @param _line: twinline_t const *
        @param _flags: uint32
        @param _bg_color: bgcolor_t

        __init__(self, _line, _cpx, _nchars, _flags, _bg_color) -> line_rendering_output_entry_t

        @param _line: twinline_t const *
        @param _cpx: int
        @param _nchars: int
        @param _flags: uint32
        @param _bg_color: bgcolor_t
        """
        _ida_kernwin.line_rendering_output_entry_t_swiginit(self, _ida_kernwin.new_line_rendering_output_entry_t(*args))

    def is_bg_color_empty(self) -> "bool":
        r"""
        is_bg_color_empty(self) -> bool
        """
        return _ida_kernwin.line_rendering_output_entry_t_is_bg_color_empty(self)

    def is_bg_color_key(self) -> "bool":
        r"""
        is_bg_color_key(self) -> bool
        """
        return _ida_kernwin.line_rendering_output_entry_t_is_bg_color_key(self)

    def is_bg_color_direct(self) -> "bool":
        r"""
        is_bg_color_direct(self) -> bool
        """
        return _ida_kernwin.line_rendering_output_entry_t_is_bg_color_direct(self)

    def __eq__(self, r: "line_rendering_output_entry_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: line_rendering_output_entry_t const &
        """
        return _ida_kernwin.line_rendering_output_entry_t___eq__(self, r)

    def __ne__(self, r: "line_rendering_output_entry_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: line_rendering_output_entry_t const &
        """
        return _ida_kernwin.line_rendering_output_entry_t___ne__(self, r)
    __swig_destroy__ = _ida_kernwin.delete_line_rendering_output_entry_t

# Register line_rendering_output_entry_t in _ida_kernwin:
_ida_kernwin.line_rendering_output_entry_t_swigregister(line_rendering_output_entry_t)
class lines_rendering_output_t(object):
    r"""
    Proxy of C++ lines_rendering_output_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    entries: "line_rendering_output_entries_refs_t" = property(_ida_kernwin.lines_rendering_output_t_entries_get, _ida_kernwin.lines_rendering_output_t_entries_set, doc=r"""entries""")
    flags: "uint32" = property(_ida_kernwin.lines_rendering_output_t_flags_get, _ida_kernwin.lines_rendering_output_t_flags_set, doc=r"""flags""")

    def __init__(self):
        r"""
        __init__(self) -> lines_rendering_output_t
        """
        _ida_kernwin.lines_rendering_output_t_swiginit(self, _ida_kernwin.new_lines_rendering_output_t())
    __swig_destroy__ = _ida_kernwin.delete_lines_rendering_output_t

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.lines_rendering_output_t_clear(self)

    def __eq__(self, r: "lines_rendering_output_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: lines_rendering_output_t const &
        """
        return _ida_kernwin.lines_rendering_output_t___eq__(self, r)

    def __ne__(self, r: "lines_rendering_output_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: lines_rendering_output_t const &
        """
        return _ida_kernwin.lines_rendering_output_t___ne__(self, r)

    def swap(self, r: "lines_rendering_output_t") -> "void":
        r"""
        swap(self, r)

        @param r: lines_rendering_output_t &
        """
        return _ida_kernwin.lines_rendering_output_t_swap(self, r)

# Register lines_rendering_output_t in _ida_kernwin:
_ida_kernwin.lines_rendering_output_t_swigregister(lines_rendering_output_t)
class line_section_t(object):
    r"""
    Proxy of C++ line_section_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    start: "cpidx_t" = property(_ida_kernwin.line_section_t_start_get, _ida_kernwin.line_section_t_start_set, doc=r"""start""")
    length: "cplen_t" = property(_ida_kernwin.line_section_t_length_get, _ida_kernwin.line_section_t_length_set, doc=r"""length""")

    def contains(self, x: "cpidx_t") -> "bool":
        r"""
        contains(self, x) -> bool

        @param x: cpidx_t
        """
        return _ida_kernwin.line_section_t_contains(self, x)

    def is_open(self) -> "bool":
        r"""
        is_open(self) -> bool
        """
        return _ida_kernwin.line_section_t_is_open(self)

    def is_closed(self) -> "bool":
        r"""
        is_closed(self) -> bool
        """
        return _ida_kernwin.line_section_t_is_closed(self)

    def valid(self) -> "bool":
        r"""
        valid(self) -> bool
        """
        return _ida_kernwin.line_section_t_valid(self)

    def __init__(self):
        r"""
        __init__(self) -> line_section_t
        """
        _ida_kernwin.line_section_t_swiginit(self, _ida_kernwin.new_line_section_t())
    __swig_destroy__ = _ida_kernwin.delete_line_section_t

# Register line_section_t in _ida_kernwin:
_ida_kernwin.line_section_t_swigregister(line_section_t)
class tagged_line_section_t(line_section_t):
    r"""
    Proxy of C++ tagged_line_section_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    tag: "color_t" = property(_ida_kernwin.tagged_line_section_t_tag_get, _ida_kernwin.tagged_line_section_t_tag_set, doc=r"""tag""")

    def __init__(self):
        r"""
        __init__(self) -> tagged_line_section_t
        """
        _ida_kernwin.tagged_line_section_t_swiginit(self, _ida_kernwin.new_tagged_line_section_t())

    def valid(self) -> "bool":
        r"""
        valid(self) -> bool
        """
        return _ida_kernwin.tagged_line_section_t_valid(self)

    def valid_in(self, _in: "qstring const &") -> "bool":
        r"""
        valid_in(self, _in) -> bool

        @param in: qstring const &
        """
        return _ida_kernwin.tagged_line_section_t_valid_in(self, _in)

    def substr(self, _in: "qstring const &", end: "tagged_line_section_t"=None) -> "bool":
        r"""
        substr(self, _in, end=None) -> bool

        @param in: qstring const &
        @param end: tagged_line_section_t const *
        """
        return _ida_kernwin.tagged_line_section_t_substr(self, _in, end)
    __swig_destroy__ = _ida_kernwin.delete_tagged_line_section_t

# Register tagged_line_section_t in _ida_kernwin:
_ida_kernwin.tagged_line_section_t_swigregister(tagged_line_section_t)
class tagged_line_sections_t(object):
    r"""
    Proxy of C++ tagged_line_sections_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def sections_at(self, out: "tagged_line_sections_t", x: "cpidx_t", tag: "color_t"=0) -> "void":
        r"""
        sections_at(self, out, x, tag=0)

        @param out: tagged_line_sections_t *
        @param x: cpidx_t
        @param tag: color_t
        """
        return _ida_kernwin.tagged_line_sections_t_sections_at(self, out, x, tag)

    def nearest_at(self, x: "cpidx_t", tag: "color_t"=0) -> "tagged_line_section_t const *":
        r"""
        nearest_at(self, x, tag=0) -> tagged_line_section_t

        @param x: cpidx_t
        @param tag: color_t
        """
        return _ida_kernwin.tagged_line_sections_t_nearest_at(self, x, tag)

    def nearest_before(self, range: "tagged_line_section_t", start: "cpidx_t", tag: "color_t"=0) -> "tagged_line_section_t const *":
        r"""
        nearest_before(self, range, start, tag=0) -> tagged_line_section_t

        @param range: tagged_line_section_t const &
        @param start: cpidx_t
        @param tag: color_t
        """
        return _ida_kernwin.tagged_line_sections_t_nearest_before(self, range, start, tag)

    def nearest_after(self, range: "tagged_line_section_t", start: "cpidx_t", tag: "color_t"=0) -> "tagged_line_section_t const *":
        r"""
        nearest_after(self, range, start, tag=0) -> tagged_line_section_t

        @param range: tagged_line_section_t const &
        @param start: cpidx_t
        @param tag: color_t
        """
        return _ida_kernwin.tagged_line_sections_t_nearest_after(self, range, start, tag)

    def __init__(self):
        r"""
        __init__(self) -> tagged_line_sections_t
        """
        _ida_kernwin.tagged_line_sections_t_swiginit(self, _ida_kernwin.new_tagged_line_sections_t())
    __swig_destroy__ = _ida_kernwin.delete_tagged_line_sections_t

# Register tagged_line_sections_t in _ida_kernwin:
_ida_kernwin.tagged_line_sections_t_swigregister(tagged_line_sections_t)
class listing_location_t(object):
    r"""
    Proxy of C++ listing_location_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cb: "int" = property(_ida_kernwin.listing_location_t_cb_get, _ida_kernwin.listing_location_t_cb_set, doc=r"""cb""")
    loc: "lochist_entry_t const *" = property(_ida_kernwin.listing_location_t_loc_get, _ida_kernwin.listing_location_t_loc_set, doc=r"""loc""")
    text: "qstring const *" = property(_ida_kernwin.listing_location_t_text_get, _ida_kernwin.listing_location_t_text_set, doc=r"""text""")
    tagged_sections: "tagged_line_sections_t const *" = property(_ida_kernwin.listing_location_t_tagged_sections_get, _ida_kernwin.listing_location_t_tagged_sections_set, doc=r"""tagged_sections""")

    def __init__(self):
        r"""
        __init__(self) -> listing_location_t
        """
        _ida_kernwin.listing_location_t_swiginit(self, _ida_kernwin.new_listing_location_t())
    __swig_destroy__ = _ida_kernwin.delete_listing_location_t

# Register listing_location_t in _ida_kernwin:
_ida_kernwin.listing_location_t_swigregister(listing_location_t)

def request_refresh(mask: "uint64", cnd: "bool"=True) -> "void":
    r"""
    request_refresh(mask, cnd=True)
    Request a refresh of a builtin window.

    @param mask: (C++: uint64) Window refresh flags
    @param cnd: (C++: bool) set if true or clear flag otherwise
    """
    return _ida_kernwin.request_refresh(mask, cnd)

def clear_refresh_request(mask: "uint64") -> "void":
    r"""
    clear_refresh_request(mask)

    @param mask: uint64
    """
    return _ida_kernwin.clear_refresh_request(mask)

def is_refresh_requested(mask: "uint64") -> "bool":
    r"""
    is_refresh_requested(mask) -> bool
    Get a refresh request state

    @param mask: (C++: uint64) Window refresh flags
    @return: the state (set or cleared)
    """
    return _ida_kernwin.is_refresh_requested(mask)
BWN_UNKNOWN = _ida_kernwin.BWN_UNKNOWN
r"""
unknown window
"""

BWN_EXPORTS = _ida_kernwin.BWN_EXPORTS
r"""
exports
"""

BWN_IMPORTS = _ida_kernwin.BWN_IMPORTS
r"""
imports
"""

BWN_NAMES = _ida_kernwin.BWN_NAMES
r"""
names
"""

BWN_FUNCS = _ida_kernwin.BWN_FUNCS
r"""
functions
"""

BWN_STRINGS = _ida_kernwin.BWN_STRINGS
r"""
strings
"""

BWN_SEGS = _ida_kernwin.BWN_SEGS
r"""
segments
"""

BWN_SEGREGS = _ida_kernwin.BWN_SEGREGS
r"""
segment registers
"""

BWN_SELS = _ida_kernwin.BWN_SELS
r"""
selectors
"""

BWN_SIGNS = _ida_kernwin.BWN_SIGNS
r"""
signatures
"""

BWN_TILS = _ida_kernwin.BWN_TILS
r"""
type libraries
"""

BWN_TILVIEW = _ida_kernwin.BWN_TILVIEW
r"""
local types
"""

BWN_CALLS = _ida_kernwin.BWN_CALLS
r"""
function calls
"""

BWN_PROBS = _ida_kernwin.BWN_PROBS
r"""
problems
"""

BWN_BPTS = _ida_kernwin.BWN_BPTS
r"""
breakpoints
"""

BWN_THREADS = _ida_kernwin.BWN_THREADS
r"""
threads
"""

BWN_MODULES = _ida_kernwin.BWN_MODULES
r"""
modules
"""

BWN_TRACE = _ida_kernwin.BWN_TRACE
r"""
tracing view
"""

BWN_CALL_STACK = _ida_kernwin.BWN_CALL_STACK
r"""
call stack
"""

BWN_XREFS = _ida_kernwin.BWN_XREFS
r"""
xrefs
"""

BWN_SEARCH = _ida_kernwin.BWN_SEARCH
r"""
search results
"""

BWN_FRAME = _ida_kernwin.BWN_FRAME
r"""
function frame
"""

BWN_NAVBAND = _ida_kernwin.BWN_NAVBAND
r"""
navigation band
"""

BWN_DISASM = _ida_kernwin.BWN_DISASM
r"""
disassembly views
"""

BWN_DUMP = _ida_kernwin.BWN_DUMP
r"""
hex dumps
"""

BWN_NOTEPAD = _ida_kernwin.BWN_NOTEPAD
r"""
notepad
"""

BWN_OUTPUT = _ida_kernwin.BWN_OUTPUT
r"""
the text area, in the output window
"""

BWN_CLI = _ida_kernwin.BWN_CLI
r"""
the command-line, in the output window
"""

BWN_WATCH = _ida_kernwin.BWN_WATCH
r"""
the 'watches' debugger window
"""

BWN_LOCALS = _ida_kernwin.BWN_LOCALS
r"""
the 'locals' debugger window
"""

BWN_STKVIEW = _ida_kernwin.BWN_STKVIEW
r"""
the 'Stack view' debugger window
"""

BWN_CHOOSER = _ida_kernwin.BWN_CHOOSER
r"""
a non-builtin chooser
"""

BWN_SHORTCUTCSR = _ida_kernwin.BWN_SHORTCUTCSR
r"""
the shortcuts chooser (Qt version only)
"""

BWN_SHORTCUTWIN = _ida_kernwin.BWN_SHORTCUTWIN
r"""
the shortcuts window (Qt version only)
"""

BWN_CPUREGS = _ida_kernwin.BWN_CPUREGS
r"""
one of the 'General registers', 'FPU register', ... debugger windows
"""

BWN_SO_STRUCTS = _ida_kernwin.BWN_SO_STRUCTS
r"""
the 'Structure offsets' dialog's 'Structures and Unions' panel
"""

BWN_SO_OFFSETS = _ida_kernwin.BWN_SO_OFFSETS
r"""
the 'Structure offsets' dialog's offset panel
"""

BWN_CMDPALCSR = _ida_kernwin.BWN_CMDPALCSR
r"""
the command palette chooser (Qt version only)
"""

BWN_CMDPALWIN = _ida_kernwin.BWN_CMDPALWIN
r"""
the command palette window (Qt version only)
"""

BWN_SNIPPETS = _ida_kernwin.BWN_SNIPPETS
r"""
the 'Execute script' window
"""

BWN_CUSTVIEW = _ida_kernwin.BWN_CUSTVIEW
r"""
custom viewers
"""

BWN_ADDRWATCH = _ida_kernwin.BWN_ADDRWATCH
r"""
the 'Watch List' window
"""

BWN_PSEUDOCODE = _ida_kernwin.BWN_PSEUDOCODE
r"""
hexrays decompiler views
"""

BWN_CALLS_CALLERS = _ida_kernwin.BWN_CALLS_CALLERS
r"""
function calls, callers
"""

BWN_CALLS_CALLEES = _ida_kernwin.BWN_CALLS_CALLEES
r"""
function calls, callees
"""

BWN_MDVIEWCSR = _ida_kernwin.BWN_MDVIEWCSR
r"""
lumina metadata view chooser
"""

BWN_DISASM_ARROWS = _ida_kernwin.BWN_DISASM_ARROWS
r"""
disassembly arrows widget
"""

BWN_CV_LINE_INFOS = _ida_kernwin.BWN_CV_LINE_INFOS
r"""
custom viewers' lineinfo widget
"""

BWN_SRCPTHMAP_CSR = _ida_kernwin.BWN_SRCPTHMAP_CSR
r"""
"Source paths..."'s path mappings chooser
"""

BWN_SRCPTHUND_CSR = _ida_kernwin.BWN_SRCPTHUND_CSR
r"""
"Source paths..."'s undesired paths chooser
"""

BWN_UNDOHIST = _ida_kernwin.BWN_UNDOHIST
r"""
Undo history.
"""

BWN_SNIPPETS_CSR = _ida_kernwin.BWN_SNIPPETS_CSR
r"""
the list of snippets in the 'Execute script' window
"""

BWN_SCRIPTS_CSR = _ida_kernwin.BWN_SCRIPTS_CSR
r"""
the "Recent scripts" chooser
"""

BWN_BOOKMARKS = _ida_kernwin.BWN_BOOKMARKS
r"""
a persistent 'Bookmarks' widget
"""

BWN_TILIST = _ida_kernwin.BWN_TILIST
r"""
a type listing widget
"""

BWN_STACK = _ida_kernwin.BWN_STACK
r"""
Alias. Some BWN_* were confusing, and thus have been renamed. This is to ensure
bw-compat.
"""

BWN_DISASMS = _ida_kernwin.BWN_DISASMS
r"""
Alias. Some BWN_* were confusing, and thus have been renamed. This is to ensure
bw-compat.
"""

BWN_DUMPS = _ida_kernwin.BWN_DUMPS
r"""
Alias. Some BWN_* were confusing, and thus have been renamed. This is to ensure
bw-compat.
"""

BWN_SEARCHS = _ida_kernwin.BWN_SEARCHS
r"""
Alias. Some BWN_* were confusing, and thus have been renamed. This is to ensure
bw-compat.
"""

IWID_EXPORTS = _ida_kernwin.IWID_EXPORTS
r"""
exports
"""

IWID_IMPORTS = _ida_kernwin.IWID_IMPORTS
r"""
imports
"""

IWID_NAMES = _ida_kernwin.IWID_NAMES
r"""
names
"""

IWID_FUNCS = _ida_kernwin.IWID_FUNCS
r"""
functions
"""

IWID_STRINGS = _ida_kernwin.IWID_STRINGS
r"""
strings
"""

IWID_SEGS = _ida_kernwin.IWID_SEGS
r"""
segments
"""

IWID_SEGREGS = _ida_kernwin.IWID_SEGREGS
r"""
segment registers
"""

IWID_SELS = _ida_kernwin.IWID_SELS
r"""
selectors
"""

IWID_SIGNS = _ida_kernwin.IWID_SIGNS
r"""
signatures
"""

IWID_TILS = _ida_kernwin.IWID_TILS
r"""
type libraries
"""

IWID_TILVIEW = _ida_kernwin.IWID_TILVIEW
r"""
local types
"""

IWID_CALLS = _ida_kernwin.IWID_CALLS
r"""
function calls
"""

IWID_PROBS = _ida_kernwin.IWID_PROBS
r"""
problems
"""

IWID_BPTS = _ida_kernwin.IWID_BPTS
r"""
breakpoints
"""

IWID_THREADS = _ida_kernwin.IWID_THREADS
r"""
threads
"""

IWID_MODULES = _ida_kernwin.IWID_MODULES
r"""
modules
"""

IWID_TRACE = _ida_kernwin.IWID_TRACE
r"""
tracing view
"""

IWID_CALL_STACK = _ida_kernwin.IWID_CALL_STACK
r"""
call stack
"""

IWID_XREFS = _ida_kernwin.IWID_XREFS
r"""
xrefs
"""

IWID_SEARCH = _ida_kernwin.IWID_SEARCH
r"""
search results
"""

IWID_FRAME = _ida_kernwin.IWID_FRAME
r"""
function frame
"""

IWID_NAVBAND = _ida_kernwin.IWID_NAVBAND
r"""
navigation band
"""

IWID_DISASM = _ida_kernwin.IWID_DISASM
r"""
disassembly views
"""

IWID_DUMP = _ida_kernwin.IWID_DUMP
r"""
hex dumps
"""

IWID_NOTEPAD = _ida_kernwin.IWID_NOTEPAD
r"""
notepad
"""

IWID_OUTPUT = _ida_kernwin.IWID_OUTPUT
r"""
output
"""

IWID_CLI = _ida_kernwin.IWID_CLI
r"""
input line
"""

IWID_WATCH = _ida_kernwin.IWID_WATCH
r"""
watches
"""

IWID_LOCALS = _ida_kernwin.IWID_LOCALS
r"""
locals
"""

IWID_STKVIEW = _ida_kernwin.IWID_STKVIEW
r"""
stack view
"""

IWID_CHOOSER = _ida_kernwin.IWID_CHOOSER
r"""
chooser
"""

IWID_SHORTCUTCSR = _ida_kernwin.IWID_SHORTCUTCSR
r"""
shortcuts chooser
"""

IWID_SHORTCUTWIN = _ida_kernwin.IWID_SHORTCUTWIN
r"""
shortcuts window
"""

IWID_CPUREGS = _ida_kernwin.IWID_CPUREGS
r"""
registers
"""

IWID_SO_STRUCTS = _ida_kernwin.IWID_SO_STRUCTS
r"""
stroff
"""

IWID_SO_OFFSETS = _ida_kernwin.IWID_SO_OFFSETS
r"""
stroff
"""

IWID_CMDPALCSR = _ida_kernwin.IWID_CMDPALCSR
r"""
command palette
"""

IWID_CMDPALWIN = _ida_kernwin.IWID_CMDPALWIN
r"""
command palette
"""

IWID_SNIPPETS = _ida_kernwin.IWID_SNIPPETS
r"""
snippets
"""

IWID_CUSTVIEW = _ida_kernwin.IWID_CUSTVIEW
r"""
custom viewers
"""

IWID_ADDRWATCH = _ida_kernwin.IWID_ADDRWATCH
r"""
address watches
"""

IWID_PSEUDOCODE = _ida_kernwin.IWID_PSEUDOCODE
r"""
decompiler
"""

IWID_CALLS_CALLERS = _ida_kernwin.IWID_CALLS_CALLERS
r"""
funcalls, callers
"""

IWID_CALLS_CALLEES = _ida_kernwin.IWID_CALLS_CALLEES
r"""
funcalls, callees
"""

IWID_MDVIEWCSR = _ida_kernwin.IWID_MDVIEWCSR
r"""
lumina md view
"""

IWID_DISASM_ARROWS = _ida_kernwin.IWID_DISASM_ARROWS
r"""
arrows widget
"""

IWID_CV_LINE_INFOS = _ida_kernwin.IWID_CV_LINE_INFOS
r"""
lineinfo widget
"""

IWID_SRCPTHMAP_CSR = _ida_kernwin.IWID_SRCPTHMAP_CSR
r"""
mappings chooser
"""

IWID_SRCPTHUND_CSR = _ida_kernwin.IWID_SRCPTHUND_CSR
r"""
undesired chooser
"""

IWID_UNDOHIST = _ida_kernwin.IWID_UNDOHIST
r"""
Undo history.
"""

IWID_SNIPPETS_CSR = _ida_kernwin.IWID_SNIPPETS_CSR
r"""
snippets chooser
"""

IWID_SCRIPTS_CSR = _ida_kernwin.IWID_SCRIPTS_CSR
r"""
recent scripts
"""

IWID_BOOKMARKS = _ida_kernwin.IWID_BOOKMARKS
r"""
bookmarks list
"""

IWID_TILIST = _ida_kernwin.IWID_TILIST
r"""
type listing
"""

IWID_ALL = _ida_kernwin.IWID_ALL
r"""
mask
"""

IWID_STACK = _ida_kernwin.IWID_STACK
r"""
Alias. Some IWID_* were confusing, and thus have been renamed. This is to ensure
bw-compat.
"""

IWID_DISASMS = _ida_kernwin.IWID_DISASMS

IWID_DUMPS = _ida_kernwin.IWID_DUMPS

IWID_SEARCHS = _ida_kernwin.IWID_SEARCHS


def is_chooser_widget(t: "twidget_type_t") -> "bool":
    r"""
    is_chooser_widget(t) -> bool
    Does the given widget type specify a chooser widget?

    @param t: (C++: twidget_type_t)
    """
    return _ida_kernwin.is_chooser_widget(t)
IDA_DEBUG_DREFS = _ida_kernwin.IDA_DEBUG_DREFS
r"""
drefs
"""

IDA_DEBUG_OFFSET = _ida_kernwin.IDA_DEBUG_OFFSET
r"""
offsets
"""

IDA_DEBUG_FLIRT = _ida_kernwin.IDA_DEBUG_FLIRT
r"""
flirt
"""

IDA_DEBUG_IDP = _ida_kernwin.IDA_DEBUG_IDP
r"""
idp module
"""

IDA_DEBUG_LDR = _ida_kernwin.IDA_DEBUG_LDR
r"""
ldr module
"""

IDA_DEBUG_PLUGIN = _ida_kernwin.IDA_DEBUG_PLUGIN
r"""
plugin module
"""

IDA_DEBUG_IDS = _ida_kernwin.IDA_DEBUG_IDS
r"""
ids files
"""

IDA_DEBUG_CONFIG = _ida_kernwin.IDA_DEBUG_CONFIG
r"""
config file
"""

IDA_DEBUG_CHECKMEM = _ida_kernwin.IDA_DEBUG_CHECKMEM
r"""
check heap consistency
"""

IDA_DEBUG_LICENSE = _ida_kernwin.IDA_DEBUG_LICENSE
r"""
licensing
"""

IDA_DEBUG_DEMANGLE = _ida_kernwin.IDA_DEBUG_DEMANGLE
r"""
demangler
"""

IDA_DEBUG_QUEUE = _ida_kernwin.IDA_DEBUG_QUEUE
r"""
queue
"""

IDA_DEBUG_ROLLBACK = _ida_kernwin.IDA_DEBUG_ROLLBACK
r"""
rollback
"""

IDA_DEBUG_ALREADY = _ida_kernwin.IDA_DEBUG_ALREADY
r"""
already data or code
"""

IDA_DEBUG_TIL = _ida_kernwin.IDA_DEBUG_TIL
r"""
type system
"""

IDA_DEBUG_NOTIFY = _ida_kernwin.IDA_DEBUG_NOTIFY
r"""
show all notifications
"""

IDA_DEBUG_DEBUGGER = _ida_kernwin.IDA_DEBUG_DEBUGGER
r"""
debugger
"""

IDA_DEBUG_APPCALL = _ida_kernwin.IDA_DEBUG_APPCALL
r"""
appcall
"""

IDA_DEBUG_SRCDBG = _ida_kernwin.IDA_DEBUG_SRCDBG
r"""
source debugging
"""

IDA_DEBUG_ACCESSIBILITY = _ida_kernwin.IDA_DEBUG_ACCESSIBILITY
r"""
accessibility
"""

IDA_DEBUG_NETWORK = _ida_kernwin.IDA_DEBUG_NETWORK
r"""
network
"""

IDA_DEBUG_INTERNET = _ida_kernwin.IDA_DEBUG_INTERNET
r"""
internet connection (for API backward compatibility)
"""

IDA_DEBUG_SIMPLEX = _ida_kernwin.IDA_DEBUG_SIMPLEX
r"""
full stack analysis
"""

IDA_DEBUG_DBGINFO = _ida_kernwin.IDA_DEBUG_DBGINFO
r"""
handling of debug info (e.g. pdb, dwarf)
"""

IDA_DEBUG_LUMINA = _ida_kernwin.IDA_DEBUG_LUMINA
r"""
lumina related
"""

IDA_DEBUG_THEMES = _ida_kernwin.IDA_DEBUG_THEMES
r"""
themes
"""

IDA_DEBUG_REGEX = _ida_kernwin.IDA_DEBUG_REGEX
r"""
regular expression
"""

IDA_DEBUG_SUBPROC = _ida_kernwin.IDA_DEBUG_SUBPROC
r"""
sub process
"""

IDA_DEBUG_RANGECB = _ida_kernwin.IDA_DEBUG_RANGECB
r"""
range-based entities like segments, functions and so on
"""

IDA_DEBUG_ALWAYS = _ida_kernwin.IDA_DEBUG_ALWAYS
r"""
everything
"""

AST_ENABLE_ALWAYS = _ida_kernwin.AST_ENABLE_ALWAYS
r"""
enable action and do not call action_handler_t::update() anymore
"""

AST_ENABLE_FOR_IDB = _ida_kernwin.AST_ENABLE_FOR_IDB
r"""
enable action for the current idb. call action_handler_t::update() when a
database is opened/closed
"""

AST_ENABLE_FOR_WIDGET = _ida_kernwin.AST_ENABLE_FOR_WIDGET
r"""
enable action for the current widget. call action_handler_t::update() when a
widget gets/loses focus
"""

AST_ENABLE = _ida_kernwin.AST_ENABLE
r"""
enable action - call action_handler_t::update() when anything changes
"""

AST_DISABLE_ALWAYS = _ida_kernwin.AST_DISABLE_ALWAYS
r"""
disable action and do not call action_handler_t::action() anymore
"""

AST_DISABLE_FOR_IDB = _ida_kernwin.AST_DISABLE_FOR_IDB
r"""
analog of AST_ENABLE_FOR_IDB
"""

AST_DISABLE_FOR_WIDGET = _ida_kernwin.AST_DISABLE_FOR_WIDGET
r"""
analog of AST_ENABLE_FOR_WIDGET
"""

AST_DISABLE = _ida_kernwin.AST_DISABLE
r"""
analog of AST_ENABLE
"""


def is_action_enabled(s: "action_state_t") -> "bool":
    r"""
    is_action_enabled(s) -> bool
    Check if the given action state is one of AST_ENABLE*.

    @param s: (C++: action_state_t) enum action_state_t
    """
    return _ida_kernwin.is_action_enabled(s)
CH_MODAL = _ida_kernwin.CH_MODAL
r"""
Modal chooser.
"""

CH_KEEP = _ida_kernwin.CH_KEEP
r"""
The chooser instance's lifecycle is not tied to the lifecycle of the widget
showing its contents. Closing the widget will not destroy the chooser structure.
This allows for, e.g., static global chooser instances that don't need to be
allocated on the heap. Also stack-allocated chooser instances must set this bit.
"""

CH_MULTI = _ida_kernwin.CH_MULTI
r"""
The chooser will allow multi-selection (only for GUI choosers). This bit is set
when using the chooser_multi_t structure.
"""

CH_MULTI_EDIT = _ida_kernwin.CH_MULTI_EDIT
r"""
Obsolete.
"""

CH_NOBTNS = _ida_kernwin.CH_NOBTNS
r"""
do not display ok/cancel/help/search buttons. Meaningful only for gui modal
windows because non-modal windows do not have any buttons anyway. Text mode does
not have them neither.
"""

CH_ATTRS = _ida_kernwin.CH_ATTRS
r"""
generate ui_get_chooser_item_attrs (gui only)
"""

CH_UNUSED = _ida_kernwin.CH_UNUSED

CH_FORCE_DEFAULT = _ida_kernwin.CH_FORCE_DEFAULT
r"""
if a non-modal chooser was already open, change selection to the default one
"""

CH_CAN_INS = _ida_kernwin.CH_CAN_INS
r"""
allow to insert new items
"""

CH_CAN_DEL = _ida_kernwin.CH_CAN_DEL
r"""
allow to delete existing item(s)
"""

CH_CAN_EDIT = _ida_kernwin.CH_CAN_EDIT
r"""
allow to edit existing item(s)
"""

CH_CAN_REFRESH = _ida_kernwin.CH_CAN_REFRESH
r"""
allow to refresh chooser
"""

CH_QFLT = _ida_kernwin.CH_QFLT
r"""
open with quick filter enabled and focused
"""

CH_QFTYP_SHIFT = _ida_kernwin.CH_QFTYP_SHIFT

CH_QFTYP_DEFAULT = _ida_kernwin.CH_QFTYP_DEFAULT
r"""
set quick filtering type to the possible existing default for this chooser
"""

CH_QFTYP_NORMAL = _ida_kernwin.CH_QFTYP_NORMAL
r"""
normal (i.e., lexicographical) quick filter type
"""

CH_QFTYP_WHOLE_WORDS = _ida_kernwin.CH_QFTYP_WHOLE_WORDS
r"""
whole words quick filter type
"""

CH_QFTYP_REGEX = _ida_kernwin.CH_QFTYP_REGEX
r"""
regex quick filter type
"""

CH_QFTYP_FUZZY = _ida_kernwin.CH_QFTYP_FUZZY
r"""
fuzzy search quick filter type
"""

CH_QFTYP_MASK = _ida_kernwin.CH_QFTYP_MASK

CH_NO_STATUS_BAR = _ida_kernwin.CH_NO_STATUS_BAR
r"""
don't show a status bar
"""

CH_RESTORE = _ida_kernwin.CH_RESTORE
r"""
restore floating position if present (equivalent of WOPN_RESTORE) (GUI version
only)
"""

CH_RENAME_IS_EDIT = _ida_kernwin.CH_RENAME_IS_EDIT
r"""
triggering a 'edit/rename' (i.e., F2 shortcut) on a cell, should call the edit()
callback for the corresponding row.
"""

CH_BUILTIN_SHIFT = _ida_kernwin.CH_BUILTIN_SHIFT

CH_BUILTIN_MASK = _ida_kernwin.CH_BUILTIN_MASK
r"""
Mask for builtin chooser numbers. Plugins should not use them.
"""

CH_HAS_DIRTREE = _ida_kernwin.CH_HAS_DIRTREE
r"""
The chooser can provide a dirtree_t, meaning a tree-like structure can be
provided to the user (instead of a flat table)
"""

CH_TM_NO_TREE = _ida_kernwin.CH_TM_NO_TREE
r"""
chooser will show in no-tree mode
"""

CH_TM_FOLDERS_ONLY = _ida_kernwin.CH_TM_FOLDERS_ONLY
r"""
chooser will show in folders-only mode
"""

CH_TM_FULL_TREE = _ida_kernwin.CH_TM_FULL_TREE
r"""
chooser will show in full-tree mode
"""

CH_TM_SHIFT = _ida_kernwin.CH_TM_SHIFT

CH_TM_MASK = _ida_kernwin.CH_TM_MASK

CH_HAS_DIFF = _ida_kernwin.CH_HAS_DIFF
r"""
The chooser can be used in a diffing/merging workflow.
"""

CH_NO_SORT = _ida_kernwin.CH_NO_SORT
r"""
The chooser will not have sorting abilities.
"""

CH_NO_FILTER = _ida_kernwin.CH_NO_FILTER
r"""
The chooser will not have filtering abilities.
"""

CH_NON_PERSISTED_TREE = _ida_kernwin.CH_NON_PERSISTED_TREE
r"""
the chooser tree is not persisted (it is not loaded on startup and is not saved
on exit)
"""

CH2_LAZY_LOADED = _ida_kernwin.CH2_LAZY_LOADED
r"""
The chooser is lazy-loaded; it receives the callback do_lazy_load_dir() (only
meaningful when CH_HAS_DIRTREE is set)
"""

CH2_HAS_INODE2INDEX = _ida_kernwin.CH2_HAS_INODE2INDEX

CHCOL_PLAIN = _ida_kernwin.CHCOL_PLAIN
r"""
plain string
"""

CHCOL_PATH = _ida_kernwin.CHCOL_PATH
r"""
file path. TUI IDA will truncate excessive cell lengths starting at their
beginning, and prepending the resulting text with "..." order to leave the
filename visible
"""

CHCOL_HEX = _ida_kernwin.CHCOL_HEX
r"""
hexadecimal number
"""

CHCOL_DEC = _ida_kernwin.CHCOL_DEC
r"""
decimal number
"""

CHCOL_EA = _ida_kernwin.CHCOL_EA
r"""
address
"""

CHCOL_FNAME = _ida_kernwin.CHCOL_FNAME
r"""
function name. If a chooser column has this flag set and implements
chooser_base_t::get_ea(), rows background colors will be automatically set to
match the navigator's "Library function", "Lumina function" and "External
symbol" colors
"""

CHCOL_FORMAT = _ida_kernwin.CHCOL_FORMAT
r"""
column format mask
"""

CHCOL_DEFHIDDEN = _ida_kernwin.CHCOL_DEFHIDDEN
r"""
column should be hidden by default
"""

CHCOL_DRAGHINT = _ida_kernwin.CHCOL_DRAGHINT
r"""
the column number that will be used to build hints for the dragging undo label.
This should be provided for at most one column for any given chooser.
"""

CHCOL_INODENAME = _ida_kernwin.CHCOL_INODENAME
r"""
if CH_HAS_DIRTREE has been specified, this instructs the chooser that this
column shows the inode name. This should be provided for at most one column for
any given chooser.
"""

CHITEM_BOLD = _ida_kernwin.CHITEM_BOLD
r"""
display the item in bold
"""

CHITEM_ITALIC = _ida_kernwin.CHITEM_ITALIC
r"""
display the item in italic
"""

CHITEM_UNDER = _ida_kernwin.CHITEM_UNDER
r"""
underline the item
"""

CHITEM_STRIKE = _ida_kernwin.CHITEM_STRIKE
r"""
strikeout the item
"""

CHITEM_GRAY = _ida_kernwin.CHITEM_GRAY
r"""
gray out the item
"""

CHOOSER_NOMAINMENU = _ida_kernwin.CHOOSER_NOMAINMENU
r"""
do not display main menu
"""

CHOOSER_NOSTATUSBAR = _ida_kernwin.CHOOSER_NOSTATUSBAR
r"""
do not display status bar (obsolete. Use CH_NO_STATUS_BAR instead)
"""

class chooser_item_attrs_t(object):
    r"""
    Proxy of C++ chooser_item_attrs_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    flags: "int" = property(_ida_kernwin.chooser_item_attrs_t_flags_get, _ida_kernwin.chooser_item_attrs_t_flags_set, doc=r"""flags""")
    r"""
    Chooser item property bits
    """
    color: "bgcolor_t" = property(_ida_kernwin.chooser_item_attrs_t_color_get, _ida_kernwin.chooser_item_attrs_t_color_set, doc=r"""color""")
    r"""
    item color
    """

    def __init__(self):
        r"""
        __init__(self) -> chooser_item_attrs_t
        """
        _ida_kernwin.chooser_item_attrs_t_swiginit(self, _ida_kernwin.new_chooser_item_attrs_t())

    def reset(self) -> "void":
        r"""
        reset(self)
        """
        return _ida_kernwin.chooser_item_attrs_t_reset(self)

    def __eq__(self, other: "chooser_item_attrs_t") -> "bool":
        r"""
        __eq__(self, other) -> bool

        @param other: chooser_item_attrs_t const &
        """
        return _ida_kernwin.chooser_item_attrs_t___eq__(self, other)
    __swig_destroy__ = _ida_kernwin.delete_chooser_item_attrs_t

# Register chooser_item_attrs_t in _ida_kernwin:
_ida_kernwin.chooser_item_attrs_t_swigregister(chooser_item_attrs_t)
class chooser_row_info_t(object):
    r"""
    Proxy of C++ chooser_row_info_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    texts: "qstrvec_t" = property(_ida_kernwin.chooser_row_info_t_texts_get, _ida_kernwin.chooser_row_info_t_texts_set, doc=r"""texts""")
    r"""
    texts, one per chooser column
    """
    attrs: "chooser_item_attrs_t" = property(_ida_kernwin.chooser_row_info_t_attrs_get, _ida_kernwin.chooser_row_info_t_attrs_set, doc=r"""attrs""")
    r"""
    styling attributes
    """
    icon: "int" = property(_ida_kernwin.chooser_row_info_t_icon_get, _ida_kernwin.chooser_row_info_t_icon_set, doc=r"""icon""")
    r"""
    icon number
    """

    def __eq__(self, other: "chooser_row_info_t") -> "bool":
        r"""
        __eq__(self, other) -> bool

        @param other: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_t___eq__(self, other)

    def __ne__(self, other: "chooser_row_info_t") -> "bool":
        r"""
        __ne__(self, other) -> bool

        @param other: chooser_row_info_t const &
        """
        return _ida_kernwin.chooser_row_info_t___ne__(self, other)

    def __init__(self):
        r"""
        __init__(self) -> chooser_row_info_t
        """
        _ida_kernwin.chooser_row_info_t_swiginit(self, _ida_kernwin.new_chooser_row_info_t())
    __swig_destroy__ = _ida_kernwin.delete_chooser_row_info_t

# Register chooser_row_info_t in _ida_kernwin:
_ida_kernwin.chooser_row_info_t_swigregister(chooser_row_info_t)
GCRF_HIGH_BIT = _ida_kernwin.GCRF_HIGH_BIT

GCRF_HEADER = _ida_kernwin.GCRF_HEADER
r"""
Return header texts.
"""

GCRF_SELECTION = _ida_kernwin.GCRF_SELECTION
r"""
Return selected rows.
"""

GCRF_CURRENT = _ida_kernwin.GCRF_CURRENT
r"""
Return the current row.
"""

GCRF_ALL = _ida_kernwin.GCRF_ALL
r"""
Return all rows.
"""

class chooser_stdact_desc_t(object):
    r"""
    Proxy of C++ chooser_stdact_desc_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    version: "int" = property(_ida_kernwin.chooser_stdact_desc_t_version_get, _ida_kernwin.chooser_stdact_desc_t_version_set, doc=r"""version""")
    r"""
    to support the backward compatibility
    """
    label: "char const *" = property(_ida_kernwin.chooser_stdact_desc_t_label_get, _ida_kernwin.chooser_stdact_desc_t_label_set, doc=r"""label""")
    r"""
    see action_desc_t
    """
    tooltip: "char const *" = property(_ida_kernwin.chooser_stdact_desc_t_tooltip_get, _ida_kernwin.chooser_stdact_desc_t_tooltip_set, doc=r"""tooltip""")
    icon: "int" = property(_ida_kernwin.chooser_stdact_desc_t_icon_get, _ida_kernwin.chooser_stdact_desc_t_icon_set, doc=r"""icon""")

    def __init__(self, _label: "char const *"=None, _tooltip: "char const *"=None, _icon: "int"=-1):
        r"""
        __init__(self, _label=None, _tooltip=None, _icon=-1) -> chooser_stdact_desc_t

        @param _label: char const *
        @param _tooltip: char const *
        @param _icon: int
        """
        if self.__class__ == chooser_stdact_desc_t:
            _self = None
        else:
            _self = self
        _ida_kernwin.chooser_stdact_desc_t_swiginit(self, _ida_kernwin.new_chooser_stdact_desc_t(_self, _label, _tooltip, _icon))
    __swig_destroy__ = _ida_kernwin.delete_chooser_stdact_desc_t

    def ucb(self, arg0: "action_ctx_base_t") -> "action_state_t":
        r"""
        ucb(self, arg0) -> action_state_t
        the update callback, see action_handler_t::update() When the update callback is
        called from the chooser UI engine, it can be sure that ctx.source.chooser is a
        valid pointer to chooser_base_t and that there are selected items for the Delete
        and Edit actions.

        @param arg0: action_update_ctx_t *
        """
        return _ida_kernwin.chooser_stdact_desc_t_ucb(self, arg0)
    def __disown__(self):
        self.this.disown()
        _ida_kernwin.disown_chooser_stdact_desc_t(self)
        return weakref.proxy(self)

# Register chooser_stdact_desc_t in _ida_kernwin:
_ida_kernwin.chooser_stdact_desc_t_swigregister(chooser_stdact_desc_t)
class chooser_base_t(object):
    r"""
    Proxy of C++ chooser_base_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    x0: "int" = property(_ida_kernwin.chooser_base_t_x0_get, doc=r"""x0""")
    r"""
    screen position, Functions: generic list choosers
    """
    y0: "int" = property(_ida_kernwin.chooser_base_t_y0_get, doc=r"""y0""")
    x1: "int" = property(_ida_kernwin.chooser_base_t_x1_get, doc=r"""x1""")
    y1: "int" = property(_ida_kernwin.chooser_base_t_y1_get, doc=r"""y1""")
    width: "int" = property(_ida_kernwin.chooser_base_t_width_get, doc=r"""width""")
    r"""
    (in chars)
    """
    height: "int" = property(_ida_kernwin.chooser_base_t_height_get, doc=r"""height""")
    r"""
    (in chars)
    """
    title: "char const *" = property(_ida_kernwin.chooser_base_t_title_get, doc=r"""title""")
    r"""
    menu title (includes ptr to help). May have chooser title prefixes (see "Chooser
     title" above).
    """
    columns: "int" = property(_ida_kernwin.chooser_base_t_columns_get, doc=r"""columns""")
    r"""
    number of columns
    """
    widths: "int const *" = property(_ida_kernwin.chooser_base_t_widths_get, doc=r"""widths""")
    r"""
    column widths
    * low 16 bits of each value hold the column width
    * high 16 bits are flags (see Chooser column flags)
    """
    header: "char const *const *" = property(_ida_kernwin.chooser_base_t_header_get, doc=r"""header""")
    r"""
    header line; contains the tooltips, and column name for each of 'columns'
    columns. When tooltips need to be provided, the syntax should be:
    "#tooltip#column-name". (Otherwise, the syntax is simply "column-name".)
    """
    icon: "int" = property(_ida_kernwin.chooser_base_t_icon_get, doc=r"""icon""")
    r"""
    default icon
    """
    POPUP_INS = _ida_kernwin.chooser_base_t_POPUP_INS
    
    POPUP_DEL = _ida_kernwin.chooser_base_t_POPUP_DEL
    
    POPUP_EDIT = _ida_kernwin.chooser_base_t_POPUP_EDIT
    
    POPUP_REFRESH = _ida_kernwin.chooser_base_t_POPUP_REFRESH
    
    NSTDPOPUPS = _ida_kernwin.chooser_base_t_NSTDPOPUPS
    
    popup_names: "qstring [chooser_base_t::NSTDPOPUPS]" = property(_ida_kernwin.chooser_base_t_popup_names_get, doc=r"""popup_names""")
    r"""
    array of custom labels of the standard actions. Used to replace labels for these
    actions.
    An empty name means that the default name will be used.
    @note: Availability of these actions is determined by the CH_CAN_... flags. The
           label, icon and other action attributes can be overwritten in the action
           description returned by get_stdact_descs()
    """
    deflt_col: "int" = property(_ida_kernwin.chooser_base_t_deflt_col_get, doc=r"""deflt_col""")
    r"""
    Column that will have focus.
    """

    def is_same(self, other: "chooser_base_t") -> "bool":
        r"""
        is_same(self, other) -> bool
        do the current and the given objects hold the same data?

        @param other: (C++: const chooser_base_t *) chooser_base_t const *
        """
        return _ida_kernwin.chooser_base_t_is_same(self, other)

    def can_ins(self) -> "bool":
        r"""
        can_ins(self) -> bool
        is an operation allowed?
        """
        return _ida_kernwin.chooser_base_t_can_ins(self)

    def can_del(self) -> "bool":
        r"""
        can_del(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_can_del(self)

    def can_edit(self) -> "bool":
        r"""
        can_edit(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_can_edit(self)

    def can_refresh(self) -> "bool":
        r"""
        can_refresh(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_can_refresh(self)

    def popup_allowed(self, stdact_idx: "int") -> "bool":
        r"""
        popup_allowed(self, stdact_idx) -> bool
        is a standard action allowed?

        @param stdact_idx: (C++: int)
        """
        return _ida_kernwin.chooser_base_t_popup_allowed(self, stdact_idx)

    def is_status_bar_hidden(self) -> "bool":
        r"""
        is_status_bar_hidden(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_is_status_bar_hidden(self)

    def should_restore_geometry(self) -> "bool":
        r"""
        should_restore_geometry(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_should_restore_geometry(self)

    def is_modal(self) -> "bool":
        r"""
        is_modal(self) -> bool
        is choose modal?
        """
        return _ida_kernwin.chooser_base_t_is_modal(self)

    def has_widget_lifecycle(self) -> "bool":
        r"""
        has_widget_lifecycle(self) -> bool
        should chooser object be deleted when the widget gets destroyed?
        """
        return _ida_kernwin.chooser_base_t_has_widget_lifecycle(self)

    def is_multi(self) -> "bool":
        r"""
        is_multi(self) -> bool
        is multi-selection allowed?
        """
        return _ida_kernwin.chooser_base_t_is_multi(self)

    def ask_item_attrs(self) -> "bool":
        r"""
        ask_item_attrs(self) -> bool
        should chooser generate ui_get_chooser_item_attrs events?
        """
        return _ida_kernwin.chooser_base_t_ask_item_attrs(self)

    def is_force_default(self) -> "bool":
        r"""
        is_force_default(self) -> bool
        should selection of the already opened non-modal chooser be changed?
        """
        return _ida_kernwin.chooser_base_t_is_force_default(self)

    def get_builtin_number(self) -> "uint":
        r"""
        get_builtin_number(self) -> uint
        get number of the built-in chooser
        """
        return _ida_kernwin.chooser_base_t_get_builtin_number(self)

    def is_quick_filter_visible_initially(self) -> "bool":
        r"""
        is_quick_filter_visible_initially(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_is_quick_filter_visible_initially(self)

    def get_quick_filter_initial_mode(self) -> "int":
        r"""
        get_quick_filter_initial_mode(self) -> int
        """
        return _ida_kernwin.chooser_base_t_get_quick_filter_initial_mode(self)

    def has_dirtree(self) -> "bool":
        r"""
        has_dirtree(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_has_dirtree(self)

    def has_diff_capability(self) -> "bool":
        r"""
        has_diff_capability(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_has_diff_capability(self)

    def can_sort(self) -> "bool":
        r"""
        can_sort(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_can_sort(self)

    def can_filter(self) -> "bool":
        r"""
        can_filter(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_can_filter(self)

    def should_rename_trigger_edit(self) -> "bool":
        r"""
        should_rename_trigger_edit(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_should_rename_trigger_edit(self)

    def is_dirtree_persisted(self) -> "bool":
        r"""
        is_dirtree_persisted(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_is_dirtree_persisted(self)

    def is_lazy_loaded(self) -> "bool":
        r"""
        is_lazy_loaded(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_is_lazy_loaded(self)

    def has_inode_to_index(self) -> "bool":
        r"""
        has_inode_to_index(self) -> bool
        """
        return _ida_kernwin.chooser_base_t_has_inode_to_index(self)

    def get_count(self) -> "size_t":
        r"""
        get_count(self) -> size_t
        get the number of elements in the chooser
        """
        return _ida_kernwin.chooser_base_t_get_count(self)

    def get_ea(self, arg2: "size_t") -> "ea_t":
        r"""
        get_ea(self, arg2) -> ea_t
        get the address of an element. When this function returns valid addresses: * If
        any column has the `CHCOL_FNAME` flag, rows will be colored according to the
        attributes of the functions who own those addresses (extern, library function,
        Lumina, ... - similar to what the "Functions" widget does) * When a selection is
        present and the user presses `<Enter>` (`<Shift+Enter>` if the chooser is
        modal), IDA will jump to that address (through jumpto())

        @param arg2: size_t
        @return: the effective address, BADADDR if the element has no address
        """
        return _ida_kernwin.chooser_base_t_get_ea(self, arg2)

    def get_row(self, n: "size_t") -> "PyObject *":
        r"""
        get_row(self, n) -> ([str, ...], int, chooser_item_attrs_t)
        get a description of an element.

        @param n: (C++: size_t) element number (0..get_count()-1)
        """
        return _ida_kernwin.chooser_base_t_get_row(self, n)

# Register chooser_base_t in _ida_kernwin:
_ida_kernwin.chooser_base_t_swigregister(chooser_base_t)
nat_lib = _ida_kernwin.nat_lib

nat_fun = _ida_kernwin.nat_fun

nat_cod = _ida_kernwin.nat_cod

nat_dat = _ida_kernwin.nat_dat

nat_und = _ida_kernwin.nat_und

nat_ext = _ida_kernwin.nat_ext

nat_err = _ida_kernwin.nat_err

nat_gap = _ida_kernwin.nat_gap

nat_cur = _ida_kernwin.nat_cur

nat_auto = _ida_kernwin.nat_auto

nat_lum = _ida_kernwin.nat_lum

nat_hlo = _ida_kernwin.nat_hlo

nat_last = _ida_kernwin.nat_last

CVH_USERDATA = _ida_kernwin.CVH_USERDATA

CVH_KEYDOWN = _ida_kernwin.CVH_KEYDOWN
r"""
see custom_viewer_keydown_t
"""

CVH_POPUP = _ida_kernwin.CVH_POPUP
r"""
see custom_viewer_popup_t
"""

CVH_DBLCLICK = _ida_kernwin.CVH_DBLCLICK
r"""
see custom_viewer_dblclick_t
"""

CVH_CURPOS = _ida_kernwin.CVH_CURPOS
r"""
see custom_viewer_curpos_t
"""

CVH_CLOSE = _ida_kernwin.CVH_CLOSE
r"""
see custom_viewer_close_t
"""

CVH_CLICK = _ida_kernwin.CVH_CLICK
r"""
see custom_viewer_click_t
"""

CVH_QT_AWARE = _ida_kernwin.CVH_QT_AWARE
r"""
see set_custom_viewer_qt_aware()
"""

CVH_HELP = _ida_kernwin.CVH_HELP
r"""
see custom_viewer_help_t
"""

CVH_MOUSEMOVE = _ida_kernwin.CVH_MOUSEMOVE
r"""
see custom_viewer_mouse_moved_t
"""

CDVH_USERDATA = _ida_kernwin.CDVH_USERDATA
r"""
see set_code_viewer_user_data()
"""

CDVH_SRCVIEW = _ida_kernwin.CDVH_SRCVIEW
r"""
see set_code_viewer_is_source()
"""

CDVH_LINES_CLICK = _ida_kernwin.CDVH_LINES_CLICK
r"""
see code_viewer_lines_click_t
"""

CDVH_LINES_DBLCLICK = _ida_kernwin.CDVH_LINES_DBLCLICK
r"""
see code_viewer_lines_click_t
"""

CDVH_LINES_POPUP = _ida_kernwin.CDVH_LINES_POPUP
r"""
see code_viewer_lines_click_t
"""

CDVH_LINES_DRAWICON = _ida_kernwin.CDVH_LINES_DRAWICON
r"""
see code_viewer_lines_icon_t
"""

CDVH_LINES_LINENUM = _ida_kernwin.CDVH_LINES_LINENUM
r"""
see code_viewer_lines_linenum_t
"""

CDVH_LINES_ICONMARGIN = _ida_kernwin.CDVH_LINES_ICONMARGIN
r"""
see set_code_viewer_lines_icon_margin()
"""

CDVH_LINES_RADIX = _ida_kernwin.CDVH_LINES_RADIX
r"""
see set_code_viewer_lines_radix()
"""

CDVH_LINES_ALIGNMENT = _ida_kernwin.CDVH_LINES_ALIGNMENT
r"""
see set_code_viewer_lines_alignment()
"""

VES_SHIFT = _ida_kernwin.VES_SHIFT
r"""
state & 1 => Shift is pressed
state & 2 => Alt is pressed
state & 4 => Ctrl is pressed
state & 8 => Mouse left button is pressed
state & 16 => Mouse right button is pressed
state & 32 => Mouse middle button is pressed
state & 128 => Meta is pressed (OSX only)
"""

VES_ALT = _ida_kernwin.VES_ALT

VES_CTRL = _ida_kernwin.VES_CTRL

VES_MOUSE_LEFT = _ida_kernwin.VES_MOUSE_LEFT

VES_MOUSE_RIGHT = _ida_kernwin.VES_MOUSE_RIGHT

VES_MOUSE_MIDDLE = _ida_kernwin.VES_MOUSE_MIDDLE

VES_META = _ida_kernwin.VES_META

msg_activated = _ida_kernwin.msg_activated
r"""
The message window is activated.
"""

msg_deactivated = _ida_kernwin.msg_deactivated
r"""
The message window is deactivated.
"""

msg_click = _ida_kernwin.msg_click
r"""
Click event.
@param x: (int) x-coordinate
@param y: (int) y-coordinate
@param state: (::view_event_state_t)
@retval 1: handled
@retval 0: not handled (invoke default handler)
"""

msg_dblclick = _ida_kernwin.msg_dblclick
r"""
Double click event.
@param x: (int) x-coordinate
@param y: (int) y-coordinate
@param state: (::view_event_state_t)
@retval 1: handled
@retval 0: not handled (invoke default handler)
"""

msg_closed = _ida_kernwin.msg_closed
r"""
View closed.
"""

msg_keydown = _ida_kernwin.msg_keydown
r"""
Key down event.
@param key: (int)
@param state: (::view_event_state_t)
@retval 1: handled
@retval 0: not handled (invoke default handler)
"""

class renderer_pos_info_t(object):
    r"""
    Proxy of C++ renderer_pos_info_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> renderer_pos_info_t
        """
        _ida_kernwin.renderer_pos_info_t_swiginit(self, _ida_kernwin.new_renderer_pos_info_t())
    node: "int" = property(_ida_kernwin.renderer_pos_info_t_node_get, _ida_kernwin.renderer_pos_info_t_node_set, doc=r"""node""")
    r"""
    the node, or -1 if the current renderer is not a graph renderer.
    """
    cx: "short" = property(_ida_kernwin.renderer_pos_info_t_cx_get, _ida_kernwin.renderer_pos_info_t_cx_set, doc=r"""cx""")
    r"""
    the X coords of the character in the current line. When in graph mode: X coords
    of the character in 'node'.
    When in flat mode: X coords of the character in the line, w/o
    taking scrolling into consideration.
    """
    cy: "short" = property(_ida_kernwin.renderer_pos_info_t_cy_get, _ida_kernwin.renderer_pos_info_t_cy_set, doc=r"""cy""")
    r"""
    the Y coords of the character. When in graph mode: Y coords of the character in
    'node'.
    When in flat mode: Line number, starting from the top.
    """
    sx: "short" = property(_ida_kernwin.renderer_pos_info_t_sx_get, _ida_kernwin.renderer_pos_info_t_sx_set, doc=r"""sx""")
    r"""
    the number of chars that are scrolled (flat mode only)
    """

    def __eq__(self, r: "renderer_pos_info_t") -> "bool":
        r"""
        __eq__(self, r) -> bool

        @param r: renderer_pos_info_t const &
        """
        return _ida_kernwin.renderer_pos_info_t___eq__(self, r)

    def __ne__(self, r: "renderer_pos_info_t") -> "bool":
        r"""
        __ne__(self, r) -> bool

        @param r: renderer_pos_info_t const &
        """
        return _ida_kernwin.renderer_pos_info_t___ne__(self, r)
    __swig_destroy__ = _ida_kernwin.delete_renderer_pos_info_t

# Register renderer_pos_info_t in _ida_kernwin:
_ida_kernwin.renderer_pos_info_t_swigregister(renderer_pos_info_t)
class view_mouse_event_location_t(object):
    r"""
    Proxy of C++ view_mouse_event_location_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ea: "ea_t" = property(_ida_kernwin.view_mouse_event_location_t_ea_get, _ida_kernwin.view_mouse_event_location_t_ea_set, doc=r"""ea""")
    r"""
    flat view (rtype == TCCRT_FLAT)
    """
    item: "selection_item_t const *" = property(_ida_kernwin.view_mouse_event_location_t_item_get, _ida_kernwin.view_mouse_event_location_t_item_set, doc=r"""item""")
    r"""
    graph views (rtype != TCCRT_FLAT). nullptr if mouse is not currently over an
    item.
    """

    def __init__(self):
        r"""
        __init__(self) -> view_mouse_event_location_t
        """
        _ida_kernwin.view_mouse_event_location_t_swiginit(self, _ida_kernwin.new_view_mouse_event_location_t())
    __swig_destroy__ = _ida_kernwin.delete_view_mouse_event_location_t

# Register view_mouse_event_location_t in _ida_kernwin:
_ida_kernwin.view_mouse_event_location_t_swigregister(view_mouse_event_location_t)
class view_mouse_event_t(object):
    r"""
    Proxy of C++ view_mouse_event_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rtype: "tcc_renderer_type_t" = property(_ida_kernwin.view_mouse_event_t_rtype_get, _ida_kernwin.view_mouse_event_t_rtype_set, doc=r"""rtype""")
    r"""
    type of renderer that received the event
    """
    x: "uint32" = property(_ida_kernwin.view_mouse_event_t_x_get, _ida_kernwin.view_mouse_event_t_x_set, doc=r"""x""")
    r"""
    screen x coordinate
    """
    y: "uint32" = property(_ida_kernwin.view_mouse_event_t_y_get, _ida_kernwin.view_mouse_event_t_y_set, doc=r"""y""")
    r"""
    screen y coordinate
    """
    location: "view_mouse_event_t::location_t" = property(_ida_kernwin.view_mouse_event_t_location_get, _ida_kernwin.view_mouse_event_t_location_set, doc=r"""location""")
    r"""
    location where event was generated
    """
    state: "view_event_state_t" = property(_ida_kernwin.view_mouse_event_t_state_get, _ida_kernwin.view_mouse_event_t_state_set, doc=r"""state""")
    r"""
    contains information about what buttons are CURRENTLY pressed on the keyboard
    and mouse. view_mouse_event_t instances created in functions like
    mouseReleaseEvent() won't contain any information about the mouse, because it
    has been released.
    """
    button: "vme_button_t" = property(_ida_kernwin.view_mouse_event_t_button_get, _ida_kernwin.view_mouse_event_t_button_set, doc=r"""button""")
    r"""
    represents which mouse button was responsible for generating the event. This
    field does not care about the current state of the mouse.
    """
    renderer_pos: "renderer_pos_info_t" = property(_ida_kernwin.view_mouse_event_t_renderer_pos_get, _ida_kernwin.view_mouse_event_t_renderer_pos_set, doc=r"""renderer_pos""")
    r"""
    position where event was generated, relative to the renderer
    """

    def __init__(self):
        r"""
        __init__(self) -> view_mouse_event_t
        """
        _ida_kernwin.view_mouse_event_t_swiginit(self, _ida_kernwin.new_view_mouse_event_t())
    __swig_destroy__ = _ida_kernwin.delete_view_mouse_event_t

# Register view_mouse_event_t in _ida_kernwin:
_ida_kernwin.view_mouse_event_t_swigregister(view_mouse_event_t)
view_activated = _ida_kernwin.view_activated
r"""
A view is activated
@param view: (TWidget *)
"""

view_deactivated = _ida_kernwin.view_deactivated
r"""
A view is deactivated
@param view: (TWidget *)
"""

view_keydown = _ida_kernwin.view_keydown
r"""
Key down event
@param view: (TWidget *)
@param key: (int)
@param state: (::view_event_state_t)
"""

view_click = _ida_kernwin.view_click
r"""
Click event
@param view: (TWidget *)
@param event: (const view_mouse_event_t *)
"""

view_dblclick = _ida_kernwin.view_dblclick
r"""
Double click event
@param view: (TWidget *)
@param event: (const view_mouse_event_t *)
"""

view_curpos = _ida_kernwin.view_curpos
r"""
Cursor position changed
@param view: (TWidget *)
"""

view_created = _ida_kernwin.view_created
r"""
A view is being created.
@param view: (TWidget *)
"""

view_close = _ida_kernwin.view_close
r"""
View closed
@param view: (TWidget *)
"""

view_switched = _ida_kernwin.view_switched
r"""
A view's renderer has changed.
@param view: (TWidget *)
@param rt: (tcc_renderer_type_t)
"""

view_mouse_over = _ida_kernwin.view_mouse_over
r"""
The user moved the mouse over (or out of) a node or an edge. This is only
relevant in a graph view.
@param view: (TWidget *)
@param event: (const view_mouse_event_t *)
"""

view_loc_changed = _ida_kernwin.view_loc_changed
r"""
The location for the view has changed (can be either the place_t, the
renderer_info_t, or both.)
@param view: (TWidget *)
@param now: (const lochist_entry_t *)
@param was: (const lochist_entry_t *)
"""

view_mouse_moved = _ida_kernwin.view_mouse_moved
r"""
The mouse moved on the view
@param view: (TWidget *)
@param event: (const view_mouse_event_t *)
"""

iek_unknown = _ida_kernwin.iek_unknown

iek_shortcut = _ida_kernwin.iek_shortcut

iek_key_press = _ida_kernwin.iek_key_press

iek_key_release = _ida_kernwin.iek_key_release

iek_mouse_button_press = _ida_kernwin.iek_mouse_button_press

iek_mouse_button_release = _ida_kernwin.iek_mouse_button_release

iek_mouse_wheel = _ida_kernwin.iek_mouse_wheel

class input_event_t(object):
    r"""
    Proxy of C++ input_event_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cb: "int" = property(_ida_kernwin.input_event_t_cb_get, _ida_kernwin.input_event_t_cb_set, doc=r"""cb""")
    r"""
    size marker
    """
    kind: "input_event_kind_t" = property(_ida_kernwin.input_event_t_kind_get, _ida_kernwin.input_event_t_kind_set, doc=r"""kind""")
    r"""
    the kind of event
    """
    modifiers: "input_event_modifiers_t" = property(_ida_kernwin.input_event_t_modifiers_get, _ida_kernwin.input_event_t_modifiers_set, doc=r"""modifiers""")
    r"""
    current keyboard (and mouse) modifiers
    """
    target: "TWidget *" = property(_ida_kernwin.input_event_t_target_get, _ida_kernwin.input_event_t_target_set, doc=r"""target""")
    r"""
    the target widget
    """
    source: "void *" = property(_ida_kernwin.input_event_t_source_get, _ida_kernwin.input_event_t_source_set, doc=r"""source""")
    r"""
    the source event, should it be required for detailed inform (e.g., a QEvent in
    the GUI version of IDA)
    """
    shortcut: "input_event_t::input_event_shortcut_data_t" = property(_ida_kernwin.input_event_t_shortcut_get, _ida_kernwin.input_event_t_shortcut_set, doc=r"""shortcut""")
    keyboard: "input_event_t::input_event_keyboard_data_t" = property(_ida_kernwin.input_event_t_keyboard_get, _ida_kernwin.input_event_t_keyboard_set, doc=r"""keyboard""")
    mouse: "input_event_t::input_event_mouse_data_t" = property(_ida_kernwin.input_event_t_mouse_get, _ida_kernwin.input_event_t_mouse_set, doc=r"""mouse""")

    def __init__(self):
        r"""
        __init__(self) -> input_event_t
        """
        _ida_kernwin.input_event_t_swiginit(self, _ida_kernwin.new_input_event_t())

    def _source_as_size(self) -> "size_t":
        r"""_source_as_size(self) -> size_t"""
        return _ida_kernwin.input_event_t__source_as_size(self)

    def _target_as_size(self) -> "size_t":
        r"""_target_as_size(self) -> size_t"""
        return _ida_kernwin.input_event_t__target_as_size(self)

    def get_source_QEvent(self):
        ptr = self._source_as_size();
        if ptr:
            from PyQt5 import sip
            if self.kind in [iek_key_press, iek_key_release]:
                from PyQt5.QtGui import QInputEvent
                return sip.wrapinstance(ptr, QInputEvent)
            elif self.kind in [
                    iek_mouse_button_press,
                    iek_mouse_button_release]:
                from PyQt5.QtGui import QMouseEvent
                return sip.wrapinstance(ptr, QMouseEvent)
            elif self.kind == iek_mouse_wheel:
                from PyQt5.QtGui import QWheelEvent
                return sip.wrapinstance(ptr, QWheelEvent)
            else:
                from PyQt5.QtCore import QEvent
                return sip.wrapinstance(ptr, QEvent)

    def get_target_QWidget(self):
        ptr = self._target_as_size()
        if ptr:
             from PyQt5 import sip
             from PyQt5.QtWidgets import QWidget, QAbstractScrollArea
             return sip.wrapinstance(ptr, QWidget)

    __swig_destroy__ = _ida_kernwin.delete_input_event_t

# Register input_event_t in _ida_kernwin:
_ida_kernwin.input_event_t_swigregister(input_event_t)
class input_event_shortcut_data_t(object):
    r"""
    Proxy of C++ input_event_t::input_event_shortcut_data_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    action_name: "char const *" = property(_ida_kernwin.input_event_shortcut_data_t_action_name_get, _ida_kernwin.input_event_shortcut_data_t_action_name_set, doc=r"""action_name""")

    def __init__(self):
        r"""
        __init__(self) -> input_event_shortcut_data_t
        """
        _ida_kernwin.input_event_shortcut_data_t_swiginit(self, _ida_kernwin.new_input_event_shortcut_data_t())
    __swig_destroy__ = _ida_kernwin.delete_input_event_shortcut_data_t

# Register input_event_shortcut_data_t in _ida_kernwin:
_ida_kernwin.input_event_shortcut_data_t_swigregister(input_event_shortcut_data_t)
class input_event_keyboard_data_t(object):
    r"""
    Proxy of C++ input_event_t::input_event_keyboard_data_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    key: "int" = property(_ida_kernwin.input_event_keyboard_data_t_key_get, _ida_kernwin.input_event_keyboard_data_t_key_set, doc=r"""key""")
    text: "char [8]" = property(_ida_kernwin.input_event_keyboard_data_t_text_get, _ida_kernwin.input_event_keyboard_data_t_text_set, doc=r"""text""")

    def __init__(self):
        r"""
        __init__(self) -> input_event_keyboard_data_t
        """
        _ida_kernwin.input_event_keyboard_data_t_swiginit(self, _ida_kernwin.new_input_event_keyboard_data_t())
    __swig_destroy__ = _ida_kernwin.delete_input_event_keyboard_data_t

# Register input_event_keyboard_data_t in _ida_kernwin:
_ida_kernwin.input_event_keyboard_data_t_swigregister(input_event_keyboard_data_t)
class input_event_mouse_data_t(object):
    r"""
    Proxy of C++ input_event_t::input_event_mouse_data_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x: "int" = property(_ida_kernwin.input_event_mouse_data_t_x_get, _ida_kernwin.input_event_mouse_data_t_x_set, doc=r"""x""")
    y: "int" = property(_ida_kernwin.input_event_mouse_data_t_y_get, _ida_kernwin.input_event_mouse_data_t_y_set, doc=r"""y""")
    button: "vme_button_t" = property(_ida_kernwin.input_event_mouse_data_t_button_get, _ida_kernwin.input_event_mouse_data_t_button_set, doc=r"""button""")

    def __init__(self):
        r"""
        __init__(self) -> input_event_mouse_data_t
        """
        _ida_kernwin.input_event_mouse_data_t_swiginit(self, _ida_kernwin.new_input_event_mouse_data_t())
    __swig_destroy__ = _ida_kernwin.delete_input_event_mouse_data_t

# Register input_event_mouse_data_t in _ida_kernwin:
_ida_kernwin.input_event_mouse_data_t_swigregister(input_event_mouse_data_t)
MFF_FAST = _ida_kernwin.MFF_FAST
r"""
execute code as soon as possible
this mode is ok call ui related functions
that do not query the database.
"""

MFF_READ = _ida_kernwin.MFF_READ
r"""
execute code only when ida is idle and it is safe to query the database.
this mode is recommended only for code that does not modify the database.
(nb: ida may be in the middle of executing another user request, for example it may be waiting for him to enter values into a modal dialog box)
"""

MFF_WRITE = _ida_kernwin.MFF_WRITE
r"""
execute code only when ida is idle and it is safe to modify the database. in particular, this flag will suspend execution if there is
a modal dialog box on the screen this mode can be used to call any ida api function. MFF_WRITE implies MFF_READ
"""

MFF_NOWAIT = _ida_kernwin.MFF_NOWAIT
r"""
Do not wait for the request to be executed.
he caller should ensure that the request is not
destroyed until the execution completes.
if not, the request will be ignored.
the return code of execute_sync() is meaningless
in this case.
This flag can be used to delay the code execution
until the next UI loop run even from the main thread
"""

class ui_requests_t(object):
    r"""
    Proxy of C++ ui_requests_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> ui_requests_t
        """
        _ida_kernwin.ui_requests_t_swiginit(self, _ida_kernwin.new_ui_requests_t())
    __swig_destroy__ = _ida_kernwin.delete_ui_requests_t

# Register ui_requests_t in _ida_kernwin:
_ida_kernwin.ui_requests_t_swigregister(ui_requests_t)
UIJMP_ACTIVATE = _ida_kernwin.UIJMP_ACTIVATE
r"""
activate the new window
"""

UIJMP_DONTPUSH = _ida_kernwin.UIJMP_DONTPUSH
r"""
do not remember the current address in the navigation history
"""

UIJMP_VIEWMASK = _ida_kernwin.UIJMP_VIEWMASK

UIJMP_ANYVIEW = _ida_kernwin.UIJMP_ANYVIEW
r"""
jump in any ea_t-capable view
"""

UIJMP_IDAVIEW = _ida_kernwin.UIJMP_IDAVIEW
r"""
jump in idaview
"""

UIJMP_IDAVIEW_NEW = _ida_kernwin.UIJMP_IDAVIEW_NEW
r"""
jump in new idaview
"""

class action_ctx_base_cur_sel_t(object):
    r"""
    Proxy of C++ action_ctx_base_cur_sel_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _from: "twinpos_t" = property(_ida_kernwin.action_ctx_base_cur_sel_t__from_get, _ida_kernwin.action_ctx_base_cur_sel_t__from_set, doc=r"""_from""")
    to: "twinpos_t" = property(_ida_kernwin.action_ctx_base_cur_sel_t_to_get, _ida_kernwin.action_ctx_base_cur_sel_t_to_set, doc=r"""to""")
    r"""
    end of selection
    """

    def __init__(self):
        r"""
        __init__(self) -> action_ctx_base_cur_sel_t
        """
        _ida_kernwin.action_ctx_base_cur_sel_t_swiginit(self, _ida_kernwin.new_action_ctx_base_cur_sel_t())

    def reset(self) -> "void":
        r"""
        reset(self)
        """
        return _ida_kernwin.action_ctx_base_cur_sel_t_reset(self)
    __swig_destroy__ = _ida_kernwin.delete_action_ctx_base_cur_sel_t

# Register action_ctx_base_cur_sel_t in _ida_kernwin:
_ida_kernwin.action_ctx_base_cur_sel_t_swigregister(action_ctx_base_cur_sel_t)
class action_ctx_base_source_t(object):
    r"""
    Proxy of C++ action_ctx_base_source_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    chooser: "chooser_base_t *" = property(_ida_kernwin.action_ctx_base_source_t_chooser_get, _ida_kernwin.action_ctx_base_source_t_chooser_set, doc=r"""chooser""")

    def __init__(self):
        r"""
        __init__(self) -> action_ctx_base_source_t
        """
        _ida_kernwin.action_ctx_base_source_t_swiginit(self, _ida_kernwin.new_action_ctx_base_source_t())

    def reset(self) -> "void":
        r"""
        reset(self)
        """
        return _ida_kernwin.action_ctx_base_source_t_reset(self)
    __swig_destroy__ = _ida_kernwin.delete_action_ctx_base_source_t

# Register action_ctx_base_source_t in _ida_kernwin:
_ida_kernwin.action_ctx_base_source_t_swigregister(action_ctx_base_source_t)
class action_ctx_base_t(object):
    r"""
    Proxy of C++ action_ctx_base_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> action_ctx_base_t
        """
        _ida_kernwin.action_ctx_base_t_swiginit(self, _ida_kernwin.new_action_ctx_base_t())

    def reset(self) -> "void":
        r"""
        reset(self)
        Invalidate all context info.
        """
        return _ida_kernwin.action_ctx_base_t_reset(self)
    widget: "TWidget *" = property(_ida_kernwin.action_ctx_base_t_widget_get, _ida_kernwin.action_ctx_base_t_widget_set, doc=r"""widget""")
    widget_type: "twidget_type_t" = property(_ida_kernwin.action_ctx_base_t_widget_type_get, _ida_kernwin.action_ctx_base_t_widget_type_set, doc=r"""widget_type""")
    r"""
    type of current widget
    """
    widget_title: "qstring" = property(_ida_kernwin.action_ctx_base_t_widget_title_get, _ida_kernwin.action_ctx_base_t_widget_title_set, doc=r"""widget_title""")
    r"""
    title of current widget
    """
    chooser_selection: "sizevec_t" = property(_ida_kernwin.action_ctx_base_t_chooser_selection_get, _ida_kernwin.action_ctx_base_t_chooser_selection_set, doc=r"""chooser_selection""")
    r"""
    current chooser selection (0-based)
    """
    action: "char const *" = property(_ida_kernwin.action_ctx_base_t_action_get, _ida_kernwin.action_ctx_base_t_action_set, doc=r"""action""")
    r"""
    action name
    """
    cur_flags: "uint32" = property(_ida_kernwin.action_ctx_base_t_cur_flags_get, _ida_kernwin.action_ctx_base_t_cur_flags_set, doc=r"""cur_flags""")
    r"""
    Current address information. see Action context property bits.
    """

    def has_flag(self, flag: "uint32") -> "bool":
        r"""
        has_flag(self, flag) -> bool
        Check if the given flag is set.

        @param flag: (C++: uint32)
        """
        return _ida_kernwin.action_ctx_base_t_has_flag(self, flag)
    cur_ea: "ea_t" = property(_ida_kernwin.action_ctx_base_t_cur_ea_get, _ida_kernwin.action_ctx_base_t_cur_ea_set, doc=r"""cur_ea""")
    r"""
    the current EA of the position in the view
    """
    cur_value: "uval_t" = property(_ida_kernwin.action_ctx_base_t_cur_value_get, _ida_kernwin.action_ctx_base_t_cur_value_set, doc=r"""cur_value""")
    r"""
    the possible address, or value the cursor is positioned on
    """
    cur_func: "func_t *" = property(_ida_kernwin.action_ctx_base_t_cur_func_get, _ida_kernwin.action_ctx_base_t_cur_func_set, doc=r"""cur_func""")
    r"""
    the current function
    """
    cur_fchunk: "func_t *" = property(_ida_kernwin.action_ctx_base_t_cur_fchunk_get, _ida_kernwin.action_ctx_base_t_cur_fchunk_set, doc=r"""cur_fchunk""")
    r"""
    the current function chunk
    """
    cur_struc: "struc_t *" = property(_ida_kernwin.action_ctx_base_t_cur_struc_get, _ida_kernwin.action_ctx_base_t_cur_struc_set, doc=r"""cur_struc""")
    r"""
    the current structure
    """
    cur_strmem: "member_t *" = property(_ida_kernwin.action_ctx_base_t_cur_strmem_get, _ida_kernwin.action_ctx_base_t_cur_strmem_set, doc=r"""cur_strmem""")
    r"""
    the current structure member
    """
    cur_seg: "segment_t *" = property(_ida_kernwin.action_ctx_base_t_cur_seg_get, _ida_kernwin.action_ctx_base_t_cur_seg_set, doc=r"""cur_seg""")
    r"""
    the current segment
    """
    cur_sel: "action_ctx_base_cur_sel_t" = property(_ida_kernwin.action_ctx_base_t_cur_sel_get, _ida_kernwin.action_ctx_base_t_cur_sel_set, doc=r"""cur_sel""")
    r"""
    the currently selected range. also see ACF_HAS_SELECTION
    """
    regname: "char const *" = property(_ida_kernwin.action_ctx_base_t_regname_get, _ida_kernwin.action_ctx_base_t_regname_set, doc=r"""regname""")
    r"""
    register name (if widget_type == BWN_CPUREGS and context menu opened on
    register)
    """
    focus: "TWidget *" = property(_ida_kernwin.action_ctx_base_t_focus_get, _ida_kernwin.action_ctx_base_t_focus_set, doc=r"""focus""")
    r"""
    The focused widget in case it is not the 'form' itself (e.g., the 'quick filter'
    input in choosers.)
    """
    graph_selection: "screen_graph_selection_t *" = property(_ida_kernwin.action_ctx_base_t_graph_selection_get, _ida_kernwin.action_ctx_base_t_graph_selection_set, doc=r"""graph_selection""")
    r"""
    the current graph selection (if in a graph view)
    """
    dirtree_selection: "dirtree_selection_t *" = property(_ida_kernwin.action_ctx_base_t_dirtree_selection_get, _ida_kernwin.action_ctx_base_t_dirtree_selection_set, doc=r"""dirtree_selection""")
    r"""
    the current dirtree_t selection (if applicable)
    """
    source: "action_ctx_base_source_t" = property(_ida_kernwin.action_ctx_base_t_source_get, _ida_kernwin.action_ctx_base_t_source_set, doc=r"""source""")
    r"""
    the underlying chooser_base_t (if 'widget' is a chooser widget)
    """
    type_ref: "til_type_ref_t *" = property(_ida_kernwin.action_ctx_base_t_type_ref_get, _ida_kernwin.action_ctx_base_t_type_ref_set, doc=r"""type_ref""")
    r"""
    a reference to the current type (if 'widget' is a type listing widget; nullptr
    otherwise)
    """

    cur_extracted_ea = cur_value

    form = ida_idaapi._make_missed_695bwcompat_property("form", "widget", has_setter=False)
    form_type = ida_idaapi._make_missed_695bwcompat_property("form_type", "widget_type", has_setter=False)
    form_title = ida_idaapi._make_missed_695bwcompat_property("form_title", "widget_title", has_setter=False)


    __swig_destroy__ = _ida_kernwin.delete_action_ctx_base_t

# Register action_ctx_base_t in _ida_kernwin:
_ida_kernwin.action_ctx_base_t_swigregister(action_ctx_base_t)
ACF_HAS_SELECTION = _ida_kernwin.ACF_HAS_SELECTION
r"""
there is currently a valid selection
"""

ACF_XTRN_EA = _ida_kernwin.ACF_XTRN_EA
r"""
cur_ea is in 'externs' segment
"""

ACF_HAS_FIELD_DIRTREE_SELECTION = _ida_kernwin.ACF_HAS_FIELD_DIRTREE_SELECTION
r"""
'dirtree_selection' field is present
"""

ACF_HAS_SOURCE = _ida_kernwin.ACF_HAS_SOURCE
r"""
'source' field is present
"""

ACF_HAS_TYPE_REF = _ida_kernwin.ACF_HAS_TYPE_REF
r"""
'type_ref' field is present
"""


AHF_VERSION = _ida_kernwin.AHF_VERSION
r"""
action handler version (used by action_handler_t::flags)
"""

AHF_VERSION_MASK = _ida_kernwin.AHF_VERSION_MASK
r"""
mask for action_handler_t::flags
"""

class action_desc_t(object):
    r"""
    Proxy of C++ action_desc_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cb: "int" = property(_ida_kernwin.action_desc_t_cb_get, _ida_kernwin.action_desc_t_cb_set, doc=r"""cb""")
    r"""
    size of this structure
    """
    name: "char const *" = property(_ida_kernwin.action_desc_t_name_get, _ida_kernwin.action_desc_t_name_set, doc=r"""name""")
    r"""
    the internal name of the action; must be unique. a way to reduce possible
    conflicts is to prefix it with some specific prefix. E.g., "myplugin:doSthg".
    """
    label: "char const *" = property(_ida_kernwin.action_desc_t_label_get, _ida_kernwin.action_desc_t_label_set, doc=r"""label""")
    r"""
    the label of the action, possibly with an accelerator key definition (e.g.,
    "~J~ump to operand")
    """
    owner: "void const *" = property(_ida_kernwin.action_desc_t_owner_get, _ida_kernwin.action_desc_t_owner_set, doc=r"""owner""")
    r"""
    either the plugin_t, or plugmod_t responsible for registering the action. Can be
    nullptr Please see ACTION_DESC_LITERAL_PLUGMOD
    """
    shortcut: "char const *" = property(_ida_kernwin.action_desc_t_shortcut_get, _ida_kernwin.action_desc_t_shortcut_set, doc=r"""shortcut""")
    r"""
    an optional shortcut definition. E.g., "Ctrl+Enter"
    """
    tooltip: "char const *" = property(_ida_kernwin.action_desc_t_tooltip_get, _ida_kernwin.action_desc_t_tooltip_set, doc=r"""tooltip""")
    r"""
    an optional tooltip for the action
    """
    icon: "int" = property(_ida_kernwin.action_desc_t_icon_get, _ida_kernwin.action_desc_t_icon_set, doc=r"""icon""")
    r"""
    an optional icon ID to use
    """
    flags: "int" = property(_ida_kernwin.action_desc_t_flags_get, _ida_kernwin.action_desc_t_flags_set, doc=r"""flags""")
    r"""
    See Action flags.
    """

    def __init__(self, name: "char const *", label: "char const *", handler: "PyObject *", shortcut: "char const *"=None, tooltip: "char const *"=None, icon: "int"=-1, flags: "int"=0):
        r"""
        __init__(self, name, label, handler, shortcut=None, tooltip=None, icon=-1, flags=0) -> action_desc_t

        @param name: char const *
        @param label: char const *
        @param handler: PyObject *
        @param shortcut: char const *
        @param tooltip: char const *
        @param icon: int
        @param flags: int
        """
        _ida_kernwin.action_desc_t_swiginit(self, _ida_kernwin.new_action_desc_t(name, label, handler, shortcut, tooltip, icon, flags))
    __swig_destroy__ = _ida_kernwin.delete_action_desc_t

# Register action_desc_t in _ida_kernwin:
_ida_kernwin.action_desc_t_swigregister(action_desc_t)
ADF_OWN_HANDLER = _ida_kernwin.ADF_OWN_HANDLER
r"""
handler is owned by the action; it'll be destroyed when the action is
unregistered. Use DYNACTION_DESC_LITERAL to set this bit.
"""

ADF_NO_UNDO = _ida_kernwin.ADF_NO_UNDO
r"""
the action does not create an undo point. useful for actions that do not modify
the database.
"""

ADF_OT_MASK = _ida_kernwin.ADF_OT_MASK
r"""
Owner type mask.
"""

ADF_OT_PLUGIN = _ida_kernwin.ADF_OT_PLUGIN
r"""
Owner is a plugin_t.
"""

ADF_OT_PLUGMOD = _ida_kernwin.ADF_OT_PLUGMOD
r"""
Owner is a plugmod_t.
"""

ADF_OT_PROCMOD = _ida_kernwin.ADF_OT_PROCMOD
r"""
Owner is a procmod_t.
"""

ADF_GLOBAL = _ida_kernwin.ADF_GLOBAL
r"""
Register the action globally, so that it's available even if no IDB is present
"""

ADF_NO_HIGHLIGHT = _ida_kernwin.ADF_NO_HIGHLIGHT
r"""
After activating, do not update the highlight according to what's under the
cursor (listings only.)
"""

ADF_CHECKABLE = _ida_kernwin.ADF_CHECKABLE
r"""
action is checkable
"""

ADF_CHECKED = _ida_kernwin.ADF_CHECKED
r"""
starts in a checked state (requires ADF_CHECKABLE)
"""


AA_NONE = _ida_kernwin.AA_NONE
r"""
no effect
"""

AA_LABEL = _ida_kernwin.AA_LABEL
r"""
see update_action_label()
"""

AA_SHORTCUT = _ida_kernwin.AA_SHORTCUT
r"""
see update_action_shortcut()
"""

AA_TOOLTIP = _ida_kernwin.AA_TOOLTIP
r"""
see update_action_tooltip()
"""

AA_ICON = _ida_kernwin.AA_ICON
r"""
see update_action_icon()
"""

AA_STATE = _ida_kernwin.AA_STATE
r"""
see update_action_state()
"""

AA_CHECKABLE = _ida_kernwin.AA_CHECKABLE
r"""
see update_action_checkable()
"""

AA_CHECKED = _ida_kernwin.AA_CHECKED
r"""
see update_action_checked()
"""

AA_VISIBILITY = _ida_kernwin.AA_VISIBILITY
r"""
see update_action_visibility()
"""


def cancel_exec_request(req_id: "int") -> "bool":
    r"""
    cancel_exec_request(req_id) -> bool
    Try to cancel an asynchronous exec request (ui_cancel_exec_request).

    @param req_id: (C++: int) request id
    @retval true: successfully canceled
    @retval false: request has already been processed.
    """
    return _ida_kernwin.cancel_exec_request(req_id)

def cancel_thread_exec_requests(tid: "__qthread_t") -> "int":
    r"""
    cancel_thread_exec_requests(tid) -> int
    Try to cancel asynchronous exec requests created by the specified thread.

    @param tid: (C++: qthread_t) thread id
    @return: number of the canceled requests.
    """
    return _ida_kernwin.cancel_thread_exec_requests(tid)

def get_synced_group(w: "TWidget const *") -> "synced_group_t const *":
    r"""
    get_synced_group(w) -> synced_group_t
    Get the group of widgets/registers this view is synchronized with

    @param w: (C++: const TWidget *) the widget
    @return: the group of widgets/registers, or nullptr
    """
    return _ida_kernwin.get_synced_group(w)

def banner(wait: "int") -> "bool":
    r"""
    banner(wait) -> bool
    Show a banner dialog box (ui_banner).

    @param wait: (C++: int) time to wait before closing
    @retval 1: ok
    @retval 0: esc was pressed
    """
    return _ida_kernwin.banner(wait)

def is_msg_inited() -> "bool":
    r"""
    is_msg_inited() -> bool
    Can we use msg() functions?
    """
    return _ida_kernwin.is_msg_inited()

def refresh_idaview() -> "void":
    r"""
    refresh_idaview()
    Refresh marked windows (ui_refreshmarked)
    """
    return _ida_kernwin.refresh_idaview()

def refresh_idaview_anyway() -> "void":
    r"""
    refresh_idaview_anyway()
    Refresh all disassembly views (ui_refresh), forces an immediate refresh. Please
    consider request_refresh() instead
    """
    return _ida_kernwin.refresh_idaview_anyway()

def analyzer_options() -> "void":
    r"""
    analyzer_options()
    Allow the user to set analyzer options. (show a dialog box)
    (ui_analyzer_options)
    """
    return _ida_kernwin.analyzer_options()

def get_screen_ea() -> "ea_t":
    r"""
    get_screen_ea() -> ea_t
    Get the address at the screen cursor (ui_screenea)
    """
    return _ida_kernwin.get_screen_ea()

def get_opnum() -> "int":
    r"""
    get_opnum() -> int
    Get current operand number, -1 means no operand (ui_get_opnum)
    """
    return _ida_kernwin.get_opnum()

def get_cursor() -> "int *, int *":
    r"""
    get_cursor() -> bool
    Get the cursor position on the screen (ui_get_cursor).
    @note: coordinates are 0-based

    @retval true: pointers are filled
    @retval false: no disassembly window open
    """
    return _ida_kernwin.get_cursor()

def get_output_cursor() -> "int *, int *":
    r"""
    get_output_cursor() -> bool
    Get coordinates of the output window's cursor (ui_get_output_cursor).
    @note: coordinates are 0-based
    @note: this function will succeed even if the output window is not visible

    @retval false: the output window has been destroyed.
    @retval true: pointers are filled
    """
    return _ida_kernwin.get_output_cursor()

def get_curline() -> "char const *":
    r"""
    get_curline() -> char const *
    Get current line from the disassemble window (ui_get_curline).

    @return: cptr current line with the color codes (use tag_remove() to remove the
             color codes)
    """
    return _ida_kernwin.get_curline()

def open_url(url: "char const *") -> "void":
    r"""
    open_url(url)
    Open the given url (ui_open_url)

    @param url: (C++: const char *) char const *
    """
    return _ida_kernwin.open_url(url)

def get_hexdump_ea(hexdump_num: "int") -> "ea_t":
    r"""
    get_hexdump_ea(hexdump_num) -> ea_t
    Get the current address in a hex view.

    @param hexdump_num: (C++: int) number of hexview window
    """
    return _ida_kernwin.get_hexdump_ea(hexdump_num)

def get_key_code(keyname: "char const *") -> "ushort":
    r"""
    get_key_code(keyname) -> ushort
    Get keyboard key code by its name (ui_get_key_code)

    @param keyname: (C++: const char *) char const *
    """
    return _ida_kernwin.get_key_code(keyname)

def lookup_key_code(key: "int", shift: "int", is_qt: "bool") -> "ushort":
    r"""
    lookup_key_code(key, shift, is_qt) -> ushort
    Get shortcut code previously created by ui_get_key_code.

    @param key: (C++: int) key constant
    @param shift: (C++: int) modifiers
    @param is_qt: (C++: bool) are we using gui version?
    """
    return _ida_kernwin.lookup_key_code(key, shift, is_qt)

def refresh_navband(force: "bool") -> "void":
    r"""
    refresh_navband(force)
    Refresh navigation band if changed (ui_refresh_navband).

    @param force: (C++: bool) refresh regardless
    """
    return _ida_kernwin.refresh_navband(force)

def refresh_chooser(title: "char const *") -> "bool":
    r"""
    refresh_chooser(title) -> bool
    Mark a non-modal custom chooser for a refresh (ui_refresh_chooser).

    @param title: (C++: const char *) title of chooser
    @return: success
    """
    return _ida_kernwin.refresh_chooser(title)

def close_chooser(title: "char const *") -> "bool":
    r"""
    close_chooser(title) -> bool
    Close a non-modal chooser (ui_close_chooser).

    @param title: (C++: const char *) window title of chooser to close
    @return: success
    """
    return _ida_kernwin.close_chooser(title)

def set_dock_pos(src_ctrl: "char const *", dest_ctrl: "char const *", orient: "int", left: "int"=0, top: "int"=0, right: "int"=0, bottom: "int"=0) -> "bool":
    r"""
    set_dock_pos(src_ctrl, dest_ctrl, orient, left=0, top=0, right=0, bottom=0) -> bool
    Sets the dock orientation of a window relatively to another window.

    Use the left, top, right, bottom parameters if DP_FLOATING is used,
    or if you want to specify the width of docked windows.

    @param src_ctrl: char const *
    @param dest_ctrl: char const *
    @param orient: One of DP_XXXX constants
    @param left: int
    @param top: int
    @param right: int
    @param bottom: int
    @return: Boolean

    Example:
        set_dock_pos('Structures', 'Enums', DP_RIGHT) <- docks the Structures window to the right of Enums window
    """
    return _ida_kernwin.set_dock_pos(src_ctrl, dest_ctrl, orient, left, top, right, bottom)

def get_icon_id_by_name(icon_name: "char const *") -> "int":
    r"""
    get_icon_id_by_name(icon_name) -> int
    Retrieve the id of the icon by name (ui_get_icon_id_by_name).

    @param icon_name: (C++: const char *) full name of the icon
    @return: icon id
    """
    return _ida_kernwin.get_icon_id_by_name(icon_name)

def free_custom_icon(icon_id: "int") -> "void":
    r"""
    free_custom_icon(icon_id)
    Frees an icon loaded with load_custom_icon()

    @param icon_id: int
    """
    return _ida_kernwin.free_custom_icon(icon_id)
class __qtimer_t(object):
    r"""
    Proxy of C++ __qtimer_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(self) -> __qtimer_t
        """
        _ida_kernwin.__qtimer_t_swiginit(self, _ida_kernwin.new___qtimer_t())
    __swig_destroy__ = _ida_kernwin.delete___qtimer_t

# Register __qtimer_t in _ida_kernwin:
_ida_kernwin.__qtimer_t_swigregister(__qtimer_t)

def unregister_action(name: "char const *") -> "bool":
    r"""
    unregister_action(name) -> bool
    Delete a previously-registered action (ui_unregister_action).

    @param name: (C++: const char *) name of action
    @return: success
    """
    return _ida_kernwin.unregister_action(name)

def create_toolbar(name: "char const *", label: "char const *", before: "char const *"=None, flags: "int"=0) -> "bool":
    r"""
    create_toolbar(name, label, before=None, flags=0) -> bool
    Create a toolbar with the given name, label and optional position

    @param name: (C++: const char *) name of toolbar (must be unique)
    @param label: (C++: const char *) label of toolbar
    @param before: (C++: const char *) if non-nullptr, the toolbar before which the new toolbar will be
                   inserted
    @param flags: (C++: int) a combination of create toolbar flags, to determine toolbar
                  position
    @return: success
    """
    return _ida_kernwin.create_toolbar(name, label, before, flags)

def delete_toolbar(name: "char const *") -> "bool":
    r"""
    delete_toolbar(name) -> bool
    Delete an existing toolbar

    @param name: (C++: const char *) name of toolbar
    @return: success
    """
    return _ida_kernwin.delete_toolbar(name)

def create_menu(name: "char const *", label: "char const *", menupath: "char const *"=None) -> "bool":
    r"""
    create_menu(name, label, menupath=None) -> bool
    Create a menu with the given name, label and optional position, either in the
    menubar, or as a submenu. If 'menupath' is non-nullptr, it provides information
    about where the menu should be positioned. First, IDA will try and resolve the
    corresponding menu by its name. If such an existing menu is found and is present
    in the menubar, then the new menu will be inserted in the menubar before it.
    Otherwise, IDA will try to resolve 'menupath' as it would for
    attach_action_to_menu() and, if found, add the new menu like so:
    // The new 'My menu' submenu will appear in the 'Comments' submenu
    // before the 'Enter comment..." command
    create_menu("(...)", "My menu", "Edit/Comments/Enter comment...");
    or
    // The new 'My menu' submenu will appear at the end of the
    // 'Comments' submenu.
    create_menu("(...)", "My menu", "Edit/Comments/");
    If the above fails, the new menu will be appended to the menubar.

    @param name: (C++: const char *) name of menu (must be unique)
    @param label: (C++: const char *) label of menu
    @param menupath: (C++: const char *) where should the menu be inserted
    @return: success
    """
    return _ida_kernwin.create_menu(name, label, menupath)

def delete_menu(name: "char const *") -> "bool":
    r"""
    delete_menu(name) -> bool
    Delete an existing menu

    @param name: (C++: const char *) name of menu
    @return: success
    """
    return _ida_kernwin.delete_menu(name)

def attach_action_to_menu(menupath: "char const *", name: "char const *", flags: "int"=0) -> "bool":
    r"""
    attach_action_to_menu(menupath, name, flags=0) -> bool
    Attach a previously-registered action to the menu (ui_attach_action_to_menu).
    @note: You should not change top level menu, or the Edit,Plugins submenus If you
           want to modify the debugger menu, do it at the ui_debugger_menu_change
           event (ida might destroy your menu item if you do it elsewhere).

    @param menupath: (C++: const char *) path to the menu item after or before which the insertion will
                     take place.
    * Example: Debug/StartProcess
    * Whitespace, punctuation are ignored.
    * It is allowed to specify only the prefix of the menu item.
    * Comparison is case insensitive.
    * menupath may start with the following prefixes:
    * [S] - modify the main menu of the structure window
    * [E] - modify the main menu of the enum window
    @param name: (C++: const char *) the action name
    @param flags: (C++: int) a combination of Set menu flags, to determine menu item position
    @return: success
    """
    return _ida_kernwin.attach_action_to_menu(menupath, name, flags)

def detach_action_from_menu(menupath: "char const *", name: "char const *") -> "bool":
    r"""
    detach_action_from_menu(menupath, name) -> bool
    Detach an action from the menu (ui_detach_action_from_menu).

    @param menupath: (C++: const char *) path to the menu item
    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.detach_action_from_menu(menupath, name)

def attach_action_to_toolbar(toolbar_name: "char const *", name: "char const *") -> "bool":
    r"""
    attach_action_to_toolbar(toolbar_name, name) -> bool
    Attach an action to an existing toolbar (ui_attach_action_to_toolbar).

    @param toolbar_name: (C++: const char *) the name of the toolbar
    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.attach_action_to_toolbar(toolbar_name, name)

def detach_action_from_toolbar(toolbar_name: "char const *", name: "char const *") -> "bool":
    r"""
    detach_action_from_toolbar(toolbar_name, name) -> bool
    Detach an action from the toolbar (ui_detach_action_from_toolbar).

    @param toolbar_name: (C++: const char *) the name of the toolbar
    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.detach_action_from_toolbar(toolbar_name, name)

def register_and_attach_to_menu(menupath: "char const *", name: "char const *", label: "char const *", shortcut: "char const *", flags: "int", handler: "action_handler_t *", owner: "void *", action_desc_t_flags: "int") -> "bool":
    r"""
    register_and_attach_to_menu(menupath, name, label, shortcut, flags, handler, owner, action_desc_t_flags) -> bool
    Helper.

    You are not encouraged to use this, as it mixes flags for both
    register_action(), and attach_action_to_menu().

    The only reason for its existence is to make it simpler to port existing plugins
    to the new actions API.

    @param menupath: (C++: const char *) char const *
    @param name: (C++: const char *) char const *
    @param label: (C++: const char *) char const *
    @param shortcut: (C++: const char *) char const *
    @param flags: (C++: int)
    @param handler: (C++: action_handler_t *)
    @param owner: (C++: void *)
    @param action_desc_t_flags: (C++: int)
    """
    return _ida_kernwin.register_and_attach_to_menu(menupath, name, label, shortcut, flags, handler, owner, action_desc_t_flags)

def display_widget(widget: "TWidget *", options: "uint32", dest_ctrl: "char const *"=None) -> "void":
    r"""
    display_widget(widget, options, dest_ctrl=None)
    Display a widget, dock it if not done before

    @param widget: (C++: TWidget *) widget to display
    @param options: (C++: uint32) Widget open flags
    @param dest_ctrl: (C++: const char *) where to dock: if nullptr or invalid then use the active
                      docker if there is not create a new tab relative to current
                      active tab
    """
    return _ida_kernwin.display_widget(widget, options, dest_ctrl)

def close_widget(widget: "TWidget *", options: "int") -> "void":
    r"""
    close_widget(widget, options)
    Close widget (ui_close_widget, only gui version).

    @param widget: (C++: TWidget *) pointer to the widget to close
    @param options: (C++: int) Form close flags
    """
    return _ida_kernwin.close_widget(widget, options)

def activate_widget(widget: "TWidget *", take_focus: "bool") -> "void":
    r"""
    activate_widget(widget, take_focus)
    Activate widget (only gui version) (ui_activate_widget).

    @param widget: (C++: TWidget *) existing widget to display
    @param take_focus: (C++: bool) give focus to given widget
    """
    return _ida_kernwin.activate_widget(widget, take_focus)

def find_widget(caption: "char const *") -> "TWidget *":
    r"""
    find_widget(caption) -> TWidget *
    Find widget with the specified caption (only gui version) (ui_find_widget). NB:
    this callback works only with the tabbed widgets!

    @param caption: (C++: const char *) title of tab, or window title if widget is not tabbed
    @return: pointer to the TWidget, nullptr if none is found
    """
    return _ida_kernwin.find_widget(caption)

def get_current_widget() -> "TWidget *":
    r"""
    get_current_widget() -> TWidget *
    Get a pointer to the current widget (ui_get_current_widget).
    """
    return _ida_kernwin.get_current_widget()

def get_widget_type(widget: "TWidget *") -> "twidget_type_t":
    r"""
    get_widget_type(widget) -> twidget_type_t
    Get the type of the TWidget * (ui_get_widget_type).

    @param widget: (C++: TWidget *)
    """
    return _ida_kernwin.get_widget_type(widget)

def get_widget_title(widget: "TWidget *") -> "qstring *":
    r"""
    get_widget_title(widget) -> str
    Get the TWidget's title (ui_get_widget_title).

    @param widget: (C++: TWidget *)
    """
    return _ida_kernwin.get_widget_title(widget)

def custom_viewer_jump(v: "TWidget *", loc: "lochist_entry_t const &", flags: "uint32"=0) -> "bool":
    r"""
    custom_viewer_jump(v, loc, flags=0) -> bool
    Append 'loc' to the viewer's history, and cause the viewer to display it.

    @param v: (C++: TWidget *) (TWidget *)
    @param loc: (C++: const lochist_entry_t &) (const lochist_entry_t &)
    @param flags: (C++: uint32) (uint32) or'ed combination of CVNF_* values
    @return: success
    """
    return _ida_kernwin.custom_viewer_jump(v, loc, flags)

def ea_viewer_history_push_and_jump(v: "TWidget *", ea: "ea_t", x: "int", y: "int", lnnum: "int") -> "bool":
    r"""
    ea_viewer_history_push_and_jump(v, ea, x, y, lnnum) -> bool
    Push current location in the history and jump to the given location
    (ui_ea_viewer_history_push_and_jump). This will jump in the given ea viewer and
    also in other synchronized views.

    @param v: (C++: TWidget *) ea viewer
    @param ea: (C++: ea_t) jump destination
    @param x: (C++: int) ,y: coords on screen
    @param lnnum: (C++: int) desired line number of given address
    @param lnnum: (C++: int) desired line number of given address
    """
    return _ida_kernwin.ea_viewer_history_push_and_jump(v, ea, x, y, lnnum)

def get_ea_viewer_history_info(nback: "int *", nfwd: "int *", v: "TWidget *") -> "bool":
    r"""
    get_ea_viewer_history_info(nback, nfwd, v) -> bool
    Get information about what's in the history (ui_ea_viewer_history_info).

    @param nback: (C++: int *) number of available back steps
    @param nfwd: (C++: int *) number of available forward steps
    @param v: (C++: TWidget *) ea viewer
    @retval false: if the given ea viewer does not exist
    @retval true: otherwise
    """
    return _ida_kernwin.get_ea_viewer_history_info(nback, nfwd, v)

def refresh_custom_viewer(custom_viewer: "TWidget *") -> "void":
    r"""
    refresh_custom_viewer(custom_viewer)
    Refresh custom ida viewer (ui_refresh_custom_viewer)

    @param custom_viewer: (C++: TWidget *)
    """
    return _ida_kernwin.refresh_custom_viewer(custom_viewer)

def repaint_custom_viewer(custom_viewer: "TWidget *") -> "void":
    r"""
    repaint_custom_viewer(custom_viewer)
    Repaint the given widget immediately (ui_repaint_qwidget)

    @param custom_viewer: (C++: TWidget *)
    """
    return _ida_kernwin.repaint_custom_viewer(custom_viewer)

def jumpto(*args) -> "bool":
    r"""
    jumpto(ea, opnum=-1, uijmp_flags=0x0001) -> bool
    Set cursor position in custom ida viewer.

    @param custom_viewer: (C++: TWidget *) view
    @param place: (C++: place_t *) target position
    @param uijmp_flags: int

    @return: success
    jumpto(custom_viewer, place, x, y) -> bool

    @param custom_viewer: TWidget *
    @param place: place_t *
    @param x: int
    """
    return _ida_kernwin.jumpto(*args)

def get_custom_viewer_place(custom_viewer: "TWidget *", mouse: "bool") -> "int *, int *":
    r"""
    get_custom_viewer_place(custom_viewer, mouse) -> place_t
    Get current place in a custom viewer (ui_get_curplace).

    See also the more complete get_custom_viewer_location()

    @param custom_viewer: (C++: TWidget *) view
    @param mouse: (C++: bool) mouse position (otherwise cursor position)
    """
    return _ida_kernwin.get_custom_viewer_place(custom_viewer, mouse)

def get_custom_viewer_location(*args) -> "bool":
    r"""
    get_custom_viewer_location(out, custom_viewer, mouse=False) -> bool
    Get the current location in a custom viewer (ui_get_custom_viewer_location_2).

    @param out: (C++: listing_location_t *) output structure to fill
    @param custom_viewer: (C++: TWidget *) the listing widget
    @param flags: (C++: uint32) or'ed combination of CVLF_* values
    get_custom_viewer_location(out, custom_viewer, flags=0) -> bool

    @param out: listing_location_t *
    @param custom_viewer: TWidget *
    @param flags: uint32
    """
    return _ida_kernwin.get_custom_viewer_location(*args)

def is_idaq() -> "bool":
    r"""
    is_idaq() -> bool
    Returns True or False depending if IDAPython is hosted by IDAQ
    """
    return _ida_kernwin.is_idaq()

def attach_action_to_popup(widget: "TWidget *", popup_handle: "TPopupMenu *", name: "char const *", popuppath: "char const *"=None, flags: "int"=0) -> "bool":
    r"""
    attach_action_to_popup(widget, popup_handle, name, popuppath=None, flags=0) -> bool
    Insert a previously-registered action into the widget's popup menu
    (ui_attach_action_to_popup). This function has two "modes": 'single-shot', and
    'permanent'.

    @param widget: (C++: TWidget *) target widget
    @param popup_handle: (C++: TPopupMenu *) target popup menu
    * if non-nullptr, the action is added to this popup menu invocation (i.e.,
    'single-shot')
    * if nullptr, the action is added to a list of actions that should always be
    present in context menus for this widget (i.e., 'permanent'.)
    @param name: (C++: const char *) action name
    @param popuppath: (C++: const char *) can be nullptr
    @param flags: (C++: int) a combination of SETMENU_ flags (see Set menu flags)
    @return: success
    """
    return _ida_kernwin.attach_action_to_popup(widget, popup_handle, name, popuppath, flags)

def detach_action_from_popup(widget: "TWidget *", name: "char const *") -> "bool":
    r"""
    detach_action_from_popup(widget, name) -> bool
    Remove a previously-registered action, from the list of 'permanent' context menu
    actions for this widget (ui_detach_action_from_popup). This only makes sense if
    the action has been added to 'widget's list of permanent popup actions by
    calling attach_action_to_popup in 'permanent' mode.

    @param widget: (C++: TWidget *) target widget
    @param name: (C++: const char *) action name
    """
    return _ida_kernwin.detach_action_from_popup(widget, name)

def update_action_label(name: "char const *", label: "char const *") -> "bool":
    r"""
    update_action_label(name, label) -> bool
    Update an action's label (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param label: (C++: const char *) new label
    @return: success
    """
    return _ida_kernwin.update_action_label(name, label)

def update_action_shortcut(name: "char const *", shortcut: "char const *") -> "bool":
    r"""
    update_action_shortcut(name, shortcut) -> bool
    Update an action's shortcut (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param shortcut: (C++: const char *) new shortcut
    @return: success
    """
    return _ida_kernwin.update_action_shortcut(name, shortcut)

def update_action_tooltip(name: "char const *", tooltip: "char const *") -> "bool":
    r"""
    update_action_tooltip(name, tooltip) -> bool
    Update an action's tooltip (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param tooltip: (C++: const char *) new tooltip
    @return: success
    """
    return _ida_kernwin.update_action_tooltip(name, tooltip)

def update_action_icon(name: "char const *", icon: "int") -> "bool":
    r"""
    update_action_icon(name, icon) -> bool
    Update an action's icon (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param icon: (C++: int) new icon id
    @return: success
    """
    return _ida_kernwin.update_action_icon(name, icon)

def update_action_state(name: "char const *", state: "action_state_t") -> "bool":
    r"""
    update_action_state(name, state) -> bool
    Update an action's state (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param state: (C++: action_state_t) new state
    @return: success
    """
    return _ida_kernwin.update_action_state(name, state)

def update_action_checkable(name: "char const *", checkable: "bool") -> "bool":
    r"""
    update_action_checkable(name, checkable) -> bool
    Update an action's checkability (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param checkable: (C++: bool) new checkability
    @return: success
    """
    return _ida_kernwin.update_action_checkable(name, checkable)

def update_action_checked(name: "char const *", checked: "bool") -> "bool":
    r"""
    update_action_checked(name, checked) -> bool
    Update an action's checked state (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param checked: (C++: bool) new checked state
    @return: success
    """
    return _ida_kernwin.update_action_checked(name, checked)

def update_action_visibility(name: "char const *", visible: "bool") -> "bool":
    r"""
    update_action_visibility(name, visible) -> bool
    Update an action's visibility (ui_update_action_attr).

    @param name: (C++: const char *) action name
    @param visible: (C++: bool) new visibility
    @return: success
    """
    return _ida_kernwin.update_action_visibility(name, visible)

def get_action_label(name: "char const *") -> "qstring *":
    r"""
    get_action_label(name) -> str
    Get an action's label (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_label(name)

def get_action_shortcut(name: "char const *") -> "qstring *":
    r"""
    get_action_shortcut(name) -> str
    Get an action's shortcut (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_shortcut(name)

def get_action_tooltip(name: "char const *") -> "qstring *":
    r"""
    get_action_tooltip(name) -> str
    Get an action's tooltip (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_tooltip(name)

def get_action_icon(name: "char const *") -> "int *":
    r"""
    get_action_icon(name) -> bool
    Get an action's icon (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_icon(name)

def get_action_state(name: "char const *") -> "action_state_t *":
    r"""
    get_action_state(name) -> bool
    Get an action's state (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_state(name)

def get_action_checkable(name: "char const *") -> "bool *":
    r"""
    get_action_checkable(name) -> bool
    Get an action's checkability (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_checkable(name)

def get_action_checked(name: "char const *") -> "bool *":
    r"""
    get_action_checked(name) -> bool
    Get an action's checked state (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_checked(name)

def get_action_visibility(name: "char const *") -> "bool *":
    r"""
    get_action_visibility(name) -> bool
    Get an action's visibility (ui_get_action_attr).

    @param name: (C++: const char *) the action name
    @return: success
    """
    return _ida_kernwin.get_action_visibility(name)

def set_custom_viewer_qt_aware(custom_viewer: "TWidget *") -> "bool":
    r"""
    set_custom_viewer_qt_aware(custom_viewer) -> bool
    Allow the given viewer to interpret Qt events (ui_set_custom_viewer_handler)

    @param custom_viewer: (C++: TWidget *)
    """
    return _ida_kernwin.set_custom_viewer_qt_aware(custom_viewer)

def get_custom_viewer_curline(custom_viewer: "TWidget *", mouse: "bool") -> "char const *":
    r"""
    get_custom_viewer_curline(custom_viewer, mouse) -> char const *
    Get current line of custom viewer (ui_get_custom_viewer_curline). The returned
    line contains color codes

    See also the more powerful get_custom_viewer_location()

    @param custom_viewer: (C++: TWidget *) view
    @param mouse: (C++: bool) mouse position (otherwise cursor position)
    @return: pointer to contents of current line
    """
    return _ida_kernwin.get_custom_viewer_curline(custom_viewer, mouse)

def get_custom_viewer_place_xcoord(custom_viewer: "TWidget *", pline: "place_t", pitem: "place_t") -> "int":
    r"""
    get_custom_viewer_place_xcoord(custom_viewer, pline, pitem) -> int
    Get the X position of the item, in the line

    @param custom_viewer: (C++: TWidget *) the widget
    @param pline: (C++: const place_t *) a place corresponding to the line
    @param pitem: (C++: const place_t *) a place corresponding to the item
    @return: -1 if 'pitem' is not included in the line
    -2 if 'pitem' points at the entire line
    >= 0 for the X coordinate within the pline, where pitem points
    """
    return _ida_kernwin.get_custom_viewer_place_xcoord(custom_viewer, pline, pitem)

def get_user_input_event(out: "input_event_t") -> "bool":
    r"""
    get_user_input_event(out) -> bool
    Get the current user input event (mouse button press, key press, ...) It is
    sometimes desirable to be able to tell when a certain situation happens (e.g.,
    'view_curpos' gets triggered); this function exists to provide that context (GUI
    version only)

    @param out: (C++: input_event_t *) the input event data
    @return: false if we are not currently processing a user input event
    """
    return _ida_kernwin.get_user_input_event(out)

def get_output_curline(mouse: "bool") -> "qstring *":
    r"""
    get_output_curline(mouse) -> str
    Get current line of output window (ui_get_output_curline).

    @param mouse: (C++: bool) current for mouse pointer?
    @return: false if output contains no text
    """
    return _ida_kernwin.get_output_curline(mouse)

def get_output_selected_text() -> "qstring *":
    r"""
    get_output_selected_text() -> str
    Returns selected text from output window (ui_get_output_selected_text).

    @return: true if there is a selection
    """
    return _ida_kernwin.get_output_selected_text()

def get_current_viewer() -> "TWidget *":
    r"""
    get_current_viewer() -> TWidget *
    Get current ida viewer (idaview or custom viewer) (ui_get_current_viewer)
    """
    return _ida_kernwin.get_current_viewer()

def get_view_renderer_type(v: "TWidget *") -> "tcc_renderer_type_t":
    r"""
    get_view_renderer_type(v) -> tcc_renderer_type_t
    Get the type of renderer currently in use in the given view
    (ui_get_renderer_type)

    @param v: (C++: TWidget *)
    """
    return _ida_kernwin.get_view_renderer_type(v)

def set_view_renderer_type(v: "TWidget *", rt: "tcc_renderer_type_t") -> "void":
    r"""
    set_view_renderer_type(v, rt)
    Set the type of renderer to use in a view (ui_set_renderer_type)

    @param v: (C++: TWidget *)
    @param rt: (C++: tcc_renderer_type_t) enum tcc_renderer_type_t
    """
    return _ida_kernwin.set_view_renderer_type(v, rt)

def create_empty_widget(title: "char const *", icon: "int"=-1) -> "TWidget *":
    r"""
    create_empty_widget(title, icon=-1) -> TWidget
    Create an empty widget, serving as a container for custom user widgets

    @param title: (C++: const char *) char const *
    @param icon: (C++: int)
    """
    return _ida_kernwin.create_empty_widget(title, icon)

def msg_clear() -> "void":
    r"""
    msg_clear()
    Clear the "Output" window.
    """
    return _ida_kernwin.msg_clear()

def msg_save(path: "qstring &") -> "bool":
    r"""
    msg_save(path) -> bool
    Save the "Output" window contents into a file

    @param path: (C++: qstring &) The path of the file to save the contents into. An empty path means
                 that the user will be prompted for the destination and, if the file
                 already exists, the user will be asked to confirm before overriding
                 its contents. Upon return, 'path' will contain the path that the
                 user chose.
    @return: success
    """
    return _ida_kernwin.msg_save(path)

def get_active_modal_widget() -> "TWidget *":
    r"""
    get_active_modal_widget() -> TWidget *
    Get the current, active modal TWidget instance. Note that in this context, the
    "wait dialog" is not considered: this function will return nullptr even if it is
    currently shown.

    @return: TWidget * the active modal widget, or nullptr
    """
    return _ida_kernwin.get_active_modal_widget()

def get_navband_pixel(ea: "ea_t") -> "bool *":
    r"""
    get_navband_pixel(ea) -> int
    Maps an address, onto a pixel coordinate within the navigation band

    @param ea: The address to map
    @return: a list [pixel, is_vertical]
    """
    return _ida_kernwin.get_navband_pixel(ea)

def get_navband_ea(pixel: "int") -> "ea_t":
    r"""
    get_navband_ea(pixel) -> ea_t
    Translate the pixel position on the navigation band, into an address.

    @param pixel: (C++: int)
    """
    return _ida_kernwin.get_navband_ea(pixel)

def get_window_id(name: "char const *"=None) -> "void *":
    r"""
    get_window_id(name=None)
    Get the system-specific window ID (GUI version only)

    @param name: (C++: const char *) name of the window (nullptr means the main IDA window)
    @return: the low-level window ID
    """
    return _ida_kernwin.get_window_id(name)

def is_idaview(v: "TWidget *") -> "bool":
    r"""
    is_idaview(v) -> bool
    Is the given custom view an idaview? (ui_is_idaview)

    @param v: (C++: TWidget *)
    """
    return _ida_kernwin.is_idaview(v)

def read_selection(v: "TWidget *", p1: "twinpos_t", p2: "twinpos_t") -> "bool":
    r"""
    read_selection(v, p1, p2) -> bool
    Read the user selection, and store its information in p0 (from) and p1 (to).

    This can be used as follows:


    >>> p0 = idaapi.twinpos_t()
    p1 = idaapi.twinpos_t()
    view = idaapi.get_current_viewer()
    idaapi.read_selection(view, p0, p1)


    At that point, p0 and p1 hold information for the selection.
    But, the 'at' property of p0 and p1 is not properly typed.
    To specialize it, call #place() on it, passing it the view
    they were retrieved from. Like so:


    >>> place0 = p0.place(view)
    place1 = p1.place(view)


    This will effectively "cast" the place into a specialized type,
    holding proper information, depending on the view type (e.g.,
    disassembly, structures, enums, ...)

    @param view: The view to retrieve the selection for.
    @param p1: Storage for the "to" part of the selection.
    @param p1: Storage for the "to" part of the selection.
    @return: a bool value indicating success.
    """
    return _ida_kernwin.read_selection(v, p1, p2)

def read_range_selection(v: "TWidget *") -> "ea_t *, ea_t *":
    r"""
    read_range_selection(v) -> bool
    Get the address range for the selected range boundaries, this is the convenient
    function for read_selection()

    @param v: (C++: TWidget *) view, nullptr means the last active window containing addresses
    @retval 0: no range is selected
    @retval 1: ok, start ea and end ea are filled
    """
    return _ida_kernwin.read_range_selection(v)

def unmark_selection() -> "void":
    r"""
    unmark_selection()
    Unmark selection (ui_unmarksel)
    """
    return _ida_kernwin.unmark_selection()

def create_code_viewer(custview: "TWidget *", flags: "int"=0, parent: "TWidget *"=None) -> "TWidget *":
    r"""
    create_code_viewer(custview, flags=0, parent=None) -> TWidget
    Create a code viewer (ui_create_code_viewer). A code viewer contains on the left
    side a widget representing the line numbers, and on the right side, the child
    widget passed as parameter. It will inherit its title from the child widget.

    @param custview: (C++: TWidget *) the custom view to be added
    @param flags: (C++: int) Code viewer flags
    @param parent: (C++: TWidget *) widget to contain the new code viewer
    """
    return _ida_kernwin.create_code_viewer(custview, flags, parent)

def set_code_viewer_handler(code_viewer: "TWidget *", handler_id: "custom_viewer_handler_id_t", handler_or_data: "void *") -> "void *":
    r"""
    set_code_viewer_handler(code_viewer, handler_id, handler_or_data) -> void *
    Set a handler for a code viewer event (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *) the code viewer
    @param handler_id: (C++: custom_viewer_handler_id_t) one of CDVH_ in custom_viewer_handler_id_t
    @param handler_or_data: (C++: void *) can be a handler or data. see examples in Functions:
                            custom viewer handlers
    @return: old value of the handler or data
    """
    return _ida_kernwin.set_code_viewer_handler(code_viewer, handler_id, handler_or_data)

def set_code_viewer_user_data(code_viewer: "TWidget *", ud: "void *") -> "bool":
    r"""
    set_code_viewer_user_data(code_viewer, ud) -> bool
    Set the user data on a code viewer (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *)
    @param ud: (C++: void *)
    """
    return _ida_kernwin.set_code_viewer_user_data(code_viewer, ud)

def get_viewer_user_data(viewer: "TWidget *") -> "void *":
    r"""
    get_viewer_user_data(viewer) -> void *
    Get the user data from a custom viewer (ui_get_viewer_user_data)

    @param viewer: (C++: TWidget *)
    """
    return _ida_kernwin.get_viewer_user_data(viewer)

def get_viewer_place_type(viewer: "TWidget *") -> "tcc_place_type_t":
    r"""
    get_viewer_place_type(viewer) -> tcc_place_type_t
    Get the type of place_t instances a viewer uses & creates
    (ui_get_viewer_place_type).

    @param viewer: (C++: TWidget *)
    """
    return _ida_kernwin.get_viewer_place_type(viewer)

def set_code_viewer_line_handlers(code_viewer: "TWidget *", click_handler: "code_viewer_lines_click_t *", popup_handler: "code_viewer_lines_click_t *", dblclick_handler: "code_viewer_lines_click_t *", drawicon_handler: "code_viewer_lines_icon_t *", linenum_handler: "code_viewer_lines_linenum_t *") -> "void":
    r"""
    set_code_viewer_line_handlers(code_viewer, click_handler, popup_handler, dblclick_handler, drawicon_handler, linenum_handler)
    Set handlers for code viewer line events. Any of these handlers may be nullptr

    @param code_viewer: (C++: TWidget *)
    @param click_handler: (C++: code_viewer_lines_click_t *)
    @param popup_handler: (C++: code_viewer_lines_click_t *)
    @param dblclick_handler: (C++: code_viewer_lines_click_t *)
    @param drawicon_handler: (C++: code_viewer_lines_icon_t *)
    @param linenum_handler: (C++: code_viewer_lines_linenum_t *)
    """
    return _ida_kernwin.set_code_viewer_line_handlers(code_viewer, click_handler, popup_handler, dblclick_handler, drawicon_handler, linenum_handler)

def set_code_viewer_lines_icon_margin(code_viewer: "TWidget *", margin: "int") -> "bool":
    r"""
    set_code_viewer_lines_icon_margin(code_viewer, margin) -> bool
    Set space allowed for icons in the margin of a code viewer
    (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *)
    @param margin: (C++: int)
    """
    return _ida_kernwin.set_code_viewer_lines_icon_margin(code_viewer, margin)

def set_code_viewer_lines_alignment(code_viewer: "TWidget *", align: "int") -> "bool":
    r"""
    set_code_viewer_lines_alignment(code_viewer, align) -> bool
    Set alignment for lines in a code viewer (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *)
    @param align: (C++: int)
    """
    return _ida_kernwin.set_code_viewer_lines_alignment(code_viewer, align)

def set_code_viewer_lines_radix(code_viewer: "TWidget *", radix: "int") -> "bool":
    r"""
    set_code_viewer_lines_radix(code_viewer, radix) -> bool
    Set radix for values displayed in a code viewer (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *)
    @param radix: (C++: int)
    """
    return _ida_kernwin.set_code_viewer_lines_radix(code_viewer, radix)

def set_code_viewer_is_source(code_viewer: "TWidget *") -> "bool":
    r"""
    set_code_viewer_is_source(code_viewer) -> bool
    Specify that the given code viewer is used to display source code
    (ui_set_custom_viewer_handler).

    @param code_viewer: (C++: TWidget *)
    """
    return _ida_kernwin.set_code_viewer_is_source(code_viewer)

def get_tab_size(path: "char const *") -> "int":
    r"""
    get_tab_size(path) -> int
    Get the size of a tab in spaces (ui_get_tab_size).

    @param path: (C++: const char *) the path of the source view for which the tab size is requested.
    * if nullptr, the default size is returned.
    """
    return _ida_kernwin.get_tab_size(path)

def clr_cancelled() -> "void":
    r"""
    clr_cancelled()
    Clear "Cancelled" flag (ui_clr_cancelled)
    """
    return _ida_kernwin.clr_cancelled()

def set_cancelled() -> "void":
    r"""
    set_cancelled()
    Set "Cancelled" flag (ui_set_cancelled)
    """
    return _ida_kernwin.set_cancelled()

def user_cancelled() -> "bool":
    r"""
    user_cancelled() -> bool
    Test the ctrl-break flag (ui_test_cancelled).
    @retval 1: Ctrl-Break is detected, a message is displayed
    @retval 2: Ctrl-Break is detected again, a message is not displayed
    @retval 0: Ctrl-Break is not detected
    """
    return _ida_kernwin.user_cancelled()

def ui_load_new_file(temp_file: "qstring *", filename: "qstring *", pli: "linput_t **", neflags: "ushort", ploaders: "load_info_t **") -> "bool":
    r"""
    ui_load_new_file(temp_file, filename, pli, neflags, ploaders) -> bool
    Display a load file dialog and load file (ui_load_file).

    @param temp_file: (C++: qstring *) name of the file with the extracted archive member.
    @param filename: (C++: qstring *) the name of input file as is, library or archive name
    @param pli: (C++: linput_t **) loader input source, may be changed to point to temp_file
    @param neflags: (C++: ushort) combination of NEF_... bits (see Load file flags)
    @param ploaders: (C++: load_info_t **) list of loaders which accept file, may be changed for loaders
                     of temp_file
    @retval true: file was successfully loaded
    @retval false: otherwise
    """
    return _ida_kernwin.ui_load_new_file(temp_file, filename, pli, neflags, ploaders)

def ui_run_debugger(dbgopts: "char const *", exename: "char const *", argc: "int", argv: "char const *const *") -> "bool":
    r"""
    ui_run_debugger(dbgopts, exename, argc, argv) -> bool
    Load a debugger plugin and run the specified program (ui_run_dbg).

    @param dbgopts: (C++: const char *) value of the -r command line switch
    @param exename: (C++: const char *) name of the file to run
    @param argc: (C++: int) number of arguments for the executable
    @param argv: (C++: const char *const *) argument vector
    @return: success
    """
    return _ida_kernwin.ui_run_debugger(dbgopts, exename, argc, argv)

def load_dbg_dbginfo(*args) -> "bool":
    r"""
    load_dbg_dbginfo(path, li=None, base=BADADDR, verbose=False) -> bool
    Load debugging information from a file.

    @param path: (C++: const char *) path to file
    @param li: (C++: linput_t *) loader input. if nullptr, check DBG_NAME_KEY
    @param base: (C++: ea_t) loading address
    @param verbose: (C++: bool) dump status to message window
    """
    return _ida_kernwin.load_dbg_dbginfo(*args)

def add_idc_hotkey(hotkey: "char const *", idcfunc: "char const *") -> "int":
    r"""
    add_idc_hotkey(hotkey, idcfunc) -> int
    Add hotkey for IDC function (ui_add_idckey).

    @param hotkey: (C++: const char *) hotkey name
    @param idcfunc: (C++: const char *) IDC function name
    @return: IDC hotkey error codes
    """
    return _ida_kernwin.add_idc_hotkey(hotkey, idcfunc)

def set_highlight(viewer: "TWidget *", str: "char const *", flags: "int") -> "bool":
    r"""
    set_highlight(viewer, str, flags) -> bool
    Set the highlighted identifier in the viewer (ui_set_highlight).

    @param viewer: (C++: TWidget *) the viewer
    @param str: (C++: const char *) the text to match, or nullptr to remove current
    @param flags: (C++: int) combination of HIF_... bits (see set_highlight flags)
    @return: false if an error occurred
    """
    return _ida_kernwin.set_highlight(viewer, str, flags)

def open_exports_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_exports_window(ea) -> TWidget *
    Open the exports window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_exports_window(ea)

def open_imports_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_imports_window(ea) -> TWidget *
    Open the exports window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_imports_window(ea)

def open_names_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_names_window(ea) -> TWidget *
    Open the names window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_names_window(ea)

def open_funcs_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_funcs_window(ea) -> TWidget *
    Open the 'Functions' window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_funcs_window(ea)

def open_strings_window(*args) -> "TWidget *":
    r"""
    open_strings_window(ea, selstart=BADADDR, selend=BADADDR) -> TWidget
    Open the 'Strings' window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @param selstart: (C++: ea_t) ,selend: only display strings that occur within this range
    @param selend: (C++: ea_t)
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_strings_window(*args)

def open_segments_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_segments_window(ea) -> TWidget *
    Open the segments window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_segments_window(ea)

def open_segregs_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_segregs_window(ea) -> TWidget *
    Open the segment registers window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_segregs_window(ea)

def open_selectors_window() -> "TWidget *":
    r"""
    open_selectors_window() -> TWidget *
    Open the selectors window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_selectors_window()

def open_signatures_window() -> "TWidget *":
    r"""
    open_signatures_window() -> TWidget *
    Open the signatures window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_signatures_window()

def open_tils_window() -> "TWidget *":
    r"""
    open_tils_window() -> TWidget *
    Open the type libraries window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_tils_window()

def open_loctypes_window(ordinal: "int", cursor: "tif_cursor_t const *"=None) -> "TWidget *":
    r"""
    open_loctypes_window(ordinal, cursor=None) -> TWidget
    Open the local types window (ui_open_builtin).

    @param ordinal: (C++: int) ordinal of type to select by default
    @param cursor: (C++: const tif_cursor_t *) cursor to the type member
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_loctypes_window(ordinal, cursor)

def open_calls_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_calls_window(ea) -> TWidget *
    Open the function calls window (ui_open_builtin).

    @param ea: (C++: ea_t)
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_calls_window(ea)

def open_problems_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_problems_window(ea) -> TWidget *
    Open the problems window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_problems_window(ea)

def open_bpts_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_bpts_window(ea) -> TWidget *
    Open the breakpoints window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_bpts_window(ea)

def open_threads_window() -> "TWidget *":
    r"""
    open_threads_window() -> TWidget *
    Open the threads window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_threads_window()

def open_modules_window() -> "TWidget *":
    r"""
    open_modules_window() -> TWidget *
    Open the modules window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_modules_window()

def open_trace_window() -> "TWidget *":
    r"""
    open_trace_window() -> TWidget *
    Open the tracing window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_trace_window()

def open_stack_window() -> "TWidget *":
    r"""
    open_stack_window() -> TWidget *
    Open the call stack window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_stack_window()

def open_xrefs_window(ea: "ea_t") -> "TWidget *":
    r"""
    open_xrefs_window(ea) -> TWidget *
    Open the cross references window (ui_open_builtin).

    @param ea: (C++: ea_t) index of entry to select by default
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_xrefs_window(ea)

def open_frame_window(pfn: "func_t *", offset: "uval_t") -> "TWidget *":
    r"""
    open_frame_window(pfn, offset) -> TWidget *
    Open the frame window for the given function (ui_open_builtin).

    @param pfn: (C++: func_t *) function to analyze
    @param offset: (C++: uval_t) offset where the cursor is placed
    @return: pointer to resulting window if 'pfn' is a valid function and the window
             was displayed,
    nullptr otherwise
    """
    return _ida_kernwin.open_frame_window(pfn, offset)

def open_navband_window(ea: "ea_t", zoom: "int") -> "TWidget *":
    r"""
    open_navband_window(ea, zoom) -> TWidget *
    Open the navigation band window (ui_open_builtin).

    @param ea: (C++: ea_t) sets the address of the navband arrow
    @param zoom: (C++: int) sets the navband zoom level
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_navband_window(ea, zoom)

def open_disasm_window(window_title: "char const *", ranges: "rangevec_t"=None) -> "TWidget *":
    r"""
    open_disasm_window(window_title, ranges=None) -> TWidget
    Open a disassembly view (ui_open_builtin).

    @param window_title: (C++: const char *) title of view to open
    @param ranges: (C++: const rangevec_t *) if != nullptr, then display a flow chart with the specified
                   ranges
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_disasm_window(window_title, ranges)

def open_hexdump_window(window_title: "char const *") -> "TWidget *":
    r"""
    open_hexdump_window(window_title) -> TWidget *
    Open a hexdump view (ui_open_builtin).

    @param window_title: (C++: const char *) title of view to open
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_hexdump_window(window_title)

def open_notepad_window() -> "TWidget *":
    r"""
    open_notepad_window() -> TWidget *
    Open the notepad window (ui_open_builtin).

    @return: pointer to resulting window
    """
    return _ida_kernwin.open_notepad_window()

def open_bookmarks_window(w: "TWidget *") -> "TWidget *":
    r"""
    open_bookmarks_window(w) -> TWidget *
    Open the bookmarks window (ui_open_builtin).

    @param w: (C++: TWidget *) The widget for which the bookmarks will open. For example, this can be
              an IDAView, or Enums view, etc.
    @return: pointer to resulting window
    """
    return _ida_kernwin.open_bookmarks_window(w)

def sync_sources(what: "sync_source_t", _with: "sync_source_t", sync: "bool") -> "bool":
    r"""
    sync_sources(what, _with, sync) -> bool
    [Un]synchronize sources

    @param what: (C++: const sync_source_t &)
    @param with: (C++: const sync_source_t &)
    @param sync: (C++: bool)
    @return: success
    """
    return _ida_kernwin.sync_sources(what, _with, sync)

def choose_til() -> "qstring *":
    r"""
    choose_til() -> str
    Choose a type library (ui_choose, chtype_idatil).

    @retval true: 'buf' was filled with the name of the selected til
    @retval false: otherwise
    """
    return _ida_kernwin.choose_til()

def choose_entry(title: "char const *") -> "ea_t":
    r"""
    choose_entry(title) -> ea_t
    Choose an entry point (ui_choose, chtype_entry).

    @param title: (C++: const char *) chooser title
    @return: ea of selected entry point, BADADDR if none selected
    """
    return _ida_kernwin.choose_entry(title)

def choose_name(title: "char const *") -> "ea_t":
    r"""
    choose_name(title) -> ea_t
    Choose a name (ui_choose, chtype_name).

    @param title: (C++: const char *) chooser title
    @return: ea of selected name, BADADDR if none selected
    """
    return _ida_kernwin.choose_name(title)

def choose_stkvar_xref(pfn: "func_t *", srkvar_tid: "tid_t") -> "ea_t":
    r"""
    choose_stkvar_xref(pfn, srkvar_tid) -> ea_t
    Choose an xref to a stack variable (ui_choose, chtype_name).

    @param pfn: (C++: func_t *) function
    @param srkvar_tid: (C++: tid_t) frame variable TID
    @return: ea of the selected xref, BADADDR if none selected
    """
    return _ida_kernwin.choose_stkvar_xref(pfn, srkvar_tid)

def choose_xref(to: "ea_t") -> "ea_t":
    r"""
    choose_xref(to) -> ea_t
    Choose an xref to an address (ui_choose, chtype_xref).

    @param to: (C++: ea_t) referenced address
    @return: ea of selected xref, BADADDR if none selected
    """
    return _ida_kernwin.choose_xref(to)

def choose_enum(out: "tinfo_t", title: "char const *", default_ord: "uint32") -> "bool":
    r"""
    choose_enum(out, title, default_ord) -> bool
    Choose an enum (ui_choose, chtype_enum).

    @param out: (C++: tinfo_t *) the selected enum type
    @param title: (C++: const char *) chooser title
    @param default_ord: (C++: uint32) ordinal of enum to select by default
    @retval true: the selected type is in OUT
    @retval false: nothing was selected
    """
    return _ida_kernwin.choose_enum(out, title, default_ord)

def choose_enum_by_value(out: "tinfo_t", title: "char const *", default_ord: "uint32", value: "uint64", nbytes: "int") -> "uchar *":
    r"""
    choose_enum_by_value(out, title, default_ord, value, nbytes) -> bool
    Choose an enum, restricted by value & size (ui_choose,
    chtype_enum_by_value_and_size). If the given value cannot be found initially,
    this function will ask if the user would like to import a standard enum.

    @param out: (C++: tinfo_t *) the selected enum type
    @param title: (C++: const char *) chooser title
    @param default_ord: (C++: uint32) ordinal of enum to select by default
    @param value: (C++: uint64) value to search for
    @param nbytes: (C++: int) size of value
    @retval true: the selected type is in OUT
    @retval false: nothing was selected
    """
    return _ida_kernwin.choose_enum_by_value(out, title, default_ord, value, nbytes)

def choose_func(title: "char const *", default_ea: "ea_t") -> "func_t *":
    r"""
    choose_func(title, default_ea) -> func_t *
    Choose a function (ui_choose, chtype_func).

    @param title: (C++: const char *) chooser title
    @param default_ea: (C++: ea_t) ea of function to select by default
    @return: pointer to function that was selected, nullptr if none selected
    """
    return _ida_kernwin.choose_func(title, default_ea)

def choose_segm(title: "char const *", default_ea: "ea_t") -> "segment_t *":
    r"""
    choose_segm(title, default_ea) -> segment_t *
    Choose a segment (ui_choose, chtype_segm).

    @param title: (C++: const char *) chooser title
    @param default_ea: (C++: ea_t) ea of segment to select by default
    @return: pointer to segment that was selected, nullptr if none selected
    """
    return _ida_kernwin.choose_segm(title, default_ea)

def choose_struct(out: "tinfo_t", title: "char const *") -> "bool":
    r"""
    choose_struct(out, title) -> bool
    Choose a structure (ui_choose, chtype_struct).

    @param out: (C++: tinfo_t *) the selected structure type
    @param title: (C++: const char *) chooser title
    @retval true: the selected type is in OUT
    @retval false: nothing was selected
    """
    return _ida_kernwin.choose_struct(out, title)

def choose_srcp(title: "char const *") -> "sreg_range_t *":
    r"""
    choose_srcp(title) -> sreg_range_t *
    Choose a segment register change point (ui_choose, chtype_srcp).

    @param title: (C++: const char *) chooser title
    @return: pointer to segment register range of selected change point, nullptr if
             none selected
    """
    return _ida_kernwin.choose_srcp(title)

def get_chooser_obj(chooser_caption: "char const *") -> "void *":
    r"""
    get_chooser_obj(chooser_caption) -> void *
    Get the underlying object of the specified chooser (ui_get_chooser_obj).

    This attemps to find the choser by its title and, if found, returns the result
    of calling its chooser_base_t::get_chooser_obj() method.

    @note: This is object is chooser-specific.

    @param chooser_caption: (C++: const char *) char const *
    @return: the object that was used to create the chooser
    """
    return _ida_kernwin.get_chooser_obj(chooser_caption)

def get_chooser_rows(out: "chooser_row_info_vec_t", chooser_caption: "char const *", what: "size_t") -> "bool":
    r"""
    get_chooser_rows(out, chooser_caption, what) -> bool
    Get the chooser contents corresponding to the rows indicated by "what".

    @param out: (C++: chooser_row_info_vec_t *) A vector of chooser_row_info_t, one entry per returned row.
    @param chooser_caption: (C++: const char *) The caption that identifies the desired chooser.
    @param what: (C++: size_t) Either one of the GCRF_ flags, or a row index.
    @return: Success.
    """
    return _ida_kernwin.get_chooser_rows(out, chooser_caption, what)

def enable_chooser_item_attrs(chooser_caption: "char const *", enable: "bool") -> "bool":
    r"""
    enable_chooser_item_attrs(chooser_caption, enable) -> bool
    Enable item-specific attributes for chooser items
    (ui_enable_chooser_item_attrs). For example: color list items differently
    depending on a criterium.
    If enabled, the chooser will generate ui_get_chooser_item_attrs
    events that can be intercepted by a plugin to modify the item attributes.
    This event is generated only in the GUI version of IDA.
    Specifying CH_ATTRS bit at the chooser creation time has the same effect.

    @param chooser_caption: (C++: const char *) char const *
    @param enable: (C++: bool)
    @return: success
    """
    return _ida_kernwin.enable_chooser_item_attrs(chooser_caption, enable)

def replace_wait_box(*args) -> "void":
    r"""
    replace_wait_box(format)
    Replace the label of "Please wait dialog box".

    @param format: (C++: const char *) char const *
    """
    return _ida_kernwin.replace_wait_box(*args)

def beep(beep_type: "beep_t"=beep_default) -> "void":
    r"""
    beep(beep_type=beep_default)
    Issue a beeping sound (ui_beep).

    @param beep_type: (C++: beep_t)
    """
    return _ida_kernwin.beep(beep_type)

def display_copyright_warning() -> "bool":
    r"""
    display_copyright_warning() -> bool
    Display copyright warning (ui_copywarn).

    @return: yes/no
    """
    return _ida_kernwin.display_copyright_warning()

def ask_for_feedback(*args) -> "void":
    r"""
    ask_for_feedback(format)
    Show a message box asking to send the input file to \link{mailto:support@hex-
    rays.com,support@hex-rays.com}.

    @param format: (C++: const char *) the reason why the input file is bad
    """
    return _ida_kernwin.ask_for_feedback(*args)

def _ask_addr(*args) -> "ea_t *":
    r"""
    _ask_addr(addr, format) -> bool

    Parameters
    ----------
    addr: ea_t *
    format: char const *

    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_addr(*args)


    return _ida_kernwin._ask_addr(*args)

def _ask_seg(*args) -> "sel_t *":
    r"""
    _ask_seg(sel, format) -> bool

    Parameters
    ----------
    sel: sel_t *
    format: char const *

    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_seg(*args)


    return _ida_kernwin._ask_seg(*args)

def _ask_long(*args) -> "sval_t *":
    r"""
    _ask_long(value, format) -> bool

    Parameters
    ----------
    value: sval_t *
    format: char const *

    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_long(*args)


    return _ida_kernwin._ask_long(*args)

def error(*args) -> "void":
    r"""
    error(format)
    Display a fatal message in a message box and quit IDA

    @param format: message to print
    """
    return _ida_kernwin.error(*args)

def warning(*args) -> "void":
    r"""
    warning(format)
    Display a message in a message box

    @param message: message to print (formatting is done in Python)

    This function can be used to debug IDAPython scripts
    The user will be able to hide messages if they appear twice in a row on
    the screen
    """
    return _ida_kernwin.warning(*args)

def info(*args) -> "void":
    r"""
    info(format)

    @param format: char const *
    """
    return _ida_kernwin.info(*args)

def nomem(*args) -> "void":
    r"""
    nomem(format)

    @param format: char const *
    """
    return _ida_kernwin.nomem(*args)
ASKBTN_YES = _ida_kernwin.ASKBTN_YES
r"""
Yes button.
"""

ASKBTN_NO = _ida_kernwin.ASKBTN_NO
r"""
No button.
"""

ASKBTN_CANCEL = _ida_kernwin.ASKBTN_CANCEL
r"""
Cancel button.
"""

ASKBTN_BTN1 = _ida_kernwin.ASKBTN_BTN1
r"""
First (Yes) button.
"""

ASKBTN_BTN2 = _ida_kernwin.ASKBTN_BTN2
r"""
Second (No) button.
"""

ASKBTN_BTN3 = _ida_kernwin.ASKBTN_BTN3
r"""
Third (Cancel) button.
"""


def ask_yn(*args) -> "int":
    r"""
    ask_yn(deflt, format) -> int
    Display a dialog box and get choice from "Yes", "No", "Cancel".

    @param deflt: (C++: int) default choice: one of Button IDs
    @param format: (C++: const char *) The question in printf() style format
    @return: the selected button (one of Button IDs). Esc key returns ASKBTN_CANCEL.
    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_yn(*args)


    return _ida_kernwin.ask_yn(*args)

def ask_buttons(*args) -> "int":
    r"""
    ask_buttons(Yes, No, Cancel, deflt, format) -> int
    Display a dialog box and get choice from maximum three possibilities
    (ui_ask_buttons).
    @note: for all buttons:
    * use "" or nullptr to take the default name for the button.
    * prepend "HIDECANCEL\n" in 'format' to hide the Cancel button

    @param Yes: (C++: const char *) text for the first button
    @param No: (C++: const char *) text for the second button
    @param Cancel: (C++: const char *) text for the third button
    @param deflt: (C++: int) default choice: one of Button IDs
    @param format: (C++: const char *) printf-style format string for question. It may have some
                   prefixes, see below.
    @return: one of Button IDs specifying the selected button (Esc key returns
             Cancel/3rd button value)
    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_buttons(*args)


    return _ida_kernwin.ask_buttons(*args)
HIST_SEG = _ida_kernwin.HIST_SEG
r"""
segment names
"""

HIST_CMT = _ida_kernwin.HIST_CMT
r"""
comments
"""

HIST_SRCH = _ida_kernwin.HIST_SRCH
r"""
search substrings
"""

HIST_IDENT = _ida_kernwin.HIST_IDENT
r"""
identifiers. usually CPU register names are forbidden
"""

HIST_FILE = _ida_kernwin.HIST_FILE
r"""
file names
"""

HIST_TYPE = _ida_kernwin.HIST_TYPE
r"""
type declarations
"""

HIST_CMD = _ida_kernwin.HIST_CMD
r"""
commands
"""

HIST_DIR = _ida_kernwin.HIST_DIR
r"""
directory names (text version only)
"""

HIST_IDENT2 = _ida_kernwin.HIST_IDENT2
r"""
identifiers, including CPU register names
"""


def ask_ident2(*args) -> "bool":
    r"""
    ask_ident2(str, format) -> bool
    Display a dialog box and wait for the user to input an identifier. If the user
    enters a non-valid identifier, this function displays a warning and allows the
    user to correct it. CPU register names are permitted.

    @param str: (C++: qstring *) qstring to fill. Can contain the default value. Cannot be nullptr.
    @param format: (C++: const char *) printf() style format string with the question
    @return: false if the user cancelled the dialog, otherwise returns true.
    """
    return _ida_kernwin.ask_ident2(*args)

def ask_file(*args) -> "char *":
    r"""
    ask_file(for_saving, defval, format) -> char *

    @param for_saving: bool
    @param defval: char const *
    @param format: char const *
    """

    import ida_kernwin
#kludge: we can't use %feature("shadow") for top-level
    # functions (see https://github.com/swig/swig/issues/980)
    # Thus we'll %feature("pythonprepend") some code, and return from it,
#making the original code unreachable. Not pretty, but I
#don't have anything better at the moment.
    with ida_kernwin.disabled_script_timeout_t():
        return _ida_kernwin.ask_file(*args)


    return _ida_kernwin.ask_file(*args)
class addon_info_t(object):
    r"""
    Proxy of C++ addon_info_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cb: "size_t" = property(_ida_kernwin.addon_info_t_cb_get, _ida_kernwin.addon_info_t_cb_set, doc=r"""cb""")
    id: "char const *" = property(_ida_kernwin.addon_info_t_id_get, _ida_kernwin.addon_info_t_id_set, doc=r"""id""")
    name: "char const *" = property(_ida_kernwin.addon_info_t_name_get, _ida_kernwin.addon_info_t_name_set, doc=r"""name""")
    producer: "char const *" = property(_ida_kernwin.addon_info_t_producer_get, _ida_kernwin.addon_info_t_producer_set, doc=r"""producer""")
    version: "char const *" = property(_ida_kernwin.addon_info_t_version_get, _ida_kernwin.addon_info_t_version_set, doc=r"""version""")
    url: "char const *" = property(_ida_kernwin.addon_info_t_url_get, _ida_kernwin.addon_info_t_url_set, doc=r"""url""")
    freeform: "char const *" = property(_ida_kernwin.addon_info_t_freeform_get, _ida_kernwin.addon_info_t_freeform_set, doc=r"""freeform""")
    custom_data: "void const *" = property(_ida_kernwin.addon_info_t_custom_data_get, _ida_kernwin.addon_info_t_custom_data_set, doc=r"""custom_data""")
    custom_size: "size_t" = property(_ida_kernwin.addon_info_t_custom_size_get, _ida_kernwin.addon_info_t_custom_size_set, doc=r"""custom_size""")

    def __init__(self):
        r"""
        __init__(self) -> addon_info_t
        """
        _ida_kernwin.addon_info_t_swiginit(self, _ida_kernwin.new_addon_info_t())
    __swig_destroy__ = _ida_kernwin.delete_addon_info_t

# Register addon_info_t in _ida_kernwin:
_ida_kernwin.addon_info_t_swigregister(addon_info_t)

def register_addon(info: "addon_info_t") -> "int":
    r"""
    register_addon(info) -> int
    Register an add-on. Show its info in the About box. For plugins, should be
    called from init() function (repeated calls with the same product code overwrite
    previous entries) returns: index of the add-on in the list, or -1 on error

    @param info: (C++: const addon_info_t *) addon_info_t const *
    """
    return _ida_kernwin.register_addon(info)

def addon_count() -> "int":
    r"""
    addon_count() -> int
    Get number of installed addons.
    """
    return _ida_kernwin.addon_count()

def get_addon_info(id: "char const *", info: "addon_info_t") -> "bool":
    r"""
    get_addon_info(id, info) -> bool
    Get info about a registered addon with a given product code. info->cb must be
    valid! NB: all pointers are invalidated by next call to register_addon or
    get_addon_info

    @param id: (C++: const char *) char const *
    @param info: (C++: addon_info_t *)
    @return: false if not found
    """
    return _ida_kernwin.get_addon_info(id, info)

def get_addon_info_idx(index: "int", info: "addon_info_t") -> "bool":
    r"""
    get_addon_info_idx(index, info) -> bool
    Get info about a registered addon with specific index. info->cb must be valid!
    NB: all pointers are invalidated by next call to register_addon or
    get_addon_info

    @param index: (C++: int)
    @param info: (C++: addon_info_t *)
    @return: false if index is out of range
    """
    return _ida_kernwin.get_addon_info_idx(index, info)
class strarray_t(object):
    r"""
    Proxy of C++ strarray_t class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    code: "int" = property(_ida_kernwin.strarray_t_code_get, _ida_kernwin.strarray_t_code_set, doc=r"""code""")
    text: "char const *" = property(_ida_kernwin.strarray_t_text_get, _ida_kernwin.strarray_t_text_set, doc=r"""text""")

    def __init__(self):
        r"""
        __init__(self) -> strarray_t
        """
        _ida_kernwin.strarray_t_swiginit(self, _ida_kernwin.new_strarray_t())
    __swig_destroy__ = _ida_kernwin.delete_strarray_t

# Register strarray_t in _ida_kernwin:
_ida_kernwin.strarray_t_swigregister(strarray_t)
CLNL_RTRIM = _ida_kernwin.CLNL_RTRIM
r"""
Remove trailing space characters.
"""

CLNL_LTRIM = _ida_kernwin.CLNL_LTRIM
r"""
Remove leading space characters.
"""

CLNL_FINDCMT = _ida_kernwin.CLNL_FINDCMT
r"""
Search for the comment symbol everywhere in the line, not only at the beginning.
"""

CLNL_TRIM = _ida_kernwin.CLNL_TRIM


def qcleanline(*args) -> "qstring *":
    r"""
    qcleanline(cmt_char='\0', flags=((1 << 0)|(1 << 1))|(1 << 2)) -> ssize_t
    Performs some cleanup operations to a line.

    @param cmt_char: (C++: char) character that denotes the start of a comment:
    * the entire text is removed if the line begins with this character (ignoring
    leading spaces)
    * all text after (and including) this character is removed if flag CLNL_FINDCMT
    is set
    @param flags: (C++: uint32) a combination of line cleanup flags. defaults to CLNL_TRIM
    @return: length of line
    """
    return _ida_kernwin.qcleanline(*args)

def strarray(array: "strarray_t", array_size: "size_t", code: "int") -> "char const *":
    r"""
    strarray(array, array_size, code) -> char const *
    Find a line with the specified code in the strarray_t array. If the last element
    of the array has code==0 then it is considered as the default entry.
    If no default entry exists and the code is not found, strarray() returns "".

    @param array: (C++: const strarray_t *) strarray_t const *
    @param array_size: (C++: size_t)
    @param code: (C++: int)
    """
    return _ida_kernwin.strarray(array, array_size, code)

def ea2str(ea: "ea_t") -> "qstring *":
    r"""
    ea2str(ea) -> str
    Convert linear address to UTF-8 string.

    @param ea: (C++: ea_t)
    """
    return _ida_kernwin.ea2str(ea)

def str2ea(*args) -> "uint32 *":
    r"""
    str2ea(str, screen_ea=BADADDR) -> bool
    Convert string to linear address. Tries to interpret the string as:
    1) "current IP" keyword if supported by assembler (e.g. "$" in x86)
    2) segment:offset expression, where "segment" may be a name or a fixed segment
    register (e.g. cs, ds)
    3) just segment name/register (translated to segment's start address)
    4) a name in the database (or debug name during debugging)
    5) hexadecimal value without prefix or suffix
    6) +delta or -delta, where numerical 'delta' is added to or subtracted from
    'screen_ea'
    7) register name (only during debugging)
    8) if all else fails, try to evaluate 'str' as an IDC expression

    @param str: (C++: const char *) string to parse
    @param screen_ea: (C++: ea_t) the current address in the disassembly/pseudocode view
    @return: success
    """
    return _ida_kernwin.str2ea(*args)

def str2ea_ex(*args) -> "uint32 *":
    r"""
    str2ea_ex(str, screen_ea=BADADDR, flags=0) -> bool
    Same as str2ea() but possibly with some steps skipped.

    @param str: (C++: const char *) string to parse
    @param screen_ea: (C++: ea_t) the current address in the disassembly/pseudocode view
    @param flags: (C++: int) see String to address conversion flags
    @return: success
    """
    return _ida_kernwin.str2ea_ex(*args)
S2EAOPT_NOCALC = _ida_kernwin.S2EAOPT_NOCALC
r"""
don't try to interpret string as IDC (or current extlang) expression
"""


def atoea(str: "char const *") -> "uint32 *":
    r"""
    atoea(str) -> bool
    Convert a number in C notation to an address. decimal: 1234
    octal: 0123
    hexadecimal: 0xabcd
    binary: 0b00101010

    @param str: (C++: const char *) the string to parse
    """
    return _ida_kernwin.atoea(str)
IK_CANCEL = _ida_kernwin.IK_CANCEL

IK_BACK = _ida_kernwin.IK_BACK

IK_TAB = _ida_kernwin.IK_TAB

IK_CLEAR = _ida_kernwin.IK_CLEAR

IK_RETURN = _ida_kernwin.IK_RETURN

IK_SHIFT = _ida_kernwin.IK_SHIFT

IK_CONTROL = _ida_kernwin.IK_CONTROL

IK_MENU = _ida_kernwin.IK_MENU

IK_PAUSE = _ida_kernwin.IK_PAUSE

IK_CAPITAL = _ida_kernwin.IK_CAPITAL

IK_KANA = _ida_kernwin.IK_KANA

IK_ESCAPE = _ida_kernwin.IK_ESCAPE

IK_MODECHANGE = _ida_kernwin.IK_MODECHANGE

IK_SPACE = _ida_kernwin.IK_SPACE

IK_PRIOR = _ida_kernwin.IK_PRIOR

IK_NEXT = _ida_kernwin.IK_NEXT

IK_END = _ida_kernwin.IK_END

IK_HOME = _ida_kernwin.IK_HOME

IK_LEFT = _ida_kernwin.IK_LEFT

IK_UP = _ida_kernwin.IK_UP

IK_RIGHT = _ida_kernwin.IK_RIGHT

IK_DOWN = _ida_kernwin.IK_DOWN

IK_SELECT = _ida_kernwin.IK_SELECT

IK_PRINT = _ida_kernwin.IK_PRINT

IK_EXECUTE = _ida_kernwin.IK_EXECUTE

IK_SNAPSHOT = _ida_kernwin.IK_SNAPSHOT

IK_INSERT = _ida_kernwin.IK_INSERT

IK_DELETE = _ida_kernwin.IK_DELETE

IK_HELP = _ida_kernwin.IK_HELP

IK_LWIN = _ida_kernwin.IK_LWIN

IK_RWIN = _ida_kernwin.IK_RWIN

IK_APPS = _ida_kernwin.IK_APPS

IK_SLEEP = _ida_kernwin.IK_SLEEP

IK_NUMPAD0 = _ida_kernwin.IK_NUMPAD0

IK_NUMPAD1 = _ida_kernwin.IK_NUMPAD1

IK_NUMPAD2 = _ida_kernwin.IK_NUMPAD2

IK_NUMPAD3 = _ida_kernwin.IK_NUMPAD3

IK_NUMPAD4 = _ida_kernwin.IK_NUMPAD4

IK_NUMPAD5 = _ida_kernwin.IK_NUMPAD5

IK_NUMPAD6 = _ida_kernwin.IK_NUMPAD6

IK_NUMPAD7 = _ida_kernwin.IK_NUMPAD7

IK_NUMPAD8 = _ida_kernwin.IK_NUMPAD8

IK_NUMPAD9 = _ida_kernwin.IK_NUMPAD9

IK_MULTIPLY = _ida_kernwin.IK_MULTIPLY

IK_ADD = _ida_kernwin.IK_ADD

IK_SEPARATOR = _ida_kernwin.IK_SEPARATOR

IK_SUBTRACT = _ida_kernwin.IK_SUBTRACT

IK_DECIMAL = _ida_kernwin.IK_DECIMAL

IK_DIVIDE = _ida_kernwin.IK_DIVIDE

IK_F1 = _ida_kernwin.IK_F1

IK_F2 = _ida_kernwin.IK_F2

IK_F3 = _ida_kernwin.IK_F3

IK_F4 = _ida_kernwin.IK_F4

IK_F5 = _ida_kernwin.IK_F5

IK_F6 = _ida_kernwin.IK_F6

IK_F7 = _ida_kernwin.IK_F7

IK_F8 = _ida_kernwin.IK_F8

IK_F9 = _ida_kernwin.IK_F9

IK_F10 = _ida_kernwin.IK_F10

IK_F11 = _ida_kernwin.IK_F11

IK_F12 = _ida_kernwin.IK_F12

IK_F13 = _ida_kernwin.IK_F13

IK_F14 = _ida_kernwin.IK_F14

IK_F15 = _ida_kernwin.IK_F15

IK_F16 = _ida_kernwin.IK_F16

IK_F17 = _ida_kernwin.IK_F17

IK_F18 = _ida_kernwin.IK_F18

IK_F19 = _ida_kernwin.IK_F19

IK_F20 = _ida_kernwin.IK_F20

IK_F21 = _ida_kernwin.IK_F21

IK_F22 = _ida_kernwin.IK_F22

IK_F23 = _ida_kernwin.IK_F23

IK_F24 = _ida_kernwin.IK_F24

IK_NUMLOCK = _ida_kernwin.IK_NUMLOCK

IK_SCROLL = _ida_kernwin.IK_SCROLL

IK_OEM_FJ_MASSHOU = _ida_kernwin.IK_OEM_FJ_MASSHOU

IK_OEM_FJ_TOUROKU = _ida_kernwin.IK_OEM_FJ_TOUROKU

IK_LSHIFT = _ida_kernwin.IK_LSHIFT

IK_RSHIFT = _ida_kernwin.IK_RSHIFT

IK_LCONTROL = _ida_kernwin.IK_LCONTROL

IK_RCONTROL = _ida_kernwin.IK_RCONTROL

IK_LMENU = _ida_kernwin.IK_LMENU

IK_RMENU = _ida_kernwin.IK_RMENU

IK_BROWSER_BACK = _ida_kernwin.IK_BROWSER_BACK

IK_BROWSER_FORWARD = _ida_kernwin.IK_BROWSER_FORWARD

IK_BROWSER_REFRESH = _ida_kernwin.IK_BROWSER_REFRESH

IK_BROWSER_STOP = _ida_kernwin.IK_BROWSER_STOP

IK_BROWSER_SEARCH = _ida_kernwin.IK_BROWSER_SEARCH

IK_BROWSER_FAVORITES = _ida_kernwin.IK_BROWSER_FAVORITES

IK_BROWSER_HOME = _ida_kernwin.IK_BROWSER_HOME

IK_VOLUME_MUTE = _ida_kernwin.IK_VOLUME_MUTE

IK_VOLUME_DOWN = _ida_kernwin.IK_VOLUME_DOWN

IK_VOLUME_UP = _ida_kernwin.IK_VOLUME_UP

IK_MEDIA_NEXT_TRACK = _ida_kernwin.IK_MEDIA_NEXT_TRACK

IK_MEDIA_PREV_TRACK = _ida_kernwin.IK_MEDIA_PREV_TRACK

IK_MEDIA_STOP = _ida_kernwin.IK_MEDIA_STOP

IK_MEDIA_PLAY_PAUSE = _ida_kernwin.IK_MEDIA_PLAY_PAUSE

IK_LAUNCH_MAIL = _ida_kernwin.IK_LAUNCH_MAIL

IK_LAUNCH_MEDIA_SELECT = _ida_kernwin.IK_LAUNCH_MEDIA_SELECT

IK_LAUNCH_APP1 = _ida_kernwin.IK_LAUNCH_APP1

IK_LAUNCH_APP2 = _ida_kernwin.IK_LAUNCH_APP2

IK_OEM_1 = _ida_kernwin.IK_OEM_1

IK_OEM_PLUS = _ida_kernwin.IK_OEM_PLUS

IK_OEM_COMMA = _ida_kernwin.IK_OEM_COMMA

IK_OEM_MINUS = _ida_kernwin.IK_OEM_MINUS

IK_OEM_PERIOD = _ida_kernwin.IK_OEM_PERIOD

IK_OEM_2 = _ida_kernwin.IK_OEM_2

IK_OEM_3 = _ida_kernwin.IK_OEM_3

IK_OEM_4 = _ida_kernwin.IK_OEM_4

IK_OEM_5 = _ida_kernwin.IK_OEM_5

IK_OEM_6 = _ida_kernwin.IK_OEM_6

IK_OEM_7 = _ida_kernwin.IK_OEM_7

IK_OEM_102 = _ida_kernwin.IK_OEM_102

IK_PLAY = _ida_kernwin.IK_PLAY

IK_ZOOM = _ida_kernwin.IK_ZOOM

IK_OEM_CLEAR = _ida_kernwin.IK_OEM_CLEAR

CB_INIT = _ida_kernwin.CB_INIT

CB_YES = _ida_kernwin.CB_YES

CB_CLOSE = _ida_kernwin.CB_CLOSE

CB_INVISIBLE = _ida_kernwin.CB_INVISIBLE

CB_DESTROYING = _ida_kernwin.CB_DESTROYING

CB_NO = _ida_kernwin.CB_NO

CB_CANCEL = _ida_kernwin.CB_CANCEL


def get_user_strlist_options(out: "strwinsetup_t *") -> "void":
    r"""
    get_user_strlist_options(out)

    @param out: strwinsetup_t *
    """
    return _ida_kernwin.get_user_strlist_options(out)

def del_idc_hotkey(hotkey: "char const *") -> "bool":
    r"""
    del_idc_hotkey(hotkey) -> bool

    @param hotkey: char const *
    """
    return _ida_kernwin.del_idc_hotkey(hotkey)
class disasm_text_t(object):
    r"""
    Proxy of C++ qvector< disasm_line_t > class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(self) -> disasm_text_t
        __init__(self, x) -> disasm_text_t

        @param x: qvector< disasm_line_t > const &
        """
        _ida_kernwin.disasm_text_t_swiginit(self, _ida_kernwin.new_disasm_text_t(*args))
    __swig_destroy__ = _ida_kernwin.delete_disasm_text_t

    def push_back(self, *args) -> "disasm_line_t &":
        r"""
        push_back(self, x)

        @param x: disasm_line_t const &

        push_back(self) -> disasm_line_t
        """
        return _ida_kernwin.disasm_text_t_push_back(self, *args)

    def pop_back(self) -> "void":
        r"""
        pop_back(self)
        """
        return _ida_kernwin.disasm_text_t_pop_back(self)

    def size(self) -> "size_t":
        r"""
        size(self) -> size_t
        """
        return _ida_kernwin.disasm_text_t_size(self)

    def empty(self) -> "bool":
        r"""
        empty(self) -> bool
        """
        return _ida_kernwin.disasm_text_t_empty(self)

    def at(self, _idx: "size_t") -> "disasm_line_t const &":
        r"""
        at(self, _idx) -> disasm_line_t

        @param _idx: size_t
        """
        return _ida_kernwin.disasm_text_t_at(self, _idx)

    def qclear(self) -> "void":
        r"""
        qclear(self)
        """
        return _ida_kernwin.disasm_text_t_qclear(self)

    def clear(self) -> "void":
        r"""
        clear(self)
        """
        return _ida_kernwin.disasm_text_t_clear(self)

    def resize(self, *args) -> "void":
        r"""
        resize(self, _newsize, x)

        @param _newsize: size_t
        @param x: disasm_line_t const &

        resize(self, _newsize)

        @param _newsize: size_t
        """
        return _ida_kernwin.disasm_text_t_resize(self, *args)

    def grow(self, *args) -> "void":
        r"""
        grow(self, x=disasm_line_t())

        @param x: disasm_line_t const &
        """
        return _ida_kernwin.disasm_text_t_grow(self, *args)

    def capacity(self) -> "size_t":
        r"""
        capacity(self) -> size_t
        """
        return _ida_kernwin.disasm_text_t_capacity(self)

    def reserve(self, cnt: "size_t") -> "void":
        r"""
        reserve(self, cnt)

        @param cnt: size_t
        """
        return _ida_kernwin.disasm_text_t_reserve(self, cnt)

    def truncate(self) -> "void":
        r"""
        truncate(self)
        """
        return _ida_kernwin.disasm_text_t_truncate(self)

    def swap(self, r: "disasm_text_t") -> "void":
        r"""
        swap(self, r)

        @param r: qvector< disasm_line_t > &
        """
        return _ida_kernwin.disasm_text_t_swap(self, r)

    def extract(self) -> "disasm_line_t *":
        r"""
        extract(self) -> disasm_line_t
        """
        return _ida_kernwin.disasm_text_t_extract(self)

    def inject(self, s: "disasm_line_t", len: "size_t") -> "void":
        r"""
        inject(self, s, len)

        @param s: disasm_line_t *
        @param len: size_t
        """
        return _ida_kernwin.disasm_text_t_inject(self, s, len)

    def begin(self, *args) -> "qvector< disasm_line_t >::const_iterator":
        r"""
        begin(self) -> disasm_line_t
        """
        return _ida_kernwin.disasm_text_t_begin(self, *args)

    def end(self, *args) -> "qvector< disasm_line_t >::const_iterator":
        r"""
        end(self) -> disasm_line_t
        """
        return _ida_kernwin.disasm_text_t_end(self, *args)

    def insert(self, it: "disasm_line_t", x: "disasm_line_t") -> "qvector< disasm_line_t >::iterator":
        r"""
        insert(self, it, x) -> disasm_line_t

        @param it: qvector< disasm_line_t >::iterator
        @param x: disasm_line_t const &
        """
        return _ida_kernwin.disasm_text_t_insert(self, it, x)

    def erase(self, *args) -> "qvector< disasm_line_t >::iterator":
        r"""
        erase(self, it) -> disasm_line_t

        @param it: qvector< disasm_line_t >::iterator

        erase(self, first, last) -> disasm_line_t

        @param first: qvector< disasm_line_t >::iterator
        @param last: qvector< disasm_line_t >::iterator
        """
        return _ida_kernwin.disasm_text_t_erase(self, *args)

    def __len__(self) -> "size_t":
        r"""
        __len__(self) -> size_t
        """
        return _ida_kernwin.disasm_text_t___len__(self)

    def __getitem__(self, i: "size_t") -> "disasm_line_t const &":
        r"""
        __getitem__(self, i) -> disasm_line_t

        @param i: size_t
        """
        return _ida_kernwin.disasm_text_t___getitem__(self, i)

    def __setitem__(self, i: "size_t", v: "disasm_line_t") -> "void":
        r"""
        __setitem__(self, i, v)

        @param i: size_t
        @param v: disasm_line_t const &
        """
        return _ida_kernwin.disasm_text_t___setitem__(self, i, v)

    front = ida_idaapi._qvector_front
    back = ida_idaapi._qvector_back
    __iter__ = ida_idaapi._bounded_getitem_iterator


# Register disasm_text_t in _ida_kernwin:
_ida_kernwin.disasm_text_t_swigregister(disasm_text_t)

#<pycode(py_kernwin)>

# ----------------------------------------------------------------------
def load_custom_icon(file_name=None, data=None, format=None):
    r"""
    Loads a custom icon and returns an identifier that can be used with other APIs

    If file_name is passed then the other two arguments are ignored.

    Load an icon and return its id (ui_load_custom_icon).

    @return: icon id
    """
    if file_name is not None:
       return _ida_kernwin.py_load_custom_icon_fn(file_name)
    elif not (data is None and format is None):
       return _ida_kernwin.py_load_custom_icon_data(data, format)
    else:
      return 0

# ----------------------------------------------------------------------
def ask_long(defval, format):
    r"""
    Display a dialog box and wait for the user to input an number (ui_ask_long). The
    number is represented in C-style. This function allows to enter any IDC
    expression and properly calculates it.

    @retval 0: if the user pressed Esc.
    @retval 1: ok, the user entered a valid number.
    """
    res, val = _ida_kernwin._ask_long(defval, format)

    if res == 1:
        return val
    else:
        return None

# ----------------------------------------------------------------------
def ask_addr(defval, format):
    r"""
    Output a formatted string to the output window (msg) preprended with "**DATABASE
    IS CORRUPTED: " Display a dialog box and wait for the user to input an address
    (ui_ask_addr).

    @retval 0: the user pressed Esc.
    @retval 1: ok, the user entered an address
    """
    res, ea = _ida_kernwin._ask_addr(defval, format)

    if res == 1:
        return ea
    else:
        return None

# ----------------------------------------------------------------------
def ask_seg(defval, format):
    r"""
    Display a dialog box and wait for the user to input an segment name
    (ui_ask_seg). This function allows to enter segment register names, segment base
    paragraphs, segment names to denote a segment.

    @retval 0: if the user pressed Esc.
    @retval 1: ok, the user entered an segment name
    """
    res, sel = _ida_kernwin._ask_seg(defval, format)

    if res == 1:
        return sel
    else:
        return None

# ----------------------------------------------------------------------
def ask_ident(defval, format):
    r"""
    Display a dialog box and wait for the user to input an identifier. If the user
    enters a non-valid identifier, this function displays a warning and allows the
    user to correct it. CPU register names are usually forbidden.

    @return: false if the user cancelled the dialog, otherwise returns true.
    """
    return ask_str(defval, HIST_IDENT, format)

# ----------------------------------------------------------------------
class action_handler_t(object):
    def __init__(self):
        pass

    def activate(self, ctx):
        r"""
        Activate an action. This function implements the core behavior of an action. It
        is called when the action is triggered, from a menu, from a popup menu, from the
        toolbar, or programmatically.

        @return: non-zero: all IDA windows will be refreshed
        """
        return 0

    def update(self, ctx):
        r"""
        Update an action. This is called when the context of the UI changed, and we need
        to let the action update some of its properties if needed (label, icon, ...)

        In addition, this lets IDA know whether the action is enabled, and when it
        should be queried for availability again.

        Note: This callback is not meant to change anything in the application's state,
        except by calling one (or many) of the "update_action_*()" functions on this
        very action.
        """
        pass

# ----------------------------------------------------------------------
# This provides an alternative to register_action()+attach_action_to_popup_menu()
class quick_widget_commands_t:

    class _cmd_t:
        def __init__(self, caption, flags, menu_index, icon, emb, shortcut):
            self.caption = caption
            self.flags = flags
            self.menu_index = menu_index
            self.icon = icon
            self.emb = emb
            self.shortcut = shortcut

    class _ah_t(action_handler_t):
        def __init__(self, parent, cmd_id):
            action_handler_t.__init__(self)
            self.parent = parent
            self.cmd_id = cmd_id

        def activate(self, ctx):
            self.parent.callback(ctx, self.cmd_id)

        def update(self, ctx):
            return AST_ENABLE_ALWAYS


    def __init__(self, callback):
        self.callback = callback
        self.cmds = []

    def add(self, caption, flags, menu_index, icon, emb, shortcut):
        for idx, cmd in enumerate(self.cmds):
            if cmd.caption == caption:
                return idx
        self.cmds.append(
            quick_widget_commands_t._cmd_t(
                caption, flags, menu_index, icon, emb, shortcut))
        return len(self.cmds) - 1

    def populate_popup(self, widget, popup):
        for idx, cmd in enumerate(self.cmds):
            if (cmd.flags & CHOOSER_POPUP_MENU) != 0:
                desc = action_desc_t(None,
                                     cmd.caption,
                                     quick_widget_commands_t._ah_t(self, idx),
                                     cmd.shortcut,
                                     None,
                                     cmd.icon)
                attach_dynamic_action_to_popup(None, popup, desc)

class disabled_script_timeout_t(object):
    def __enter__(self):
        import _ida_idaapi
        self.was_timeout = _ida_idaapi.set_script_timeout(0)

    def __exit__(self, type, value, tb):
        import _ida_idaapi
        _ida_idaapi.set_script_timeout(self.was_timeout)

import ida_ida
ida_ida.__wrap_hooks_callback(
    UI_Hooks,
    "database_closed",
    "term",
    lambda cb, *args: cb(*args))


# ----------------------------------------------------------------------
# bw-compat/deprecated. You shouldn't rely on this in new code
from ida_pro import str2user
SETMENU_IF_ENABLED = 4

# bw-compat (flag removed in IDA 8.4):
CH_NOIDB = CH_UNUSED

BWN_LOCTYPS = BWN_TILVIEW
IWID_LOCTYPS = IWID_TILVIEW

#</pycode(py_kernwin)>

CHOOSER_NO_SELECTION = _ida_kernwin.CHOOSER_NO_SELECTION

CHOOSER_MULTI_SELECTION = _ida_kernwin.CHOOSER_MULTI_SELECTION

CHOOSER_POPUP_MENU = _ida_kernwin.CHOOSER_POPUP_MENU

CHOOSER_MENU_EDIT = _ida_kernwin.CHOOSER_MENU_EDIT

CHOOSER_MENU_JUMP = _ida_kernwin.CHOOSER_MENU_JUMP

CHOOSER_MENU_SEARCH = _ida_kernwin.CHOOSER_MENU_SEARCH


def choose_find(title: "char const *") -> "PyObject *":
    r"""
    choose_find(title) -> MyChoose or None

    @param title: char const *
    """
    return _ida_kernwin.choose_find(title)

def choose_refresh(_self: "PyObject *") -> "void":
    r"""
    choose_refresh(_self)

    @param self: PyObject *
    """
    return _ida_kernwin.choose_refresh(_self)

def choose_close(_self: "PyObject *") -> "void":
    r"""
    choose_close(_self)

    @param self: PyObject *
    """
    return _ida_kernwin.choose_close(_self)

def choose_get_widget(_self: "PyObject *") -> "TWidget *":
    r"""
    choose_get_widget(_self) -> TWidget *

    @param self: PyObject *
    """
    return _ida_kernwin.choose_get_widget(_self)

def choose_choose(_self: "PyObject *") -> "PyObject *":
    r"""
    choose_choose(_self) -> PyObject *

    @param self: PyObject *
    """
    return _ida_kernwin.choose_choose(_self)

def choose_activate(_self: "PyObject *") -> "void":
    r"""
    choose_activate(_self)

    @param self: PyObject *
    """
    return _ida_kernwin.choose_activate(_self)

def choose_create_embedded_chobj(_self: "PyObject *") -> "PyObject *":
    r"""
    choose_create_embedded_chobj(_self) -> PyObject *

    @param self: PyObject *
    """
    return _ida_kernwin.choose_create_embedded_chobj(_self)

def get_chooser_data(chooser_caption: "char const *", n: "int") -> "PyObject *":
    r"""
    get_chooser_data(chooser_caption, n) -> [str, ...]
    Get the text corresponding to the index N in the chooser data. Use -1 to get the
    header.

    See also get_chooser_rows().

    @param chooser_caption: (C++: const char *) char const *
    @param n: (C++: int)
    """
    return _ida_kernwin.get_chooser_data(chooser_caption, n)
CH_NOIDB = _ida_kernwin.CH_NOIDB


#<pycode(py_kernwin_choose)>
import _ida_kernwin

class Choose(object):
    r"""
    Chooser wrapper class.

    Some constants are defined in this class.
    Please refer to kernwin.hpp for more information.
    """

    CH_MODAL        = _ida_kernwin.CH_MODAL
    r"""
    Modal chooser
    """

    CH_MULTI        = _ida_kernwin.CH_MULTI
    r"""
    Allow multi selection.
    Refer the description of the OnInsertLine(), OnDeleteLine(),
    OnEditLine(), OnSelectLine(), OnRefresh(), OnSelectionChange() to
    see a difference between single and multi selection callbacks.
    """

    CH_NOBTNS       = _ida_kernwin.CH_NOBTNS

    CH_ATTRS        = _ida_kernwin.CH_ATTRS

    CH_NOIDB        = _ida_kernwin.CH_NOIDB
    r"""
    use the chooser even without an open database, same as x0=-2
    """

    CH_FORCE_DEFAULT = _ida_kernwin.CH_FORCE_DEFAULT
    r"""
    If a non-modal chooser was already open, change selection to the given
    default one
    """

    CH_CAN_INS      = _ida_kernwin.CH_CAN_INS
    r"""
    allow to insert new items
    """

    CH_CAN_DEL      = _ida_kernwin.CH_CAN_DEL
    r"""
    allow to delete existing item(s)
    """

    CH_CAN_EDIT     = _ida_kernwin.CH_CAN_EDIT
    r"""
    allow to edit existing item(s)
    """

    CH_CAN_REFRESH  = _ida_kernwin.CH_CAN_REFRESH
    r"""
    allow to refresh chooser
    """

    CH_QFLT         =  _ida_kernwin.CH_QFLT
    r"""
    open with quick filter enabled and focused
    """

    CH_QFTYP_SHIFT  = _ida_kernwin.CH_QFTYP_SHIFT
    CH_QFTYP_DEFAULT     = _ida_kernwin.CH_QFTYP_DEFAULT
    CH_QFTYP_NORMAL      = _ida_kernwin.CH_QFTYP_NORMAL
    CH_QFTYP_WHOLE_WORDS = _ida_kernwin.CH_QFTYP_WHOLE_WORDS
    CH_QFTYP_REGEX       = _ida_kernwin.CH_QFTYP_REGEX
    CH_QFTYP_FUZZY       = _ida_kernwin.CH_QFTYP_FUZZY
    CH_QFTYP_MASK        = _ida_kernwin.CH_QFTYP_MASK

    CH_NO_STATUS_BAR = _ida_kernwin.CH_NO_STATUS_BAR
    r"""
    don't show a status bar
    """
    CH_RESTORE       = _ida_kernwin.CH_RESTORE
    r"""
    restore floating position if present (equivalent of WOPN_RESTORE) (GUI version only)
    """

    CH_RENAME_IS_EDIT = _ida_kernwin.CH_RENAME_IS_EDIT
    r"""
    triggering a 'edit/rename' (i.e., F2 shortcut) on a cell,
    should call the edit() callback for the corresponding row.
    """

    CH_BUILTIN_SHIFT = _ida_kernwin.CH_BUILTIN_SHIFT
    CH_BUILTIN_MASK = _ida_kernwin.CH_BUILTIN_MASK

    """The chooser can provide a dirtree_t, meaning a tree-like structure
       can be provided to the user (instead of a flat table)"""
    CH_HAS_DIRTREE = _ida_kernwin.CH_HAS_DIRTREE

    """The chooser can be used in a diffing/merging workflow"""
    CH_HAS_DIFF = _ida_kernwin.CH_HAS_DIFF

# column flags (are specified in the widths array)
    CHCOL_PLAIN     = _ida_kernwin.CHCOL_PLAIN
    CHCOL_PATH      = _ida_kernwin.CHCOL_PATH
    CHCOL_HEX       = _ida_kernwin.CHCOL_HEX
    CHCOL_DEC       = _ida_kernwin.CHCOL_DEC
    CHCOL_EA        = _ida_kernwin.CHCOL_EA
    CHCOL_FNAME     = _ida_kernwin.CHCOL_FNAME
    CHCOL_FORMAT    = _ida_kernwin.CHCOL_FORMAT
    CHCOL_DEFHIDDEN = _ida_kernwin.CHCOL_DEFHIDDEN
    CHCOL_DRAGHINT  = _ida_kernwin.CHCOL_DRAGHINT
    CHCOL_INODENAME = _ida_kernwin.CHCOL_INODENAME

# special values of the chooser index
    NO_SELECTION   = -1
    r"""
    there is no selected item
    """
    EMPTY_CHOOSER  = -2
    r"""
    the chooser is initialized
    """
    ALREADY_EXISTS = -3
    r"""
    the non-modal chooser with the same data is already open
    """
    NO_ATTR        = -4
    r"""
    some mandatory attribute is missing
    """

# return value of ins(), del(), edit(), enter(), refresh() callbacks
    NOTHING_CHANGED   = 0
    ALL_CHANGED       = 1
    SELECTION_CHANGED = 2

    class UI_Hooks_Trampoline(UI_Hooks):
        def __init__(self, v):
            UI_Hooks.__init__(self)
            self.hook()
            import weakref
            self.v = weakref.ref(v)

        def populating_widget_popup(self, widget, popup_handle):
            chooser = self.v()
            if widget == chooser.GetWidget() and \
               hasattr(chooser, "OnPopup") and \
               callable(getattr(chooser, "OnPopup")):
                chooser.OnPopup(widget, popup_handle)

    def __init__(self, title, cols, flags = 0, popup_names = None,
                 icon=-1, x1=-1, y1=-1, x2=-1, y2=-1,
                 deflt = None,
                 embedded = False, width = None, height = None,
                 forbidden_cb = 0, flags2 = 0):
        r"""
        Constructs a chooser window.
        @param title: The chooser title
        @param cols: a list of colums; each list item is a list of two items
            example: [ ["Address", 10 | Choose.CHCOL_HEX],
                       ["Name",    30 | Choose.CHCOL_PLAIN] ]
        @param flags: One of CH_XXXX constants
        @param flags2: One of CH2_XXXX constants
        @param deflt: The index of the default item (0-based) for single
            selection choosers or the list of indexes for multi selection
            chooser
        @param popup_names: List of new captions to replace this list
            ["Insert", "Delete", "Edit", "Refresh"]
        @param icon: Icon index (the icon should exist in ida resources or
            an index to a custom loaded icon)
        @param x1: , y1, x2, y2: The default location (for txt-version)
        @param embedded: Create as embedded chooser
        @param width: Embedded chooser width
        @param height: Embedded chooser height
        @param forbidden_cb: Explicitly forbidden callbacks
        """
        self.title = title
        self.flags = flags
        self.flags2 = flags2
        self.cols = cols
        if deflt == None:
          deflt = 0 if (flags & Choose.CH_MULTI) == 0 else [0]
        self.deflt = deflt
        self.popup_names = popup_names
        self.icon = icon
        self.x1 = x1
        self.y1 = y1
        self.x2 = x2
        self.y2 = y2
        self.embedded = embedded
        self.width = width
        self.height = height
        self.forbidden_cb = forbidden_cb
        self.ui_hooks_trampoline = None # set on Show
        def _qccb(ctx, cmd_id):
            for idx in ctx.chooser_selection:
                self.OnCommand(idx, cmd_id)
        self._quick_commands = quick_widget_commands_t(_qccb)


    def Embedded(self, create_chobj=False):
        r"""
        Creates an embedded chooser (as opposed to Show())
        @return: Returns 0 on success or NO_ATTR
        """
        if not self.embedded:
          return Choose.NO_ATTR
        if create_chobj:
            return _ida_kernwin.choose_create_embedded_chobj(self)
        else:
            return _ida_kernwin.choose_choose(self)


    def GetEmbSelection(self):
        r"""
        Deprecated. For embedded choosers, the selection is
        available through 'Form.EmbeddedChooserControl.selection'
        """
        return None


    def Show(self, modal=False):
        r"""
        Activates or creates a chooser window
        @param modal: Display as modal dialog
        @return: For all choosers it will return NO_ATTR if some mandatory
                 attribute is missing. The mandatory attributes are: flags,
                 title, cols, OnGetSize(), OnGetLine();
                 For modal choosers it will return the selected item index (0-based),
                 or NO_SELECTION if no selection,
                 or EMPTY_CHOOSER if the OnRefresh() callback returns EMPTY_CHOOSER;
                 For non-modal choosers it will return 0
                 or ALREADY_EXISTS if the chooser was already open and is active now;
        """
        if self.embedded:
          return Choose.NO_ATTR
# it will be deleted and unhooked in py_choose_t::closed()
        self.ui_hooks_trampoline = self.UI_Hooks_Trampoline(self)
        if modal:
            self.flags |= Choose.CH_MODAL

# Disable the timeout
            with disabled_script_timeout_t():
                n = _ida_kernwin.choose_choose(self)

# Delete the modal chooser instance
            self.Close()

            return n
        else:
            self.flags &= ~Choose.CH_MODAL
            return _ida_kernwin.choose_choose(self)


    def Activate(self):
        r"""
        Activates a visible chooser
        """
        return _ida_kernwin.choose_activate(self)


    def Refresh(self):
        r"""
        Causes the refresh callback to trigger
        """
        return _ida_kernwin.choose_refresh(self)


    def Close(self):
        r"""
        Closes the chooser
        """
        if not self.embedded:
            _ida_kernwin.choose_close(self)

    def GetWidget(self):
        r"""
        Return the TWidget underlying this view.

        @return: The TWidget underlying this view, or None.
        """
        return _ida_kernwin.choose_get_widget(self)

    def adjust_last_item(self, n):
        r"""
        Helper for OnDeleteLine() and OnRefresh() callbacks.
        They can be finished by the following line:
        return [Choose.ALL_CHANGED] + self.adjust_last_item(n)
        @param line: number of the remaining select item
        @return: list of selected lines numbers (one element or empty)
        """
        cnt = self.OnGetSize()
        if cnt == 0:
            return []
# take in account deleting of the last item(s)
        if n >= cnt:
            n = cnt - 1
        return [n]

    def AddCommand(self,
                   caption,
                   flags = _ida_kernwin.CHOOSER_POPUP_MENU,
                   menu_index = -1,
                   icon = -1,
                   emb=None,
                   shortcut=None):
        return self._quick_commands.add(
            caption=caption,
            flags=flags,
            menu_index=menu_index,
            icon=icon,
            emb=emb,
            shortcut=shortcut)

    def OnPopup(self, widget, popup_handle):
        self._quick_commands.populate_popup(widget, popup_handle)

    def OnInit(self):
        r"""
        Initialize the chooser and populate it.

        This callback is optional
        """
        pass

    def OnGetSize(self):
        r"""
        Get the number of elements in the chooser.

        This callback is mandatory

        @return: the number of elements
        """
        pass

    def OnGetLine(self, n):
        r"""
        Get data for an element

        This callback is mandatory

        @param n: the index to fetch data for
        @return: a list of strings
        """
        pass

    def OnGetIcon(self, n):
        r"""
        Get an icon to associate with the first cell of an element

        @param n: index of the element
        @return: an icon ID
        """
        pass

    def OnGetLineAttr(self, n):
        r"""
        Get attributes for an element

        @param n: index of the element
        @return: a tuple (color, flags)
        """
        pass

    def OnInsertLine(self, sel):
        r"""
        User asked to insert an element

        @param sel: the current selection
        @return: a tuple (changed, selection)
        """
        pass

    def OnDeleteLine(self, sel):
        r"""
        User deleted an element

        @param sel: the current selection
        @return: a tuple (changed, selection)
        """
        pass

    def OnEditLine(self, sel):
        r"""
        User asked to edit an element.

        @param sel: the current selection
        @return: a tuple (changed, selection)
        """
        pass

    def OnSelectLine(self, sel):
        r"""
        User pressed the enter key, or double-clicked a selection

        @param sel: the current selection
        @return: a tuple (changed, selection)
        """
        pass

    def OnSelectionChange(self, sel):
        r"""
        Selection changed

        @param sel: the new selection
        """
        pass

    def OnRefresh(self, sel):
        r"""
        The chooser needs to be refreshed.
        It returns the new positions of the selected items.

        @param sel: the current selection
        @return: a tuple (changed, selection)
        """
        pass

    def OnClose(self):
        r"""
        The chooser window is closed.
        """
        pass

    def OnGetEA(self, n):
        r"""
        Get the address of an element

        When this function returns valid addresses:
          * If any column has the `CHCOL_FNAME` flag, rows will
            be colored according to the attributes of the functions
            who own those addresses (extern, library function,
            Lumina, ... - similar to what the "Functions" widget does)
          * When a selection is present and the user presses `<Enter>`
            (`<Shift+Enter>` if the chooser is modal), IDA will jump
            to that address (through jumpto())
        @param n: element number (0-based)
        @return: the effective address, ida_idaapi.BADADDR if the element has no address
        """
        pass

    def OnGetDirTree(self):
        r"""
        Get the dirtree_t that will be used to present a tree-like
        structure to the user (see CH_HAS_DIRTREE)

        @return: the dirtree_t, or None
        """
        pass

    def OnIndexToInode(self, n):
        r"""
        Map an element index to a dirtree_t inode

        This callback is mandatory if CH_HAS_DIRTREE is specified

        @param n: index of the element
        @return: the inode number
        """
        pass

    def OnIndexToDiffpos(self, n):
        r"""
        Map an element index to a diffpos_t

        This callback is mandatory if CH_HAS_DIFF is specified

        @param n: index of the element
        @return: the diffpos
        """
        pass

    def OnLazyLoadDir(self, path):
        r"""
        Callback for lazy-loaded, dirtree-based choosers;
        the function will be called when a folder is expanded and it has
        not been loaded before. The implementation should use the
        given dirtree's link() or mkdir() methods to add the folder contents.

        @param path: an absolute dirtree path to the directory that is being expanded
        @return: success
        """
        pass

#</pycode(py_kernwin_choose)>


def textctrl_info_t_assign(_self: "PyObject *", other: "PyObject *") -> "bool":
    r"""
    textctrl_info_t_assign(_self, other) -> bool

    @param self: PyObject *
    @param other: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_assign(_self, other)

def textctrl_info_t_set_text(_self: "PyObject *", s: "char const *") -> "bool":
    r"""
    textctrl_info_t_set_text(_self, s) -> bool

    @param self: PyObject *
    @param s: char const *
    """
    return _ida_kernwin.textctrl_info_t_set_text(_self, s)

def textctrl_info_t_get_text(_self: "PyObject *") -> "char const *":
    r"""
    textctrl_info_t_get_text(_self) -> char const *

    @param self: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_get_text(_self)

def textctrl_info_t_set_flags(_self: "PyObject *", flags: "unsigned int") -> "bool":
    r"""
    textctrl_info_t_set_flags(_self, flags) -> bool

    @param self: PyObject *
    @param flags: unsigned int
    """
    return _ida_kernwin.textctrl_info_t_set_flags(_self, flags)

def textctrl_info_t_get_flags(_self: "PyObject *") -> "unsigned int":
    r"""
    textctrl_info_t_get_flags(_self) -> unsigned int

    @param self: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_get_flags(_self)

def textctrl_info_t_set_tabsize(_self: "PyObject *", tabsize: "unsigned int") -> "bool":
    r"""
    textctrl_info_t_set_tabsize(_self, tabsize) -> bool

    @param self: PyObject *
    @param tabsize: unsigned int
    """
    return _ida_kernwin.textctrl_info_t_set_tabsize(_self, tabsize)

def textctrl_info_t_get_tabsize(_self: "PyObject *") -> "unsigned int":
    r"""
    textctrl_info_t_get_tabsize(_self) -> unsigned int

    @param self: PyObject *
    """
    return _ida_kernwin.textctrl_info_t_get_tabsize(_self)

def formchgcbfa_enable_field(p_fa: "size_t", fid: "int", enable: "bool") -> "bool":
    r"""
    formchgcbfa_enable_field(p_fa, fid, enable) -> bool

    @param p_fa: size_t
    @param fid: int
    @param enable: bool
    """
    return _ida_kernwin.formchgcbfa_enable_field(p_fa, fid, enable)

def formchgcbfa_show_field(p_fa: "size_t", fid: "int", show: "bool") -> "bool":
    r"""
    formchgcbfa_show_field(p_fa, fid, show) -> bool

    @param p_fa: size_t
    @param fid: int
    @param show: bool
    """
    return _ida_kernwin.formchgcbfa_show_field(p_fa, fid, show)

def formchgcbfa_move_field(p_fa: "size_t", fid: "int", x: "int", y: "int", w: "int", h: "int") -> "bool":
    r"""
    formchgcbfa_move_field(p_fa, fid, x, y, w, h) -> bool

    @param p_fa: size_t
    @param fid: int
    @param x: int
    @param y: int
    @param w: int
    @param h: int
    """
    return _ida_kernwin.formchgcbfa_move_field(p_fa, fid, x, y, w, h)

def formchgcbfa_get_focused_field(p_fa: "size_t") -> "int":
    r"""
    formchgcbfa_get_focused_field(p_fa) -> int

    @param p_fa: size_t
    """
    return _ida_kernwin.formchgcbfa_get_focused_field(p_fa)

def formchgcbfa_set_focused_field(p_fa: "size_t", fid: "int") -> "bool":
    r"""
    formchgcbfa_set_focused_field(p_fa, fid) -> bool

    @param p_fa: size_t
    @param fid: int
    """
    return _ida_kernwin.formchgcbfa_set_focused_field(p_fa, fid)

def formchgcbfa_refresh_field(p_fa: "size_t", fid: "int") -> "void":
    r"""
    formchgcbfa_refresh_field(p_fa, fid)

    @param p_fa: size_t
    @param fid: int
    """
    return _ida_kernwin.formchgcbfa_refresh_field(p_fa, fid)

def formchgcbfa_close(p_fa: "size_t", close_normally: "int") -> "void":
    r"""
    formchgcbfa_close(p_fa, close_normally)

    @param p_fa: size_t
    @param close_normally: int
    """
    return _ida_kernwin.formchgcbfa_close(p_fa, close_normally)

def formchgcbfa_get_field_value(p_fa: "size_t", fid: "int", ft: "int", sz: "size_t") -> "PyObject *":
    r"""
    formchgcbfa_get_field_value(p_fa, fid, ft, sz) -> PyObject *

    @param p_fa: size_t
    @param fid: int
    @param ft: int
    @param sz: size_t
    """
    return _ida_kernwin.formchgcbfa_get_field_value(p_fa, fid, ft, sz)

def formchgcbfa_set_field_value(p_fa: "size_t", fid: "int", ft: "int", py_val: "PyObject *") -> "bool":
    r"""
    formchgcbfa_set_field_value(p_fa, fid, ft, py_val) -> bool

    @param p_fa: size_t
    @param fid: int
    @param ft: int
    @param py_val: PyObject *
    """
    return _ida_kernwin.formchgcbfa_set_field_value(p_fa, fid, ft, py_val)

def py_get_ask_form() -> "size_t":
    r"""
    py_get_ask_form() -> size_t
    """
    return _ida_kernwin.py_get_ask_form()

def py_get_open_form() -> "size_t":
    r"""
    py_get_open_form() -> size_t
    """
    return _ida_kernwin.py_get_open_form()

def py_register_compiled_form(py_form: "PyObject *") -> "void":
    r"""
    py_register_compiled_form(py_form)

    @param py_form: PyObject *
    """
    return _ida_kernwin.py_register_compiled_form(py_form)

def py_unregister_compiled_form(py_form: "PyObject *") -> "void":
    r"""
    py_unregister_compiled_form(py_form)

    @param py_form: PyObject *
    """
    return _ida_kernwin.py_unregister_compiled_form(py_form)

#<pycode(py_kernwin_askform)>
import sys

import ida_idaapi, _ida_idaapi
import ida_pro

#ICON WARNING|QUESTION|INFO|NONE
#AUTOHIDE NONE|DATABASE|REGISTRY|SESSION
#HIDECANCEL
#BUTTON YES|NO|CANCEL "Value|NONE"
#STARTITEM {id:ItemName}
#HELP / ENDHELP
try:
    import types
    import ctypes
# On Windows, we use stdcall

# Callback for buttons
# typedef int (idaapi *buttoncb_t)(int button_code, form_actions_t &fa);

    _BUTTONCB_T = ctypes.WINFUNCTYPE(ctypes.c_int, ctypes.c_int, ctypes.c_void_p)

# Callback for form change
# typedef int (idaapi *formchgcb_t)(int field_id, form_actions_t &fa);
    _FORMCHGCB_T = ctypes.WINFUNCTYPE(ctypes.c_int, ctypes.c_int, ctypes.c_void_p)
except:
    try:
        _BUTTONCB_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_int, ctypes.c_void_p)
        _FORMCHGCB_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_int, ctypes.c_void_p)
    except:
        _BUTTONCB_T = _FORMCHGCB_T = None


# -----------------------------------------------------------------------
# textctrl_info_t clinked object
class textctrl_info_t(ida_idaapi.py_clinked_object_t):
    r"""
    Class representing textctrl_info_t
    """

# Some constants
    TXTF_AUTOINDENT = 0x0001
    r"""
    Auto-indent on new line
    """
    TXTF_ACCEPTTABS = 0x0002
    r"""
    Tab key inserts 'tabsize' spaces
    """
    TXTF_READONLY   = 0x0004
    r"""
    Text cannot be edited (but can be selected and copied)
    """
    TXTF_SELECTED   = 0x0008
    r"""
    Shows the field with its text selected
    """
    TXTF_MODIFIED   = 0x0010
    r"""
    Gets/sets the modified status
    """
    TXTF_FIXEDFONT  = 0x0020
    r"""
    The control uses IDA's fixed font
    """

    def __init__(self, text="", flags=0, tabsize=0):
        ida_idaapi.py_clinked_object_t.__init__(self)
        if text:
            self.text = text
        if flags:
            self.flags = flags
        if tabsize:
            self.tabsize = tabsize

    def _create_clink(self):
        return _ida_kernwin.textctrl_info_t_create()

    def _del_clink(self, lnk):
        return _ida_kernwin.textctrl_info_t_destroy(lnk)

    def _get_clink_ptr(self):
        return _ida_kernwin.textctrl_info_t_get_clink_ptr(self)

    def assign(self, other):
        r"""
        Copies the contents of 'other' to 'self'
        """
        return _ida_kernwin.textctrl_info_t_assign(self, other)

    def __set_text(self, s):
        r"""
        Sets the text value
        """
        return _ida_kernwin.textctrl_info_t_set_text(self, s)

    def __get_text(self):
        r"""
        Sets the text value
        """
        return _ida_kernwin.textctrl_info_t_get_text(self)

    def __set_flags__(self, flags):
        r"""
        Sets the flags value
        """
        return _ida_kernwin.textctrl_info_t_set_flags(self, flags)

    def __get_flags__(self):
        r"""
        Returns the flags value
        """
        return _ida_kernwin.textctrl_info_t_get_flags(self)

    def __set_tabsize__(self, tabsize):
        r"""
        Sets the tabsize value
        """
        return _ida_kernwin.textctrl_info_t_set_tabsize(self, tabsize)

    def __get_tabsize__(self):
        r"""
        Returns the tabsize value
        """
        return _ida_kernwin.textctrl_info_t_get_tabsize(self)

    value   = property(__get_text, __set_text)
    r"""
    Alias for the text property
    """
    text    = property(__get_text, __set_text)
    r"""
    in, out: text control value
    """
    flags   = property(__get_flags__, __set_flags__)
    r"""
    Text control property bits
    """
    tabsize = property(__get_tabsize__, __set_tabsize__)
    r"""
    how many spaces a single tab will indent
    """

# -----------------------------------------------------------------------
class Form(object):

    FT_ASCII = 'A'
    r"""
    Ascii string - char *
    """
    FT_SEG = 'S'
    r"""
    Segment - sel_t *
    """
    FT_HEX = 'N'
    r"""
    Hex number - uval_t *
    """
    FT_SHEX = 'n'
    r"""
    Signed hex number - sval_t *
    """
    FT_COLOR = 'K'
    r"""
    Color button - bgcolor_t *
    """
    FT_ADDR = '$'
    r"""
    Address - ea_t *
    """
    FT_UINT64 = 'L'
    r"""
    default base uint64 - uint64
    """
    FT_INT64 = 'l'
    r"""
    default base int64 - int64
    """
    FT_RAWHEX = 'M'
    r"""
    Hex number, no 0x prefix - uval_t *
    """
    FT_FILE = 'f'
    r"""
    File browse - char * at least QMAXPATH
    """
    FT_DEC = 'D'
    r"""
    Decimal number - sval_t *
    """
    FT_OCT = 'O'
    r"""
    Octal number, C notation - sval_t *
    """
    FT_BIN = 'Y'
    r"""
    Binary number, 0b prefix - sval_t *
    """
    FT_CHAR = 'H'
    r"""
    Char value -- sval_t *
    """
    FT_IDENT = 'I'
    r"""
    Identifier - char * at least MAXNAMELEN
    """
    FT_BUTTON = 'B'
    r"""
    Button - def handler(code)
    """
    FT_DIR = 'F'
    r"""
    Path to directory - char * at least QMAXPATH
    """
    FT_TYPE = 'T'
    r"""
    Type declaration - char * at least MAXSTR
    """
    _FT_USHORT = '_US'
    r"""
    Unsigned short
    """
    FT_FORMCHG = '%/'
    r"""
    Form change callback - formchgcb_t
    """
    FT_ECHOOSER = 'E'
    r"""
    Embedded chooser - idaapi.Choose
    """
    FT_MULTI_LINE_TEXT = 't'
    r"""
    Multi text control - textctrl_info_t
    """
    FT_DROPDOWN_LIST   = 'b'
    r"""
    Dropdown list control - Form.DropdownControl
    """
    FT_HTML_LABEL = 'h'
    r"""
    HTML label to display (only for GUI version, and for dynamic labels; no input)
    """

    FT_CHKGRP = 'C'
    FT_CHKGRP2= 'c'
    FT_RADGRP = 'R'
    FT_RADGRP2= 'r'

    @staticmethod
    def create_string_buffer(value, size=None):
        if value is None:
            assert(size is not None)
            return ctypes.create_string_buffer(size)
        else:
            if sys.version_info.major >= 3:
                return ctypes.create_string_buffer(value.encode("UTF-8"), size)
            else:
                return ctypes.create_string_buffer(value, size)

    @staticmethod
    def fieldtype_to_ctype(tp, i64 = False):
        r"""
        Factory method returning a ctype class corresponding to the field type string
        """
        if tp in (Form.FT_SEG, Form.FT_HEX, Form.FT_RAWHEX, Form.FT_ADDR):
            return ctypes.c_uint64 if i64 else ctypes.c_ulong
        elif tp in (Form.FT_SHEX, Form.FT_DEC, Form.FT_OCT, Form.FT_BIN, Form.FT_CHAR):
            return ctypes.c_int64 if i64 else ctypes.c_long
        elif tp == Form.FT_UINT64:
            return ctypes.c_uint64
        elif tp == Form.FT_INT64:
            return ctypes.c_int64
        elif tp == Form.FT_COLOR:
            return ctypes.c_ulong
        elif tp == Form._FT_USHORT:
            return ctypes.c_ushort
        elif tp in (Form.FT_FORMCHG, Form.FT_ECHOOSER):
            return ctypes.c_void_p
        else:
            return None


#
# Generic argument helper classes
#
    class NumericArgument(object):
        """
        Argument representing various integer arguments (ushort, uint32, uint64, etc...)
        @param tp: One of Form.FT_XXX
        """
        DefI64 = False
        def __init__(self, tp, value):
            cls = Form.fieldtype_to_ctype(tp, self.DefI64)
            if cls is None:
                raise TypeError("Invalid numeric field type: %s" % tp)
# Get a pointer type to the ctype type
            self.arg = ctypes.pointer(cls(value))

        def __set_value(self, v):
            self.arg.contents.value = v
        value = property(lambda self: self.arg.contents.value, __set_value)


    class StringArgument(object):
        """
        Argument representing a character buffer
        """
        def __init__(self, size=None, value=None):
            if size is None:
                raise SyntaxError("The string size must be passed")
            if isinstance(size, str):
                value, size = size, None
            self.size = size
            self.arg = Form.create_string_buffer(value, size)

        def __get_value(self):
            return self.arg.value.decode("UTF-8")

        def __set_value(self, v):
            self.arg.value = v.encode("UTF-8")
        value = property(__get_value, __set_value)


#
# Base control class
#
    class Control(object):
        def __init__(self):
            self.id = 0
            """Automatically assigned control ID"""

            self.input_field_index = None
            """If this control is an input field, once Compile() returns this will hold its index. This is used only to compute the possible STARTITEM index"""

            self.arg = None
            """Control argument value. This could be one element or a list/tuple (for multiple args per control)"""

            self.form = None
            """Reference to the parent form. It is filled by Form.Add()"""

            self.form_hasattr = False

        def get_tag(self):
            """
            Control tag character. One of Form.FT_XXXX.
            The form class will expand the {} notation and replace them with the tags
            """
            pass

        def get_arg(self):
            """
            Control returns the parameter to be pushed on the stack
            (Of ask_form())
            """
            return self.arg

        def free(self):
            """
            Free the control
            """
# Release the parent form reference
            self.form = None

        def is_input_field(self):
            """
            Return True if this field acts as an input
            """
            return False

#
# Label controls
#
    class LabelControl(Control):
        """
        Base class for static label control
        """
        def __init__(self, tp):
            Form.Control.__init__(self)
            self.tp = tp

        def get_tag(self):
            return '%%%d%s' % (self.id, self.tp)


    class StringLabel(LabelControl):
        """
        String label control
        """
        def __init__(self, value, tp=None, size=ida_pro.MAXSTR):
            """
            Type field can be one of:
            A - ascii string
            T - type declaration
            I - ident
            F - folder
            f - file
            X - command
            """
            if tp is None:
                tp = Form.FT_ASCII
            Form.LabelControl.__init__(self, tp)
            self.size = size
            self.arg = Form.create_string_buffer(value, size)


    class NumericLabel(LabelControl, NumericArgument):
        """
        Numeric label control
        """
        def __init__(self, value, tp=None):
            if tp is None:
                tp = Form.FT_HEX
            Form.LabelControl.__init__(self, tp)
            Form.NumericArgument.__init__(self, tp, value)


#
# Group controls
#
    class GroupItemControl(Control):
        """
        Base class for group control items
        """
        def __init__(self, tag, parent):
            Form.Control.__init__(self)
            self.tag = tag
            self.parent = parent
# Item position (filled when form is compiled)
            self.pos = 0

        def assign_pos(self):
            self.pos = self.parent.next_child_pos()

        def get_tag(self):
            return "%s%d" % (self.tag, self.id)

        def is_input_field(self):
            return True


    class ChkGroupItemControl(GroupItemControl):
        """
        Checkbox group item control
        """
        def __init__(self, tag, parent):
            Form.GroupItemControl.__init__(self, tag, parent)

        def __get_value(self):
            return (self.parent.value & (1 << self.pos)) != 0

        def __set_value(self, v):
            pv = self.parent.value
            if v:
                pv = pv | (1 << self.pos)
            else:
                pv = pv & ~(1 << self.pos)

            self.parent.value = pv

        checked = property(__get_value, __set_value)
        """Get/Sets checkbox item check status"""


    class RadGroupItemControl(GroupItemControl):
        """
        Radiobox group item control
        """
        def __init__(self, tag, parent):
            Form.GroupItemControl.__init__(self, tag, parent)

        def __get_value(self):
            return self.parent.value == self.pos

        def __set_value(self, v):
            self.parent.value = self.pos

        selected = property(__get_value, __set_value)
        """Get/Sets radiobox item selection status"""


    class GroupControl(Control, NumericArgument):
        """
        Base class for group controls
        """
        def __init__(self, children_names, tag, value=0):
            Form.Control.__init__(self)
            self.children_names = children_names
            self.tag = tag
            self._reset()
            Form.NumericArgument.__init__(self, Form._FT_USHORT, value)

        def _reset(self):
            self.childpos = 0

        def next_child_pos(self):
            v = self.childpos
            self.childpos += 1
            return v

        def get_tag(self):
            return "%d" % self.id


    class ChkGroupControl(GroupControl):
        """
        Checkbox group control class.
        It holds a set of checkbox controls
        """
        ItemClass = None
        """
        Group control item factory class instance
        We need this because later we won't be treating ChkGroupControl or RadGroupControl
        individually, instead we will be working with GroupControl in general.
        """
        def __init__(self, children_names, value=0, secondary=False):
# Assign group item factory class
            if Form.ChkGroupControl.ItemClass is None:
                Form.ChkGroupControl.ItemClass = Form.ChkGroupItemControl

            Form.GroupControl.__init__(
                self,
                children_names,
                Form.FT_CHKGRP2 if secondary else Form.FT_CHKGRP,
                value)


    class RadGroupControl(GroupControl):
        """
        Radiobox group control class.
        It holds a set of radiobox controls
        """
        ItemClass = None
        def __init__(self, children_names, value=0, secondary=False):
            """
            Creates a radiogroup control.
            @param children_names: A tuple containing group item names
            @param value: Initial selected radio item
            @param secondory: Allows rendering one the same line as the previous group control.
                              Use this if you have another group control on the same line.
            """
# Assign group item factory class
            if Form.RadGroupControl.ItemClass is None:
                Form.RadGroupControl.ItemClass = Form.RadGroupItemControl

            Form.GroupControl.__init__(
                self,
                children_names,
                Form.FT_RADGRP2 if secondary else Form.FT_RADGRP,
                value)


#
# Input controls
#
    class InputControl(Control):
        """
        Generic form input control.
        It could be numeric control, string control, directory/file browsing, etc...
        """
        def __init__(self,
                     tp,
                     width,
                     swidth,
                     hlp=None,
                     is_relative_offset=False):
            """
            @param width:  The maximum possible number of characters that
                           can be entered into the input field
            @param swidth: The width of visible part of the input field
            """
            Form.Control.__init__(self)
            self.tp = tp
            self.width = width
            self.swidth = swidth
            self.hlp = hlp
            self.is_relative_offset = is_relative_offset

        def get_tag(self):
            return "%s%d:%s%s:%s:%s" % (
                self.tp, self.id,
                "+" if self.is_relative_offset else "",
                self.width,
                self.swidth,
                ":" if self.hlp is None else self.hlp)

        def is_input_field(self):
            return True


    class NumericInput(InputControl, NumericArgument):
        """
        A composite class serving as a base numeric input control class
        """
        def __init__(self,
                     tp=None,
                     value=0,
                     width=50,
                     swidth=10,
                     hlp=None,
                     is_relative_offset=False):
            if tp is None:
                tp = Form.FT_HEX
            Form.InputControl.__init__(self,
                tp, width, swidth, hlp, is_relative_offset)
            Form.NumericArgument.__init__(self, self.tp, value)


    class ColorInput(NumericInput):
        """
        Color button input control
        """
        def __init__(self, value = 0):
            """
            @param value: Initial color value in RGB
            """
            Form.NumericInput.__init__(self, tp=Form.FT_COLOR, value=value)


    class StringInput(InputControl, StringArgument):
        """
        Base string input control class.
        This class also constructs a StringArgument
        """
        def __init__(self,
                     tp=None,
                     width=ida_pro.MAXSTR,
                     swidth=40,
                     hlp=None,
                     value=None,
                     size=None):
            """
            @param width: String size. But in some cases it has special meaning. For example in FileInput control.
                          If you want to define the string buffer size then pass the 'size' argument
            @param swidth: Control width
            @param value: Initial value
            @param size: String size
            """
            if tp is None:
                tp = Form.FT_ASCII
            if not size:
                size = width
            Form.InputControl.__init__(self, tp, width, swidth, hlp)
            Form.StringArgument.__init__(self, size=size, value=value)


    class FileInput(StringInput):
        """
        File Open/Save input control
        """
        def __init__(self,
                     width=512,
                     swidth=80,
                     save=False, open=False,
                     hlp=None, value=None):

            if save == open:
                raise ValueError("Invalid mode. Choose either open or save")
            if width < 512:
                raise ValueError("Invalid width. Must be greater than 512.")

# The width field is overloaded in this control and is used
# to denote the type of the FileInput dialog (save or load)
# On the other hand it is passed as is to the StringArgument part
            Form.StringInput.__init__(
                self,
                tp=Form.FT_FILE,
                width="1" if save else "0",
                swidth=swidth,
                hlp=hlp,
                size=width,
                value=value)


    class DirInput(StringInput):
        """
        Directory browsing control
        """
        def __init__(self,
                     width=512,
                     swidth=80,
                     hlp=None,
                     value=None):

            if width < 512:
                raise ValueError("Invalid width. Must be greater than 512.")

            Form.StringInput.__init__(
                self,
                tp=Form.FT_DIR,
                width=width,
                swidth=swidth,
                hlp=hlp,
                size=width,
                value=value)


    class ButtonInput(InputControl):
        """
        Button control.
        A handler along with a 'code' (numeric value) can be associated with the button.
        This way one handler can handle many buttons based on the button code (or in other terms id or tag)
        """
        def __init__(self, handler, code="", swidth="", hlp=None):
            """
            @param handler: Button handler. A callback taking one argument which is the code.
            @param code: A code associated with the button and that is later passed to the handler.
            """
            Form.InputControl.__init__(
                self,
                Form.FT_BUTTON,
                code,
                swidth,
                hlp)
            self.handler = handler
            self.arg = _BUTTONCB_T(self.helper_cb)

        def helper_cb(self, button_code, p_fa):
# Remember the pointer to the forms_action in the parent form
            self.form.p_fa = p_fa

# Call user's handler
            r = self.handler(button_code)
            return 0 if r is None else r

        def is_input_field(self):
            return False


    class FormChangeCb(Control):
        """
        Form change handler.
        This can be thought of like a dialog procedure.
        Everytime a form action occurs, this handler will be called along with the control id.
        The programmer can then call various form actions accordingly:
          - EnableField
          - ShowField
          - MoveField
          - GetFieldValue
          - etc...

        Special control IDs: -1 (The form is initialized) and -2 (Ok has been clicked)

        """
        def __init__(self, handler):
            """
            Constructs the handler.
            @param handler: The handler (preferrably a member function of a class derived from the Form class).
            """
            Form.Control.__init__(self)

# Save the handler
            self.handler = handler

# Create a callback stub
# We use this mechanism to create an intermediate step
# where we can create an 'fa' adapter for use by Python
            self.arg = _FORMCHGCB_T(self.helper_cb)

        def helper_cb(self, fid, p_fa):
# Remember the pointer to the forms_action in the parent form
            self.form.p_fa = p_fa

# Call user's handler
            r = self.handler(fid)
            return 0 if r is None else r

        def get_tag(self):
            return Form.FT_FORMCHG

        def free(self):
            Form.Control.free(self)
# Remove reference to the handler
# (Normally the handler is a member function in the parent form)
            self.handler = None


    class EmbeddedChooserControl(InputControl):
        """
        Embedded chooser control.
        This control links to a Chooser2 control created with the 'embedded=True'
        """
        def __init__(self,
                     chooser=None,
                     swidth=40,
                     hlp=None):
            """
            Embedded chooser control

            @param chooser: A chooser2 instance (must be constructed with 'embedded=True')
            """

# !! Make sure a chooser instance is passed !!
            if chooser is None or not isinstance(chooser, Choose):
                raise ValueError("Invalid chooser passed.")

# Create an embedded chooser structure from the Choose instance,
# and retrieve the pointer to the chooser_base_t.
            emb = chooser.Embedded(create_chobj=True)
# if chooser.Embedded() != 0:
            if emb is None:
                raise ValueError("Failed to create embedded chooser instance.")

# Construct input control
            Form.InputControl.__init__(self, Form.FT_ECHOOSER, "", swidth)

            self.selobj = ida_pro.sizevec_t()

# Get a pointer to the selection vector
            if sys.version_info.major >= 3:
                sel = self.selobj.this.__int__()
            else:
                sel = self.selobj.this.__long__()

# Get a pointer to a c_void_p constructed from an address
            p_embedded = ctypes.pointer(ctypes.c_void_p.from_address(emb))
            p_sel      = ctypes.pointer(ctypes.c_void_p.from_address(sel))

# - Create the embedded chooser info on control creation
# - Do not free the embeded chooser because after we get the args
#   via Compile() the user can still call Execute() which relies
#   on the already computed args
            self.arg   = (p_embedded, p_sel)

# Save chooser instance
            self.chooser = chooser

# Add a bogus 'size' attribute
            self.size = 0


        value = property(lambda self: self.chooser)
        """Returns the embedded chooser instance"""

        def __get_selection__(self):
            if len(self.selobj):
                out = []
                for item in self.selobj:
                    out.append(int(item))
                return out
        selection = property(__get_selection__)
        """Returns the selection"""

        def free(self):
            """
            Frees the embedded chooser data
            """
            self.chooser.Close()
            self.chooser = None
            Form.Control.free(self)


    class DropdownListControl(InputControl, ida_pro._qstrvec_t):
        """
        Dropdown control
        This control allows manipulating a dropdown control
        """
        def __init__(self, items=[], readonly=True, selval=0, width=50, swidth=50, hlp = None):
            """
            @param items: A string list of items used to prepopulate the control
            @param readonly: Specifies whether the dropdown list is editable or not
            @param selval: The preselected item index (when readonly) or text value (when editable)
            @param width: the control width (n/a if the dropdown list is readonly)
            @param swidth: string width
            """

# Ignore the width if readonly was set
            if readonly:
                width = 0

# Init the input control base class
            Form.InputControl.__init__(
                self,
                Form.FT_DROPDOWN_LIST,
                width,
                swidth,
                hlp)

# Init the associated qstrvec
            ida_pro._qstrvec_t.__init__(self, items)

# Remember if readonly or not
            self.readonly = readonly

            if readonly:
# Create a C integer and remember it
                self.__selval = ctypes.c_int(selval)
                val_addr      = ctypes.addressof(self.__selval)
            else:
# Create an strvec with one qstring
                self.__selval = ida_pro._qstrvec_t([selval])
# Get address of the first element
                val_addr      = self.__selval.addressof(0)

# Two arguments:
# - argument #1: a pointer to the qstrvec containing the items
# - argument #2: an integer to hold the selection
#         or
#            #2: a qstring to hold the dropdown text control value
            self.arg = (
                ctypes.pointer(ctypes.c_void_p.from_address(self.clink_ptr)),
                ctypes.pointer(ctypes.c_void_p.from_address(val_addr))
            )


        def __set_selval(self, val):
            if self.readonly:
                self.__selval.value = val
            else:
                self.__selval[0] = val

        def __get_selval(self):
# Return the selection index
# or the entered text value
            return self.__selval.value if self.readonly else self.__selval[0]

        value  = property(__get_selval, __set_selval)
        selval = property(__get_selval, __set_selval)
        """
        Read/write the selection value.
        The value is used as an item index in readonly mode or text value in editable mode
        This value can be used only after the form has been closed.
        """

        def free(self):
            self._free()


        def set_items(self, items):
            """Sets the dropdown list items"""
            self.from_list(items)


    class MultiLineTextControl(InputControl, textctrl_info_t):
        """
        Multi line text control.
        This class inherits from textctrl_info_t. Thus the attributes are also inherited
        This control allows manipulating a multilinetext control
        """
        def __init__(self, text="", flags=0, tabsize=0, width=50, swidth=50, hlp = None):
            """
            @param text: Initial text value
            @param flags: One of textctrl_info_t.TXTF_.... values
            @param tabsize: Tab size
            @param width: Display width
            @param swidth: String width
            """
# Init the input control base class
            Form.InputControl.__init__(self, Form.FT_MULTI_LINE_TEXT, width, swidth, hlp)

# Init the associated textctrl_info base class
            textctrl_info_t.__init__(self, text=text, flags=flags, tabsize=tabsize)

# Get the argument as a pointer from the embedded ti
            self.arg = ctypes.pointer(ctypes.c_void_p.from_address(self.clink_ptr))


        def free(self):
            self._free()


#
# Form class
#
    def __init__(self, form, controls):
        r"""
        Contruct a Form class.
        This class wraps around ask_form() or open_form() and provides an easier / alternative syntax for describing forms.
        The form control names are wrapped inside the opening and closing curly braces and the control themselves are
        defined and instantiated via various form controls (subclasses of Form).

        @param form: The form string
        @param controls: A dictionary containing the control name as a _key_ and control object as _value_
        """
        self._reset()
        self.form = form
        """Form string"""
        self.controls = controls
        """Dictionary of controls"""
        self.__args = None

        self.title = None
        """The Form title. It will be filled when the form is compiled"""

        self.modal = True
        """By default, forms are modal"""

        self.openform_flags = 0
        """
        If non-modal, these flags will be passed to open_form.
        This is an OR'ed combination of the PluginForm.FORM_* values.
        """


    def Free(self):
        r"""
        Frees all resources associated with a compiled form.
        Make sure you call this function when you finish using the form.
        """

# Free all the controls
        for name, ctrl in self.__controls.items():
            if ctrl.parent_hasattr:
                delattr(self, name)
                ctrl.parent_hasattr = False
            ctrl.free()

# Reset the controls
# (Note that we are not removing the form control attributes, no need)
        self._reset()

# Unregister, so we don't try and free it again at closing-time.
        _ida_kernwin.py_unregister_compiled_form(self)


    def _reset(self):
        """
        Resets the Form class state variables
        """
        self.__controls = {}
        self.__ctrl_id = 1


    def __getitem__(self, name):
        r"""
        Returns a control object by name
        """
        return self.__controls[name]


    def Add(self, name, ctrl, mkattr = True):
        r"""
        Low level function. Prefer AddControls() to this function.
        This function adds one control to the form.

        @param name: Control name
        @param ctrl: Control object
        @param mkattr: Create control name / control object as a form attribute
        """
# Assign a unique ID
        ctrl.id = self.__ctrl_id
        self.__ctrl_id += 1

# Create attribute with control name
        if mkattr:
            setattr(self, name, ctrl)
            ctrl.parent_hasattr = True

# Remember the control
        self.__controls[name] = ctrl

# Link the form to the control via its form attribute
        ctrl.form = self

# Is it a group? Add each child
        if isinstance(ctrl, Form.GroupControl):
            self._AddGroup(ctrl, mkattr)


    def FindControlById(self, id):
        r"""
        Finds a control instance given its id
        """
        for ctrl in self.__controls.values():
            if ctrl.id == id:
                return ctrl
        return None


    @staticmethod
    def _ParseFormTitle(form):
        """
        Parses the form's title from the form text
        """
        help_state = 0
        for i, line in enumerate(form.split("\n")):
            if line.startswith("STARTITEM ") or line.startswith("BUTTON "):
                continue
# Skip "HELP" and remember state
            elif help_state == 0 and line == "HELP":
                help_state = 1 # Mark inside HELP
                continue
            elif help_state == 1 and line == "ENDHELP":
                help_state = 2 # Mark end of HELP
                continue
            return line.strip()

        return None


    def _AddGroup(self, Group, mkattr=True):
        """
        Internal function.
        This function expands the group item names and creates individual group item controls

        @param Group: The group class (checkbox or radio group class)
        """

# Create group item controls for each child
        for child_name in sorted(Group.children_names):
            self.Add(
                child_name,
# Use the class factory
                Group.ItemClass(Group.tag, Group),
                mkattr)


    def AddControls(self, controls, mkattr=True):
        r"""
        Adds controls from a dictionary.
        The dictionary key is the control name and the value is a Form.Control object
        @param controls: The control dictionary
        """
        for name in sorted(controls.keys()):
# Add the control
            self.Add(name, controls[name], mkattr)


    def CompileEx(self, form):
        r"""
        Low level function.
        Compiles (parses the form syntax and adds the control) the form string and
        returns the argument list to be passed the argument list to ask_form().

        The form controls are wrapped inside curly braces: {ControlName}.

        A special operator can be used to return the index of a given control by its name: {id:ControlName}.
        This is useful when you use the STARTITEM form keyword to set the initially focused control.
        (note that, technically, the index is not the same as the ID; that's because STARTITEM
        uses raw, 0-based indexes rather than control IDs to determine the focused widget.)

        @param form: Compiles the form and returns the arguments needed to be passed to ask_form()
        """
# First argument is the form string
        args = [None]

# Second argument, if form is not modal, is the set of flags
        if not self.modal:
            args.append(self.openform_flags | 0x80) # Add FORM_QWIDGET

        ctrlcnt = 1

# Reset all group control internal flags
        for ctrl in self.__controls.values():
            if isinstance(ctrl, Form.GroupControl):
                ctrl._reset()

        def next_control(form, p, first_pass):
            i1 = form.find("{", p)
            if i1 < 0:
                return form, None, None, None
            if form[i1 - 1] == '\\' and i1 > 0:
                if first_pass:
                    return next_control(form, i1 + 1, first_pass)
                else:
# Remove escape sequence and restart search
                    form = form[:i1 - 1] + form[i1:]
                    return next_control(form, i1, first_pass)
            i2 = form.find("}", i1)
            if i2 < 0:
                raise SyntaxError("No matching closing brace '}'")
            ctrlname = form[i1 + 1:i2]
            if not ctrlname:
                raise ValueError("Control %d has an invalid name!" % ctrlcnt)
            return form, i1, i2, ctrlname


        control_count = 0
        last_input_field_index = 0
# First pass: assign input_field_index values to controls
        p = 0
        while True:
            form, i1, i2, ctrlname = next_control(form, p, first_pass=True)
            if ctrlname is None:
                break
            p = i2

            if ctrlname.startswith("id:"):
                continue

            ctrl = self.__controls.get(ctrlname, None)
            if ctrl is None:
                raise ValueError("No matching control '%s'" % ctrlname)

            if isinstance(ctrl, Form.FormChangeCb) and control_count > 0:
                raise SyntaxError("Control '%s' should be the first control in the form" % ctrlname)

# If this control is an input, assign its index
            if ctrl.is_input_field():
                ctrl.input_field_index = last_input_field_index
                last_input_field_index += 1

            control_count += 1


        p = 0
        while True:
            form, i1, i2, ctrlname = next_control(form, p, first_pass=False)
            if ctrlname is None:
                break

# Is it the IDOF operator?
            if ctrlname.startswith("id:"):
                idfunc = True
# Take actual ctrlname
                ctrlname = ctrlname[3:]
            else:
                idfunc = False

# Find the control
            ctrl = self.__controls.get(ctrlname, None)
            if ctrl is None:
                raise ValueError("No matching control '%s'" % ctrlname)

# Replace control name by tag
            if idfunc:
                tag = str(ctrl.input_field_index if ctrl.input_field_index is not None else ctrl.id)
            else:
                tag = ctrl.get_tag()
            taglen = len(tag)
            form = form[:i1] + tag + form[i2+1:]

# Set new position
            p = i1 + taglen

# Was it an IDOF() ? No need to push parameters
# Just ID substitution is fine
            if idfunc:
                continue


# For GroupItem controls, there are no individual arguments
# The argument is assigned for the group itself
            if isinstance(ctrl, Form.GroupItemControl):
# GroupItem controls will have their position dynamically set
                ctrl.assign_pos()
            else:
# Push argument(s)
# (Some controls need more than one argument)
                arg = ctrl.get_arg()
                if isinstance(arg, (list, tuple)):
# Push all args
                    args.extend(arg)
                else:
# Push one arg
                    args.append(arg)

            ctrlcnt += 1

# If no FormChangeCb instance was passed, and thus there's no '%/'
# in the resulting form string, let's provide a minimal one, so that
# we will retrieve 'p_fa', and thus actions that rely on it will work.
        if form.find(Form.FT_FORMCHG) < 0:
            form = form + Form.FT_FORMCHG
            fccb = Form.FormChangeCb(lambda *args: 1)
            self.Add("___dummyfchgcb", fccb)
# Regardless of the actual position of '%/' in the form
# string, a formchange callback _must_ be right after
# the form string.
            if self.modal:
                inspos = 1
            else:
                inspos = 2
            args.insert(inspos, fccb.get_arg())

# Patch in the final form string

        if sys.version_info.major >= 3:
            args[0] = form.encode("UTF-8")
        else:
            args[0] = form

        self.title = self._ParseFormTitle(form)
        return args


    def Compile(self):
        r"""
        Compiles a form and returns the form object (self) and the argument list.
        The form object will contain object names corresponding to the form elements

        @return: It will raise an exception on failure. Otherwise the return value is ignored
        """

# Reset controls
        self._reset()

# Insert controls
        self.AddControls(self.controls)

# Compile form and get args
        self.__args = self.CompileEx(self.form)

# Register this form, to make sure it will be freed at closing-time.
        _ida_kernwin.py_register_compiled_form(self)

        return (self, self.__args)


    def Compiled(self):
        r"""
        Checks if the form has already been compiled

        @return: Boolean
        """
        return self.__args is not None


    def _ChkCompiled(self):
        if not self.Compiled():
            raise SyntaxError("Form is not compiled")


    def Execute(self):
        r"""
        Displays a modal dialog containing the compiled form.
        @return: 1 - ok ; 0 - cancel
        """
        self._ChkCompiled()
        if not self.modal:
            raise SyntaxError("Form is not modal. Open() should be instead")

        return ask_form(*self.__args)


    def Open(self):
        r"""
        Opens a widget containing the compiled form.
        """
        self._ChkCompiled()
        if self.modal:
            raise SyntaxError("Form is modal. Execute() should be instead")

        open_form(*self.__args)


    def EnableField(self, ctrl, enable):
        r"""
        Enable or disable an input field
        @return: False - no such control
        """
        return _ida_kernwin.formchgcbfa_enable_field(self.p_fa, ctrl.id, enable)


    def ShowField(self, ctrl, show):
        r"""
        Show or hide an input field
        @return: False - no such control
        """
        return _ida_kernwin.formchgcbfa_show_field(self.p_fa, ctrl.id, show)


    def MoveField(self, ctrl, x, y, w, h):
        r"""
        Move/resize an input field

        @return: False - no such fiel
        """
        return _ida_kernwin.formchgcbfa_move_field(self.p_fa, ctrl.id, x, y, w, h)


    def GetFocusedField(self):
        r"""
        Get currently focused input field.
        @return: None if no field is selected otherwise the control ID
        """
        id = _ida_kernwin.formchgcbfa_get_focused_field(self.p_fa)
        return self.FindControlById(id)


    def SetFocusedField(self, ctrl):
        r"""
        Set currently focused input field
        @return: False - no such control
        """
        return _ida_kernwin.formchgcbfa_set_focused_field(self.p_fa, ctrl.id)


    def RefreshField(self, ctrl):
        r"""
        Refresh a field
        @return: False - no such control
        """
        return _ida_kernwin.formchgcbfa_refresh_field(self.p_fa, ctrl.id)


    def Close(self, close_normally):
        r"""
        Close the form
        @param close_normally
                   1: form is closed normally as if the user pressed Enter
                   0: form is closed abnormally as if the user pressed Esc
        @return: None
        """
        return _ida_kernwin.formchgcbfa_close(self.p_fa, close_normally)


    def GetControlValue(self, ctrl):
        r"""
        Returns the control's value depending on its type
        @param ctrl: Form control instance
        @return:     - color button, radio controls: integer
            - file/dir input, string input and string label: string
            - embedded chooser control (0-based indices of selected items): integer list
            - for multilinetext control: textctrl_info_t
            - dropdown list controls: string (when editable) or index (when readonly)
            - None: on failure
        """
        tid, size = self.ControlToFieldTypeIdAndSize(ctrl)
        r = _ida_kernwin.formchgcbfa_get_field_value(
                    self.p_fa,
                    ctrl.id,
                    tid,
                    size)
# Multilinetext? Unpack the tuple into a new textctrl_info_t instance
        if r is not None and tid == 7:
            return textctrl_info_t(text=r[0], flags=r[1], tabsize=r[2])
        else:
            return r


    def SetControlValue(self, ctrl, value):
        r"""
        Set the control's value depending on its type
        @param ctrl: Form control instance
        @param value
            - embedded chooser: a 0-base indices list to select embedded chooser items
            - multilinetext: a textctrl_info_t
            - dropdown list: an integer designating the selection index if readonly
                             a string designating the edit control value if not readonly
        @return: Boolean true on success
        """
        tid, _ = self.ControlToFieldTypeIdAndSize(ctrl)
        return _ida_kernwin.formchgcbfa_set_field_value(
                    self.p_fa,
                    ctrl.id,
                    tid,
                    value)


    @staticmethod
    def ControlToFieldTypeIdAndSize(ctrl):
        r"""
        Converts a control object to a tuple containing the field id
        and the associated buffer size
        """
# Input control depend on the associated buffer size (supplied by the user)

# Make sure you check instances types taking into account inheritance
        if isinstance(ctrl, Form.DropdownListControl):
            return (8, 1 if ctrl.readonly else 0)
        elif isinstance(ctrl, Form.MultiLineTextControl):
            return (7, 0)
        elif isinstance(ctrl, Form.EmbeddedChooserControl):
            return (5, 0)
# Group items or controls
        elif isinstance(ctrl, (Form.GroupItemControl, Form.GroupControl)):
            return (2, 0)
        elif isinstance(ctrl, Form.StringLabel):
            return (3, min(ida_pro.MAXSTR, ctrl.size))
        elif isinstance(ctrl, Form.ColorInput):
            return (4, 0)
        elif isinstance(ctrl, Form.NumericInput):
# Pass the numeric control type
            return (6, ord(ctrl.tp[0]))
        elif isinstance(ctrl, Form.InputControl):
            return (1, ctrl.size)
        else:
            raise NotImplementedError("Not yet implemented")

# --------------------------------------------------------------------------
# Instantiate ask_form/open_form function pointers
try:
    import ctypes
# Setup the numeric argument size
    Form.NumericArgument.DefI64 = _ida_idaapi.BADADDR == 0xFFFFFFFFFFFFFFFF
# int ask_form(const char *form, ...)
    __ask_form_callable = ctypes.CFUNCTYPE(ctypes.c_int)(_ida_kernwin.py_get_ask_form())
# specify types of the fixed arguments explicitly so that varargs are passed correctly on arm macOS
# https://bugs.python.org/issue42880
    __ask_form_callable.argtypes = [ ctypes.c_char_p ]
#  TWidget *open_form(const char *form, uint32 flags, ...)
    __open_form_callable = ctypes.CFUNCTYPE(ctypes.c_void_p )(_ida_kernwin.py_get_open_form())
    __open_form_callable.argtypes = [ ctypes.c_char_p, ctypes.c_uint32 ]
except:
    def __ask_form_callable(*args):
        warning("ask_form() needs ctypes library in order to work")
        return 0
    def __open_form_callable(*args):
        warning("open_form() needs ctypes library in order to work")

def __call_form_callable(call, *args):
    assert(len(args))
    with disabled_script_timeout_t():
        if sys.version_info.major >= 3 and isinstance(args[0], str):
            largs = list(args)
            largs[0] = largs[0].encode("UTF-8")
            args = tuple(largs)
        r = call(*args)
    return r

def ask_form(*args):
    r"""
    Display a dialog box and wait for the user. If the form contains the "BUTTON NO
    <title>" keyword, then the return values are the same as in the ask_yn()
    function (Button IDs)

    @retval 0: no memory to display or form syntax error (a warning is displayed in
               this case). the user pressed the 'No' button (if the form has it) or
               the user cancelled the dialog otherwise. all variables retain their
               original values.
    @retval 1: ok, all input fields are filled and validated.
    @retval -1: the form has the 'No' button and the user cancelled the dialog
    """
    return __call_form_callable(__ask_form_callable, *args)

def open_form(*args):
    r"""
    Display a dockable modeless dialog box and return a handle to it. The modeless
    form can be closed in the following ways:
    * by pressing the small 'x' in the window title
    * by calling form_actions_t::close() from the form callback (form_actions_t)
    @note: pressing the 'Yes/No/Cancel' buttons does not close the modeless form,
           except if the form callback explicitly calls close().

    @return: handle to the form or nullptr. the handle can be used with TWidget
    """
    if len(args) == 1:
        args = (args[0], 0) # add default flags
    return __call_form_callable(__open_form_callable, *args)

#</pycode(py_kernwin_askform)>


def install_command_interpreter(py_obj: "PyObject *") -> "int":
    r"""
    install_command_interpreter(py_obj) -> int
    Install command line interpreter (ui_install_cli)

    @param py_obj: PyObject *
    """
    return _ida_kernwin.install_command_interpreter(py_obj)

def remove_command_interpreter(cli_idx: "int") -> "void":
    r"""
    remove_command_interpreter(cli_idx)
    Remove command line interpreter (ui_install_cli)

    @param cli_idx: int
    """
    return _ida_kernwin.remove_command_interpreter(cli_idx)

#<pycode(py_kernwin_cli)>
import ida_idaapi

class cli_t(ida_idaapi.pyidc_opaque_object_t):
    r"""
    cli_t wrapper class.

    This class allows you to implement your own command line interface handlers.
    """

    def __init__(self):
        self.__cli_idx = -1
        self.__clink__ = None

    def __del__(self):
        self.unregister()

    def register(self, flags = 0, sname = None, lname = None, hint = None):
        r"""
        Registers the CLI.

        @param flags: Feature bits. No bits are defined yet, must be 0
        @param sname: Short name (displayed on the button)
        @param lname: Long name (displayed in the menu)
        @param hint: Hint for the input line

        @return: Boolean: True-Success, False-Failed
        """

# Already registered?
        if self.__cli_idx >= 0:
            return True

        if sname is not None: self.sname = sname
        if lname is not None: self.lname = lname
        if hint is not None:  self.hint  = hint

# Register
        self.__cli_idx = _ida_kernwin.install_command_interpreter(self)
        return False if self.__cli_idx < 0 else True

    def unregister(self):
        r"""
        Unregisters the CLI (if it was registered)
        """
        if self.__cli_idx < 0:
            return False

        _ida_kernwin.remove_command_interpreter(self.__cli_idx)
        self.__cli_idx = -1
        return True

    def OnExecuteLine(self, line):
        r"""
        The user pressed Enter. The CLI is free to execute the line immediately or ask for more lines.

        This callback is mandatory.

        @param line: typed line(s)
        @return: Boolean: True-executed line, False-ask for more lines
        """
        return True

    def OnKeydown(self, line, x, sellen, vkey, shift):
        r"""
        A keyboard key has been pressed
        This is a generic callback and the CLI is free to do whatever it wants.

        This callback is optional.

        @param line: current input line
        @param x: current x coordinate of the cursor
        @param sellen: current selection length (usually 0)
        @param vkey: virtual key code. if the key has been handled, it should be returned as zero
        @param shift: shift state

        @return:     None - Nothing was changed
            tuple(line, x, sellen, vkey): if either of the input line or the x coordinate or the selection length has been modified.
            It is possible to return a tuple with None elements to preserve old values. Example: tuple(new_line, None, None, None) or tuple(new_line)
        """
        return None

    def OnCompleteLine(self, prefix, n, line, prefix_start):
        r"""
        The user pressed Tab. Find a completion number N for prefix PREFIX

        This callback is optional.

        @param prefix: Line prefix at prefix_start (string)
        @param n: completion number (int)
        @param line: the current line (string)
        @param prefix_start: the index where PREFIX starts in LINE (int)

        @return: None if no completion could be generated otherwise a String with the completion suggestion
        """
        return None

#</pycode(py_kernwin_cli)>

class View_Hooks(object):
    r"""
    Proxy of C++ View_Hooks class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, _flags: "uint32"=0, _hkcb_flags: "uint32"=0x0001):
        r"""
        __init__(self, _flags=0, _hkcb_flags=0x0001) -> View_Hooks

        @param _flags: uint32
        @param _hkcb_flags: uint32
        """
        if self.__class__ == View_Hooks:
            _self = None
        else:
            _self = self
        _ida_kernwin.View_Hooks_swiginit(self, _ida_kernwin.new_View_Hooks(_self, _flags, _hkcb_flags))

    def hook(self) -> "bool":
        r"""
        hook(self) -> bool
        """
        return _ida_kernwin.View_Hooks_hook(self)

    def unhook(self) -> "bool":
        r"""
        unhook(self) -> bool
        """
        return _ida_kernwin.View_Hooks_unhook(self)

    def view_activated(self, view: "TWidget *") -> "void":
        r"""
        view_activated(self, view)
        A view is activated

        @param view: (TWidget *)
        """
        return _ida_kernwin.View_Hooks_view_activated(self, view)

    def view_deactivated(self, view: "TWidget *") -> "void":
        r"""
        view_deactivated(self, view)
        A view is deactivated

        @param view: (TWidget *)
        """
        return _ida_kernwin.View_Hooks_view_deactivated(self, view)

    def view_keydown(self, view: "TWidget *", key: "int", state: "view_event_state_t") -> "void":
        r"""
        view_keydown(self, view, key, state)
        Key down event

        @param view: (TWidget *)
        @param key: (int)
        @param state: (::view_event_state_t)
        """
        return _ida_kernwin.View_Hooks_view_keydown(self, view, key, state)

    def view_click(self, view: "TWidget *", event: "view_mouse_event_t") -> "void":
        r"""
        view_click(self, view, event)
        Click event

        @param view: (TWidget *)
        @param event: (const view_mouse_event_t *)
        """
        return _ida_kernwin.View_Hooks_view_click(self, view, event)

    def view_dblclick(self, view: "TWidget *", event: "view_mouse_event_t") -> "void":
        r"""
        view_dblclick(self, view, event)
        Double click event

        @param view: (TWidget *)
        @param event: (const view_mouse_event_t *)
        """
        return _ida_kernwin.View_Hooks_view_dblclick(self, view, event)

    def view_curpos(self, view: "TWidget *") -> "void":
        r"""
        view_curpos(self, view)
        Cursor position changed

        @param view: (TWidget *)
        """
        return _ida_kernwin.View_Hooks_view_curpos(self, view)

    def view_created(self, view: "TWidget *") -> "void":
        r"""
        view_created(self, view)
        A view is being created.

        @param view: (TWidget *)
        """
        return _ida_kernwin.View_Hooks_view_created(self, view)

    def view_close(self, view: "TWidget *") -> "void":
        r"""
        view_close(self, view)
        View closed

        @param view: (TWidget *)
        """
        return _ida_kernwin.View_Hooks_view_close(self, view)

    def view_switched(self, view: "TWidget *", rt: "tcc_renderer_type_t") -> "void":
        r"""
        view_switched(self, view, rt)
        A view's renderer has changed.

        @param view: (TWidget *)
        @param rt: (tcc_renderer_type_t)
        """
        return _ida_kernwin.View_Hooks_view_switched(self, view, rt)

    def view_mouse_over(self, view: "TWidget *", event: "view_mouse_event_t") -> "void":
        r"""
        view_mouse_over(self, view, event)
        The user moved the mouse over (or out of) a node or an edge. This is only
        relevant in a graph view.

        @param view: (TWidget *)
        @param event: (const view_mouse_event_t *)
        """
        return _ida_kernwin.View_Hooks_view_mouse_over(self, view, event)

    def view_loc_changed(self, view: "TWidget *", now: "lochist_entry_t const *", was: "lochist_entry_t const *") -> "void":
        r"""
        view_loc_changed(self, view, now, was)
        The location for the view has changed (can be either the place_t, the
        renderer_info_t, or both.)

        @param view: (TWidget *)
        @param now: (const lochist_entry_t *)
        @param was: (const lochist_entry_t *)
        """
        return _ida_kernwin.View_Hooks_view_loc_changed(self, view, now, was)

    def view_mouse_moved(self, view: "TWidget *", event: "view_mouse_event_t") -> "void":
        r"""
        view_mouse_moved(self, view, event)
        The mouse moved on the view

        @param view: (TWidget *)
        @param event: (const view_mouse_event_t *)
        """
        return _ida_kernwin.View_Hooks_view_mouse_moved(self, view, event)
    __swig_destroy__ = _ida_kernwin.delete_View_Hooks
    def __disown__(self):
        self.this.disown()
        _ida_kernwin.disown_View_Hooks(self)
        return weakref.proxy(self)

# Register View_Hooks in _ida_kernwin:
_ida_kernwin.View_Hooks_swigregister(View_Hooks)

#<pycode(py_kernwin_viewhooks)>
# -----------------------------------------------------------------------
#                           CustomIDAMemo
# -----------------------------------------------------------------------
class CustomIDAMemo(View_Hooks):
    def __init__(self):
        View_Hooks.__init__(self)

    def _graph_item_tuple(self, ve):
        item = None
        if ve.rtype in [TCCRT_GRAPH, TCCRT_PROXIMITY]:
            item = ve.location.item
        if item is not None:
            if item.is_node:
                return (item.node,)
            else:
                return (item.elp.e.src, item.elp.e.dst)
        else:
            return ()

    @staticmethod
    def _dummy_cb(*args):
        pass

    def _get_cb(self, view, cb_name):
        cb = CustomIDAMemo._dummy_cb
        if view == self.GetWidget():
            cb = getattr(self, cb_name, cb)
        return cb

    def _get_cb_arity(self, cb):
        import sys
        import inspect
        if sys.version_info.major >= 3:
            return len(inspect.getfullargspec(cb).args)
        else:
            return len(inspect.getargspec(cb).args)

    def view_activated(self, view):
        return self._get_cb(view, "OnViewActivated")()

    def view_deactivated(self, view):
        return self._get_cb(view, "OnViewDeactivated")()

    def view_keydown(self, view, key, state):
        return self._get_cb(view, "OnViewKeydown")(key, state)

    def view_click(self, view, ve):
        cb = self._get_cb(view, "OnViewClick")
        if cb != CustomIDAMemo._dummy_cb:
            arity = self._get_cb_arity(cb)
            args = [ve.x, ve.y, ve.state]
            if arity >= 5:
                args.append(ve.button)
                if arity >= 6:
                    args.append(ve.renderer_pos)
            return cb(*tuple(args))

    def view_dblclick(self, view, ve):
        cb = self._get_cb(view, "OnViewDblclick")
        if cb != CustomIDAMemo._dummy_cb:
            arity = self._get_cb_arity(cb)
            args = [ve.x, ve.y, ve.state]
            if arity >= 5:
                args.append(ve.renderer_pos)
            return cb(*tuple(args))

    def view_curpos(self, view, *args):
        return self._get_cb(view, "OnViewCurpos")()

    def view_close(self, view, *args):
        rc = self._get_cb(view, "OnClose")()
        if view == self.GetWidget():
            ida_idaapi.pycim_view_close(self)
        return rc

    def view_switched(self, view, rt):
        return self._get_cb(view, "OnViewSwitched")(rt)

    def view_mouse_over(self, view, ve):
        cb = self._get_cb(view, "OnViewMouseOver")
        if cb != CustomIDAMemo._dummy_cb:
            arity = self._get_cb_arity(cb)
            gitpl = self._graph_item_tuple(ve)
            args = [ve.x, ve.y, ve.state, len(gitpl), gitpl]
            if arity >= 7:
                args.append(ve.renderer_pos)
            return cb(*tuple(args))

    def view_loc_changed(self, view, now, was):
        return self._get_cb(view, "OnViewLocationChanged")(now, was)

    def view_mouse_moved(self, view, ve):
        cb = self._get_cb(view, "OnViewMouseMoved")
        if cb != CustomIDAMemo._dummy_cb:
            gitpl = self._graph_item_tuple(ve)
            return cb(ve.x, ve.y, ve.state, len(gitpl), gitpl, ve.renderer_pos)

    def _OnBind(self, hook):
        if hook:
            self.hook()
        else:
            self.unhook()

# End of hooks->wrapper trampolines


    def Refresh(self):
        r"""
        Refreshes the view. This causes the OnRefresh() to be called
        """
        ida_idaapi.pygc_refresh(self)

    def GetCurrentRendererType(self):
        return get_view_renderer_type(self.GetWidget())

    def SetCurrentRendererType(self, rtype):
        r"""
        Set the current view's renderer.

        @param rtype: The renderer type. Should be one of the idaapi.TCCRT_* values.
        """
        return set_view_renderer_type(self.GetWidget(), rtype)

    def SetNodeInfo(self, node_index, node_info, flags):
        r"""
        Set the properties for the given node.

        Example usage (set second nodes's bg color to red):
          inst = ...
          p = idaapi.node_info_t()
          p.bg_color = 0x00ff0000
          inst.SetNodeInfo(1, p, idaapi.NIF_BG_COLOR)

        @param node_index: The node index.
        @param node_info: An idaapi.node_info_t instance.
        @param flags: An OR'ed value of NIF_* values.
        """
        import ida_graph
        return ida_graph.viewer_set_node_info(self.GetWidget(), node_index, node_info, flags)

    def SetNodesInfos(self, values):
        r"""
        Set the properties for the given nodes.

        Example usage (set first three nodes's bg color to purple):
          inst = ...
          p = idaapi.node_info_t()
          p.bg_color = 0x00ff00ff
          inst.SetNodesInfos({0 : p, 1 : p, 2 : p})

        @param values: A dictionary of 'int -> node_info_t' objects.
        """
        import ida_graph
        for node_index, node_info in values.items():
            ida_graph.viewer_set_node_info(self.GetWidget(), node_index, node_info, ida_graph.NIF_ALL)

    def GetNodeInfo(self, *args):
        r"""
        Get the properties for the given node.

        @param ni: A node_info_t instance
        @param node: The index of the node.
        @return: success
        """
        import ida_graph
        if len(args) < 2:
# bw-compat
            ni, node = ida_graph.node_info_t(), args[0]
            if ida_graph.viewer_get_node_info(self.GetWidget(), ni, node):
                return (ni.bg_color, ni.frame_color, ni.ea, ni.text)
            else:
                return None
        else:
            ni, node = args[0], args[1]
            return ida_graph.viewer_get_node_info(self.GetWidget(), ni, node)

    def DelNodesInfos(self, *nodes):
        r"""
        Delete the properties for the given node(s).

        @param nodes: A list of node IDs
        """
        import ida_graph
        for n in nodes:
            ida_graph.viewer_del_node_info(self.GetWidget(), n)

    def CreateGroups(self, groups_infos):
        r"""
        Send a request to modify the graph by creating a
        (set of) group(s), and perform an animation.

        Each object in the 'groups_infos' list must be of the format:
        {
          "nodes" : [<int>, <int>, <int>, ...] # The list of nodes to group
          "text" : <string>                    # The synthetic text for that group
        }

        @param groups_infos: A list of objects that describe those groups.
        @return: A [<int>, <int>, ...] list of group nodes, or None (failure).
        """
        return ida_idaapi.pygc_create_groups(self, groups_infos)

    def DeleteGroups(self, groups, new_current = -1):
        r"""
        Send a request to delete the specified groups in the graph,
        and perform an animation.

        @param groups: A list of group node numbers.
        @param new_current: A node to focus on after the groups have been deleted
        @return: True on success, False otherwise.
        """
        return ida_idaapi.pygc_delete_groups(self, groups, new_current)

    def SetGroupsVisibility(self, groups, expand, new_current = -1):
        r"""
        Send a request to expand/collapse the specified groups in the graph,
        and perform an animation.

        @param groups: A list of group node numbers.
        @param expand: True to expand the group, False otherwise.
        @param new_current: A node to focus on after the groups have been expanded/collapsed.
        @return: True on success, False otherwise.
        """
        return ida_idaapi.pygc_set_groups_visibility(self, groups, expand, new_current)

    def GetWidget(self):
        r"""
        Return the TWidget underlying this view.

        @return: The TWidget underlying this view, or None.
        """
        return ida_idaapi.pycim_get_widget(self)

    def GetWidgetAsGraphViewer(self):
        r"""
        Return the graph_viewer_t underlying this view.

        @return: The graph_viewer_t underlying this view, or None.
        """
        return ida_idaapi.pycim_get_widget_as_graph_viewer(self)

# ----------------------------------------------------------------------
# bw-compat/deprecated. You shouldn't rely on this in new code
import ida_idaapi
ida_idaapi.CustomIDAMemo = CustomIDAMemo

#</pycode(py_kernwin_viewhooks)>


def pyidag_bind(_self: "PyObject *") -> "bool":
    r"""
    pyidag_bind(_self) -> bool

    @param self: PyObject *
    """
    return _ida_kernwin.pyidag_bind(_self)

def pyidag_unbind(_self: "PyObject *") -> "bool":
    r"""
    pyidag_unbind(_self) -> bool

    @param self: PyObject *
    """
    return _ida_kernwin.pyidag_unbind(_self)

#<pycode(py_kernwin_idaview)>
#-------------------------------------------------------------------------
#                             IDAViewWrapper
#-------------------------------------------------------------------------
import _ida_kernwin
class IDAViewWrapper(CustomIDAMemo):
    r"""
    Deprecated. Use View_Hooks instead.

    Because the lifecycle of an IDAView is not trivial to track (e.g., a user
    might close, then re-open the same disassembly view), this wrapper doesn't
    bring anything superior to the View_Hooks: quite the contrary, as the
    latter is much more generic (and better maps IDA's internal model.)
    """
    def __init__(self, title):
        CustomIDAMemo.__init__(self)
        self._title = title

    def Bind(self):
        rc = _ida_kernwin.pyidag_bind(self)
        if rc:
            self.hook()
        return rc

    def Unbind(self):
        rc = _ida_kernwin.pyidag_unbind(self)
        if rc:
            self.unhook()
        return rc

#</pycode(py_kernwin_idaview)>


def pyscv_init(py_link: "PyObject *", title: "char const *") -> "PyObject *":
    r"""
    pyscv_init(py_link, title) -> PyObject *

    @param py_link: PyObject *
    @param title: char const *
    """
    return _ida_kernwin.pyscv_init(py_link, title)

def pyscv_refresh(py_this: "PyObject *") -> "bool":
    r"""
    pyscv_refresh(py_this) -> bool

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_refresh(py_this)

def pyscv_get_current_line(py_this: "PyObject *", mouse: "bool", notags: "bool") -> "PyObject *":
    r"""
    pyscv_get_current_line(py_this, mouse, notags) -> PyObject *

    @param py_this: PyObject *
    @param mouse: bool
    @param notags: bool
    """
    return _ida_kernwin.pyscv_get_current_line(py_this, mouse, notags)

def pyscv_is_focused(py_this: "PyObject *") -> "bool":
    r"""
    pyscv_is_focused(py_this) -> bool

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_is_focused(py_this)

def pyscv_count(py_this: "PyObject *") -> "size_t":
    r"""
    pyscv_count(py_this) -> size_t

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_count(py_this)

def pyscv_show(py_this: "PyObject *") -> "bool":
    r"""
    pyscv_show(py_this) -> bool

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_show(py_this)

def pyscv_close(py_this: "PyObject *") -> "void":
    r"""
    pyscv_close(py_this)

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_close(py_this)

def pyscv_jumpto(py_this: "PyObject *", ln: "size_t", x: "int", y: "int") -> "bool":
    r"""
    pyscv_jumpto(py_this, ln, x, y) -> bool

    @param py_this: PyObject *
    @param ln: size_t
    @param x: int
    @param y: int
    """
    return _ida_kernwin.pyscv_jumpto(py_this, ln, x, y)

def pyscv_get_line(py_this: "PyObject *", nline: "size_t") -> "PyObject *":
    r"""
    pyscv_get_line(py_this, nline) -> PyObject *

    @param py_this: PyObject *
    @param nline: size_t
    """
    return _ida_kernwin.pyscv_get_line(py_this, nline)

def pyscv_get_pos(py_this: "PyObject *", mouse: "bool") -> "PyObject *":
    r"""
    pyscv_get_pos(py_this, mouse) -> PyObject *

    @param py_this: PyObject *
    @param mouse: bool
    """
    return _ida_kernwin.pyscv_get_pos(py_this, mouse)

def pyscv_clear_lines(py_this: "PyObject *") -> "PyObject *":
    r"""
    pyscv_clear_lines(py_this) -> PyObject *

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_clear_lines(py_this)

def pyscv_add_line(py_this: "PyObject *", py_sl: "PyObject *") -> "bool":
    r"""
    pyscv_add_line(py_this, py_sl) -> bool

    @param py_this: PyObject *
    @param py_sl: PyObject *
    """
    return _ida_kernwin.pyscv_add_line(py_this, py_sl)

def pyscv_insert_line(py_this: "PyObject *", nline: "size_t", py_sl: "PyObject *") -> "bool":
    r"""
    pyscv_insert_line(py_this, nline, py_sl) -> bool

    @param py_this: PyObject *
    @param nline: size_t
    @param py_sl: PyObject *
    """
    return _ida_kernwin.pyscv_insert_line(py_this, nline, py_sl)

def pyscv_patch_line(py_this: "PyObject *", nline: "size_t", offs: "size_t", value: "int") -> "bool":
    r"""
    pyscv_patch_line(py_this, nline, offs, value) -> bool

    @param py_this: PyObject *
    @param nline: size_t
    @param offs: size_t
    @param value: int
    """
    return _ida_kernwin.pyscv_patch_line(py_this, nline, offs, value)

def pyscv_del_line(py_this: "PyObject *", nline: "size_t") -> "bool":
    r"""
    pyscv_del_line(py_this, nline) -> bool

    @param py_this: PyObject *
    @param nline: size_t
    """
    return _ida_kernwin.pyscv_del_line(py_this, nline)

def pyscv_get_selection(py_this: "PyObject *") -> "PyObject *":
    r"""
    pyscv_get_selection(py_this) -> PyObject *

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_get_selection(py_this)

def pyscv_get_current_word(py_this: "PyObject *", mouse: "bool") -> "PyObject *":
    r"""
    pyscv_get_current_word(py_this, mouse) -> PyObject *

    @param py_this: PyObject *
    @param mouse: bool
    """
    return _ida_kernwin.pyscv_get_current_word(py_this, mouse)

def pyscv_edit_line(py_this: "PyObject *", nline: "size_t", py_sl: "PyObject *") -> "bool":
    r"""
    pyscv_edit_line(py_this, nline, py_sl) -> bool

    @param py_this: PyObject *
    @param nline: size_t
    @param py_sl: PyObject *
    """
    return _ida_kernwin.pyscv_edit_line(py_this, nline, py_sl)

def pyscv_get_widget(py_this: "PyObject *") -> "TWidget *":
    r"""
    pyscv_get_widget(py_this) -> TWidget *

    @param py_this: PyObject *
    """
    return _ida_kernwin.pyscv_get_widget(py_this)

#<pycode(py_kernwin_custview)>
class simplecustviewer_t(object):
    r"""
    The base class for implementing simple custom viewers
    """

    class UI_Hooks_Trampoline(UI_Hooks):
        def __init__(self, v):
            UI_Hooks.__init__(self)
            self.hook()
            import weakref
            self.v = weakref.ref(v)

        def populating_widget_popup(self, form, popup_handle):
            my_form = self.v().GetWidget()
            if form == my_form:
                cb = self.v().OnPopup
                import sys
                import inspect
                handled = False
                if sys.version_info.major >= 3:
                    if len(inspect.getfullargspec(cb).args) == 3:
                        cb(my_form, popup_handle)
                        handled = True
                else:
                    if len(inspect.getargspec(cb).args) == 3:
                        cb(my_form, popup_handle)
                        handled = True
                if not handled:
                    cb() # bw-compat

    def __init__(self):
        self.__this = None
        self.ui_hooks_trampoline = self.UI_Hooks_Trampoline(self)

    @staticmethod
    def __make_sl_arg(line, fgcolor=None, bgcolor=None):
        return line if (fgcolor is None and bgcolor is None) else (line, fgcolor, bgcolor)

    def OnPopup(self, form, popup_handle):
        r"""
        Context menu popup is about to be shown. Create items dynamically if you wish
        @return: Boolean. True if you handled the event
        """
        pass

    def Create(self, title):
        r"""
        Creates the custom view. This should be the first method called after instantiation

        @param title: The title of the view
        @return: Boolean whether it succeeds or fails. It may fail if a window with the same title is already open.
                 In this case better close existing windows
        """
        self.title = title
        self.__this = _ida_kernwin.pyscv_init(self, title)
        return True if self.__this else False

    def Close(self):
        r"""
        Destroys the view.
        One has to call Create() afterwards.
        Show() can be called and it will call Create() internally.
        @return: Boolean
        """
        return _ida_kernwin.pyscv_close(self.__this)

    def Show(self):
        r"""
        Shows an already created view. It the view was closed, then it will call Create() for you
        @return: Boolean
        """
        return _ida_kernwin.pyscv_show(self.__this)

    def Refresh(self):
        return _ida_kernwin.pyscv_refresh(self.__this)

    def RefreshCurrent(self):
        r"""
        Refreshes the current line only
        """
        return _ida_kernwin.pyscv_refresh(self.__this)

    def Count(self):
        r"""
        Returns the number of lines in the view
        """
        return _ida_kernwin.pyscv_count(self.__this)

    def GetSelection(self):
        r"""
        Returns the selected range or None
        @return:     - tuple(x1, y1, x2, y2)
            - None if no selection
        """
        return _ida_kernwin.pyscv_get_selection(self.__this)

    def ClearLines(self):
        r"""
        Clears all the lines
        """
        _ida_kernwin.pyscv_clear_lines(self.__this)

    def AddLine(self, line, fgcolor=None, bgcolor=None):
        r"""
        Adds a colored line to the view
        @return: Boolean
        """
        return _ida_kernwin.pyscv_add_line(self.__this, self.__make_sl_arg(line, fgcolor, bgcolor))

    def InsertLine(self, lineno, line, fgcolor=None, bgcolor=None):
        r"""
        Inserts a line in the given position
        @return: Boolean
        """
        return _ida_kernwin.pyscv_insert_line(self.__this, lineno, self.__make_sl_arg(line, fgcolor, bgcolor))

    def EditLine(self, lineno, line, fgcolor=None, bgcolor=None):
        r"""
        Edits an existing line.
        @return: Boolean
        """
        return _ida_kernwin.pyscv_edit_line(self.__this, lineno, self.__make_sl_arg(line, fgcolor, bgcolor))

    def PatchLine(self, lineno, offs, value):
        r"""
        Patches an existing line character at the given offset. This is a low level function. You must know what you're doing
        """
        return _ida_kernwin.pyscv_patch_line(self.__this, lineno, offs, value)

    def DelLine(self, lineno):
        r"""
        Deletes an existing line
        @return: Boolean
        """
        return _ida_kernwin.pyscv_del_line(self.__this, lineno)

    def GetLine(self, lineno):
        r"""
        Returns a line
        @param lineno: The line number
        @return:     Returns a tuple (colored_line, fgcolor, bgcolor) or None
        """
        return _ida_kernwin.pyscv_get_line(self.__this, lineno)

    def GetCurrentWord(self, mouse = 0):
        r"""
        Returns the current word
        @param mouse: Use mouse position or cursor position
        @return: None if failed or a String containing the current word at mouse or cursor
        """
        return _ida_kernwin.pyscv_get_current_word(self.__this, mouse)

    def GetCurrentLine(self, mouse = 0, notags = 0):
        r"""
        Returns the current line.
        @param mouse: Current line at mouse pos
        @param notags: If True then tag_remove() will be called before returning the line
        @return: Returns the current line (colored or uncolored) or None on failure
        """
        return _ida_kernwin.pyscv_get_current_line(self.__this, mouse, notags)

    def GetPos(self, mouse = 0):
        r"""
        Returns the current cursor or mouse position.
        @param mouse: return mouse position
        @return: Returns a tuple (lineno, x, y)
        """
        return _ida_kernwin.pyscv_get_pos(self.__this, mouse)

    def GetLineNo(self, mouse = 0):
        r"""
        Calls GetPos() and returns the current line number or -1 on failure
        """
        r = self.GetPos(mouse)
        return -1 if not r else r[0]

    def Jump(self, lineno, x=0, y=0):
        return _ida_kernwin.pyscv_jumpto(self.__this, lineno, x, y)

    def IsFocused(self):
        r"""
        Returns True if the current view is the focused view
        """
        return _ida_kernwin.pyscv_is_focused(self.__this)

    def GetWidget(self):
        r"""
        Return the TWidget underlying this view.

        @return: The TWidget underlying this view, or None.
        """
        return _ida_kernwin.pyscv_get_widget(self.__this)



# Here are all the supported events
#<pydoc>
#    def OnClick(self, shift):
#        """
#        User clicked in the view
#        @param shift: Shift flag
#        @return: Boolean. True if you handled the event
#        """
#        print("OnClick, shift=%d" % shift)
#        return True
#
#    def OnDblClick(self, shift):
#        """
#        User dbl-clicked in the view
#        @param shift: Shift flag
#        @return: Boolean. True if you handled the event
#        """
#        print("OnDblClick, shift=%d" % shift)
#        return True
#
#    def OnCursorPosChanged(self):
#        """
#        Cursor position changed.
#        @return: Nothing
#        """
#        print("OnCurposChanged")
#
#    def OnClose(self):
#        """
#        The view is closing. Use this event to cleanup.
#        @return: Nothing
#        """
#        print("OnClose")
#
#    def OnKeydown(self, vkey, shift):
#        """
#        User pressed a key
#        @param vkey: Virtual key code
#        @param shift: Shift flag
#        @return: Boolean. True if you handled the event
#        """
#        print("OnKeydown, vk=%d shift=%d" % (vkey, shift))
#        return False
#
#    def OnHint(self, lineno):
#        """
#        Hint requested for the given line number.
#        @param lineno: The line number (zero based)
#        @return:
#            - tuple(number of important lines, hint string)
#            - None: if no hint available
#        """
#        return (1, "OnHint, line=%d" % lineno)
#
#    def OnPopupMenu(self, menu_id):
#        """
#        A context (or popup) menu item was executed.
#        @param menu_id: ID previously registered with add_popup_menu()
#        @return: Boolean
#        """
#        print("OnPopupMenu, menu_id=" % menu_id)
#        return True
#</pydoc>
#</pycode(py_kernwin_custview)>


def plgform_new() -> "PyObject *":
    r"""
    plgform_new() -> PyObject *
    """
    return _ida_kernwin.plgform_new()

def plgform_show(*args) -> "bool":
    r"""
    plgform_show(py_link, py_obj, caption, options=(0x0040 << 16)|0x00000004u) -> bool

    @param py_link: PyObject *
    @param py_obj: PyObject *
    @param caption: char const *
    @param options: int
    """
    return _ida_kernwin.plgform_show(*args)

def plgform_close(py_link: "PyObject *", options: "int") -> "void":
    r"""
    plgform_close(py_link, options)

    @param py_link: PyObject *
    @param options: int
    """
    return _ida_kernwin.plgform_close(py_link, options)

def plgform_get_widget(py_link: "PyObject *") -> "TWidget *":
    r"""
    plgform_get_widget(py_link) -> TWidget *

    @param py_link: PyObject *
    """
    return _ida_kernwin.plgform_get_widget(py_link)

#<pycode(py_kernwin_plgform)>
import sys

import ida_idaapi

class PluginForm(object):
    r"""
    PluginForm class.

    This form can be used to host additional controls. Please check the PyQt example.
    """

    WOPN_MDI      = 0x01 # no-op
    WOPN_TAB      = 0x02 # no-op
    WOPN_RESTORE  = _ida_kernwin.WOPN_RESTORE
    r"""
    if the widget is the only widget in a floating area when
    it is closed, remember that area's geometry. The next
    time that widget is created as floating (i.e., WOPN_DP_FLOATING)
    its geometry will be restored (e.g., "Execute script"
    """
    WOPN_ONTOP       = 0x08 # no-op
    WOPN_MENU        = 0x10 # no-op
    WOPN_CENTERED    = 0x20 # no-op
    WOPN_PERSIST     = _ida_kernwin.WOPN_PERSIST
    r"""
    form will persist until explicitly closed with Close()
    """
    WOPN_DP_LEFT     = _ida_kernwin.WOPN_DP_LEFT
    r"""
    Dock widget to the left of dest_ctrl
    """
    WOPN_DP_TOP      = _ida_kernwin.WOPN_DP_TOP
    r"""
    Dock widget above dest_ctrl
    """
    WOPN_DP_RIGHT    = _ida_kernwin.WOPN_DP_RIGHT
    r"""
    Dock widget to the right of dest_ctrl
    """
    WOPN_DP_BOTTOM   = _ida_kernwin.WOPN_DP_BOTTOM
    r"""
    Dock widget below dest_ctrl
    """
    WOPN_DP_INSIDE   = _ida_kernwin.WOPN_DP_INSIDE
    r"""
    Create a new tab bar with both widget and dest_ctrl
    """
    WOPN_DP_TAB      = _ida_kernwin.WOPN_DP_TAB
    r"""
    Place widget into a tab next to dest_ctrl,
    if dest_ctrl is in a tab bar
    (otherwise the same as #WOPN_DP_INSIDE)
    """
    WOPN_DP_BEFORE   = _ida_kernwin.WOPN_DP_BEFORE
    r"""
    place widget before dst_form in the tab bar instead of after
    used with #WOPN_DP_INSIDE and #WOPN_DP_TAB
    """
    WOPN_DP_FLOATING = _ida_kernwin.WOPN_DP_FLOATING
    r"""
    When floating or in a splitter (i.e., not tabbed),
    use the widget's size hint to determine the best
    geometry (Qt only)
    """
    WOPN_DP_SZHINT   = _ida_kernwin.WOPN_DP_SZHINT
    r"""
    Make widget floating
    """
    WOPN_DP_INSIDE_BEFORE = _ida_kernwin.WOPN_DP_INSIDE_BEFORE
    WOPN_DP_TAB_BEFORE = _ida_kernwin.WOPN_DP_TAB_BEFORE

    WOPN_CREATE_ONLY = {}


    def __init__(self):
        self.__clink__ = _ida_kernwin.plgform_new()


    def Show(self, caption, options=0):
        r"""
        Creates the form if not was not created or brings to front if it was already created

        @param caption: The form caption
        @param options: One of PluginForm.WOPN_ constants
        """
        if options == self.WOPN_CREATE_ONLY:
            options = -1
        else:
            options |= PluginForm.WOPN_DP_TAB|PluginForm.WOPN_RESTORE
        return _ida_kernwin.plgform_show(self.__clink__, self, caption, options)


    @staticmethod
    def _ensure_widget_deps(ctx):
        for modname in ["sip", "QtWidgets"]:
            if not hasattr(ctx, modname):
                import importlib
                setattr(ctx, modname, importlib.import_module("PyQt5." + modname))


    VALID_CAPSULE_NAME = b"$valid$"

    @staticmethod
    def TWidgetToPyQtWidget(tw, ctx = sys.modules['__main__']):
        r"""
        Convert a TWidget* to a QWidget to be used by PyQt

        @param ctx: Context. Reference to a module that already imported SIP and QtWidgets modules
        """
        if type(tw).__name__ == "SwigPyObject":
            ptr_l = ida_idaapi.long_type(tw)
        else:
            import ctypes
            ctypes.pythonapi.PyCapsule_GetPointer.restype = ctypes.c_void_p
            ctypes.pythonapi.PyCapsule_GetPointer.argtypes = [ctypes.py_object, ctypes.c_char_p]
            ptr_l = ctypes.pythonapi.PyCapsule_GetPointer(tw, PluginForm.VALID_CAPSULE_NAME)
        PluginForm._ensure_widget_deps(ctx)
        vptr = ctx.sip.voidptr(ptr_l)
        return ctx.sip.wrapinstance(vptr.__int__(), ctx.QtWidgets.QWidget)
    FormToPyQtWidget = TWidgetToPyQtWidget


    @staticmethod
    def QtWidgetToTWidget(w, ctx = sys.modules['__main__']):
        r"""
        Convert a QWidget to a TWidget* to be used by IDA

        @param ctx: Context. Reference to a module that already imported SIP and QtWidgets modules
        """
        PluginForm._ensure_widget_deps(ctx)
        as_long = ida_idaapi.long_type(ctx.sip.unwrapinstance(w))
        return TWidget__from_ptrval__(as_long)


    @staticmethod
    def TWidgetToPySideWidget(tw, ctx = sys.modules['__main__']):
        r"""
        Use this method to convert a TWidget* to a QWidget to be used by PySide

        @param ctx: Context. Reference to a module that already imported QtWidgets module
        """
        if tw is None:
            return None
        if type(tw).__name__ == "SwigPyObject":
# Since 'tw' is a SwigPyObject, we first need to convert it to a PyCapsule.
# However, there's no easy way of doing it, so we'll use a rather brutal approach:
# converting the SwigPyObject to a 'long' (will go through 'SwigPyObject_long',
# that will return the pointer's value as a long), and then convert that value
# back to a pointer into a PyCapsule.
            ptr_l = ida_idaapi.long_type(tw)
# Warning: this is untested
            import ctypes
            ctypes.pythonapi.PyCapsule_New.restype = ctypes.py_object
            ctypes.pythonapi.PyCapsule_New.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p]
            tw = ctypes.pythonapi.PyCapsule_New(ptr_l, PluginForm.VALID_CAPSULE_NAME, 0)
        return ctx.QtGui.QWidget.FromCapsule(tw)
    FormToPySideWidget = TWidgetToPySideWidget

    def OnCreate(self, form):
        r"""
        This event is called when the plugin form is created.
        The programmer should populate the form when this event is triggered.

        @return: None
        """
        pass


    def OnClose(self, form):
        r"""
        Called when the plugin form is closed

        @return: None
        """
        pass


    def Close(self, options):
        r"""
        Closes the form.

        @param options: Close options (WCLS_SAVE, WCLS_NO_CONTEXT, ...)

        @return: None
        """
        return _ida_kernwin.plgform_close(self.__clink__, options)


    def GetWidget(self):
        r"""
        Return the TWidget underlying this view.

        @return: The TWidget underlying this view, or None.
        """
        return _ida_kernwin.plgform_get_widget(self.__clink__)


    WCLS_SAVE           = _ida_kernwin.WCLS_SAVE
    r"""
    Save state in desktop config
    """

    WCLS_NO_CONTEXT     = _ida_kernwin.WCLS_NO_CONTEXT
    r"""
    Don't change the current context (useful for toolbars)
    """

    WCLS_DONT_SAVE_SIZE = _ida_kernwin.WCLS_DONT_SAVE_SIZE
    r"""
    Don't save size of the window
    """

    WCLS_DELETE_LATER   = _ida_kernwin.WCLS_DELETE_LATER
    r"""
    This flag should be used when Close() is called from an event handler
    """

    WCLS_CLOSE_LATER  = WCLS_DELETE_LATER

#</pycode(py_kernwin_plgform)>


#<pycode(py_kernwin_end)>
place_t_as_idaplace_t = place_t.as_idaplace_t
place_t_as_simpleline_place_t = place_t.as_simpleline_place_t
place_t_as_tiplace_t = place_t.as_tiplace_t
#</pycode(py_kernwin_end)>



