#include <idc.idc>

//
// Format: (triple slashes) func=function_name entry=entry_value purge=val retval=val

// func
//      specifies the function name. No need to specify the module name since
//      it is deduced from the name of the script file. The file name has
//      always the following format: api_modulename.idc
//
// entry
//      module_name.function_name means to forward to another module
//      idc_function_name         means to call the specified IDC function
//                                The return value of the script controls the execution:
//                                  - zero: means to continue execution
//                                  - non-zero: suspend the application
//      this attribute is optional.
//      If it is missing, a dummy stub will be generated by IDA. The next
//      two attributes are used by the stub generator:
// purge
//      How many bytes to purge from the stack. Do not specify this value
//      if you are forwarding to another module.
// retval
//      The return value (this attribute is used only to generate stubs)
//
//

//--------------------------------------------------------------------------
// These are system definitions.
// !! Do not change them unless you know what you are doing !!
///func=GetModuleFileNameA entry=bochsys._BxGetModuleFileNameA@12
///func=GetModuleFileNameW entry=bochsys._BxGetModuleFileNameW@12
///func=GetModuleHandleA entry=bochsys._BxGetModuleHandleA@4
///func=GetModuleHandleW entry=bochsys._BxGetModuleHandleW@4
///func=GetCommandLineA entry=bochsys._BxWin32GetCommandLineA@0
///func=GetCommandLineW entry=bochsys._BxWin32GetCommandLineW@0
///func=LoadLibraryA entry=bochsys._BxLoadLibraryA@4
///func=LoadLibraryW entry=bochsys._BxLoadLibraryW@4
///func=GetEnvironmentStrings entry=bochsys._BxWin32GetEnvironmentStringsA@0
///func=GetEnvironmentStringsA entry=bochsys._BxWin32GetEnvironmentStringsA@0
///func=GetEnvironmentStringsW entry=bochsys._BxWin32GetEnvironmentStringsW@0
///func=GetProcAddress entry=bochsys._BxGetProcAddress@8
///func=ExitProcess entry=bochsys._BxExitProcess@4
///func=VirtualAlloc entry=bochsys._BxVirtualAlloc@16
///func=VirtualFree entry=bochsys._BxVirtualFree@12
///func=VirtualProtect entry=bochsys._BxVirtualProtect@16
///func=GetTickCount entry=bochsys._BxGetTickCount@0
///func=GetLastError entry=ntdll.RtlGetLastWin32Error
///func=SetLastError entry=ntdll.RtlSetLastWin32Error
///func=TlsAlloc entry=bochsys._BxWin32TlsAlloc@0
///func=TlsFree entry=bochsys._BxWin32TlsFree@4
///func=TlsGetValue entry=bochsys._BxWin32TlsGetValue@4
///func=TlsSetValue entry=bochsys._BxWin32TlsSetValue@8
///func=FlsAlloc entry=bochsys._BxWin32FlsAlloc@4
///func=FlsFree entry=bochsys._BxWin32TlsFree@4
///func=FlsGetValue entry=bochsys._BxWin32TlsGetValue@4
///func=FlsSetValue entry=bochsys._BxWin32TlsSetValue@8
///func=HeapCreate retval=1
///func=HeapFree retval=1 purge=12
///func=InitializeCriticalSectionAndSpinCount retval=1
///func=lstrcpyA entry=bochsys._BxStrCpyA@8
///func=lstrcpyW entry=bochsys._BxStrCpyW@8
///func=lstrcatA entry=bochsys._BxStrCatA@8
///func=lstrcatW entry=bochsys._BxStrCatW@8

// example: user dll implementation: func=GetCommandLineA entry=mydll.MyGetCommandLineA purge=0

//--------------------------------------------------------------------------
// HMODULE WINAPI LoadLibraryExA(LPCSTR lpFileName, HANDLE hFile, DWORD dwFlags);
///func=LoadLibraryExA entry=k32_LoadLibraryExA
static k32_LoadLibraryExA()
{
  auto lpFileName, hFile, dwFlags;

  hFile = BochsGetParam(2);
  if (hFile != 0)
  {
    eax = 0;
    return 0;
  }
  lpFileName = get_strlit_contents(BochsGetParam(1), -1, STRTYPE_C);
  dwFlags    = BochsGetParam(3);

  // Since Bochs plugin does not support dynamic DLL loading, we simply return the module handle.
  // (the DLL must be declared in startup.idc so it is pre-loaded)
  eax        = BochsGetModuleHandle(lpFileName);
  return 0; // continue execution
}

//--------------------------------------------------------------------------
///func=WideCharToMultiByte entry=k32_WideCharToMultiByte
static k32_WideCharToMultiByte()
{
  auto i, len_wide, len_multi, p_wide, p_multi, len;

  len_wide  = BochsGetParam(4);
  len_multi = BochsGetParam(6); //  int cbMultiByte,
  if (len_wide == 0)
  {
    eax = 0;
    return 0;
  }

  if (len_multi == 0)
    len = 0;
  else if (len_wide == -1 || len_wide > len_multi)
    len = len_multi;
  else
    len = len_wide;

  p_wide    = BochsGetParam(3); // LPCWSTR lpWideCharStr
  p_multi   = BochsGetParam(5); // LPSTR lpMultiByteStr

  if (len == 0)
  {
    for (i=0;;i++)
    {
      if ( get_wide_byte(p_wide) == 0 )
        break;
      p_wide = p_wide + 2;
    }
  }
  else
  {
    for (i=0;i<len;i++)
    {
      BochsPatchDbgDword(p_multi, get_wide_byte(p_wide));
      p_wide = p_wide + 2;
      p_multi = p_multi + 1;
    }
  }
  eax = i;
  return 0;
}

//--------------------------------------------------------------------------
///func=Beep entry=beep purge=8
static beep()
{
  auto param1, param2;

  param1 = BochsGetParam(1);
  param2 = BochsGetParam(2);

  msg("I am Beep(%d, %d)\n", param1, param2);

  // The emulated function returns 1:
  eax = 1;

  // Our return value controls execution of the debugged application:
  //   1 = suspend execution (inside IDACALL)
  //   0 = continue transparently
  return 0;
}

//--------------------------------------------------------------------------
///func=GlobalAlloc entry=k32_GlobalAlloc purge=8
static k32_GlobalAlloc()
{
  // Redirect GlobalAlloc -> VirtualAlloc
  eax = BochsVirtAlloc(0, BochsGetParam(2), 1);
  return 0;
}

//--------------------------------------------------------------------------
///func=GlobalFree entry=k32_GlobalFree purge=4
static k32_GlobalFree()
{
  // Redirect GlobalFree -> VirtualFree
  eax = BochsVirtFree(BochsGetParam(1), 0);
  return 0;
}

//--------------------------------------------------------------------------
///func=GetCurrentThread entry=k32_GetCurrentThread purge=0
static k32_GetCurrentThread()
{
  eax = -2;
  return 0;
}

#define STD_INPUT_HANDLE  0xFFFFFFF6
#define STD_OUTPUT_HANDLE 0xFFFFFFF5
#define STD_ERROR_HANDLE  0xFFFFFFF4

// BOOL WINAPI WriteFile(HANDLE hFile,LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped);
///func=WriteFile entry=k32_writefile
static k32_writefile()
{
  auto fp, hfile, len, buf;
  hfile = BochsGetParam(1);
  buf   = BochsGetParam(2);
  len   = BochsGetParam(3);

  if (hfile == STD_OUTPUT_HANDLE || hfile == STD_ERROR_HANDLE)
  {
    msg("WriteFile(STDOUT): %s\n", get_strlit_contents(buf, len, STRTYPE_C));
  }
  else
  {
    fp = fopen("writefile.bin", "a+b");
    if (fp != 0)
    {
      msg("fp=%d\n len=%d", fp, filelength(fp));
      savefile(fp, filelength(fp), buf, len);
      fclose(fp);
    }
  }
  buf = BochsGetParam(4);
  if (buf != 0)
    BochsPatchDbgDword(get_wide_dword(buf), len); // save the number of bytes written
  eax = 1; // success
  return 0;
}

//--------------------------------------------------------------------------
///func=get_current_thread entry=k32_GetCurrentThreadId
static k32_GetCurrentThreadId()
{
  eax = get_current_thread();
  return 0;
}

//--------------------------------------------------------------------------
///func=GetStdHandle entry=k32_GetStdHandle
static k32_GetStdHandle()
{
  // return same value
  eax = BochsGetParam(1);
  return 0;
}

//--------------------------------------------------------------------------
///func=GlobalMemoryStatus entry=k32_GlobalMemoryStatus
static k32_GlobalMemoryStatus()
{
  /*
  00000000 MEMORYSTATUS    struc
  00000000 dwLength        dd
  00000004 dwMemoryLoad    dd
  00000008 dwTotalPhys     dd
  0000000C dwAvailPhys     dd
  00000010 dwTotalPageFile dd
  00000014 dwAvailPageFile dd
  00000018 dwTotalVirtual  dd
  0000001C dwAvailVirtual  dd
  00000020 MEMORYSTATUS    ends
  */
  auto ms, avail, total;

  ms = BochsGetParam(1);
  avail = BochsGetFreeMem();
  total = BochsGetMaxMem();

  BochsPatchDbgDword(ms + 0x08, total); // total phys
  BochsPatchDbgDword(ms + 0x0C, avail); // avail phys
  BochsPatchDbgDword(ms + 0x10, 0    ); // total page
  BochsPatchDbgDword(ms + 0x14, 0    ); // avail page
  BochsPatchDbgDword(ms + 0x18, total); // total virt
  BochsPatchDbgDword(ms + 0x1C, avail); // avail virt

  return 0;
}

//--------------------------------------------------------------------------
//UINT __stdcall GetPrivateProfileIntA(LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault, LPCSTR lpFileName)
///func=GetPrivateProfileIntA entry=k32_GetPrivateProfileIntA
static k32_GetPrivateProfileIntA()
{
  auto appname  = get_wide_dword(BochsGetParam(1));
  auto keyname  = get_wide_dword(BochsGetParam(2));
  auto filename = get_wide_dword(BochsGetParam(4));
  msg("GetPrivateProfileIntA(appname=%x keyname=%x filename=%x)\n", appname, keyname, filename);

  if (appname == 0 && keyname == 0 && filename == 0)
    eax = BochsGetParam(3);
  else
    eax = 0;
  return 0;
}

/*
Example custom implementation of resource APIs

//--------------------------------------------------------------------------
//HRSRC WINAPI FindResource(
//  __in_opt  HMODULE hModule,
//  __in      LPCTSTR lpName,
//  __in      LPCTSTR lpType
//);
///func=FindResourceA entry=k32_FindResource
static k32_FindResource()
{
  auto name = BochsGetParam(2);
  //msg("FindResource(name=%x)\n", name);
  if (name == 0x137)
    eax = 0x404120;
  else if (name == 0x138)
    eax = 0x413520;
  else
    eax = 0;
  return 0;
}


//--------------------------------------------------------------------------
//HGLOBAL WINAPI LoadResource(
//  __in_opt  HMODULE hModule,
//  __in      HRSRC hResInfo
//);
///func=LoadResource entry=k32_LoadResource
static k32_LoadResource()
{
  eax = BochsGetParam(2);
  return 0;
}

//--------------------------------------------------------------------------
//LPVOID WINAPI LockResource(
//  __in  HGLOBAL hResData
//);
///func=LockResource entry=k32_LockResource
static k32_LockResource()
{
  eax = BochsGetParam(1);
  return 0;
}

//--------------------------------------------------------------------------
//DWORD WINAPI SizeofResource(
//  __in_opt  HMODULE hModule,
//  __in      HRSRC hResInfo
//);
///func=SizeofResource entry=k32_SizeofResource
static k32_SizeofResource()
{
  auto resinfo = BochsGetParam(2);
  if (resinfo == 0x404120)
    eax = 62464;
  else if (resinfo == 0x413520)
    eax = 15;
  else
    eax = 0;
  return 0;
}
*/
